/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SecuritySettingsName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/securitySettings/{security_settings}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String securitySettings;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSecuritySettings() {
        return this.securitySettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SecuritySettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.securitySettings = (String)Preconditions.checkNotNull((Object)builder.getSecuritySettings());
    }

    public static SecuritySettingsName of(String project, String location, String securitySettings) {
        return SecuritySettingsName.newBuilder().setProject(project).setLocation(location).setSecuritySettings(securitySettings).build();
    }

    public static String format(String project, String location, String securitySettings) {
        return SecuritySettingsName.newBuilder().setProject(project).setLocation(location).setSecuritySettings(securitySettings).build().toString();
    }

    public static SecuritySettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SecuritySettingsName.parse: formattedString not in valid format");
        return SecuritySettingsName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("security_settings"));
    }

    public static List<SecuritySettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SecuritySettingsName> list = new ArrayList<SecuritySettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecuritySettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecuritySettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecuritySettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecuritySettingsName securitySettingsName = this;
            synchronized (securitySettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"securitySettings", (Object)this.securitySettings);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "security_settings", this.securitySettings});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecuritySettingsName) {
            SecuritySettingsName that = (SecuritySettingsName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.securitySettings.equals(that.securitySettings);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.securitySettings.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String securitySettings;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecuritySettings() {
            return this.securitySettings;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSecuritySettings(String securitySettings) {
            this.securitySettings = securitySettings;
            return this;
        }

        private Builder() {
        }

        private Builder(SecuritySettingsName securitySettingsName) {
            this.project = securitySettingsName.project;
            this.location = securitySettingsName.location;
            this.securitySettings = securitySettingsName.securitySettings;
        }

        public SecuritySettingsName build() {
            return new SecuritySettingsName(this);
        }
    }
}

