/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/sessions/{session}");
    private static final PathTemplate PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String agent;
    private final String session;
    private final String environment;

    @Deprecated
    protected SessionName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.session = null;
        this.environment = null;
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.environment = null;
        this.pathTemplate = PROJECT_LOCATION_AGENT_SESSION;
    }

    private SessionName(ProjectLocationAgentEnvironmentSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.pathTemplate = PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getSession() {
        return this.session;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationAgentSessionBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationAgentEnvironmentSessionBuilder newProjectLocationAgentEnvironmentSessionBuilder() {
        return new ProjectLocationAgentEnvironmentSessionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionName of(String project, String location, String agent, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionName ofProjectLocationAgentSessionName(String project, String location, String agent, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SessionName ofProjectLocationAgentEnvironmentSessionName(String project, String location, String agent, String environment, String session) {
        return SessionName.newProjectLocationAgentEnvironmentSessionBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setSession(session).build();
    }

    public static String format(String project, String location, String agent, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAgentSessionName(String project, String location, String agent, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setSession(session).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationAgentEnvironmentSessionName(String project, String location, String agent, String environment, String session) {
        return SessionName.newProjectLocationAgentEnvironmentSessionBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setSession(session).build().toString();
    }

    public static SessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_AGENT_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_SESSION.match(formattedString);
            return SessionName.ofProjectLocationAgentSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("session"));
        }
        if (PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION.match(formattedString);
            return SessionName.ofProjectLocationAgentEnvironmentSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("environment"), (String)matchMap.get("session"));
        }
        throw new ValidationException("SessionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionName> parseList(List<String> formattedStrings) {
        ArrayList<SessionName> list = new ArrayList<SessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_SESSION.matches(formattedString) || PROJECT_LOCATION_AGENT_ENVIRONMENT_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionName sessionName = this;
            synchronized (sessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SessionName that = (SessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.session, that.session) && Objects.equals(this.environment, that.environment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        return h ^= Objects.hashCode(this.environment);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationAgentEnvironmentSessionBuilder {
        private String project;
        private String location;
        private String agent;
        private String environment;
        private String session;

        protected ProjectLocationAgentEnvironmentSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectLocationAgentEnvironmentSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionBuilder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectLocationAgentEnvironmentSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(SessionName sessionName) {
            Preconditions.checkArgument((boolean)Objects.equals(sessionName.pathTemplate, PROJECT_LOCATION_AGENT_SESSION), (Object)"toBuilder is only supported when SessionName has the pattern of projects/{project}/locations/{location}/agents/{agent}/sessions/{session}");
            this.project = sessionName.project;
            this.location = sessionName.location;
            this.agent = sessionName.agent;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

