/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightsConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHTS_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightsConfigs/{insights_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String insightsConfig;

    @Deprecated
    protected InsightsConfigName() {
        this.project = null;
        this.location = null;
        this.insightsConfig = null;
    }

    private InsightsConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightsConfig = (String)Preconditions.checkNotNull((Object)builder.getInsightsConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightsConfig() {
        return this.insightsConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightsConfigName of(String project, String location, String insightsConfig) {
        return InsightsConfigName.newBuilder().setProject(project).setLocation(location).setInsightsConfig(insightsConfig).build();
    }

    public static String format(String project, String location, String insightsConfig) {
        return InsightsConfigName.newBuilder().setProject(project).setLocation(location).setInsightsConfig(insightsConfig).build().toString();
    }

    public static InsightsConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSIGHTS_CONFIG.validatedMatch(formattedString, "InsightsConfigName.parse: formattedString not in valid format");
        return InsightsConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insights_config"));
    }

    public static List<InsightsConfigName> parseList(List<String> formattedStrings) {
        ArrayList<InsightsConfigName> list = new ArrayList<InsightsConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightsConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightsConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightsConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHTS_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightsConfigName insightsConfigName = this;
            synchronized (insightsConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightsConfig != null) {
                        fieldMapBuilder.put((Object)"insights_config", (Object)this.insightsConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSIGHTS_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "insights_config", this.insightsConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InsightsConfigName that = (InsightsConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightsConfig, that.insightsConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.insightsConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightsConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightsConfig() {
            return this.insightsConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightsConfig(String insightsConfig) {
            this.insightsConfig = insightsConfig;
            return this;
        }

        private Builder(InsightsConfigName insightsConfigName) {
            this.project = insightsConfigName.project;
            this.location = insightsConfigName.location;
            this.insightsConfig = insightsConfigName.insightsConfig;
        }

        public InsightsConfigName build() {
            return new InsightsConfigName(this);
        }
    }
}

