/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GitRepositoryLinkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONNECTION_GIT_REPOSITORY_LINK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connections/{connection}/gitRepositoryLinks/{git_repository_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String connection;
    private final String gitRepositoryLink;

    @Deprecated
    protected GitRepositoryLinkName() {
        this.project = null;
        this.location = null;
        this.connection = null;
        this.gitRepositoryLink = null;
    }

    private GitRepositoryLinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connection = (String)Preconditions.checkNotNull((Object)builder.getConnection());
        this.gitRepositoryLink = (String)Preconditions.checkNotNull((Object)builder.getGitRepositoryLink());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getGitRepositoryLink() {
        return this.gitRepositoryLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GitRepositoryLinkName of(String project, String location, String connection, String gitRepositoryLink) {
        return GitRepositoryLinkName.newBuilder().setProject(project).setLocation(location).setConnection(connection).setGitRepositoryLink(gitRepositoryLink).build();
    }

    public static String format(String project, String location, String connection, String gitRepositoryLink) {
        return GitRepositoryLinkName.newBuilder().setProject(project).setLocation(location).setConnection(connection).setGitRepositoryLink(gitRepositoryLink).build().toString();
    }

    public static GitRepositoryLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONNECTION_GIT_REPOSITORY_LINK.validatedMatch(formattedString, "GitRepositoryLinkName.parse: formattedString not in valid format");
        return GitRepositoryLinkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connection"), (String)matchMap.get("git_repository_link"));
    }

    public static List<GitRepositoryLinkName> parseList(List<String> formattedStrings) {
        ArrayList<GitRepositoryLinkName> list = new ArrayList<GitRepositoryLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GitRepositoryLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GitRepositoryLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GitRepositoryLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONNECTION_GIT_REPOSITORY_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GitRepositoryLinkName gitRepositoryLinkName = this;
            synchronized (gitRepositoryLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.connection != null) {
                        fieldMapBuilder.put((Object)"connection", (Object)this.connection);
                    }
                    if (this.gitRepositoryLink != null) {
                        fieldMapBuilder.put((Object)"git_repository_link", (Object)this.gitRepositoryLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONNECTION_GIT_REPOSITORY_LINK.instantiate(new String[]{"project", this.project, "location", this.location, "connection", this.connection, "git_repository_link", this.gitRepositoryLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GitRepositoryLinkName that = (GitRepositoryLinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.connection, that.connection) && Objects.equals(this.gitRepositoryLink, that.gitRepositoryLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.connection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.gitRepositoryLink);
    }

    public static class Builder {
        private String project;
        private String location;
        private String connection;
        private String gitRepositoryLink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnection() {
            return this.connection;
        }

        public String getGitRepositoryLink() {
            return this.gitRepositoryLink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder setGitRepositoryLink(String gitRepositoryLink) {
            this.gitRepositoryLink = gitRepositoryLink;
            return this;
        }

        private Builder(GitRepositoryLinkName gitRepositoryLinkName) {
            this.project = gitRepositoryLinkName.project;
            this.location = gitRepositoryLinkName.location;
            this.connection = gitRepositoryLinkName.connection;
            this.gitRepositoryLink = gitRepositoryLinkName.gitRepositoryLink;
        }

        public GitRepositoryLinkName build() {
            return new GitRepositoryLinkName(this);
        }
    }
}

