/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeliveryPipelineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DELIVERY_PIPELINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deliveryPipeline;

    @Deprecated
    protected DeliveryPipelineName() {
        this.project = null;
        this.location = null;
        this.deliveryPipeline = null;
    }

    private DeliveryPipelineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deliveryPipeline = (String)Preconditions.checkNotNull((Object)builder.getDeliveryPipeline());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeliveryPipeline() {
        return this.deliveryPipeline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeliveryPipelineName of(String project, String location, String deliveryPipeline) {
        return DeliveryPipelineName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).build();
    }

    public static String format(String project, String location, String deliveryPipeline) {
        return DeliveryPipelineName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).build().toString();
    }

    public static DeliveryPipelineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DELIVERY_PIPELINE.validatedMatch(formattedString, "DeliveryPipelineName.parse: formattedString not in valid format");
        return DeliveryPipelineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("delivery_pipeline"));
    }

    public static List<DeliveryPipelineName> parseList(List<String> formattedStrings) {
        ArrayList<DeliveryPipelineName> list = new ArrayList<DeliveryPipelineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeliveryPipelineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeliveryPipelineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeliveryPipelineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DELIVERY_PIPELINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeliveryPipelineName deliveryPipelineName = this;
            synchronized (deliveryPipelineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deliveryPipeline != null) {
                        fieldMapBuilder.put((Object)"delivery_pipeline", (Object)this.deliveryPipeline);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DELIVERY_PIPELINE.instantiate(new String[]{"project", this.project, "location", this.location, "delivery_pipeline", this.deliveryPipeline});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DeliveryPipelineName that = (DeliveryPipelineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deliveryPipeline, that.deliveryPipeline);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deliveryPipeline);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deliveryPipeline;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeliveryPipeline() {
            return this.deliveryPipeline;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeliveryPipeline(String deliveryPipeline) {
            this.deliveryPipeline = deliveryPipeline;
            return this;
        }

        private Builder(DeliveryPipelineName deliveryPipelineName) {
            this.project = deliveryPipelineName.project;
            this.location = deliveryPipelineName.location;
            this.deliveryPipeline = deliveryPipelineName.deliveryPipeline;
        }

        public DeliveryPipelineName build() {
            return new DeliveryPipelineName(this);
        }
    }
}

