/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The result of fetching an entity from Datastore.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.EntityResult}
 */
public final class EntityResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.EntityResult)
    EntityResultOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EntityResult.newBuilder() to construct.
  private EntityResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityResult() {
    cursor_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_EntityResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_EntityResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.EntityResult.class,
            com.google.datastore.v1.EntityResult.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies what data the 'entity' field contains.
   * A `ResultType` is either implied (for example, in `LookupResponse.missing`
   * from `datastore.proto`, it is always `KEY_ONLY`) or specified by context
   * (for example, in message `QueryResultBatch`, field `entity_result_type`
   * specifies a `ResultType` for all the values in field `entity_results`).
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.EntityResult.ResultType}
   */
  public enum ResultType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. This value is never used.
     * </pre>
     *
     * <code>RESULT_TYPE_UNSPECIFIED = 0;</code>
     */
    RESULT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The key and properties.
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    FULL(1),
    /**
     *
     *
     * <pre>
     * A projected subset of properties. The entity may have no key.
     * </pre>
     *
     * <code>PROJECTION = 2;</code>
     */
    PROJECTION(2),
    /**
     *
     *
     * <pre>
     * Only the key.
     * </pre>
     *
     * <code>KEY_ONLY = 3;</code>
     */
    KEY_ONLY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. This value is never used.
     * </pre>
     *
     * <code>RESULT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RESULT_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The key and properties.
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    public static final int FULL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * A projected subset of properties. The entity may have no key.
     * </pre>
     *
     * <code>PROJECTION = 2;</code>
     */
    public static final int PROJECTION_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Only the key.
     * </pre>
     *
     * <code>KEY_ONLY = 3;</code>
     */
    public static final int KEY_ONLY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResultType forNumber(int value) {
      switch (value) {
        case 0:
          return RESULT_TYPE_UNSPECIFIED;
        case 1:
          return FULL;
        case 2:
          return PROJECTION;
        case 3:
          return KEY_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResultType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResultType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResultType>() {
          public ResultType findValueByNumber(int number) {
            return ResultType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.EntityResult.getDescriptor().getEnumTypes().get(0);
    }

    private static final ResultType[] VALUES = values();

    public static ResultType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResultType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.EntityResult.ResultType)
  }

  private int bitField0_;
  public static final int ENTITY_FIELD_NUMBER = 1;
  private com.google.datastore.v1.Entity entity_;

  /**
   *
   *
   * <pre>
   * The resulting entity.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity entity = 1;</code>
   *
   * @return Whether the entity field is set.
   */
  @java.lang.Override
  public boolean hasEntity() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The resulting entity.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity entity = 1;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getEntity() {
    return entity_ == null ? com.google.datastore.v1.Entity.getDefaultInstance() : entity_;
  }

  /**
   *
   *
   * <pre>
   * The resulting entity.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity entity = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getEntityOrBuilder() {
    return entity_ == null ? com.google.datastore.v1.Entity.getDefaultInstance() : entity_;
  }

  public static final int VERSION_FIELD_NUMBER = 4;
  private long version_ = 0L;

  /**
   *
   *
   * <pre>
   * The version of the entity, a strictly positive number that monotonically
   * increases with changes to the entity.
   *
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   *
   * For [missing][google.datastore.v1.LookupResponse.missing] entities in
   * `LookupResponse`, this is the version of the snapshot that was used to look
   * up the entity, and it is always set except for eventually consistent reads.
   * </pre>
   *
   * <code>int64 version = 4;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public long getVersion() {
    return version_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * The time at which the entity was created.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time at which the entity was created.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * The time at which the entity was created.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * The time at which the entity was last changed.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time at which the entity was last changed.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * The time at which the entity was last changed.
   * This field is set for
   * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
   * If this entity is missing, this field will not be set.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int CURSOR_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString cursor_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * A cursor that points to the position after the result entity.
   * Set only when the `EntityResult` is part of a `QueryResultBatch` message.
   * </pre>
   *
   * <code>bytes cursor = 3;</code>
   *
   * @return The cursor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCursor() {
    return cursor_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEntity());
    }
    if (!cursor_.isEmpty()) {
      output.writeBytes(3, cursor_);
    }
    if (version_ != 0L) {
      output.writeInt64(4, version_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEntity());
    }
    if (!cursor_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, cursor_);
    }
    if (version_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, version_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.EntityResult)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.EntityResult other = (com.google.datastore.v1.EntityResult) obj;

    if (hasEntity() != other.hasEntity()) return false;
    if (hasEntity()) {
      if (!getEntity().equals(other.getEntity())) return false;
    }
    if (getVersion() != other.getVersion()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getCursor().equals(other.getCursor())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEntity()) {
      hash = (37 * hash) + ENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getEntity().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getVersion());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + CURSOR_FIELD_NUMBER;
    hash = (53 * hash) + getCursor().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.EntityResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.EntityResult parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.EntityResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.EntityResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.EntityResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The result of fetching an entity from Datastore.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.EntityResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.EntityResult)
      com.google.datastore.v1.EntityResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_EntityResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_EntityResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.EntityResult.class,
              com.google.datastore.v1.EntityResult.Builder.class);
    }

    // Construct using com.google.datastore.v1.EntityResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntityFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      version_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      cursor_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_EntityResult_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.EntityResult getDefaultInstanceForType() {
      return com.google.datastore.v1.EntityResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.EntityResult build() {
      com.google.datastore.v1.EntityResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.EntityResult buildPartial() {
      com.google.datastore.v1.EntityResult result = new com.google.datastore.v1.EntityResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.EntityResult result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.entity_ = entityBuilder_ == null ? entity_ : entityBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.cursor_ = cursor_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.EntityResult) {
        return mergeFrom((com.google.datastore.v1.EntityResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.EntityResult other) {
      if (other == com.google.datastore.v1.EntityResult.getDefaultInstance()) return this;
      if (other.hasEntity()) {
        mergeEntity(other.getEntity());
      }
      if (other.getVersion() != 0L) {
        setVersion(other.getVersion());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getCursor() != com.google.protobuf.ByteString.EMPTY) {
        setCursor(other.getCursor());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEntityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                cursor_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 32:
              {
                version_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.datastore.v1.Entity entity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        entityBuilder_;

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     *
     * @return Whether the entity field is set.
     */
    public boolean hasEntity() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     *
     * @return The entity.
     */
    public com.google.datastore.v1.Entity getEntity() {
      if (entityBuilder_ == null) {
        return entity_ == null ? com.google.datastore.v1.Entity.getDefaultInstance() : entity_;
      } else {
        return entityBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.datastore.v1.Entity value) {
      if (entityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entity_ = value;
      } else {
        entityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (entityBuilder_ == null) {
        entity_ = builderForValue.build();
      } else {
        entityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public Builder mergeEntity(com.google.datastore.v1.Entity value) {
      if (entityBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && entity_ != null
            && entity_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          getEntityBuilder().mergeFrom(value);
        } else {
          entity_ = value;
        }
      } else {
        entityBuilder_.mergeFrom(value);
      }
      if (entity_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public Builder clearEntity() {
      bitField0_ = (bitField0_ & ~0x00000001);
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public com.google.datastore.v1.Entity.Builder getEntityBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEntityFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    public com.google.datastore.v1.EntityOrBuilder getEntityOrBuilder() {
      if (entityBuilder_ != null) {
        return entityBuilder_.getMessageOrBuilder();
      } else {
        return entity_ == null ? com.google.datastore.v1.Entity.getDefaultInstance() : entity_;
      }
    }

    /**
     *
     *
     * <pre>
     * The resulting entity.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity entity = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getEntityFieldBuilder() {
      if (entityBuilder_ == null) {
        entityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                getEntity(), getParentForChildren(), isClean());
        entity_ = null;
      }
      return entityBuilder_;
    }

    private long version_;

    /**
     *
     *
     * <pre>
     * The version of the entity, a strictly positive number that monotonically
     * increases with changes to the entity.
     *
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     *
     * For [missing][google.datastore.v1.LookupResponse.missing] entities in
     * `LookupResponse`, this is the version of the snapshot that was used to look
     * up the entity, and it is always set except for eventually consistent reads.
     * </pre>
     *
     * <code>int64 version = 4;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public long getVersion() {
      return version_;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity, a strictly positive number that monotonically
     * increases with changes to the entity.
     *
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     *
     * For [missing][google.datastore.v1.LookupResponse.missing] entities in
     * `LookupResponse`, this is the version of the snapshot that was used to look
     * up the entity, and it is always set except for eventually consistent reads.
     * </pre>
     *
     * <code>int64 version = 4;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(long value) {

      version_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity, a strictly positive number that monotonically
     * increases with changes to the entity.
     *
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     *
     * For [missing][google.datastore.v1.LookupResponse.missing] entities in
     * `LookupResponse`, this is the version of the snapshot that was used to look
     * up the entity, and it is always set except for eventually consistent reads.
     * </pre>
     *
     * <code>int64 version = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000002);
      version_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was created.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the entity was last changed.
     * This field is set for
     * [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
     * If this entity is missing, this field will not be set.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.ByteString cursor_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the result entity.
     * Set only when the `EntityResult` is part of a `QueryResultBatch` message.
     * </pre>
     *
     * <code>bytes cursor = 3;</code>
     *
     * @return The cursor.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCursor() {
      return cursor_;
    }

    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the result entity.
     * Set only when the `EntityResult` is part of a `QueryResultBatch` message.
     * </pre>
     *
     * <code>bytes cursor = 3;</code>
     *
     * @param value The cursor to set.
     * @return This builder for chaining.
     */
    public Builder setCursor(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cursor_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the result entity.
     * Set only when the `EntityResult` is part of a `QueryResultBatch` message.
     * </pre>
     *
     * <code>bytes cursor = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCursor() {
      bitField0_ = (bitField0_ & ~0x00000010);
      cursor_ = getDefaultInstance().getCursor();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.EntityResult)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.EntityResult)
  private static final com.google.datastore.v1.EntityResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.EntityResult();
  }

  public static com.google.datastore.v1.EntityResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityResult> PARSER =
      new com.google.protobuf.AbstractParser<EntityResult>() {
        @java.lang.Override
        public EntityResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EntityResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.EntityResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
