/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1beta2/workflow_templates.proto

package com.google.cloud.dataproc.v1beta2;

/**
 *
 *
 * <pre>
 * The workflow node.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1beta2.WorkflowNode}
 */
public final class WorkflowNode extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1beta2.WorkflowNode)
    WorkflowNodeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkflowNode.newBuilder() to construct.
  private WorkflowNode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowNode() {
    stepId_ = "";
    prerequisiteStepIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    jobId_ = "";
    state_ = 0;
    error_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowNode();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WorkflowNode(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              stepId_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                prerequisiteStepIds_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              prerequisiteStepIds_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              jobId_ = s;
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              error_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        prerequisiteStepIds_ = prerequisiteStepIds_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1beta2.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1beta2_WorkflowNode_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1beta2.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1beta2_WorkflowNode_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1beta2.WorkflowNode.class,
            com.google.cloud.dataproc.v1beta2.WorkflowNode.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The workflow node state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1beta2.WorkflowNode.NodeState}
   */
  public enum NodeState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State is unspecified.
     * </pre>
     *
     * <code>NODE_STATUS_UNSPECIFIED = 0;</code>
     */
    NODE_STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The node is awaiting prerequisite node to finish.
     * </pre>
     *
     * <code>BLOCKED = 1;</code>
     */
    BLOCKED(1),
    /**
     *
     *
     * <pre>
     * The node is runnable but not running.
     * </pre>
     *
     * <code>RUNNABLE = 2;</code>
     */
    RUNNABLE(2),
    /**
     *
     *
     * <pre>
     * The node is running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    /**
     *
     *
     * <pre>
     * The node completed successfully.
     * </pre>
     *
     * <code>COMPLETED = 4;</code>
     */
    COMPLETED(4),
    /**
     *
     *
     * <pre>
     * The node failed. A node can be marked FAILED because
     * its ancestor or peer failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State is unspecified.
     * </pre>
     *
     * <code>NODE_STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int NODE_STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The node is awaiting prerequisite node to finish.
     * </pre>
     *
     * <code>BLOCKED = 1;</code>
     */
    public static final int BLOCKED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The node is runnable but not running.
     * </pre>
     *
     * <code>RUNNABLE = 2;</code>
     */
    public static final int RUNNABLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The node is running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The node completed successfully.
     * </pre>
     *
     * <code>COMPLETED = 4;</code>
     */
    public static final int COMPLETED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The node failed. A node can be marked FAILED because
     * its ancestor or peer failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NodeState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NodeState forNumber(int value) {
      switch (value) {
        case 0:
          return NODE_STATUS_UNSPECIFIED;
        case 1:
          return BLOCKED;
        case 2:
          return RUNNABLE;
        case 3:
          return RUNNING;
        case 4:
          return COMPLETED;
        case 5:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NodeState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NodeState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NodeState>() {
          public NodeState findValueByNumber(int number) {
            return NodeState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.WorkflowNode.getDescriptor().getEnumTypes().get(0);
    }

    private static final NodeState[] VALUES = values();

    public static NodeState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NodeState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1beta2.WorkflowNode.NodeState)
  }

  public static final int STEP_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object stepId_;
  /**
   *
   *
   * <pre>
   * Output only. The name of the node.
   * </pre>
   *
   * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stepId.
   */
  public java.lang.String getStepId() {
    java.lang.Object ref = stepId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stepId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the node.
   * </pre>
   *
   * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stepId.
   */
  public com.google.protobuf.ByteString getStepIdBytes() {
    java.lang.Object ref = stepId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stepId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREREQUISITE_STEP_IDS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList prerequisiteStepIds_;
  /**
   *
   *
   * <pre>
   * Output only. Node's prerequisite nodes.
   * </pre>
   *
   * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the prerequisiteStepIds.
   */
  public com.google.protobuf.ProtocolStringList getPrerequisiteStepIdsList() {
    return prerequisiteStepIds_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Node's prerequisite nodes.
   * </pre>
   *
   * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of prerequisiteStepIds.
   */
  public int getPrerequisiteStepIdsCount() {
    return prerequisiteStepIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Node's prerequisite nodes.
   * </pre>
   *
   * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The prerequisiteStepIds at the given index.
   */
  public java.lang.String getPrerequisiteStepIds(int index) {
    return prerequisiteStepIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Node's prerequisite nodes.
   * </pre>
   *
   * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the prerequisiteStepIds at the given index.
   */
  public com.google.protobuf.ByteString getPrerequisiteStepIdsBytes(int index) {
    return prerequisiteStepIds_.getByteString(index);
  }

  public static final int JOB_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object jobId_;
  /**
   *
   *
   * <pre>
   * Output only. The job id; populated after the node enters RUNNING state.
   * </pre>
   *
   * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The jobId.
   */
  public java.lang.String getJobId() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The job id; populated after the node enters RUNNING state.
   * </pre>
   *
   * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for jobId.
   */
  public com.google.protobuf.ByteString getJobIdBytes() {
    java.lang.Object ref = jobId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The node state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The node state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  public com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState result =
        com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.valueOf(state_);
    return result == null
        ? com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_FIELD_NUMBER = 6;
  private volatile java.lang.Object error_;
  /**
   *
   *
   * <pre>
   * Output only. The error detail.
   * </pre>
   *
   * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  public java.lang.String getError() {
    java.lang.Object ref = error_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      error_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The error detail.
   * </pre>
   *
   * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for error.
   */
  public com.google.protobuf.ByteString getErrorBytes() {
    java.lang.Object ref = error_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      error_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getStepIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, stepId_);
    }
    for (int i = 0; i < prerequisiteStepIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, prerequisiteStepIds_.getRaw(i));
    }
    if (!getJobIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jobId_);
    }
    if (state_
        != com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.NODE_STATUS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, state_);
    }
    if (!getErrorBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, error_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getStepIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, stepId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < prerequisiteStepIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(prerequisiteStepIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPrerequisiteStepIdsList().size();
    }
    if (!getJobIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, jobId_);
    }
    if (state_
        != com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.NODE_STATUS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (!getErrorBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, error_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1beta2.WorkflowNode)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1beta2.WorkflowNode other =
        (com.google.cloud.dataproc.v1beta2.WorkflowNode) obj;

    if (!getStepId().equals(other.getStepId())) return false;
    if (!getPrerequisiteStepIdsList().equals(other.getPrerequisiteStepIdsList())) return false;
    if (!getJobId().equals(other.getJobId())) return false;
    if (state_ != other.state_) return false;
    if (!getError().equals(other.getError())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STEP_ID_FIELD_NUMBER;
    hash = (53 * hash) + getStepId().hashCode();
    if (getPrerequisiteStepIdsCount() > 0) {
      hash = (37 * hash) + PREREQUISITE_STEP_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getPrerequisiteStepIdsList().hashCode();
    }
    hash = (37 * hash) + JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + getJobId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ERROR_FIELD_NUMBER;
    hash = (53 * hash) + getError().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1beta2.WorkflowNode prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The workflow node.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1beta2.WorkflowNode}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1beta2.WorkflowNode)
      com.google.cloud.dataproc.v1beta2.WorkflowNodeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1beta2_WorkflowNode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1beta2.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1beta2_WorkflowNode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1beta2.WorkflowNode.class,
              com.google.cloud.dataproc.v1beta2.WorkflowNode.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1beta2.WorkflowNode.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      stepId_ = "";

      prerequisiteStepIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      jobId_ = "";

      state_ = 0;

      error_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1beta2.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1beta2_WorkflowNode_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.WorkflowNode getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1beta2.WorkflowNode.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.WorkflowNode build() {
      com.google.cloud.dataproc.v1beta2.WorkflowNode result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.WorkflowNode buildPartial() {
      com.google.cloud.dataproc.v1beta2.WorkflowNode result =
          new com.google.cloud.dataproc.v1beta2.WorkflowNode(this);
      int from_bitField0_ = bitField0_;
      result.stepId_ = stepId_;
      if (((bitField0_ & 0x00000001) != 0)) {
        prerequisiteStepIds_ = prerequisiteStepIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.prerequisiteStepIds_ = prerequisiteStepIds_;
      result.jobId_ = jobId_;
      result.state_ = state_;
      result.error_ = error_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1beta2.WorkflowNode) {
        return mergeFrom((com.google.cloud.dataproc.v1beta2.WorkflowNode) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1beta2.WorkflowNode other) {
      if (other == com.google.cloud.dataproc.v1beta2.WorkflowNode.getDefaultInstance()) return this;
      if (!other.getStepId().isEmpty()) {
        stepId_ = other.stepId_;
        onChanged();
      }
      if (!other.prerequisiteStepIds_.isEmpty()) {
        if (prerequisiteStepIds_.isEmpty()) {
          prerequisiteStepIds_ = other.prerequisiteStepIds_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensurePrerequisiteStepIdsIsMutable();
          prerequisiteStepIds_.addAll(other.prerequisiteStepIds_);
        }
        onChanged();
      }
      if (!other.getJobId().isEmpty()) {
        jobId_ = other.jobId_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getError().isEmpty()) {
        error_ = other.error_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dataproc.v1beta2.WorkflowNode parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dataproc.v1beta2.WorkflowNode) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object stepId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the node.
     * </pre>
     *
     * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stepId.
     */
    public java.lang.String getStepId() {
      java.lang.Object ref = stepId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stepId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the node.
     * </pre>
     *
     * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stepId.
     */
    public com.google.protobuf.ByteString getStepIdBytes() {
      java.lang.Object ref = stepId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stepId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the node.
     * </pre>
     *
     * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stepId to set.
     * @return This builder for chaining.
     */
    public Builder setStepId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      stepId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the node.
     * </pre>
     *
     * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStepId() {

      stepId_ = getDefaultInstance().getStepId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the node.
     * </pre>
     *
     * <code>string step_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stepId to set.
     * @return This builder for chaining.
     */
    public Builder setStepIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      stepId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList prerequisiteStepIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePrerequisiteStepIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        prerequisiteStepIds_ = new com.google.protobuf.LazyStringArrayList(prerequisiteStepIds_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the prerequisiteStepIds.
     */
    public com.google.protobuf.ProtocolStringList getPrerequisiteStepIdsList() {
      return prerequisiteStepIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of prerequisiteStepIds.
     */
    public int getPrerequisiteStepIdsCount() {
      return prerequisiteStepIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The prerequisiteStepIds at the given index.
     */
    public java.lang.String getPrerequisiteStepIds(int index) {
      return prerequisiteStepIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the prerequisiteStepIds at the given index.
     */
    public com.google.protobuf.ByteString getPrerequisiteStepIdsBytes(int index) {
      return prerequisiteStepIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The prerequisiteStepIds to set.
     * @return This builder for chaining.
     */
    public Builder setPrerequisiteStepIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrerequisiteStepIdsIsMutable();
      prerequisiteStepIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The prerequisiteStepIds to add.
     * @return This builder for chaining.
     */
    public Builder addPrerequisiteStepIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrerequisiteStepIdsIsMutable();
      prerequisiteStepIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The prerequisiteStepIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrerequisiteStepIds(java.lang.Iterable<java.lang.String> values) {
      ensurePrerequisiteStepIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, prerequisiteStepIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrerequisiteStepIds() {
      prerequisiteStepIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Node's prerequisite nodes.
     * </pre>
     *
     * <code>repeated string prerequisite_step_ids = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the prerequisiteStepIds to add.
     * @return This builder for chaining.
     */
    public Builder addPrerequisiteStepIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePrerequisiteStepIdsIsMutable();
      prerequisiteStepIds_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object jobId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The job id; populated after the node enters RUNNING state.
     * </pre>
     *
     * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobId.
     */
    public java.lang.String getJobId() {
      java.lang.Object ref = jobId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job id; populated after the node enters RUNNING state.
     * </pre>
     *
     * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobId.
     */
    public com.google.protobuf.ByteString getJobIdBytes() {
      java.lang.Object ref = jobId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job id; populated after the node enters RUNNING state.
     * </pre>
     *
     * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      jobId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job id; populated after the node enters RUNNING state.
     * </pre>
     *
     * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobId() {

      jobId_ = getDefaultInstance().getJobId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job id; populated after the node enters RUNNING state.
     * </pre>
     *
     * <code>string job_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for jobId to set.
     * @return This builder for chaining.
     */
    public Builder setJobIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      jobId_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The node state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The node state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The node state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    public com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState result =
          com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.valueOf(state_);
      return result == null
          ? com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The node state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataproc.v1beta2.WorkflowNode.NodeState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The node state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.WorkflowNode.NodeState state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object error_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The error detail.
     * </pre>
     *
     * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public java.lang.String getError() {
      java.lang.Object ref = error_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        error_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error detail.
     * </pre>
     *
     * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for error.
     */
    public com.google.protobuf.ByteString getErrorBytes() {
      java.lang.Object ref = error_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        error_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error detail.
     * </pre>
     *
     * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The error to set.
     * @return This builder for chaining.
     */
    public Builder setError(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      error_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error detail.
     * </pre>
     *
     * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearError() {

      error_ = getDefaultInstance().getError();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error detail.
     * </pre>
     *
     * <code>string error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for error to set.
     * @return This builder for chaining.
     */
    public Builder setErrorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      error_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1beta2.WorkflowNode)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1beta2.WorkflowNode)
  private static final com.google.cloud.dataproc.v1beta2.WorkflowNode DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1beta2.WorkflowNode();
  }

  public static com.google.cloud.dataproc.v1beta2.WorkflowNode getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowNode> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowNode>() {
        @java.lang.Override
        public WorkflowNode parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WorkflowNode(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WorkflowNode> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowNode> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1beta2.WorkflowNode getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
