/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1beta2/operations.proto

package com.google.cloud.dataproc.v1beta2;

/**
 *
 *
 * <pre>
 * Metadata describing the operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1beta2.ClusterOperationMetadata}
 */
public final class ClusterOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1beta2.ClusterOperationMetadata)
    ClusterOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterOperationMetadata.newBuilder() to construct.
  private ClusterOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterOperationMetadata() {
    clusterName_ = "";
    clusterUuid_ = "";
    statusHistory_ = java.util.Collections.emptyList();
    operationType_ = "";
    description_ = "";
    warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ClusterOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              clusterName_ = s;
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              clusterUuid_ = s;
              break;
            }
          case 74:
            {
              com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder subBuilder = null;
              if (status_ != null) {
                subBuilder = status_.toBuilder();
              }
              status_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(status_);
                status_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                statusHistory_ =
                    new java.util.ArrayList<
                        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>();
                mutable_bitField0_ |= 0x00000001;
              }
              statusHistory_.add(
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.parser(),
                      extensionRegistry));
              break;
            }
          case 90:
            {
              java.lang.String s = input.readStringRequireUtf8();

              operationType_ = s;
              break;
            }
          case 98:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 106:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 114:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                warnings_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              warnings_.add(s);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        warnings_ = warnings_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1beta2.OperationsProto
        .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 13:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1beta2.OperationsProto
        .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.class,
            com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.Builder.class);
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 7;
  private volatile java.lang.Object clusterName_;
  /**
   *
   *
   * <pre>
   * Output only. Name of the cluster for the operation.
   * </pre>
   *
   * <code>string cluster_name = 7;</code>
   *
   * @return The clusterName.
   */
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the cluster for the operation.
   * </pre>
   *
   * <code>string cluster_name = 7;</code>
   *
   * @return The bytes for clusterName.
   */
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_UUID_FIELD_NUMBER = 8;
  private volatile java.lang.Object clusterUuid_;
  /**
   *
   *
   * <pre>
   * Output only. Cluster UUID for the operation.
   * </pre>
   *
   * <code>string cluster_uuid = 8;</code>
   *
   * @return The clusterUuid.
   */
  public java.lang.String getClusterUuid() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster UUID for the operation.
   * </pre>
   *
   * <code>string cluster_uuid = 8;</code>
   *
   * @return The bytes for clusterUuid.
   */
  public com.google.protobuf.ByteString getClusterUuidBytes() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 9;
  private com.google.cloud.dataproc.v1beta2.ClusterOperationStatus status_;
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
   *
   * @return Whether the status field is set.
   */
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
   *
   * @return The status.
   */
  public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus getStatus() {
    return status_ == null
        ? com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  public static final int STATUS_HISTORY_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus> statusHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
   * </code>
   */
  public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>
      getStatusHistoryList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
   * </code>
   */
  public java.util.List<? extends com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
      getStatusHistoryOrBuilderList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
   * </code>
   */
  public int getStatusHistoryCount() {
    return statusHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus getStatusHistory(int index) {
    return statusHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder
      getStatusHistoryOrBuilder(int index) {
    return statusHistory_.get(index);
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 11;
  private volatile java.lang.Object operationType_;
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>string operation_type = 11;</code>
   *
   * @return The operationType.
   */
  public java.lang.String getOperationType() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>string operation_type = 11;</code>
   *
   * @return The bytes for operationType.
   */
  public com.google.protobuf.ByteString getOperationTypeBytes() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 12;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Output only. Short description of operation.
   * </pre>
   *
   * <code>string description = 12;</code>
   *
   * @return The description.
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Short description of operation.
   * </pre>
   *
   * <code>string description = 12;</code>
   *
   * @return The bytes for description.
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 13;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1beta2.OperationsProto
                .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13;</code>
   */
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13;</code>
   */
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13;</code>
   */
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WARNINGS_FIELD_NUMBER = 14;
  private com.google.protobuf.LazyStringList warnings_;
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14;</code>
   *
   * @return A list containing the warnings.
   */
  public com.google.protobuf.ProtocolStringList getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14;</code>
   *
   * @return The count of warnings.
   */
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  public java.lang.String getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  public com.google.protobuf.ByteString getWarningsBytes(int index) {
    return warnings_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getClusterNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, clusterName_);
    }
    if (!getClusterUuidBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, clusterUuid_);
    }
    if (status_ != null) {
      output.writeMessage(9, getStatus());
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      output.writeMessage(10, statusHistory_.get(i));
    }
    if (!getOperationTypeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, operationType_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 13);
    for (int i = 0; i < warnings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, warnings_.getRaw(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getClusterNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, clusterName_);
    }
    if (!getClusterUuidBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, clusterUuid_);
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getStatus());
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, statusHistory_.get(i));
    }
    if (!getOperationTypeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, operationType_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < warnings_.size(); i++) {
        dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWarningsList().size();
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata other =
        (com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata) obj;

    if (!getClusterName().equals(other.getClusterName())) return false;
    if (!getClusterUuid().equals(other.getClusterUuid())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusHistoryList().equals(other.getStatusHistoryList())) return false;
    if (!getOperationType().equals(other.getOperationType())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    hash = (37 * hash) + CLUSTER_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterUuid().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusHistoryCount() > 0) {
      hash = (37 * hash) + STATUS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatusHistoryList().hashCode();
    }
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getOperationType().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing the operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1beta2.ClusterOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1beta2.ClusterOperationMetadata)
      com.google.cloud.dataproc.v1beta2.ClusterOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.OperationsProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 13:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 13:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1beta2.OperationsProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.class,
              com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatusHistoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      clusterName_ = "";

      clusterUuid_ = "";

      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        statusHistoryBuilder_.clear();
      }
      operationType_ = "";

      description_ = "";

      internalGetMutableLabels().clear();
      warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1beta2.OperationsProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata build() {
      com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata buildPartial() {
      com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata result =
          new com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata(this);
      int from_bitField0_ = bitField0_;
      result.clusterName_ = clusterName_;
      result.clusterUuid_ = clusterUuid_;
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      if (statusHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.statusHistory_ = statusHistory_;
      } else {
        result.statusHistory_ = statusHistoryBuilder_.build();
      }
      result.operationType_ = operationType_;
      result.description_ = description_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (((bitField0_ & 0x00000004) != 0)) {
        warnings_ = warnings_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.warnings_ = warnings_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata) {
        return mergeFrom((com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata other) {
      if (other == com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata.getDefaultInstance())
        return this;
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        onChanged();
      }
      if (!other.getClusterUuid().isEmpty()) {
        clusterUuid_ = other.clusterUuid_;
        onChanged();
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (statusHistoryBuilder_ == null) {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistory_.isEmpty()) {
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureStatusHistoryIsMutable();
            statusHistory_.addAll(other.statusHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistoryBuilder_.isEmpty()) {
            statusHistoryBuilder_.dispose();
            statusHistoryBuilder_ = null;
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000001);
            statusHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusHistoryFieldBuilder()
                    : null;
          } else {
            statusHistoryBuilder_.addAllMessages(other.statusHistory_);
          }
        }
      }
      if (!other.getOperationType().isEmpty()) {
        operationType_ = other.operationType_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.warnings_.isEmpty()) {
        if (warnings_.isEmpty()) {
          warnings_ = other.warnings_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureWarningsIsMutable();
          warnings_.addAll(other.warnings_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7;</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7;</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7;</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {

      clusterName_ = getDefaultInstance().getClusterName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7;</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object clusterUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8;</code>
     *
     * @return The clusterUuid.
     */
    public java.lang.String getClusterUuid() {
      java.lang.Object ref = clusterUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8;</code>
     *
     * @return The bytes for clusterUuid.
     */
    public com.google.protobuf.ByteString getClusterUuidBytes() {
      java.lang.Object ref = clusterUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8;</code>
     *
     * @param value The clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterUuid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterUuid() {

      clusterUuid_ = getDefaultInstance().getClusterUuid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8;</code>
     *
     * @param value The bytes for clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterUuid_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1beta2.ClusterOperationStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     *
     * @return The status.
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1beta2.ClusterOperationStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public Builder setStatus(
        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public Builder mergeStatus(com.google.cloud.dataproc.v1beta2.ClusterOperationStatus value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
              com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.newBuilder(status_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1beta2.ClusterOperationStatus status = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>
        statusHistory_ = java.util.Collections.emptyList();

    private void ensureStatusHistoryIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        statusHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>(
                statusHistory_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
        statusHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>
        getStatusHistoryList() {
      if (statusHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusHistory_);
      } else {
        return statusHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public int getStatusHistoryCount() {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.size();
      } else {
        return statusHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus getStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder setStatusHistory(
        int index,
        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder addStatusHistory(
        int index,
        com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder addAllStatusHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1beta2.ClusterOperationStatus>
            values) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusHistory_);
        onChanged();
      } else {
        statusHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder clearStatusHistory() {
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        statusHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public Builder removeStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.remove(index);
        onChanged();
      } else {
        statusHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder getStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder
        getStatusHistoryOrBuilder(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
        getStatusHistoryOrBuilderList() {
      if (statusHistoryBuilder_ != null) {
        return statusHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder
        addStatusHistoryBuilder() {
      return getStatusHistoryFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder addStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>repeated .google.cloud.dataproc.v1beta2.ClusterOperationStatus status_history = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder>
        getStatusHistoryBuilderList() {
      return getStatusHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>
        getStatusHistoryFieldBuilder() {
      if (statusHistoryBuilder_ == null) {
        statusHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatus,
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatus.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterOperationStatusOrBuilder>(
                statusHistory_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        statusHistory_ = null;
      }
      return statusHistoryBuilder_;
    }

    private java.lang.Object operationType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11;</code>
     *
     * @return The operationType.
     */
    public java.lang.String getOperationType() {
      java.lang.Object ref = operationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11;</code>
     *
     * @return The bytes for operationType.
     */
    public com.google.protobuf.ByteString getOperationTypeBytes() {
      java.lang.Object ref = operationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11;</code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      operationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {

      operationType_ = getDefaultInstance().getOperationType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11;</code>
     *
     * @param value The bytes for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      operationType_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.LazyStringList warnings_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      return warnings_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param index The index to set the value at.
     * @param value The warnings to set.
     * @return This builder for chaining.
     */
    public Builder setWarnings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param value The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarnings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param values The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
      ensureWarningsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWarnings() {
      warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14;</code>
     *
     * @param value The bytes of the warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWarningsIsMutable();
      warnings_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1beta2.ClusterOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1beta2.ClusterOperationMetadata)
  private static final com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata();
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ClusterOperationMetadata>() {
        @java.lang.Override
        public ClusterOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ClusterOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ClusterOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1beta2.ClusterOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
