/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1beta2/clusters.proto

package com.google.cloud.dataproc.v1beta2;

/**
 *
 *
 * <pre>
 * The cluster config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1beta2.ClusterConfig}
 */
public final class ClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1beta2.ClusterConfig)
    ClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterConfig.newBuilder() to construct.
  private ClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterConfig() {
    configBucket_ = "";
    initializationActions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ClusterConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              configBucket_ = s;
              break;
            }
          case 66:
            {
              com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder subBuilder = null;
              if (gceClusterConfig_ != null) {
                subBuilder = gceClusterConfig_.toBuilder();
              }
              gceClusterConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.GceClusterConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(gceClusterConfig_);
                gceClusterConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder subBuilder = null;
              if (masterConfig_ != null) {
                subBuilder = masterConfig_.toBuilder();
              }
              masterConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(masterConfig_);
                masterConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder subBuilder = null;
              if (workerConfig_ != null) {
                subBuilder = workerConfig_.toBuilder();
              }
              workerConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(workerConfig_);
                workerConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                initializationActions_ =
                    new java.util.ArrayList<
                        com.google.cloud.dataproc.v1beta2.NodeInitializationAction>();
                mutable_bitField0_ |= 0x00000001;
              }
              initializationActions_.add(
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.NodeInitializationAction.parser(),
                      extensionRegistry));
              break;
            }
          case 98:
            {
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder subBuilder = null;
              if (secondaryWorkerConfig_ != null) {
                subBuilder = secondaryWorkerConfig_.toBuilder();
              }
              secondaryWorkerConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(secondaryWorkerConfig_);
                secondaryWorkerConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder subBuilder = null;
              if (softwareConfig_ != null) {
                subBuilder = softwareConfig_.toBuilder();
              }
              softwareConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.SoftwareConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(softwareConfig_);
                softwareConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder subBuilder = null;
              if (lifecycleConfig_ != null) {
                subBuilder = lifecycleConfig_.toBuilder();
              }
              lifecycleConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.LifecycleConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(lifecycleConfig_);
                lifecycleConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder subBuilder = null;
              if (encryptionConfig_ != null) {
                subBuilder = encryptionConfig_.toBuilder();
              }
              encryptionConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.EncryptionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryptionConfig_);
                encryptionConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 130:
            {
              com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder subBuilder = null;
              if (autoscalingConfig_ != null) {
                subBuilder = autoscalingConfig_.toBuilder();
              }
              autoscalingConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.AutoscalingConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(autoscalingConfig_);
                autoscalingConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 138:
            {
              com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder subBuilder = null;
              if (endpointConfig_ != null) {
                subBuilder = endpointConfig_.toBuilder();
              }
              endpointConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.EndpointConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endpointConfig_);
                endpointConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 146:
            {
              com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder subBuilder = null;
              if (securityConfig_ != null) {
                subBuilder = securityConfig_.toBuilder();
              }
              securityConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.SecurityConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(securityConfig_);
                securityConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        initializationActions_ = java.util.Collections.unmodifiableList(initializationActions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1beta2.ClustersProto
        .internal_static_google_cloud_dataproc_v1beta2_ClusterConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1beta2.ClustersProto
        .internal_static_google_cloud_dataproc_v1beta2_ClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1beta2.ClusterConfig.class,
            com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder.class);
  }

  public static final int CONFIG_BUCKET_FIELD_NUMBER = 1;
  private volatile java.lang.Object configBucket_;
  /**
   *
   *
   * <pre>
   * Optional. A Google Cloud Storage bucket used to stage job
   * dependencies, config files, and job driver console output.
   * If you do not specify a staging bucket, Cloud
   * Dataproc will determine a Cloud Storage location (US,
   * ASIA, or EU) for your cluster's staging bucket according to the Google
   * Compute Engine zone where your cluster is deployed, and then create
   * and manage this project-level, per-location bucket (see
   * [Cloud Dataproc staging
   * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
   * </pre>
   *
   * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The configBucket.
   */
  public java.lang.String getConfigBucket() {
    java.lang.Object ref = configBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      configBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A Google Cloud Storage bucket used to stage job
   * dependencies, config files, and job driver console output.
   * If you do not specify a staging bucket, Cloud
   * Dataproc will determine a Cloud Storage location (US,
   * ASIA, or EU) for your cluster's staging bucket according to the Google
   * Compute Engine zone where your cluster is deployed, and then create
   * and manage this project-level, per-location bucket (see
   * [Cloud Dataproc staging
   * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
   * </pre>
   *
   * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for configBucket.
   */
  public com.google.protobuf.ByteString getConfigBucketBytes() {
    java.lang.Object ref = configBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      configBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCE_CLUSTER_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.dataproc.v1beta2.GceClusterConfig gceClusterConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The shared Compute Engine config settings for
   * all instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gceClusterConfig field is set.
   */
  public boolean hasGceClusterConfig() {
    return gceClusterConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The shared Compute Engine config settings for
   * all instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gceClusterConfig.
   */
  public com.google.cloud.dataproc.v1beta2.GceClusterConfig getGceClusterConfig() {
    return gceClusterConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.GceClusterConfig.getDefaultInstance()
        : gceClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The shared Compute Engine config settings for
   * all instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.GceClusterConfigOrBuilder
      getGceClusterConfigOrBuilder() {
    return getGceClusterConfig();
  }

  public static final int MASTER_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig masterConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * the master instance in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the masterConfig field is set.
   */
  public boolean hasMasterConfig() {
    return masterConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * the master instance in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The masterConfig.
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getMasterConfig() {
    return masterConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
        : masterConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * the master instance in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder getMasterConfigOrBuilder() {
    return getMasterConfig();
  }

  public static final int WORKER_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig workerConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the workerConfig field is set.
   */
  public boolean hasWorkerConfig() {
    return workerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The workerConfig.
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getWorkerConfig() {
    return workerConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
        : workerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder getWorkerConfigOrBuilder() {
    return getWorkerConfig();
  }

  public static final int SECONDARY_WORKER_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig secondaryWorkerConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * additional worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the secondaryWorkerConfig field is set.
   */
  public boolean hasSecondaryWorkerConfig() {
    return secondaryWorkerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * additional worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The secondaryWorkerConfig.
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getSecondaryWorkerConfig() {
    return secondaryWorkerConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
        : secondaryWorkerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine config settings for
   * additional worker instances in a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder
      getSecondaryWorkerConfigOrBuilder() {
    return getSecondaryWorkerConfig();
  }

  public static final int SOFTWARE_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.dataproc.v1beta2.SoftwareConfig softwareConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The config settings for software inside the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the softwareConfig field is set.
   */
  public boolean hasSoftwareConfig() {
    return softwareConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The config settings for software inside the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The softwareConfig.
   */
  public com.google.cloud.dataproc.v1beta2.SoftwareConfig getSoftwareConfig() {
    return softwareConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.SoftwareConfig.getDefaultInstance()
        : softwareConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The config settings for software inside the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.SoftwareConfigOrBuilder getSoftwareConfigOrBuilder() {
    return getSoftwareConfig();
  }

  public static final int LIFECYCLE_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.dataproc.v1beta2.LifecycleConfig lifecycleConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The config setting for auto delete cluster schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the lifecycleConfig field is set.
   */
  public boolean hasLifecycleConfig() {
    return lifecycleConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The config setting for auto delete cluster schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The lifecycleConfig.
   */
  public com.google.cloud.dataproc.v1beta2.LifecycleConfig getLifecycleConfig() {
    return lifecycleConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.LifecycleConfig.getDefaultInstance()
        : lifecycleConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The config setting for auto delete cluster schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.LifecycleConfigOrBuilder getLifecycleConfigOrBuilder() {
    return getLifecycleConfig();
  }

  public static final int INITIALIZATION_ACTIONS_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloud.dataproc.v1beta2.NodeInitializationAction>
      initializationActions_;
  /**
   *
   *
   * <pre>
   * Optional. Commands to execute on each node after config is
   * completed. By default, executables are run on master and all worker nodes.
   * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
   * a master or worker node, as shown below using `curl` (you can also use
   * `wget`):
   *     ROLE=$(curl -H Metadata-Flavor:Google
   *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
   *     if [[ "${ROLE}" == 'Master' ]]; then
   *       ... master specific actions ...
   *     else
   *       ... worker specific actions ...
   *     fi
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.util.List<com.google.cloud.dataproc.v1beta2.NodeInitializationAction>
      getInitializationActionsList() {
    return initializationActions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Commands to execute on each node after config is
   * completed. By default, executables are run on master and all worker nodes.
   * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
   * a master or worker node, as shown below using `curl` (you can also use
   * `wget`):
   *     ROLE=$(curl -H Metadata-Flavor:Google
   *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
   *     if [[ "${ROLE}" == 'Master' ]]; then
   *       ... master specific actions ...
   *     else
   *       ... worker specific actions ...
   *     fi
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder>
      getInitializationActionsOrBuilderList() {
    return initializationActions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Commands to execute on each node after config is
   * completed. By default, executables are run on master and all worker nodes.
   * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
   * a master or worker node, as shown below using `curl` (you can also use
   * `wget`):
   *     ROLE=$(curl -H Metadata-Flavor:Google
   *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
   *     if [[ "${ROLE}" == 'Master' ]]; then
   *       ... master specific actions ...
   *     else
   *       ... worker specific actions ...
   *     fi
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getInitializationActionsCount() {
    return initializationActions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Commands to execute on each node after config is
   * completed. By default, executables are run on master and all worker nodes.
   * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
   * a master or worker node, as shown below using `curl` (you can also use
   * `wget`):
   *     ROLE=$(curl -H Metadata-Flavor:Google
   *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
   *     if [[ "${ROLE}" == 'Master' ]]; then
   *       ... master specific actions ...
   *     else
   *       ... worker specific actions ...
   *     fi
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.NodeInitializationAction getInitializationActions(
      int index) {
    return initializationActions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Commands to execute on each node after config is
   * completed. By default, executables are run on master and all worker nodes.
   * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
   * a master or worker node, as shown below using `curl` (you can also use
   * `wget`):
   *     ROLE=$(curl -H Metadata-Flavor:Google
   *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
   *     if [[ "${ROLE}" == 'Master' ]]; then
   *       ... master specific actions ...
   *     else
   *       ... worker specific actions ...
   *     fi
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder
      getInitializationActionsOrBuilder(int index) {
    return initializationActions_.get(index);
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.dataproc.v1beta2.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Encryption settings for the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  public boolean hasEncryptionConfig() {
    return encryptionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Encryption settings for the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  public com.google.cloud.dataproc.v1beta2.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Encryption settings for the cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return getEncryptionConfig();
  }

  public static final int AUTOSCALING_CONFIG_FIELD_NUMBER = 16;
  private com.google.cloud.dataproc.v1beta2.AutoscalingConfig autoscalingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Autoscaling config for the policy associated with the cluster.
   * Cluster does not autoscale if this field is unset.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoscalingConfig field is set.
   */
  public boolean hasAutoscalingConfig() {
    return autoscalingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Autoscaling config for the policy associated with the cluster.
   * Cluster does not autoscale if this field is unset.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoscalingConfig.
   */
  public com.google.cloud.dataproc.v1beta2.AutoscalingConfig getAutoscalingConfig() {
    return autoscalingConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.AutoscalingConfig.getDefaultInstance()
        : autoscalingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Autoscaling config for the policy associated with the cluster.
   * Cluster does not autoscale if this field is unset.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.AutoscalingConfigOrBuilder
      getAutoscalingConfigOrBuilder() {
    return getAutoscalingConfig();
  }

  public static final int ENDPOINT_CONFIG_FIELD_NUMBER = 17;
  private com.google.cloud.dataproc.v1beta2.EndpointConfig endpointConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Port/endpoint configuration for this cluster
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the endpointConfig field is set.
   */
  public boolean hasEndpointConfig() {
    return endpointConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Port/endpoint configuration for this cluster
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The endpointConfig.
   */
  public com.google.cloud.dataproc.v1beta2.EndpointConfig getEndpointConfig() {
    return endpointConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.EndpointConfig.getDefaultInstance()
        : endpointConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Port/endpoint configuration for this cluster
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.EndpointConfigOrBuilder getEndpointConfigOrBuilder() {
    return getEndpointConfig();
  }

  public static final int SECURITY_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.dataproc.v1beta2.SecurityConfig securityConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Security related configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the securityConfig field is set.
   */
  public boolean hasSecurityConfig() {
    return securityConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Security related configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The securityConfig.
   */
  public com.google.cloud.dataproc.v1beta2.SecurityConfig getSecurityConfig() {
    return securityConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.SecurityConfig.getDefaultInstance()
        : securityConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Security related configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.SecurityConfigOrBuilder getSecurityConfigOrBuilder() {
    return getSecurityConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getConfigBucketBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, configBucket_);
    }
    if (gceClusterConfig_ != null) {
      output.writeMessage(8, getGceClusterConfig());
    }
    if (masterConfig_ != null) {
      output.writeMessage(9, getMasterConfig());
    }
    if (workerConfig_ != null) {
      output.writeMessage(10, getWorkerConfig());
    }
    for (int i = 0; i < initializationActions_.size(); i++) {
      output.writeMessage(11, initializationActions_.get(i));
    }
    if (secondaryWorkerConfig_ != null) {
      output.writeMessage(12, getSecondaryWorkerConfig());
    }
    if (softwareConfig_ != null) {
      output.writeMessage(13, getSoftwareConfig());
    }
    if (lifecycleConfig_ != null) {
      output.writeMessage(14, getLifecycleConfig());
    }
    if (encryptionConfig_ != null) {
      output.writeMessage(15, getEncryptionConfig());
    }
    if (autoscalingConfig_ != null) {
      output.writeMessage(16, getAutoscalingConfig());
    }
    if (endpointConfig_ != null) {
      output.writeMessage(17, getEndpointConfig());
    }
    if (securityConfig_ != null) {
      output.writeMessage(18, getSecurityConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getConfigBucketBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, configBucket_);
    }
    if (gceClusterConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getGceClusterConfig());
    }
    if (masterConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMasterConfig());
    }
    if (workerConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getWorkerConfig());
    }
    for (int i = 0; i < initializationActions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, initializationActions_.get(i));
    }
    if (secondaryWorkerConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSecondaryWorkerConfig());
    }
    if (softwareConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getSoftwareConfig());
    }
    if (lifecycleConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getLifecycleConfig());
    }
    if (encryptionConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getEncryptionConfig());
    }
    if (autoscalingConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getAutoscalingConfig());
    }
    if (endpointConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEndpointConfig());
    }
    if (securityConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getSecurityConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1beta2.ClusterConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1beta2.ClusterConfig other =
        (com.google.cloud.dataproc.v1beta2.ClusterConfig) obj;

    if (!getConfigBucket().equals(other.getConfigBucket())) return false;
    if (hasGceClusterConfig() != other.hasGceClusterConfig()) return false;
    if (hasGceClusterConfig()) {
      if (!getGceClusterConfig().equals(other.getGceClusterConfig())) return false;
    }
    if (hasMasterConfig() != other.hasMasterConfig()) return false;
    if (hasMasterConfig()) {
      if (!getMasterConfig().equals(other.getMasterConfig())) return false;
    }
    if (hasWorkerConfig() != other.hasWorkerConfig()) return false;
    if (hasWorkerConfig()) {
      if (!getWorkerConfig().equals(other.getWorkerConfig())) return false;
    }
    if (hasSecondaryWorkerConfig() != other.hasSecondaryWorkerConfig()) return false;
    if (hasSecondaryWorkerConfig()) {
      if (!getSecondaryWorkerConfig().equals(other.getSecondaryWorkerConfig())) return false;
    }
    if (hasSoftwareConfig() != other.hasSoftwareConfig()) return false;
    if (hasSoftwareConfig()) {
      if (!getSoftwareConfig().equals(other.getSoftwareConfig())) return false;
    }
    if (hasLifecycleConfig() != other.hasLifecycleConfig()) return false;
    if (hasLifecycleConfig()) {
      if (!getLifecycleConfig().equals(other.getLifecycleConfig())) return false;
    }
    if (!getInitializationActionsList().equals(other.getInitializationActionsList())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (hasAutoscalingConfig() != other.hasAutoscalingConfig()) return false;
    if (hasAutoscalingConfig()) {
      if (!getAutoscalingConfig().equals(other.getAutoscalingConfig())) return false;
    }
    if (hasEndpointConfig() != other.hasEndpointConfig()) return false;
    if (hasEndpointConfig()) {
      if (!getEndpointConfig().equals(other.getEndpointConfig())) return false;
    }
    if (hasSecurityConfig() != other.hasSecurityConfig()) return false;
    if (hasSecurityConfig()) {
      if (!getSecurityConfig().equals(other.getSecurityConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONFIG_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getConfigBucket().hashCode();
    if (hasGceClusterConfig()) {
      hash = (37 * hash) + GCE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGceClusterConfig().hashCode();
    }
    if (hasMasterConfig()) {
      hash = (37 * hash) + MASTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMasterConfig().hashCode();
    }
    if (hasWorkerConfig()) {
      hash = (37 * hash) + WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerConfig().hashCode();
    }
    if (hasSecondaryWorkerConfig()) {
      hash = (37 * hash) + SECONDARY_WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryWorkerConfig().hashCode();
    }
    if (hasSoftwareConfig()) {
      hash = (37 * hash) + SOFTWARE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSoftwareConfig().hashCode();
    }
    if (hasLifecycleConfig()) {
      hash = (37 * hash) + LIFECYCLE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLifecycleConfig().hashCode();
    }
    if (getInitializationActionsCount() > 0) {
      hash = (37 * hash) + INITIALIZATION_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getInitializationActionsList().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    if (hasAutoscalingConfig()) {
      hash = (37 * hash) + AUTOSCALING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingConfig().hashCode();
    }
    if (hasEndpointConfig()) {
      hash = (37 * hash) + ENDPOINT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointConfig().hashCode();
    }
    if (hasSecurityConfig()) {
      hash = (37 * hash) + SECURITY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1beta2.ClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The cluster config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1beta2.ClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1beta2.ClusterConfig)
      com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1beta2.ClusterConfig.class,
              com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1beta2.ClusterConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInitializationActionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      configBucket_ = "";

      if (gceClusterConfigBuilder_ == null) {
        gceClusterConfig_ = null;
      } else {
        gceClusterConfig_ = null;
        gceClusterConfigBuilder_ = null;
      }
      if (masterConfigBuilder_ == null) {
        masterConfig_ = null;
      } else {
        masterConfig_ = null;
        masterConfigBuilder_ = null;
      }
      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = null;
      } else {
        secondaryWorkerConfig_ = null;
        secondaryWorkerConfigBuilder_ = null;
      }
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = null;
      } else {
        softwareConfig_ = null;
        softwareConfigBuilder_ = null;
      }
      if (lifecycleConfigBuilder_ == null) {
        lifecycleConfig_ = null;
      } else {
        lifecycleConfig_ = null;
        lifecycleConfigBuilder_ = null;
      }
      if (initializationActionsBuilder_ == null) {
        initializationActions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        initializationActionsBuilder_.clear();
      }
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = null;
      } else {
        encryptionConfig_ = null;
        encryptionConfigBuilder_ = null;
      }
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfig_ = null;
      } else {
        autoscalingConfig_ = null;
        autoscalingConfigBuilder_ = null;
      }
      if (endpointConfigBuilder_ == null) {
        endpointConfig_ = null;
      } else {
        endpointConfig_ = null;
        endpointConfigBuilder_ = null;
      }
      if (securityConfigBuilder_ == null) {
        securityConfig_ = null;
      } else {
        securityConfig_ = null;
        securityConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_ClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1beta2.ClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterConfig build() {
      com.google.cloud.dataproc.v1beta2.ClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.ClusterConfig buildPartial() {
      com.google.cloud.dataproc.v1beta2.ClusterConfig result =
          new com.google.cloud.dataproc.v1beta2.ClusterConfig(this);
      int from_bitField0_ = bitField0_;
      result.configBucket_ = configBucket_;
      if (gceClusterConfigBuilder_ == null) {
        result.gceClusterConfig_ = gceClusterConfig_;
      } else {
        result.gceClusterConfig_ = gceClusterConfigBuilder_.build();
      }
      if (masterConfigBuilder_ == null) {
        result.masterConfig_ = masterConfig_;
      } else {
        result.masterConfig_ = masterConfigBuilder_.build();
      }
      if (workerConfigBuilder_ == null) {
        result.workerConfig_ = workerConfig_;
      } else {
        result.workerConfig_ = workerConfigBuilder_.build();
      }
      if (secondaryWorkerConfigBuilder_ == null) {
        result.secondaryWorkerConfig_ = secondaryWorkerConfig_;
      } else {
        result.secondaryWorkerConfig_ = secondaryWorkerConfigBuilder_.build();
      }
      if (softwareConfigBuilder_ == null) {
        result.softwareConfig_ = softwareConfig_;
      } else {
        result.softwareConfig_ = softwareConfigBuilder_.build();
      }
      if (lifecycleConfigBuilder_ == null) {
        result.lifecycleConfig_ = lifecycleConfig_;
      } else {
        result.lifecycleConfig_ = lifecycleConfigBuilder_.build();
      }
      if (initializationActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          initializationActions_ = java.util.Collections.unmodifiableList(initializationActions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.initializationActions_ = initializationActions_;
      } else {
        result.initializationActions_ = initializationActionsBuilder_.build();
      }
      if (encryptionConfigBuilder_ == null) {
        result.encryptionConfig_ = encryptionConfig_;
      } else {
        result.encryptionConfig_ = encryptionConfigBuilder_.build();
      }
      if (autoscalingConfigBuilder_ == null) {
        result.autoscalingConfig_ = autoscalingConfig_;
      } else {
        result.autoscalingConfig_ = autoscalingConfigBuilder_.build();
      }
      if (endpointConfigBuilder_ == null) {
        result.endpointConfig_ = endpointConfig_;
      } else {
        result.endpointConfig_ = endpointConfigBuilder_.build();
      }
      if (securityConfigBuilder_ == null) {
        result.securityConfig_ = securityConfig_;
      } else {
        result.securityConfig_ = securityConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1beta2.ClusterConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1beta2.ClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1beta2.ClusterConfig other) {
      if (other == com.google.cloud.dataproc.v1beta2.ClusterConfig.getDefaultInstance())
        return this;
      if (!other.getConfigBucket().isEmpty()) {
        configBucket_ = other.configBucket_;
        onChanged();
      }
      if (other.hasGceClusterConfig()) {
        mergeGceClusterConfig(other.getGceClusterConfig());
      }
      if (other.hasMasterConfig()) {
        mergeMasterConfig(other.getMasterConfig());
      }
      if (other.hasWorkerConfig()) {
        mergeWorkerConfig(other.getWorkerConfig());
      }
      if (other.hasSecondaryWorkerConfig()) {
        mergeSecondaryWorkerConfig(other.getSecondaryWorkerConfig());
      }
      if (other.hasSoftwareConfig()) {
        mergeSoftwareConfig(other.getSoftwareConfig());
      }
      if (other.hasLifecycleConfig()) {
        mergeLifecycleConfig(other.getLifecycleConfig());
      }
      if (initializationActionsBuilder_ == null) {
        if (!other.initializationActions_.isEmpty()) {
          if (initializationActions_.isEmpty()) {
            initializationActions_ = other.initializationActions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInitializationActionsIsMutable();
            initializationActions_.addAll(other.initializationActions_);
          }
          onChanged();
        }
      } else {
        if (!other.initializationActions_.isEmpty()) {
          if (initializationActionsBuilder_.isEmpty()) {
            initializationActionsBuilder_.dispose();
            initializationActionsBuilder_ = null;
            initializationActions_ = other.initializationActions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            initializationActionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInitializationActionsFieldBuilder()
                    : null;
          } else {
            initializationActionsBuilder_.addAllMessages(other.initializationActions_);
          }
        }
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (other.hasAutoscalingConfig()) {
        mergeAutoscalingConfig(other.getAutoscalingConfig());
      }
      if (other.hasEndpointConfig()) {
        mergeEndpointConfig(other.getEndpointConfig());
      }
      if (other.hasSecurityConfig()) {
        mergeSecurityConfig(other.getSecurityConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dataproc.v1beta2.ClusterConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dataproc.v1beta2.ClusterConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object configBucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A Google Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the Google
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Cloud Dataproc staging
     * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * </pre>
     *
     * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The configBucket.
     */
    public java.lang.String getConfigBucket() {
      java.lang.Object ref = configBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        configBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Google Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the Google
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Cloud Dataproc staging
     * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * </pre>
     *
     * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for configBucket.
     */
    public com.google.protobuf.ByteString getConfigBucketBytes() {
      java.lang.Object ref = configBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        configBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Google Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the Google
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Cloud Dataproc staging
     * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * </pre>
     *
     * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The configBucket to set.
     * @return This builder for chaining.
     */
    public Builder setConfigBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      configBucket_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Google Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the Google
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Cloud Dataproc staging
     * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * </pre>
     *
     * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfigBucket() {

      configBucket_ = getDefaultInstance().getConfigBucket();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Google Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the Google
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Cloud Dataproc staging
     * bucket](/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * </pre>
     *
     * <code>string config_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for configBucket to set.
     * @return This builder for chaining.
     */
    public Builder setConfigBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      configBucket_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1beta2.GceClusterConfig gceClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.GceClusterConfig,
            com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder,
            com.google.cloud.dataproc.v1beta2.GceClusterConfigOrBuilder>
        gceClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gceClusterConfig field is set.
     */
    public boolean hasGceClusterConfig() {
      return gceClusterConfigBuilder_ != null || gceClusterConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gceClusterConfig.
     */
    public com.google.cloud.dataproc.v1beta2.GceClusterConfig getGceClusterConfig() {
      if (gceClusterConfigBuilder_ == null) {
        return gceClusterConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.GceClusterConfig.getDefaultInstance()
            : gceClusterConfig_;
      } else {
        return gceClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGceClusterConfig(com.google.cloud.dataproc.v1beta2.GceClusterConfig value) {
      if (gceClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gceClusterConfig_ = value;
        onChanged();
      } else {
        gceClusterConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGceClusterConfig(
        com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder builderForValue) {
      if (gceClusterConfigBuilder_ == null) {
        gceClusterConfig_ = builderForValue.build();
        onChanged();
      } else {
        gceClusterConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGceClusterConfig(com.google.cloud.dataproc.v1beta2.GceClusterConfig value) {
      if (gceClusterConfigBuilder_ == null) {
        if (gceClusterConfig_ != null) {
          gceClusterConfig_ =
              com.google.cloud.dataproc.v1beta2.GceClusterConfig.newBuilder(gceClusterConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          gceClusterConfig_ = value;
        }
        onChanged();
      } else {
        gceClusterConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGceClusterConfig() {
      if (gceClusterConfigBuilder_ == null) {
        gceClusterConfig_ = null;
        onChanged();
      } else {
        gceClusterConfig_ = null;
        gceClusterConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder getGceClusterConfigBuilder() {

      onChanged();
      return getGceClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.GceClusterConfigOrBuilder
        getGceClusterConfigOrBuilder() {
      if (gceClusterConfigBuilder_ != null) {
        return gceClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return gceClusterConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.GceClusterConfig.getDefaultInstance()
            : gceClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The shared Compute Engine config settings for
     * all instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.GceClusterConfig gce_cluster_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.GceClusterConfig,
            com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder,
            com.google.cloud.dataproc.v1beta2.GceClusterConfigOrBuilder>
        getGceClusterConfigFieldBuilder() {
      if (gceClusterConfigBuilder_ == null) {
        gceClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.GceClusterConfig,
                com.google.cloud.dataproc.v1beta2.GceClusterConfig.Builder,
                com.google.cloud.dataproc.v1beta2.GceClusterConfigOrBuilder>(
                getGceClusterConfig(), getParentForChildren(), isClean());
        gceClusterConfig_ = null;
      }
      return gceClusterConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig masterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        masterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the masterConfig field is set.
     */
    public boolean hasMasterConfig() {
      return masterConfigBuilder_ != null || masterConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The masterConfig.
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getMasterConfig() {
      if (masterConfigBuilder_ == null) {
        return masterConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : masterConfig_;
      } else {
        return masterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMasterConfig(com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (masterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        masterConfig_ = value;
        onChanged();
      } else {
        masterConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMasterConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder builderForValue) {
      if (masterConfigBuilder_ == null) {
        masterConfig_ = builderForValue.build();
        onChanged();
      } else {
        masterConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMasterConfig(com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (masterConfigBuilder_ == null) {
        if (masterConfig_ != null) {
          masterConfig_ =
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.newBuilder(masterConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          masterConfig_ = value;
        }
        onChanged();
      } else {
        masterConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMasterConfig() {
      if (masterConfigBuilder_ == null) {
        masterConfig_ = null;
        onChanged();
      } else {
        masterConfig_ = null;
        masterConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder getMasterConfigBuilder() {

      onChanged();
      return getMasterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder
        getMasterConfigOrBuilder() {
      if (masterConfigBuilder_ != null) {
        return masterConfigBuilder_.getMessageOrBuilder();
      } else {
        return masterConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : masterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * the master instance in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig master_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        getMasterConfigFieldBuilder() {
      if (masterConfigBuilder_ == null) {
        masterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>(
                getMasterConfig(), getParentForChildren(), isClean());
        masterConfig_ = null;
      }
      return masterConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig workerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        workerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the workerConfig field is set.
     */
    public boolean hasWorkerConfig() {
      return workerConfigBuilder_ != null || workerConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The workerConfig.
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : workerConfig_;
      } else {
        return workerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkerConfig(com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (workerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workerConfig_ = value;
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder builderForValue) {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = builderForValue.build();
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWorkerConfig(com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (workerConfigBuilder_ == null) {
        if (workerConfig_ != null) {
          workerConfig_ =
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.newBuilder(workerConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          workerConfig_ = value;
        }
        onChanged();
      } else {
        workerConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
        onChanged();
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder getWorkerConfigBuilder() {

      onChanged();
      return getWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder
        getWorkerConfigOrBuilder() {
      if (workerConfigBuilder_ != null) {
        return workerConfigBuilder_.getMessageOrBuilder();
      } else {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : workerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig worker_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        getWorkerConfigFieldBuilder() {
      if (workerConfigBuilder_ == null) {
        workerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>(
                getWorkerConfig(), getParentForChildren(), isClean());
        workerConfig_ = null;
      }
      return workerConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.InstanceGroupConfig secondaryWorkerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        secondaryWorkerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the secondaryWorkerConfig field is set.
     */
    public boolean hasSecondaryWorkerConfig() {
      return secondaryWorkerConfigBuilder_ != null || secondaryWorkerConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The secondaryWorkerConfig.
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig getSecondaryWorkerConfig() {
      if (secondaryWorkerConfigBuilder_ == null) {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : secondaryWorkerConfig_;
      } else {
        return secondaryWorkerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secondaryWorkerConfig_ = value;
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder builderForValue) {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = builderForValue.build();
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (secondaryWorkerConfig_ != null) {
          secondaryWorkerConfig_ =
              com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.newBuilder(
                      secondaryWorkerConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          secondaryWorkerConfig_ = value;
        }
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSecondaryWorkerConfig() {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = null;
        onChanged();
      } else {
        secondaryWorkerConfig_ = null;
        secondaryWorkerConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder
        getSecondaryWorkerConfigBuilder() {

      onChanged();
      return getSecondaryWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder
        getSecondaryWorkerConfigOrBuilder() {
      if (secondaryWorkerConfigBuilder_ != null) {
        return secondaryWorkerConfigBuilder_.getMessageOrBuilder();
      } else {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.getDefaultInstance()
            : secondaryWorkerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine config settings for
     * additional worker instances in a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupConfig secondary_worker_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>
        getSecondaryWorkerConfigFieldBuilder() {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfig.Builder,
                com.google.cloud.dataproc.v1beta2.InstanceGroupConfigOrBuilder>(
                getSecondaryWorkerConfig(), getParentForChildren(), isClean());
        secondaryWorkerConfig_ = null;
      }
      return secondaryWorkerConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.SoftwareConfig softwareConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.SoftwareConfig,
            com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder,
            com.google.cloud.dataproc.v1beta2.SoftwareConfigOrBuilder>
        softwareConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the softwareConfig field is set.
     */
    public boolean hasSoftwareConfig() {
      return softwareConfigBuilder_ != null || softwareConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The softwareConfig.
     */
    public com.google.cloud.dataproc.v1beta2.SoftwareConfig getSoftwareConfig() {
      if (softwareConfigBuilder_ == null) {
        return softwareConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.SoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      } else {
        return softwareConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftwareConfig(com.google.cloud.dataproc.v1beta2.SoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softwareConfig_ = value;
        onChanged();
      } else {
        softwareConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSoftwareConfig(
        com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder builderForValue) {
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = builderForValue.build();
        onChanged();
      } else {
        softwareConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSoftwareConfig(com.google.cloud.dataproc.v1beta2.SoftwareConfig value) {
      if (softwareConfigBuilder_ == null) {
        if (softwareConfig_ != null) {
          softwareConfig_ =
              com.google.cloud.dataproc.v1beta2.SoftwareConfig.newBuilder(softwareConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          softwareConfig_ = value;
        }
        onChanged();
      } else {
        softwareConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSoftwareConfig() {
      if (softwareConfigBuilder_ == null) {
        softwareConfig_ = null;
        onChanged();
      } else {
        softwareConfig_ = null;
        softwareConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder getSoftwareConfigBuilder() {

      onChanged();
      return getSoftwareConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.SoftwareConfigOrBuilder getSoftwareConfigOrBuilder() {
      if (softwareConfigBuilder_ != null) {
        return softwareConfigBuilder_.getMessageOrBuilder();
      } else {
        return softwareConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.SoftwareConfig.getDefaultInstance()
            : softwareConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The config settings for software inside the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SoftwareConfig software_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.SoftwareConfig,
            com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder,
            com.google.cloud.dataproc.v1beta2.SoftwareConfigOrBuilder>
        getSoftwareConfigFieldBuilder() {
      if (softwareConfigBuilder_ == null) {
        softwareConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.SoftwareConfig,
                com.google.cloud.dataproc.v1beta2.SoftwareConfig.Builder,
                com.google.cloud.dataproc.v1beta2.SoftwareConfigOrBuilder>(
                getSoftwareConfig(), getParentForChildren(), isClean());
        softwareConfig_ = null;
      }
      return softwareConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.LifecycleConfig lifecycleConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.LifecycleConfig,
            com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder,
            com.google.cloud.dataproc.v1beta2.LifecycleConfigOrBuilder>
        lifecycleConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the lifecycleConfig field is set.
     */
    public boolean hasLifecycleConfig() {
      return lifecycleConfigBuilder_ != null || lifecycleConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The lifecycleConfig.
     */
    public com.google.cloud.dataproc.v1beta2.LifecycleConfig getLifecycleConfig() {
      if (lifecycleConfigBuilder_ == null) {
        return lifecycleConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.LifecycleConfig.getDefaultInstance()
            : lifecycleConfig_;
      } else {
        return lifecycleConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLifecycleConfig(com.google.cloud.dataproc.v1beta2.LifecycleConfig value) {
      if (lifecycleConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifecycleConfig_ = value;
        onChanged();
      } else {
        lifecycleConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLifecycleConfig(
        com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder builderForValue) {
      if (lifecycleConfigBuilder_ == null) {
        lifecycleConfig_ = builderForValue.build();
        onChanged();
      } else {
        lifecycleConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLifecycleConfig(com.google.cloud.dataproc.v1beta2.LifecycleConfig value) {
      if (lifecycleConfigBuilder_ == null) {
        if (lifecycleConfig_ != null) {
          lifecycleConfig_ =
              com.google.cloud.dataproc.v1beta2.LifecycleConfig.newBuilder(lifecycleConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lifecycleConfig_ = value;
        }
        onChanged();
      } else {
        lifecycleConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLifecycleConfig() {
      if (lifecycleConfigBuilder_ == null) {
        lifecycleConfig_ = null;
        onChanged();
      } else {
        lifecycleConfig_ = null;
        lifecycleConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder getLifecycleConfigBuilder() {

      onChanged();
      return getLifecycleConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.LifecycleConfigOrBuilder
        getLifecycleConfigOrBuilder() {
      if (lifecycleConfigBuilder_ != null) {
        return lifecycleConfigBuilder_.getMessageOrBuilder();
      } else {
        return lifecycleConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.LifecycleConfig.getDefaultInstance()
            : lifecycleConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The config setting for auto delete cluster schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.LifecycleConfig lifecycle_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.LifecycleConfig,
            com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder,
            com.google.cloud.dataproc.v1beta2.LifecycleConfigOrBuilder>
        getLifecycleConfigFieldBuilder() {
      if (lifecycleConfigBuilder_ == null) {
        lifecycleConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.LifecycleConfig,
                com.google.cloud.dataproc.v1beta2.LifecycleConfig.Builder,
                com.google.cloud.dataproc.v1beta2.LifecycleConfigOrBuilder>(
                getLifecycleConfig(), getParentForChildren(), isClean());
        lifecycleConfig_ = null;
      }
      return lifecycleConfigBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1beta2.NodeInitializationAction>
        initializationActions_ = java.util.Collections.emptyList();

    private void ensureInitializationActionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        initializationActions_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1beta2.NodeInitializationAction>(
                initializationActions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.NodeInitializationAction,
            com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder,
            com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder>
        initializationActionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.NodeInitializationAction>
        getInitializationActionsList() {
      if (initializationActionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(initializationActions_);
      } else {
        return initializationActionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getInitializationActionsCount() {
      if (initializationActionsBuilder_ == null) {
        return initializationActions_.size();
      } else {
        return initializationActionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.NodeInitializationAction getInitializationActions(
        int index) {
      if (initializationActionsBuilder_ == null) {
        return initializationActions_.get(index);
      } else {
        return initializationActionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInitializationActions(
        int index, com.google.cloud.dataproc.v1beta2.NodeInitializationAction value) {
      if (initializationActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInitializationActionsIsMutable();
        initializationActions_.set(index, value);
        onChanged();
      } else {
        initializationActionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInitializationActions(
        int index,
        com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder builderForValue) {
      if (initializationActionsBuilder_ == null) {
        ensureInitializationActionsIsMutable();
        initializationActions_.set(index, builderForValue.build());
        onChanged();
      } else {
        initializationActionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInitializationActions(
        com.google.cloud.dataproc.v1beta2.NodeInitializationAction value) {
      if (initializationActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInitializationActionsIsMutable();
        initializationActions_.add(value);
        onChanged();
      } else {
        initializationActionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInitializationActions(
        int index, com.google.cloud.dataproc.v1beta2.NodeInitializationAction value) {
      if (initializationActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInitializationActionsIsMutable();
        initializationActions_.add(index, value);
        onChanged();
      } else {
        initializationActionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInitializationActions(
        com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder builderForValue) {
      if (initializationActionsBuilder_ == null) {
        ensureInitializationActionsIsMutable();
        initializationActions_.add(builderForValue.build());
        onChanged();
      } else {
        initializationActionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInitializationActions(
        int index,
        com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder builderForValue) {
      if (initializationActionsBuilder_ == null) {
        ensureInitializationActionsIsMutable();
        initializationActions_.add(index, builderForValue.build());
        onChanged();
      } else {
        initializationActionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllInitializationActions(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1beta2.NodeInitializationAction>
            values) {
      if (initializationActionsBuilder_ == null) {
        ensureInitializationActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, initializationActions_);
        onChanged();
      } else {
        initializationActionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInitializationActions() {
      if (initializationActionsBuilder_ == null) {
        initializationActions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        initializationActionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeInitializationActions(int index) {
      if (initializationActionsBuilder_ == null) {
        ensureInitializationActionsIsMutable();
        initializationActions_.remove(index);
        onChanged();
      } else {
        initializationActionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder
        getInitializationActionsBuilder(int index) {
      return getInitializationActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder
        getInitializationActionsOrBuilder(int index) {
      if (initializationActionsBuilder_ == null) {
        return initializationActions_.get(index);
      } else {
        return initializationActionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder>
        getInitializationActionsOrBuilderList() {
      if (initializationActionsBuilder_ != null) {
        return initializationActionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(initializationActions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder
        addInitializationActionsBuilder() {
      return getInitializationActionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1beta2.NodeInitializationAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder
        addInitializationActionsBuilder(int index) {
      return getInitializationActionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataproc.v1beta2.NodeInitializationAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Commands to execute on each node after config is
     * completed. By default, executables are run on master and all worker nodes.
     * You can test a node's &lt;code&gt;role&lt;/code&gt; metadata to run an executable on
     * a master or worker node, as shown below using `curl` (you can also use
     * `wget`):
     *     ROLE=$(curl -H Metadata-Flavor:Google
     *     http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
     *     if [[ "${ROLE}" == 'Master' ]]; then
     *       ... master specific actions ...
     *     else
     *       ... worker specific actions ...
     *     fi
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.NodeInitializationAction initialization_actions = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder>
        getInitializationActionsBuilderList() {
      return getInitializationActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.NodeInitializationAction,
            com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder,
            com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder>
        getInitializationActionsFieldBuilder() {
      if (initializationActionsBuilder_ == null) {
        initializationActionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.NodeInitializationAction,
                com.google.cloud.dataproc.v1beta2.NodeInitializationAction.Builder,
                com.google.cloud.dataproc.v1beta2.NodeInitializationActionOrBuilder>(
                initializationActions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        initializationActions_ = null;
      }
      return initializationActionsBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.EncryptionConfig,
            com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder,
            com.google.cloud.dataproc.v1beta2.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return encryptionConfigBuilder_ != null || encryptionConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.cloud.dataproc.v1beta2.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(com.google.cloud.dataproc.v1beta2.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
        onChanged();
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
        onChanged();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(com.google.cloud.dataproc.v1beta2.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (encryptionConfig_ != null) {
          encryptionConfig_ =
              com.google.cloud.dataproc.v1beta2.EncryptionConfig.newBuilder(encryptionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionConfig_ = value;
        }
        onChanged();
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = null;
        onChanged();
      } else {
        encryptionConfig_ = null;
        encryptionConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder getEncryptionConfigBuilder() {

      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Encryption settings for the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EncryptionConfig encryption_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.EncryptionConfig,
            com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder,
            com.google.cloud.dataproc.v1beta2.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.EncryptionConfig,
                com.google.cloud.dataproc.v1beta2.EncryptionConfig.Builder,
                com.google.cloud.dataproc.v1beta2.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.AutoscalingConfig autoscalingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.AutoscalingConfig,
            com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1beta2.AutoscalingConfigOrBuilder>
        autoscalingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoscalingConfig field is set.
     */
    public boolean hasAutoscalingConfig() {
      return autoscalingConfigBuilder_ != null || autoscalingConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoscalingConfig.
     */
    public com.google.cloud.dataproc.v1beta2.AutoscalingConfig getAutoscalingConfig() {
      if (autoscalingConfigBuilder_ == null) {
        return autoscalingConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      } else {
        return autoscalingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingConfig(com.google.cloud.dataproc.v1beta2.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingConfig_ = value;
        onChanged();
      } else {
        autoscalingConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscalingConfig(
        com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder builderForValue) {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfig_ = builderForValue.build();
        onChanged();
      } else {
        autoscalingConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoscalingConfig(
        com.google.cloud.dataproc.v1beta2.AutoscalingConfig value) {
      if (autoscalingConfigBuilder_ == null) {
        if (autoscalingConfig_ != null) {
          autoscalingConfig_ =
              com.google.cloud.dataproc.v1beta2.AutoscalingConfig.newBuilder(autoscalingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          autoscalingConfig_ = value;
        }
        onChanged();
      } else {
        autoscalingConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoscalingConfig() {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfig_ = null;
        onChanged();
      } else {
        autoscalingConfig_ = null;
        autoscalingConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder
        getAutoscalingConfigBuilder() {

      onChanged();
      return getAutoscalingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.AutoscalingConfigOrBuilder
        getAutoscalingConfigOrBuilder() {
      if (autoscalingConfigBuilder_ != null) {
        return autoscalingConfigBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.AutoscalingConfig.getDefaultInstance()
            : autoscalingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Autoscaling config for the policy associated with the cluster.
     * Cluster does not autoscale if this field is unset.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.AutoscalingConfig autoscaling_config = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.AutoscalingConfig,
            com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1beta2.AutoscalingConfigOrBuilder>
        getAutoscalingConfigFieldBuilder() {
      if (autoscalingConfigBuilder_ == null) {
        autoscalingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.AutoscalingConfig,
                com.google.cloud.dataproc.v1beta2.AutoscalingConfig.Builder,
                com.google.cloud.dataproc.v1beta2.AutoscalingConfigOrBuilder>(
                getAutoscalingConfig(), getParentForChildren(), isClean());
        autoscalingConfig_ = null;
      }
      return autoscalingConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.EndpointConfig endpointConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.EndpointConfig,
            com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder,
            com.google.cloud.dataproc.v1beta2.EndpointConfigOrBuilder>
        endpointConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endpointConfig field is set.
     */
    public boolean hasEndpointConfig() {
      return endpointConfigBuilder_ != null || endpointConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endpointConfig.
     */
    public com.google.cloud.dataproc.v1beta2.EndpointConfig getEndpointConfig() {
      if (endpointConfigBuilder_ == null) {
        return endpointConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.EndpointConfig.getDefaultInstance()
            : endpointConfig_;
      } else {
        return endpointConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpointConfig(com.google.cloud.dataproc.v1beta2.EndpointConfig value) {
      if (endpointConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointConfig_ = value;
        onChanged();
      } else {
        endpointConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpointConfig(
        com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder builderForValue) {
      if (endpointConfigBuilder_ == null) {
        endpointConfig_ = builderForValue.build();
        onChanged();
      } else {
        endpointConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEndpointConfig(com.google.cloud.dataproc.v1beta2.EndpointConfig value) {
      if (endpointConfigBuilder_ == null) {
        if (endpointConfig_ != null) {
          endpointConfig_ =
              com.google.cloud.dataproc.v1beta2.EndpointConfig.newBuilder(endpointConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          endpointConfig_ = value;
        }
        onChanged();
      } else {
        endpointConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndpointConfig() {
      if (endpointConfigBuilder_ == null) {
        endpointConfig_ = null;
        onChanged();
      } else {
        endpointConfig_ = null;
        endpointConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder getEndpointConfigBuilder() {

      onChanged();
      return getEndpointConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.EndpointConfigOrBuilder getEndpointConfigOrBuilder() {
      if (endpointConfigBuilder_ != null) {
        return endpointConfigBuilder_.getMessageOrBuilder();
      } else {
        return endpointConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.EndpointConfig.getDefaultInstance()
            : endpointConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Port/endpoint configuration for this cluster
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.EndpointConfig endpoint_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.EndpointConfig,
            com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder,
            com.google.cloud.dataproc.v1beta2.EndpointConfigOrBuilder>
        getEndpointConfigFieldBuilder() {
      if (endpointConfigBuilder_ == null) {
        endpointConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.EndpointConfig,
                com.google.cloud.dataproc.v1beta2.EndpointConfig.Builder,
                com.google.cloud.dataproc.v1beta2.EndpointConfigOrBuilder>(
                getEndpointConfig(), getParentForChildren(), isClean());
        endpointConfig_ = null;
      }
      return endpointConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.SecurityConfig securityConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.SecurityConfig,
            com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder,
            com.google.cloud.dataproc.v1beta2.SecurityConfigOrBuilder>
        securityConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the securityConfig field is set.
     */
    public boolean hasSecurityConfig() {
      return securityConfigBuilder_ != null || securityConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The securityConfig.
     */
    public com.google.cloud.dataproc.v1beta2.SecurityConfig getSecurityConfig() {
      if (securityConfigBuilder_ == null) {
        return securityConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.SecurityConfig.getDefaultInstance()
            : securityConfig_;
      } else {
        return securityConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecurityConfig(com.google.cloud.dataproc.v1beta2.SecurityConfig value) {
      if (securityConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityConfig_ = value;
        onChanged();
      } else {
        securityConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecurityConfig(
        com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder builderForValue) {
      if (securityConfigBuilder_ == null) {
        securityConfig_ = builderForValue.build();
        onChanged();
      } else {
        securityConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSecurityConfig(com.google.cloud.dataproc.v1beta2.SecurityConfig value) {
      if (securityConfigBuilder_ == null) {
        if (securityConfig_ != null) {
          securityConfig_ =
              com.google.cloud.dataproc.v1beta2.SecurityConfig.newBuilder(securityConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          securityConfig_ = value;
        }
        onChanged();
      } else {
        securityConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSecurityConfig() {
      if (securityConfigBuilder_ == null) {
        securityConfig_ = null;
        onChanged();
      } else {
        securityConfig_ = null;
        securityConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder getSecurityConfigBuilder() {

      onChanged();
      return getSecurityConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.SecurityConfigOrBuilder getSecurityConfigOrBuilder() {
      if (securityConfigBuilder_ != null) {
        return securityConfigBuilder_.getMessageOrBuilder();
      } else {
        return securityConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.SecurityConfig.getDefaultInstance()
            : securityConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Security related configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.SecurityConfig security_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.SecurityConfig,
            com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder,
            com.google.cloud.dataproc.v1beta2.SecurityConfigOrBuilder>
        getSecurityConfigFieldBuilder() {
      if (securityConfigBuilder_ == null) {
        securityConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.SecurityConfig,
                com.google.cloud.dataproc.v1beta2.SecurityConfig.Builder,
                com.google.cloud.dataproc.v1beta2.SecurityConfigOrBuilder>(
                getSecurityConfig(), getParentForChildren(), isClean());
        securityConfig_ = null;
      }
      return securityConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1beta2.ClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1beta2.ClusterConfig)
  private static final com.google.cloud.dataproc.v1beta2.ClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1beta2.ClusterConfig();
  }

  public static com.google.cloud.dataproc.v1beta2.ClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<ClusterConfig>() {
        @java.lang.Override
        public ClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ClusterConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1beta2.ClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
