/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1beta2/clusters.proto

package com.google.cloud.dataproc.v1beta2;

/**
 *
 *
 * <pre>
 * Describes the identifying information, config, and status of
 * a cluster of Compute Engine instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1beta2.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1beta2.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    projectId_ = "";
    clusterName_ = "";
    statusHistory_ = java.util.Collections.emptyList();
    clusterUuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cluster();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Cluster(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              clusterName_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder subBuilder = null;
              if (config_ != null) {
                subBuilder = config_.toBuilder();
              }
              config_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(config_);
                config_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder subBuilder = null;
              if (status_ != null) {
                subBuilder = status_.toBuilder();
              }
              status_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterStatus.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(status_);
                status_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              clusterUuid_ = s;
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                statusHistory_ =
                    new java.util.ArrayList<com.google.cloud.dataproc.v1beta2.ClusterStatus>();
                mutable_bitField0_ |= 0x00000002;
              }
              statusHistory_.add(
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterStatus.parser(), extensionRegistry));
              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 74:
            {
              com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder subBuilder = null;
              if (metrics_ != null) {
                subBuilder = metrics_.toBuilder();
              }
              metrics_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.ClusterMetrics.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metrics_);
                metrics_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1beta2.ClustersProto
        .internal_static_google_cloud_dataproc_v1beta2_Cluster_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1beta2.ClustersProto
        .internal_static_google_cloud_dataproc_v1beta2_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1beta2.Cluster.class,
            com.google.cloud.dataproc.v1beta2.Cluster.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object clusterName_;
  /**
   *
   *
   * <pre>
   * Required. The cluster name. Cluster names within a project must be
   * unique. Names of deleted clusters can be reused.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clusterName.
   */
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster name. Cluster names within a project must be
   * unique. Names of deleted clusters can be reused.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clusterName.
   */
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1beta2.ClusterConfig config_;
  /**
   *
   *
   * <pre>
   * Required. The cluster config. Note that Cloud Dataproc may set
   * default values, and values may change when clusters are updated.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the config field is set.
   */
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster config. Note that Cloud Dataproc may set
   * default values, and values may change when clusters are updated.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The config.
   */
  public com.google.cloud.dataproc.v1beta2.ClusterConfig getConfig() {
    return config_ == null
        ? com.google.cloud.dataproc.v1beta2.ClusterConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster config. Note that Cloud Dataproc may set
   * default values, and values may change when clusters are updated.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder getConfigOrBuilder() {
    return getConfig();
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1beta2.ClustersProto
                .internal_static_google_cloud_dataproc_v1beta2_Cluster_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1beta2.ClusterStatus status_;
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  public com.google.cloud.dataproc.v1beta2.ClusterStatus getStatus() {
    return status_ == null
        ? com.google.cloud.dataproc.v1beta2.ClusterStatus.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder getStatusOrBuilder() {
    return getStatus();
  }

  public static final int STATUS_HISTORY_FIELD_NUMBER = 7;
  private java.util.List<com.google.cloud.dataproc.v1beta2.ClusterStatus> statusHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterStatus> getStatusHistoryList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<? extends com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
      getStatusHistoryOrBuilderList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public int getStatusHistoryCount() {
    return statusHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterStatus getStatusHistory(int index) {
    return statusHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder getStatusHistoryOrBuilder(
      int index) {
    return statusHistory_.get(index);
  }

  public static final int CLUSTER_UUID_FIELD_NUMBER = 6;
  private volatile java.lang.Object clusterUuid_;
  /**
   *
   *
   * <pre>
   * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
   * generates this value when it creates the cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterUuid.
   */
  public java.lang.String getClusterUuid() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
   * generates this value when it creates the cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterUuid.
   */
  public com.google.protobuf.ByteString getClusterUuidBytes() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 9;
  private com.google.cloud.dataproc.v1beta2.ClusterMetrics metrics_;
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metrics field is set.
   */
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metrics.
   */
  public com.google.cloud.dataproc.v1beta2.ClusterMetrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.dataproc.v1beta2.ClusterMetrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.ClusterMetricsOrBuilder getMetricsOrBuilder() {
    return getMetrics();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!getClusterNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
    }
    if (config_ != null) {
      output.writeMessage(3, getConfig());
    }
    if (status_ != null) {
      output.writeMessage(4, getStatus());
    }
    if (!getClusterUuidBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, clusterUuid_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      output.writeMessage(7, statusHistory_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    if (metrics_ != null) {
      output.writeMessage(9, getMetrics());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!getClusterNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfig());
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStatus());
    }
    if (!getClusterUuidBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, clusterUuid_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, statusHistory_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMetrics());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1beta2.Cluster)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1beta2.Cluster other =
        (com.google.cloud.dataproc.v1beta2.Cluster) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getClusterName().equals(other.getClusterName())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusHistoryList().equals(other.getStatusHistoryList())) return false;
    if (!getClusterUuid().equals(other.getClusterUuid())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusHistoryCount() > 0) {
      hash = (37 * hash) + STATUS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatusHistoryList().hashCode();
    }
    hash = (37 * hash) + CLUSTER_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterUuid().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1beta2.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the identifying information, config, and status of
   * a cluster of Compute Engine instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1beta2.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1beta2.Cluster)
      com.google.cloud.dataproc.v1beta2.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_Cluster_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1beta2.Cluster.class,
              com.google.cloud.dataproc.v1beta2.Cluster.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1beta2.Cluster.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatusHistoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      projectId_ = "";

      clusterName_ = "";

      if (configBuilder_ == null) {
        config_ = null;
      } else {
        config_ = null;
        configBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (statusBuilder_ == null) {
        status_ = null;
      } else {
        status_ = null;
        statusBuilder_ = null;
      }
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        statusHistoryBuilder_.clear();
      }
      clusterUuid_ = "";

      if (metricsBuilder_ == null) {
        metrics_ = null;
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1beta2.ClustersProto
          .internal_static_google_cloud_dataproc_v1beta2_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.Cluster getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1beta2.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.Cluster build() {
      com.google.cloud.dataproc.v1beta2.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.Cluster buildPartial() {
      com.google.cloud.dataproc.v1beta2.Cluster result =
          new com.google.cloud.dataproc.v1beta2.Cluster(this);
      int from_bitField0_ = bitField0_;
      result.projectId_ = projectId_;
      result.clusterName_ = clusterName_;
      if (configBuilder_ == null) {
        result.config_ = config_;
      } else {
        result.config_ = configBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (statusBuilder_ == null) {
        result.status_ = status_;
      } else {
        result.status_ = statusBuilder_.build();
      }
      if (statusHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.statusHistory_ = statusHistory_;
      } else {
        result.statusHistory_ = statusHistoryBuilder_.build();
      }
      result.clusterUuid_ = clusterUuid_;
      if (metricsBuilder_ == null) {
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1beta2.Cluster) {
        return mergeFrom((com.google.cloud.dataproc.v1beta2.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1beta2.Cluster other) {
      if (other == com.google.cloud.dataproc.v1beta2.Cluster.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (statusHistoryBuilder_ == null) {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistory_.isEmpty()) {
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStatusHistoryIsMutable();
            statusHistory_.addAll(other.statusHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistoryBuilder_.isEmpty()) {
            statusHistoryBuilder_.dispose();
            statusHistoryBuilder_ = null;
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000002);
            statusHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusHistoryFieldBuilder()
                    : null;
          } else {
            statusHistoryBuilder_.addAllMessages(other.statusHistory_);
          }
        }
      }
      if (!other.getClusterUuid().isEmpty()) {
        clusterUuid_ = other.clusterUuid_;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dataproc.v1beta2.Cluster parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dataproc.v1beta2.Cluster) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The cluster name. Cluster names within a project must be
     * unique. Names of deleted clusters can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name. Cluster names within a project must be
     * unique. Names of deleted clusters can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name. Cluster names within a project must be
     * unique. Names of deleted clusters can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name. Cluster names within a project must be
     * unique. Names of deleted clusters can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {

      clusterName_ = getDefaultInstance().getClusterName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name. Cluster names within a project must be
     * unique. Names of deleted clusters can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1beta2.ClusterConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterConfig,
            com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return configBuilder_ != null || config_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.dataproc.v1beta2.ClusterConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(com.google.cloud.dataproc.v1beta2.ClusterConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        configBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.dataproc.v1beta2.ClusterConfig value) {
      if (configBuilder_ == null) {
        if (config_ != null) {
          config_ =
              com.google.cloud.dataproc.v1beta2.ClusterConfig.newBuilder(config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        configBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConfig() {
      if (configBuilder_ == null) {
        config_ = null;
        onChanged();
      } else {
        config_ = null;
        configBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder getConfigBuilder() {

      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster config. Note that Cloud Dataproc may set
     * default values, and values may change when clusters are updated.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterConfig,
            com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterConfig,
                com.google.cloud.dataproc.v1beta2.ClusterConfig.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.dataproc.v1beta2.ClusterStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterStatus,
            com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return statusBuilder_ != null || status_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1beta2.ClusterStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
        onChanged();
      } else {
        statusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(
        com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
        onChanged();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.dataproc.v1beta2.ClusterStatus value) {
      if (statusBuilder_ == null) {
        if (status_ != null) {
          status_ =
              com.google.cloud.dataproc.v1beta2.ClusterStatus.newBuilder(status_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          status_ = value;
        }
        onChanged();
      } else {
        statusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      if (statusBuilder_ == null) {
        status_ = null;
        onChanged();
      } else {
        status_ = null;
        statusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder getStatusBuilder() {

      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterStatus,
            com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterStatus,
                com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1beta2.ClusterStatus> statusHistory_ =
        java.util.Collections.emptyList();

    private void ensureStatusHistoryIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        statusHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1beta2.ClusterStatus>(
                statusHistory_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterStatus,
            com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
        statusHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterStatus> getStatusHistoryList() {
      if (statusHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusHistory_);
      } else {
        return statusHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStatusHistoryCount() {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.size();
      } else {
        return statusHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus getStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(com.google.cloud.dataproc.v1beta2.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStatusHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1beta2.ClusterStatus> values) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusHistory_);
        onChanged();
      } else {
        statusHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatusHistory() {
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        statusHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.remove(index);
        onChanged();
      } else {
        statusHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder getStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder getStatusHistoryOrBuilder(
        int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
        getStatusHistoryOrBuilderList() {
      if (statusHistoryBuilder_ != null) {
        return statusHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder addStatusHistoryBuilder() {
      return getStatusHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1beta2.ClusterStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder addStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1beta2.ClusterStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1beta2.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder>
        getStatusHistoryBuilderList() {
      return getStatusHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterStatus,
            com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>
        getStatusHistoryFieldBuilder() {
      if (statusHistoryBuilder_ == null) {
        statusHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterStatus,
                com.google.cloud.dataproc.v1beta2.ClusterStatus.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterStatusOrBuilder>(
                statusHistory_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        statusHistory_ = null;
      }
      return statusHistoryBuilder_;
    }

    private java.lang.Object clusterUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterUuid.
     */
    public java.lang.String getClusterUuid() {
      java.lang.Object ref = clusterUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterUuid.
     */
    public com.google.protobuf.ByteString getClusterUuidBytes() {
      java.lang.Object ref = clusterUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterUuid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterUuid() {

      clusterUuid_ = getDefaultInstance().getClusterUuid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterUuid_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1beta2.ClusterMetrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterMetrics,
            com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterMetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return metricsBuilder_ != null || metrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metrics.
     */
    public com.google.cloud.dataproc.v1beta2.ClusterMetrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterMetrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(com.google.cloud.dataproc.v1beta2.ClusterMetrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        metricsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(
        com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetrics(com.google.cloud.dataproc.v1beta2.ClusterMetrics value) {
      if (metricsBuilder_ == null) {
        if (metrics_ != null) {
          metrics_ =
              com.google.cloud.dataproc.v1beta2.ClusterMetrics.newBuilder(metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        metricsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = null;
        onChanged();
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder getMetricsBuilder() {

      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.ClusterMetricsOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.dataproc.v1beta2.ClusterMetrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.ClusterMetrics,
            com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder,
            com.google.cloud.dataproc.v1beta2.ClusterMetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.ClusterMetrics,
                com.google.cloud.dataproc.v1beta2.ClusterMetrics.Builder,
                com.google.cloud.dataproc.v1beta2.ClusterMetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1beta2.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1beta2.Cluster)
  private static final com.google.cloud.dataproc.v1beta2.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1beta2.Cluster();
  }

  public static com.google.cloud.dataproc.v1beta2.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Cluster(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1beta2.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
