/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1beta2/autoscaling_policies.proto

package com.google.cloud.dataproc.v1beta2;

/**
 *
 *
 * <pre>
 * Describes an autoscaling policy for Dataproc cluster autoscaler.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1beta2.AutoscalingPolicy}
 */
public final class AutoscalingPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1beta2.AutoscalingPolicy)
    AutoscalingPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutoscalingPolicy.newBuilder() to construct.
  private AutoscalingPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoscalingPolicy() {
    id_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoscalingPolicy();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AutoscalingPolicy(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 26:
            {
              com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder subBuilder = null;
              if (algorithmCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_)
                        .toBuilder();
              }
              algorithm_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_);
                algorithm_ = subBuilder.buildPartial();
              }
              algorithmCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
                  subBuilder = null;
              if (workerConfig_ != null) {
                subBuilder = workerConfig_.toBuilder();
              }
              workerConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(workerConfig_);
                workerConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
                  subBuilder = null;
              if (secondaryWorkerConfig_ != null) {
                subBuilder = secondaryWorkerConfig_.toBuilder();
              }
              secondaryWorkerConfig_ =
                  input.readMessage(
                      com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(secondaryWorkerConfig_);
                secondaryWorkerConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1beta2.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1beta2_AutoscalingPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1beta2.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1beta2_AutoscalingPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.class,
            com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.Builder.class);
  }

  private int algorithmCase_ = 0;
  private java.lang.Object algorithm_;

  public enum AlgorithmCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASIC_ALGORITHM(3),
    ALGORITHM_NOT_SET(0);
    private final int value;

    private AlgorithmCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AlgorithmCase valueOf(int value) {
      return forNumber(value);
    }

    public static AlgorithmCase forNumber(int value) {
      switch (value) {
        case 3:
          return BASIC_ALGORITHM;
        case 0:
          return ALGORITHM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AlgorithmCase getAlgorithmCase() {
    return AlgorithmCase.forNumber(algorithmCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Required. The policy id.
   * The id must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). Cannot begin or end with underscore
   * or hyphen. Must consist of between 3 and 50 characters.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The policy id.
   * The id must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). Cannot begin or end with underscore
   * or hyphen. Must consist of between 3 and 50 characters.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The "resource name" of the autoscaling policy, as described
   * in https://cloud.google.com/apis/design/resource_names.
   * * For `projects.regions.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
   * * For `projects.locations.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The "resource name" of the autoscaling policy, as described
   * in https://cloud.google.com/apis/design/resource_names.
   * * For `projects.regions.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
   * * For `projects.locations.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASIC_ALGORITHM_FIELD_NUMBER = 3;
  /**
   * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
   *
   * @return Whether the basicAlgorithm field is set.
   */
  public boolean hasBasicAlgorithm() {
    return algorithmCase_ == 3;
  }
  /**
   * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
   *
   * @return The basicAlgorithm.
   */
  public com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm getBasicAlgorithm() {
    if (algorithmCase_ == 3) {
      return (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_;
    }
    return com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
  }
  /** <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code> */
  public com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithmOrBuilder
      getBasicAlgorithmOrBuilder() {
    if (algorithmCase_ == 3) {
      return (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_;
    }
    return com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
  }

  public static final int WORKER_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig workerConfig_;
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the workerConfig field is set.
   */
  public boolean hasWorkerConfig() {
    return workerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The workerConfig.
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig getWorkerConfig() {
    return workerConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
            .getDefaultInstance()
        : workerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder
      getWorkerConfigOrBuilder() {
    return getWorkerConfig();
  }

  public static final int SECONDARY_WORKER_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
      secondaryWorkerConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the secondaryWorkerConfig field is set.
   */
  public boolean hasSecondaryWorkerConfig() {
    return secondaryWorkerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The secondaryWorkerConfig.
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
      getSecondaryWorkerConfig() {
    return secondaryWorkerConfig_ == null
        ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
            .getDefaultInstance()
        : secondaryWorkerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder
      getSecondaryWorkerConfigOrBuilder() {
    return getSecondaryWorkerConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (algorithmCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_);
    }
    if (workerConfig_ != null) {
      output.writeMessage(4, getWorkerConfig());
    }
    if (secondaryWorkerConfig_ != null) {
      output.writeMessage(5, getSecondaryWorkerConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (algorithmCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_);
    }
    if (workerConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getWorkerConfig());
    }
    if (secondaryWorkerConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSecondaryWorkerConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1beta2.AutoscalingPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1beta2.AutoscalingPolicy other =
        (com.google.cloud.dataproc.v1beta2.AutoscalingPolicy) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getName().equals(other.getName())) return false;
    if (hasWorkerConfig() != other.hasWorkerConfig()) return false;
    if (hasWorkerConfig()) {
      if (!getWorkerConfig().equals(other.getWorkerConfig())) return false;
    }
    if (hasSecondaryWorkerConfig() != other.hasSecondaryWorkerConfig()) return false;
    if (hasSecondaryWorkerConfig()) {
      if (!getSecondaryWorkerConfig().equals(other.getSecondaryWorkerConfig())) return false;
    }
    if (!getAlgorithmCase().equals(other.getAlgorithmCase())) return false;
    switch (algorithmCase_) {
      case 3:
        if (!getBasicAlgorithm().equals(other.getBasicAlgorithm())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasWorkerConfig()) {
      hash = (37 * hash) + WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerConfig().hashCode();
    }
    if (hasSecondaryWorkerConfig()) {
      hash = (37 * hash) + SECONDARY_WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryWorkerConfig().hashCode();
    }
    switch (algorithmCase_) {
      case 3:
        hash = (37 * hash) + BASIC_ALGORITHM_FIELD_NUMBER;
        hash = (53 * hash) + getBasicAlgorithm().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1beta2.AutoscalingPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an autoscaling policy for Dataproc cluster autoscaler.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1beta2.AutoscalingPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1beta2.AutoscalingPolicy)
      com.google.cloud.dataproc.v1beta2.AutoscalingPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1beta2.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1beta2_AutoscalingPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1beta2.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1beta2_AutoscalingPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.class,
              com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      name_ = "";

      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = null;
      } else {
        secondaryWorkerConfig_ = null;
        secondaryWorkerConfigBuilder_ = null;
      }
      algorithmCase_ = 0;
      algorithm_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1beta2.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1beta2_AutoscalingPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.AutoscalingPolicy getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.AutoscalingPolicy build() {
      com.google.cloud.dataproc.v1beta2.AutoscalingPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1beta2.AutoscalingPolicy buildPartial() {
      com.google.cloud.dataproc.v1beta2.AutoscalingPolicy result =
          new com.google.cloud.dataproc.v1beta2.AutoscalingPolicy(this);
      result.id_ = id_;
      result.name_ = name_;
      if (algorithmCase_ == 3) {
        if (basicAlgorithmBuilder_ == null) {
          result.algorithm_ = algorithm_;
        } else {
          result.algorithm_ = basicAlgorithmBuilder_.build();
        }
      }
      if (workerConfigBuilder_ == null) {
        result.workerConfig_ = workerConfig_;
      } else {
        result.workerConfig_ = workerConfigBuilder_.build();
      }
      if (secondaryWorkerConfigBuilder_ == null) {
        result.secondaryWorkerConfig_ = secondaryWorkerConfig_;
      } else {
        result.secondaryWorkerConfig_ = secondaryWorkerConfigBuilder_.build();
      }
      result.algorithmCase_ = algorithmCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1beta2.AutoscalingPolicy) {
        return mergeFrom((com.google.cloud.dataproc.v1beta2.AutoscalingPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1beta2.AutoscalingPolicy other) {
      if (other == com.google.cloud.dataproc.v1beta2.AutoscalingPolicy.getDefaultInstance())
        return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasWorkerConfig()) {
        mergeWorkerConfig(other.getWorkerConfig());
      }
      if (other.hasSecondaryWorkerConfig()) {
        mergeSecondaryWorkerConfig(other.getSecondaryWorkerConfig());
      }
      switch (other.getAlgorithmCase()) {
        case BASIC_ALGORITHM:
          {
            mergeBasicAlgorithm(other.getBasicAlgorithm());
            break;
          }
        case ALGORITHM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dataproc.v1beta2.AutoscalingPolicy parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dataproc.v1beta2.AutoscalingPolicy) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int algorithmCase_ = 0;
    private java.lang.Object algorithm_;

    public AlgorithmCase getAlgorithmCase() {
      return AlgorithmCase.forNumber(algorithmCase_);
    }

    public Builder clearAlgorithm() {
      algorithmCase_ = 0;
      algorithm_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm,
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder,
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithmOrBuilder>
        basicAlgorithmBuilder_;
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     *
     * @return Whether the basicAlgorithm field is set.
     */
    public boolean hasBasicAlgorithm() {
      return algorithmCase_ == 3;
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     *
     * @return The basicAlgorithm.
     */
    public com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm getBasicAlgorithm() {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3) {
          return (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_;
        }
        return com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
      } else {
        if (algorithmCase_ == 3) {
          return basicAlgorithmBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public Builder setBasicAlgorithm(
        com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm value) {
      if (basicAlgorithmBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        algorithm_ = value;
        onChanged();
      } else {
        basicAlgorithmBuilder_.setMessage(value);
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public Builder setBasicAlgorithm(
        com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder builderForValue) {
      if (basicAlgorithmBuilder_ == null) {
        algorithm_ = builderForValue.build();
        onChanged();
      } else {
        basicAlgorithmBuilder_.setMessage(builderForValue.build());
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public Builder mergeBasicAlgorithm(
        com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm value) {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3
            && algorithm_
                != com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm
                    .getDefaultInstance()) {
          algorithm_ =
              com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.newBuilder(
                      (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          algorithm_ = value;
        }
        onChanged();
      } else {
        if (algorithmCase_ == 3) {
          basicAlgorithmBuilder_.mergeFrom(value);
        }
        basicAlgorithmBuilder_.setMessage(value);
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public Builder clearBasicAlgorithm() {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3) {
          algorithmCase_ = 0;
          algorithm_ = null;
          onChanged();
        }
      } else {
        if (algorithmCase_ == 3) {
          algorithmCase_ = 0;
          algorithm_ = null;
        }
        basicAlgorithmBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder
        getBasicAlgorithmBuilder() {
      return getBasicAlgorithmFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    public com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithmOrBuilder
        getBasicAlgorithmOrBuilder() {
      if ((algorithmCase_ == 3) && (basicAlgorithmBuilder_ != null)) {
        return basicAlgorithmBuilder_.getMessageOrBuilder();
      } else {
        if (algorithmCase_ == 3) {
          return (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_;
        }
        return com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm basic_algorithm = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm,
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder,
            com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithmOrBuilder>
        getBasicAlgorithmFieldBuilder() {
      if (basicAlgorithmBuilder_ == null) {
        if (!(algorithmCase_ == 3)) {
          algorithm_ =
              com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.getDefaultInstance();
        }
        basicAlgorithmBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm,
                com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm.Builder,
                com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithmOrBuilder>(
                (com.google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm) algorithm_,
                getParentForChildren(),
                isClean());
        algorithm_ = null;
      }
      algorithmCase_ = 3;
      onChanged();
      ;
      return basicAlgorithmBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig workerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        workerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the workerConfig field is set.
     */
    public boolean hasWorkerConfig() {
      return workerConfigBuilder_ != null || workerConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The workerConfig.
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
        getWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                .getDefaultInstance()
            : workerConfig_;
      } else {
        return workerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig value) {
      if (workerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workerConfig_ = value;
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
            builderForValue) {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = builderForValue.build();
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig value) {
      if (workerConfigBuilder_ == null) {
        if (workerConfig_ != null) {
          workerConfig_ =
              com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.newBuilder(
                      workerConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          workerConfig_ = value;
        }
        onChanged();
      } else {
        workerConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
        onChanged();
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
        getWorkerConfigBuilder() {

      onChanged();
      return getWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder
        getWorkerConfigOrBuilder() {
      if (workerConfigBuilder_ != null) {
        return workerConfigBuilder_.getMessageOrBuilder();
      } else {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                .getDefaultInstance()
            : workerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        getWorkerConfigFieldBuilder() {
      if (workerConfigBuilder_ == null) {
        workerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>(
                getWorkerConfig(), getParentForChildren(), isClean());
        workerConfig_ = null;
      }
      return workerConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
        secondaryWorkerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        secondaryWorkerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the secondaryWorkerConfig field is set.
     */
    public boolean hasSecondaryWorkerConfig() {
      return secondaryWorkerConfigBuilder_ != null || secondaryWorkerConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The secondaryWorkerConfig.
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
        getSecondaryWorkerConfig() {
      if (secondaryWorkerConfigBuilder_ == null) {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                .getDefaultInstance()
            : secondaryWorkerConfig_;
      } else {
        return secondaryWorkerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secondaryWorkerConfig_ = value;
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
            builderForValue) {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = builderForValue.build();
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (secondaryWorkerConfig_ != null) {
          secondaryWorkerConfig_ =
              com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.newBuilder(
                      secondaryWorkerConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          secondaryWorkerConfig_ = value;
        }
        onChanged();
      } else {
        secondaryWorkerConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSecondaryWorkerConfig() {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = null;
        onChanged();
      } else {
        secondaryWorkerConfig_ = null;
        secondaryWorkerConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder
        getSecondaryWorkerConfigBuilder() {

      onChanged();
      return getSecondaryWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder
        getSecondaryWorkerConfigOrBuilder() {
      if (secondaryWorkerConfigBuilder_ != null) {
        return secondaryWorkerConfigBuilder_.getMessageOrBuilder();
      } else {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig
                .getDefaultInstance()
            : secondaryWorkerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        getSecondaryWorkerConfigFieldBuilder() {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig,
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig.Builder,
                com.google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfigOrBuilder>(
                getSecondaryWorkerConfig(), getParentForChildren(), isClean());
        secondaryWorkerConfig_ = null;
      }
      return secondaryWorkerConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1beta2.AutoscalingPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1beta2.AutoscalingPolicy)
  private static final com.google.cloud.dataproc.v1beta2.AutoscalingPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1beta2.AutoscalingPolicy();
  }

  public static com.google.cloud.dataproc.v1beta2.AutoscalingPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoscalingPolicy> PARSER =
      new com.google.protobuf.AbstractParser<AutoscalingPolicy>() {
        @java.lang.Override
        public AutoscalingPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AutoscalingPolicy(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AutoscalingPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoscalingPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1beta2.AutoscalingPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
