/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutoscalingPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTOSCALING_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/autoscalingPolicies/{autoscaling_policy}");
    private static final PathTemplate PROJECT_REGION_AUTOSCALING_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/autoscalingPolicies/{autoscaling_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String autoscalingPolicy;
    private final String region;

    @Deprecated
    protected AutoscalingPolicyName() {
        this.project = null;
        this.location = null;
        this.autoscalingPolicy = null;
        this.region = null;
    }

    private AutoscalingPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.autoscalingPolicy = (String)Preconditions.checkNotNull((Object)builder.getAutoscalingPolicy());
        this.region = null;
        this.pathTemplate = PROJECT_LOCATION_AUTOSCALING_POLICY;
    }

    private AutoscalingPolicyName(ProjectRegionAutoscalingPolicyBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.autoscalingPolicy = (String)Preconditions.checkNotNull((Object)builder.getAutoscalingPolicy());
        this.location = null;
        this.pathTemplate = PROJECT_REGION_AUTOSCALING_POLICY;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAutoscalingPolicy() {
        return this.autoscalingPolicy;
    }

    public String getRegion() {
        return this.region;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationAutoscalingPolicyBuilder() {
        return new Builder();
    }

    public static ProjectRegionAutoscalingPolicyBuilder newProjectRegionAutoscalingPolicyBuilder() {
        return new ProjectRegionAutoscalingPolicyBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutoscalingPolicyName of(String project, String location, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setLocation(location).setAutoscalingPolicy(autoscalingPolicy).build();
    }

    public static AutoscalingPolicyName ofProjectLocationAutoscalingPolicyName(String project, String location, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setLocation(location).setAutoscalingPolicy(autoscalingPolicy).build();
    }

    public static AutoscalingPolicyName ofProjectRegionAutoscalingPolicyName(String project, String region, String autoscalingPolicy) {
        return AutoscalingPolicyName.newProjectRegionAutoscalingPolicyBuilder().setProject(project).setRegion(region).setAutoscalingPolicy(autoscalingPolicy).build();
    }

    public static String format(String project, String location, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setLocation(location).setAutoscalingPolicy(autoscalingPolicy).build().toString();
    }

    public static String formatProjectLocationAutoscalingPolicyName(String project, String location, String autoscalingPolicy) {
        return AutoscalingPolicyName.newBuilder().setProject(project).setLocation(location).setAutoscalingPolicy(autoscalingPolicy).build().toString();
    }

    public static String formatProjectRegionAutoscalingPolicyName(String project, String region, String autoscalingPolicy) {
        return AutoscalingPolicyName.newProjectRegionAutoscalingPolicyBuilder().setProject(project).setRegion(region).setAutoscalingPolicy(autoscalingPolicy).build().toString();
    }

    public static AutoscalingPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_AUTOSCALING_POLICY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AUTOSCALING_POLICY.match(formattedString);
            return AutoscalingPolicyName.ofProjectLocationAutoscalingPolicyName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("autoscaling_policy"));
        }
        if (PROJECT_REGION_AUTOSCALING_POLICY.matches(formattedString)) {
            Map matchMap = PROJECT_REGION_AUTOSCALING_POLICY.match(formattedString);
            return AutoscalingPolicyName.ofProjectRegionAutoscalingPolicyName((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("autoscaling_policy"));
        }
        throw new ValidationException("AutoscalingPolicyName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AutoscalingPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AutoscalingPolicyName> list = new ArrayList<AutoscalingPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutoscalingPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutoscalingPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutoscalingPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTOSCALING_POLICY.matches(formattedString) || PROJECT_REGION_AUTOSCALING_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutoscalingPolicyName autoscalingPolicyName = this;
            synchronized (autoscalingPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.autoscalingPolicy != null) {
                        fieldMapBuilder.put((Object)"autoscaling_policy", (Object)this.autoscalingPolicy);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutoscalingPolicyName that = (AutoscalingPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.autoscalingPolicy, that.autoscalingPolicy) && Objects.equals(this.region, that.region);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.autoscalingPolicy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.region);
    }

    public static class ProjectRegionAutoscalingPolicyBuilder {
        private String project;
        private String region;
        private String autoscalingPolicy;

        protected ProjectRegionAutoscalingPolicyBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getAutoscalingPolicy() {
            return this.autoscalingPolicy;
        }

        public ProjectRegionAutoscalingPolicyBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectRegionAutoscalingPolicyBuilder setRegion(String region) {
            this.region = region;
            return this;
        }

        public ProjectRegionAutoscalingPolicyBuilder setAutoscalingPolicy(String autoscalingPolicy) {
            this.autoscalingPolicy = autoscalingPolicy;
            return this;
        }

        public AutoscalingPolicyName build() {
            return new AutoscalingPolicyName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String autoscalingPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAutoscalingPolicy() {
            return this.autoscalingPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAutoscalingPolicy(String autoscalingPolicy) {
            this.autoscalingPolicy = autoscalingPolicy;
            return this;
        }

        private Builder(AutoscalingPolicyName autoscalingPolicyName) {
            Preconditions.checkArgument((boolean)Objects.equals(autoscalingPolicyName.pathTemplate, PROJECT_LOCATION_AUTOSCALING_POLICY), (Object)"toBuilder is only supported when AutoscalingPolicyName has the pattern of projects/{project}/locations/{location}/autoscalingPolicies/{autoscaling_policy}");
            this.project = autoscalingPolicyName.project;
            this.location = autoscalingPolicyName.location;
            this.autoscalingPolicy = autoscalingPolicyName.autoscalingPolicy;
        }

        public AutoscalingPolicyName build() {
            return new AutoscalingPolicyName(this);
        }
    }
}

