/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.cloud.dataproc.v1.ClusterOperation;
import com.google.cloud.dataproc.v1.ClusterOperationOrBuilder;
import com.google.cloud.dataproc.v1.WorkflowGraph;
import com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder;
import com.google.cloud.dataproc.v1.WorkflowMetadataOrBuilder;
import com.google.cloud.dataproc.v1.WorkflowTemplatesProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class WorkflowMetadata
extends GeneratedMessageV3
implements WorkflowMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TEMPLATE_FIELD_NUMBER = 1;
    private volatile Object template_ = "";
    public static final int VERSION_FIELD_NUMBER = 2;
    private int version_ = 0;
    public static final int CREATE_CLUSTER_FIELD_NUMBER = 3;
    private ClusterOperation createCluster_;
    public static final int GRAPH_FIELD_NUMBER = 4;
    private WorkflowGraph graph_;
    public static final int DELETE_CLUSTER_FIELD_NUMBER = 5;
    private ClusterOperation deleteCluster_;
    public static final int STATE_FIELD_NUMBER = 6;
    private int state_ = 0;
    public static final int CLUSTER_NAME_FIELD_NUMBER = 7;
    private volatile Object clusterName_ = "";
    public static final int PARAMETERS_FIELD_NUMBER = 8;
    private MapField<String, String> parameters_;
    public static final int START_TIME_FIELD_NUMBER = 9;
    private Timestamp startTime_;
    public static final int END_TIME_FIELD_NUMBER = 10;
    private Timestamp endTime_;
    public static final int CLUSTER_UUID_FIELD_NUMBER = 11;
    private volatile Object clusterUuid_ = "";
    public static final int DAG_TIMEOUT_FIELD_NUMBER = 12;
    private Duration dagTimeout_;
    public static final int DAG_START_TIME_FIELD_NUMBER = 13;
    private Timestamp dagStartTime_;
    public static final int DAG_END_TIME_FIELD_NUMBER = 14;
    private Timestamp dagEndTime_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final WorkflowMetadata DEFAULT_INSTANCE = new WorkflowMetadata();
    private static final Parser<WorkflowMetadata> PARSER = new AbstractParser<WorkflowMetadata>(){

        public WorkflowMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = WorkflowMetadata.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private WorkflowMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private WorkflowMetadata() {
        this.template_ = "";
        this.state_ = 0;
        this.clusterName_ = "";
        this.clusterUuid_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new WorkflowMetadata();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 8: {
                return this.internalGetParameters();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(WorkflowMetadata.class, Builder.class);
    }

    @Override
    public String getTemplate() {
        Object ref = this.template_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.template_ = s;
        return s;
    }

    @Override
    public ByteString getTemplateBytes() {
        Object ref = this.template_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.template_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getVersion() {
        return this.version_;
    }

    @Override
    public boolean hasCreateCluster() {
        return this.createCluster_ != null;
    }

    @Override
    public ClusterOperation getCreateCluster() {
        return this.createCluster_ == null ? ClusterOperation.getDefaultInstance() : this.createCluster_;
    }

    @Override
    public ClusterOperationOrBuilder getCreateClusterOrBuilder() {
        return this.createCluster_ == null ? ClusterOperation.getDefaultInstance() : this.createCluster_;
    }

    @Override
    public boolean hasGraph() {
        return this.graph_ != null;
    }

    @Override
    public WorkflowGraph getGraph() {
        return this.graph_ == null ? WorkflowGraph.getDefaultInstance() : this.graph_;
    }

    @Override
    public WorkflowGraphOrBuilder getGraphOrBuilder() {
        return this.graph_ == null ? WorkflowGraph.getDefaultInstance() : this.graph_;
    }

    @Override
    public boolean hasDeleteCluster() {
        return this.deleteCluster_ != null;
    }

    @Override
    public ClusterOperation getDeleteCluster() {
        return this.deleteCluster_ == null ? ClusterOperation.getDefaultInstance() : this.deleteCluster_;
    }

    @Override
    public ClusterOperationOrBuilder getDeleteClusterOrBuilder() {
        return this.deleteCluster_ == null ? ClusterOperation.getDefaultInstance() : this.deleteCluster_;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public String getClusterName() {
        Object ref = this.clusterName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterName_ = s;
        return s;
    }

    @Override
    public ByteString getClusterNameBytes() {
        Object ref = this.clusterName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetParameters() {
        if (this.parameters_ == null) {
            return MapField.emptyMapField(ParametersDefaultEntryHolder.defaultEntry);
        }
        return this.parameters_;
    }

    @Override
    public int getParametersCount() {
        return this.internalGetParameters().getMap().size();
    }

    @Override
    public boolean containsParameters(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetParameters().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getParameters() {
        return this.getParametersMap();
    }

    @Override
    public Map<String, String> getParametersMap() {
        return this.internalGetParameters().getMap();
    }

    @Override
    public String getParametersOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetParameters().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getParametersOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetParameters().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasStartTime() {
        return this.startTime_ != null;
    }

    @Override
    public Timestamp getStartTime() {
        return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
    }

    @Override
    public TimestampOrBuilder getStartTimeOrBuilder() {
        return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
    }

    @Override
    public boolean hasEndTime() {
        return this.endTime_ != null;
    }

    @Override
    public Timestamp getEndTime() {
        return this.endTime_ == null ? Timestamp.getDefaultInstance() : this.endTime_;
    }

    @Override
    public TimestampOrBuilder getEndTimeOrBuilder() {
        return this.endTime_ == null ? Timestamp.getDefaultInstance() : this.endTime_;
    }

    @Override
    public String getClusterUuid() {
        Object ref = this.clusterUuid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterUuid_ = s;
        return s;
    }

    @Override
    public ByteString getClusterUuidBytes() {
        Object ref = this.clusterUuid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterUuid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasDagTimeout() {
        return this.dagTimeout_ != null;
    }

    @Override
    public Duration getDagTimeout() {
        return this.dagTimeout_ == null ? Duration.getDefaultInstance() : this.dagTimeout_;
    }

    @Override
    public DurationOrBuilder getDagTimeoutOrBuilder() {
        return this.dagTimeout_ == null ? Duration.getDefaultInstance() : this.dagTimeout_;
    }

    @Override
    public boolean hasDagStartTime() {
        return this.dagStartTime_ != null;
    }

    @Override
    public Timestamp getDagStartTime() {
        return this.dagStartTime_ == null ? Timestamp.getDefaultInstance() : this.dagStartTime_;
    }

    @Override
    public TimestampOrBuilder getDagStartTimeOrBuilder() {
        return this.dagStartTime_ == null ? Timestamp.getDefaultInstance() : this.dagStartTime_;
    }

    @Override
    public boolean hasDagEndTime() {
        return this.dagEndTime_ != null;
    }

    @Override
    public Timestamp getDagEndTime() {
        return this.dagEndTime_ == null ? Timestamp.getDefaultInstance() : this.dagEndTime_;
    }

    @Override
    public TimestampOrBuilder getDagEndTimeOrBuilder() {
        return this.dagEndTime_ == null ? Timestamp.getDefaultInstance() : this.dagEndTime_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.template_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.template_);
        }
        if (this.version_ != 0) {
            output.writeInt32(2, this.version_);
        }
        if (this.createCluster_ != null) {
            output.writeMessage(3, (MessageLite)this.getCreateCluster());
        }
        if (this.graph_ != null) {
            output.writeMessage(4, (MessageLite)this.getGraph());
        }
        if (this.deleteCluster_ != null) {
            output.writeMessage(5, (MessageLite)this.getDeleteCluster());
        }
        if (this.state_ != State.UNKNOWN.getNumber()) {
            output.writeEnum(6, this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.clusterName_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, (int)8);
        if (this.startTime_ != null) {
            output.writeMessage(9, (MessageLite)this.getStartTime());
        }
        if (this.endTime_ != null) {
            output.writeMessage(10, (MessageLite)this.getEndTime());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterUuid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.clusterUuid_);
        }
        if (this.dagTimeout_ != null) {
            output.writeMessage(12, (MessageLite)this.getDagTimeout());
        }
        if (this.dagStartTime_ != null) {
            output.writeMessage(13, (MessageLite)this.getDagStartTime());
        }
        if (this.dagEndTime_ != null) {
            output.writeMessage(14, (MessageLite)this.getDagEndTime());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.template_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.template_);
        }
        if (this.version_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.version_);
        }
        if (this.createCluster_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCreateCluster());
        }
        if (this.graph_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getGraph());
        }
        if (this.deleteCluster_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getDeleteCluster());
        }
        if (this.state_ != State.UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterName_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.clusterName_);
        }
        for (Map.Entry entry : this.internalGetParameters().getMap().entrySet()) {
            MapEntry parameters__ = ParametersDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)parameters__);
        }
        if (this.startTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getStartTime());
        }
        if (this.endTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getEndTime());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterUuid_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.clusterUuid_);
        }
        if (this.dagTimeout_ != null) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getDagTimeout());
        }
        if (this.dagStartTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getDagStartTime());
        }
        if (this.dagEndTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getDagEndTime());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowMetadata)) {
            return super.equals(obj);
        }
        WorkflowMetadata other = (WorkflowMetadata)obj;
        if (!this.getTemplate().equals(other.getTemplate())) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.hasCreateCluster() != other.hasCreateCluster()) {
            return false;
        }
        if (this.hasCreateCluster() && !this.getCreateCluster().equals(other.getCreateCluster())) {
            return false;
        }
        if (this.hasGraph() != other.hasGraph()) {
            return false;
        }
        if (this.hasGraph() && !this.getGraph().equals(other.getGraph())) {
            return false;
        }
        if (this.hasDeleteCluster() != other.hasDeleteCluster()) {
            return false;
        }
        if (this.hasDeleteCluster() && !this.getDeleteCluster().equals(other.getDeleteCluster())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (!this.getClusterName().equals(other.getClusterName())) {
            return false;
        }
        if (!this.internalGetParameters().equals(other.internalGetParameters())) {
            return false;
        }
        if (this.hasStartTime() != other.hasStartTime()) {
            return false;
        }
        if (this.hasStartTime() && !this.getStartTime().equals((Object)other.getStartTime())) {
            return false;
        }
        if (this.hasEndTime() != other.hasEndTime()) {
            return false;
        }
        if (this.hasEndTime() && !this.getEndTime().equals((Object)other.getEndTime())) {
            return false;
        }
        if (!this.getClusterUuid().equals(other.getClusterUuid())) {
            return false;
        }
        if (this.hasDagTimeout() != other.hasDagTimeout()) {
            return false;
        }
        if (this.hasDagTimeout() && !this.getDagTimeout().equals((Object)other.getDagTimeout())) {
            return false;
        }
        if (this.hasDagStartTime() != other.hasDagStartTime()) {
            return false;
        }
        if (this.hasDagStartTime() && !this.getDagStartTime().equals((Object)other.getDagStartTime())) {
            return false;
        }
        if (this.hasDagEndTime() != other.hasDagEndTime()) {
            return false;
        }
        if (this.hasDagEndTime() && !this.getDagEndTime().equals((Object)other.getDagEndTime())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + WorkflowMetadata.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTemplate().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getVersion();
        if (this.hasCreateCluster()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCreateCluster().hashCode();
        }
        if (this.hasGraph()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getGraph().hashCode();
        }
        if (this.hasDeleteCluster()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDeleteCluster().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getClusterName().hashCode();
        if (!this.internalGetParameters().getMap().isEmpty()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.internalGetParameters().hashCode();
        }
        if (this.hasStartTime()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getStartTime().hashCode();
        }
        if (this.hasEndTime()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getEndTime().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getClusterUuid().hashCode();
        if (this.hasDagTimeout()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getDagTimeout().hashCode();
        }
        if (this.hasDagStartTime()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getDagStartTime().hashCode();
        }
        if (this.hasDagEndTime()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getDagEndTime().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static WorkflowMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data);
    }

    public static WorkflowMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data);
    }

    public static WorkflowMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data);
    }

    public static WorkflowMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowMetadata parseFrom(InputStream input) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static WorkflowMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WorkflowMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static WorkflowMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WorkflowMetadata parseFrom(CodedInputStream input) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static WorkflowMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return WorkflowMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(WorkflowMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static WorkflowMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<WorkflowMetadata> parser() {
        return PARSER;
    }

    public Parser<WorkflowMetadata> getParserForType() {
        return PARSER;
    }

    public WorkflowMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements WorkflowMetadataOrBuilder {
        private int bitField0_;
        private Object template_ = "";
        private int version_;
        private ClusterOperation createCluster_;
        private SingleFieldBuilderV3<ClusterOperation, ClusterOperation.Builder, ClusterOperationOrBuilder> createClusterBuilder_;
        private WorkflowGraph graph_;
        private SingleFieldBuilderV3<WorkflowGraph, WorkflowGraph.Builder, WorkflowGraphOrBuilder> graphBuilder_;
        private ClusterOperation deleteCluster_;
        private SingleFieldBuilderV3<ClusterOperation, ClusterOperation.Builder, ClusterOperationOrBuilder> deleteClusterBuilder_;
        private int state_ = 0;
        private Object clusterName_ = "";
        private MapField<String, String> parameters_;
        private Timestamp startTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> startTimeBuilder_;
        private Timestamp endTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> endTimeBuilder_;
        private Object clusterUuid_ = "";
        private Duration dagTimeout_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> dagTimeoutBuilder_;
        private Timestamp dagStartTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> dagStartTimeBuilder_;
        private Timestamp dagEndTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> dagEndTimeBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetParameters();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetMutableParameters();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(WorkflowMetadata.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.template_ = "";
            this.version_ = 0;
            this.createCluster_ = null;
            if (this.createClusterBuilder_ != null) {
                this.createClusterBuilder_.dispose();
                this.createClusterBuilder_ = null;
            }
            this.graph_ = null;
            if (this.graphBuilder_ != null) {
                this.graphBuilder_.dispose();
                this.graphBuilder_ = null;
            }
            this.deleteCluster_ = null;
            if (this.deleteClusterBuilder_ != null) {
                this.deleteClusterBuilder_.dispose();
                this.deleteClusterBuilder_ = null;
            }
            this.state_ = 0;
            this.clusterName_ = "";
            this.internalGetMutableParameters().clear();
            this.startTime_ = null;
            if (this.startTimeBuilder_ != null) {
                this.startTimeBuilder_.dispose();
                this.startTimeBuilder_ = null;
            }
            this.endTime_ = null;
            if (this.endTimeBuilder_ != null) {
                this.endTimeBuilder_.dispose();
                this.endTimeBuilder_ = null;
            }
            this.clusterUuid_ = "";
            this.dagTimeout_ = null;
            if (this.dagTimeoutBuilder_ != null) {
                this.dagTimeoutBuilder_.dispose();
                this.dagTimeoutBuilder_ = null;
            }
            this.dagStartTime_ = null;
            if (this.dagStartTimeBuilder_ != null) {
                this.dagStartTimeBuilder_.dispose();
                this.dagStartTimeBuilder_ = null;
            }
            this.dagEndTime_ = null;
            if (this.dagEndTimeBuilder_ != null) {
                this.dagEndTimeBuilder_.dispose();
                this.dagEndTimeBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
        }

        public WorkflowMetadata getDefaultInstanceForType() {
            return WorkflowMetadata.getDefaultInstance();
        }

        public WorkflowMetadata build() {
            WorkflowMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public WorkflowMetadata buildPartial() {
            WorkflowMetadata result = new WorkflowMetadata(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(WorkflowMetadata result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.template_ = this.template_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.version_ = this.version_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.createCluster_ = this.createClusterBuilder_ == null ? this.createCluster_ : (ClusterOperation)this.createClusterBuilder_.build();
            }
            if ((from_bitField0_ & 8) != 0) {
                result.graph_ = this.graphBuilder_ == null ? this.graph_ : (WorkflowGraph)this.graphBuilder_.build();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.deleteCluster_ = this.deleteClusterBuilder_ == null ? this.deleteCluster_ : (ClusterOperation)this.deleteClusterBuilder_.build();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.clusterName_ = this.clusterName_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.parameters_ = this.internalGetParameters();
                result.parameters_.makeImmutable();
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.startTime_ = this.startTimeBuilder_ == null ? this.startTime_ : (Timestamp)this.startTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.endTime_ = this.endTimeBuilder_ == null ? this.endTime_ : (Timestamp)this.endTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.clusterUuid_ = this.clusterUuid_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.dagTimeout_ = this.dagTimeoutBuilder_ == null ? this.dagTimeout_ : (Duration)this.dagTimeoutBuilder_.build();
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.dagStartTime_ = this.dagStartTimeBuilder_ == null ? this.dagStartTime_ : (Timestamp)this.dagStartTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.dagEndTime_ = this.dagEndTimeBuilder_ == null ? this.dagEndTime_ : (Timestamp)this.dagEndTimeBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof WorkflowMetadata) {
                return this.mergeFrom((WorkflowMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(WorkflowMetadata other) {
            if (other == WorkflowMetadata.getDefaultInstance()) {
                return this;
            }
            if (!other.getTemplate().isEmpty()) {
                this.template_ = other.template_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getVersion() != 0) {
                this.setVersion(other.getVersion());
            }
            if (other.hasCreateCluster()) {
                this.mergeCreateCluster(other.getCreateCluster());
            }
            if (other.hasGraph()) {
                this.mergeGraph(other.getGraph());
            }
            if (other.hasDeleteCluster()) {
                this.mergeDeleteCluster(other.getDeleteCluster());
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (!other.getClusterName().isEmpty()) {
                this.clusterName_ = other.clusterName_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            this.internalGetMutableParameters().mergeFrom(other.internalGetParameters());
            this.bitField0_ |= 0x80;
            if (other.hasStartTime()) {
                this.mergeStartTime(other.getStartTime());
            }
            if (other.hasEndTime()) {
                this.mergeEndTime(other.getEndTime());
            }
            if (!other.getClusterUuid().isEmpty()) {
                this.clusterUuid_ = other.clusterUuid_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.hasDagTimeout()) {
                this.mergeDagTimeout(other.getDagTimeout());
            }
            if (other.hasDagStartTime()) {
                this.mergeDagStartTime(other.getDagStartTime());
            }
            if (other.hasDagEndTime()) {
                this.mergeDagEndTime(other.getDagEndTime());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 10: {
                            this.template_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 16: {
                            this.version_ = input.readInt32();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCreateClusterFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getGraphFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDeleteClusterFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 48: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 58: {
                            this.clusterName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 66: {
                            MapEntry parameters__ = (MapEntry)input.readMessage(ParametersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableParameters().getMutableMap().put(parameters__.getKey(), parameters__.getValue());
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block22;
                        }
                        case 90: {
                            this.clusterUuid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getDagTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getDagStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getDagEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getTemplate() {
            Object ref = this.template_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.template_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTemplateBytes() {
            Object ref = this.template_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.template_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTemplate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.template_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTemplate() {
            this.template_ = WorkflowMetadata.getDefaultInstance().getTemplate();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setTemplateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowMetadata.checkByteStringIsUtf8((ByteString)value);
            this.template_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getVersion() {
            return this.version_;
        }

        public Builder setVersion(int value) {
            this.version_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearVersion() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.version_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateCluster() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public ClusterOperation getCreateCluster() {
            if (this.createClusterBuilder_ == null) {
                return this.createCluster_ == null ? ClusterOperation.getDefaultInstance() : this.createCluster_;
            }
            return (ClusterOperation)this.createClusterBuilder_.getMessage();
        }

        public Builder setCreateCluster(ClusterOperation value) {
            if (this.createClusterBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createCluster_ = value;
            } else {
                this.createClusterBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setCreateCluster(ClusterOperation.Builder builderForValue) {
            if (this.createClusterBuilder_ == null) {
                this.createCluster_ = builderForValue.build();
            } else {
                this.createClusterBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateCluster(ClusterOperation value) {
            if (this.createClusterBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.createCluster_ != null && this.createCluster_ != ClusterOperation.getDefaultInstance()) {
                    this.getCreateClusterBuilder().mergeFrom(value);
                } else {
                    this.createCluster_ = value;
                }
            } else {
                this.createClusterBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearCreateCluster() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.createCluster_ = null;
            if (this.createClusterBuilder_ != null) {
                this.createClusterBuilder_.dispose();
                this.createClusterBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ClusterOperation.Builder getCreateClusterBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (ClusterOperation.Builder)this.getCreateClusterFieldBuilder().getBuilder();
        }

        @Override
        public ClusterOperationOrBuilder getCreateClusterOrBuilder() {
            if (this.createClusterBuilder_ != null) {
                return (ClusterOperationOrBuilder)this.createClusterBuilder_.getMessageOrBuilder();
            }
            return this.createCluster_ == null ? ClusterOperation.getDefaultInstance() : this.createCluster_;
        }

        private SingleFieldBuilderV3<ClusterOperation, ClusterOperation.Builder, ClusterOperationOrBuilder> getCreateClusterFieldBuilder() {
            if (this.createClusterBuilder_ == null) {
                this.createClusterBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateCluster(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createCluster_ = null;
            }
            return this.createClusterBuilder_;
        }

        @Override
        public boolean hasGraph() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public WorkflowGraph getGraph() {
            if (this.graphBuilder_ == null) {
                return this.graph_ == null ? WorkflowGraph.getDefaultInstance() : this.graph_;
            }
            return (WorkflowGraph)this.graphBuilder_.getMessage();
        }

        public Builder setGraph(WorkflowGraph value) {
            if (this.graphBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.graph_ = value;
            } else {
                this.graphBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setGraph(WorkflowGraph.Builder builderForValue) {
            if (this.graphBuilder_ == null) {
                this.graph_ = builderForValue.build();
            } else {
                this.graphBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeGraph(WorkflowGraph value) {
            if (this.graphBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.graph_ != null && this.graph_ != WorkflowGraph.getDefaultInstance()) {
                    this.getGraphBuilder().mergeFrom(value);
                } else {
                    this.graph_ = value;
                }
            } else {
                this.graphBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearGraph() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.graph_ = null;
            if (this.graphBuilder_ != null) {
                this.graphBuilder_.dispose();
                this.graphBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowGraph.Builder getGraphBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (WorkflowGraph.Builder)this.getGraphFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowGraphOrBuilder getGraphOrBuilder() {
            if (this.graphBuilder_ != null) {
                return (WorkflowGraphOrBuilder)this.graphBuilder_.getMessageOrBuilder();
            }
            return this.graph_ == null ? WorkflowGraph.getDefaultInstance() : this.graph_;
        }

        private SingleFieldBuilderV3<WorkflowGraph, WorkflowGraph.Builder, WorkflowGraphOrBuilder> getGraphFieldBuilder() {
            if (this.graphBuilder_ == null) {
                this.graphBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getGraph(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.graph_ = null;
            }
            return this.graphBuilder_;
        }

        @Override
        public boolean hasDeleteCluster() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public ClusterOperation getDeleteCluster() {
            if (this.deleteClusterBuilder_ == null) {
                return this.deleteCluster_ == null ? ClusterOperation.getDefaultInstance() : this.deleteCluster_;
            }
            return (ClusterOperation)this.deleteClusterBuilder_.getMessage();
        }

        public Builder setDeleteCluster(ClusterOperation value) {
            if (this.deleteClusterBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.deleteCluster_ = value;
            } else {
                this.deleteClusterBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setDeleteCluster(ClusterOperation.Builder builderForValue) {
            if (this.deleteClusterBuilder_ == null) {
                this.deleteCluster_ = builderForValue.build();
            } else {
                this.deleteClusterBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeDeleteCluster(ClusterOperation value) {
            if (this.deleteClusterBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.deleteCluster_ != null && this.deleteCluster_ != ClusterOperation.getDefaultInstance()) {
                    this.getDeleteClusterBuilder().mergeFrom(value);
                } else {
                    this.deleteCluster_ = value;
                }
            } else {
                this.deleteClusterBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearDeleteCluster() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.deleteCluster_ = null;
            if (this.deleteClusterBuilder_ != null) {
                this.deleteClusterBuilder_.dispose();
                this.deleteClusterBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ClusterOperation.Builder getDeleteClusterBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (ClusterOperation.Builder)this.getDeleteClusterFieldBuilder().getBuilder();
        }

        @Override
        public ClusterOperationOrBuilder getDeleteClusterOrBuilder() {
            if (this.deleteClusterBuilder_ != null) {
                return (ClusterOperationOrBuilder)this.deleteClusterBuilder_.getMessageOrBuilder();
            }
            return this.deleteCluster_ == null ? ClusterOperation.getDefaultInstance() : this.deleteCluster_;
        }

        private SingleFieldBuilderV3<ClusterOperation, ClusterOperation.Builder, ClusterOperationOrBuilder> getDeleteClusterFieldBuilder() {
            if (this.deleteClusterBuilder_ == null) {
                this.deleteClusterBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDeleteCluster(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.deleteCluster_ = null;
            }
            return this.deleteClusterBuilder_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getClusterName() {
            Object ref = this.clusterName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterNameBytes() {
            Object ref = this.clusterName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterName_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearClusterName() {
            this.clusterName_ = WorkflowMetadata.getDefaultInstance().getClusterName();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setClusterNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowMetadata.checkByteStringIsUtf8((ByteString)value);
            this.clusterName_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetParameters() {
            if (this.parameters_ == null) {
                return MapField.emptyMapField(ParametersDefaultEntryHolder.defaultEntry);
            }
            return this.parameters_;
        }

        private MapField<String, String> internalGetMutableParameters() {
            if (this.parameters_ == null) {
                this.parameters_ = MapField.newMapField(ParametersDefaultEntryHolder.defaultEntry);
            }
            if (!this.parameters_.isMutable()) {
                this.parameters_ = this.parameters_.copy();
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this.parameters_;
        }

        @Override
        public int getParametersCount() {
            return this.internalGetParameters().getMap().size();
        }

        @Override
        public boolean containsParameters(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetParameters().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getParameters() {
            return this.getParametersMap();
        }

        @Override
        public Map<String, String> getParametersMap() {
            return this.internalGetParameters().getMap();
        }

        @Override
        public String getParametersOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetParameters().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getParametersOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetParameters().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearParameters() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.internalGetMutableParameters().getMutableMap().clear();
            return this;
        }

        public Builder removeParameters(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableParameters().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableParameters() {
            this.bitField0_ |= 0x80;
            return this.internalGetMutableParameters().getMutableMap();
        }

        public Builder putParameters(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableParameters().getMutableMap().put(key, value);
            this.bitField0_ |= 0x80;
            return this;
        }

        public Builder putAllParameters(Map<String, String> values) {
            this.internalGetMutableParameters().getMutableMap().putAll(values);
            this.bitField0_ |= 0x80;
            return this;
        }

        @Override
        public boolean hasStartTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getStartTime() {
            if (this.startTimeBuilder_ == null) {
                return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
            }
            return (Timestamp)this.startTimeBuilder_.getMessage();
        }

        public Builder setStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startTime_ = value;
            } else {
                this.startTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setStartTime(Timestamp.Builder builderForValue) {
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = builderForValue.build();
            } else {
                this.startTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.startTime_ != null && this.startTime_ != Timestamp.getDefaultInstance()) {
                    this.getStartTimeBuilder().mergeFrom(value);
                } else {
                    this.startTime_ = value;
                }
            } else {
                this.startTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearStartTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.startTime_ = null;
            if (this.startTimeBuilder_ != null) {
                this.startTimeBuilder_.dispose();
                this.startTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getStartTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getStartTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getStartTimeOrBuilder() {
            if (this.startTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.startTimeBuilder_.getMessageOrBuilder();
            }
            return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getStartTimeFieldBuilder() {
            if (this.startTimeBuilder_ == null) {
                this.startTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startTime_ = null;
            }
            return this.startTimeBuilder_;
        }

        @Override
        public boolean hasEndTime() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public Timestamp getEndTime() {
            if (this.endTimeBuilder_ == null) {
                return this.endTime_ == null ? Timestamp.getDefaultInstance() : this.endTime_;
            }
            return (Timestamp)this.endTimeBuilder_.getMessage();
        }

        public Builder setEndTime(Timestamp value) {
            if (this.endTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.endTime_ = value;
            } else {
                this.endTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setEndTime(Timestamp.Builder builderForValue) {
            if (this.endTimeBuilder_ == null) {
                this.endTime_ = builderForValue.build();
            } else {
                this.endTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeEndTime(Timestamp value) {
            if (this.endTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.endTime_ != null && this.endTime_ != Timestamp.getDefaultInstance()) {
                    this.getEndTimeBuilder().mergeFrom(value);
                } else {
                    this.endTime_ = value;
                }
            } else {
                this.endTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearEndTime() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.endTime_ = null;
            if (this.endTimeBuilder_ != null) {
                this.endTimeBuilder_.dispose();
                this.endTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEndTimeBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (Timestamp.Builder)this.getEndTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEndTimeOrBuilder() {
            if (this.endTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.endTimeBuilder_.getMessageOrBuilder();
            }
            return this.endTime_ == null ? Timestamp.getDefaultInstance() : this.endTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEndTimeFieldBuilder() {
            if (this.endTimeBuilder_ == null) {
                this.endTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEndTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.endTime_ = null;
            }
            return this.endTimeBuilder_;
        }

        @Override
        public String getClusterUuid() {
            Object ref = this.clusterUuid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterUuid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterUuidBytes() {
            Object ref = this.clusterUuid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterUuid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterUuid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterUuid_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearClusterUuid() {
            this.clusterUuid_ = WorkflowMetadata.getDefaultInstance().getClusterUuid();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setClusterUuidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowMetadata.checkByteStringIsUtf8((ByteString)value);
            this.clusterUuid_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDagTimeout() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public Duration getDagTimeout() {
            if (this.dagTimeoutBuilder_ == null) {
                return this.dagTimeout_ == null ? Duration.getDefaultInstance() : this.dagTimeout_;
            }
            return (Duration)this.dagTimeoutBuilder_.getMessage();
        }

        public Builder setDagTimeout(Duration value) {
            if (this.dagTimeoutBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dagTimeout_ = value;
            } else {
                this.dagTimeoutBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setDagTimeout(Duration.Builder builderForValue) {
            if (this.dagTimeoutBuilder_ == null) {
                this.dagTimeout_ = builderForValue.build();
            } else {
                this.dagTimeoutBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeDagTimeout(Duration value) {
            if (this.dagTimeoutBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.dagTimeout_ != null && this.dagTimeout_ != Duration.getDefaultInstance()) {
                    this.getDagTimeoutBuilder().mergeFrom(value);
                } else {
                    this.dagTimeout_ = value;
                }
            } else {
                this.dagTimeoutBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearDagTimeout() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.dagTimeout_ = null;
            if (this.dagTimeoutBuilder_ != null) {
                this.dagTimeoutBuilder_.dispose();
                this.dagTimeoutBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getDagTimeoutBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (Duration.Builder)this.getDagTimeoutFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getDagTimeoutOrBuilder() {
            if (this.dagTimeoutBuilder_ != null) {
                return (DurationOrBuilder)this.dagTimeoutBuilder_.getMessageOrBuilder();
            }
            return this.dagTimeout_ == null ? Duration.getDefaultInstance() : this.dagTimeout_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getDagTimeoutFieldBuilder() {
            if (this.dagTimeoutBuilder_ == null) {
                this.dagTimeoutBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDagTimeout(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dagTimeout_ = null;
            }
            return this.dagTimeoutBuilder_;
        }

        @Override
        public boolean hasDagStartTime() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public Timestamp getDagStartTime() {
            if (this.dagStartTimeBuilder_ == null) {
                return this.dagStartTime_ == null ? Timestamp.getDefaultInstance() : this.dagStartTime_;
            }
            return (Timestamp)this.dagStartTimeBuilder_.getMessage();
        }

        public Builder setDagStartTime(Timestamp value) {
            if (this.dagStartTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dagStartTime_ = value;
            } else {
                this.dagStartTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setDagStartTime(Timestamp.Builder builderForValue) {
            if (this.dagStartTimeBuilder_ == null) {
                this.dagStartTime_ = builderForValue.build();
            } else {
                this.dagStartTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeDagStartTime(Timestamp value) {
            if (this.dagStartTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.dagStartTime_ != null && this.dagStartTime_ != Timestamp.getDefaultInstance()) {
                    this.getDagStartTimeBuilder().mergeFrom(value);
                } else {
                    this.dagStartTime_ = value;
                }
            } else {
                this.dagStartTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearDagStartTime() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.dagStartTime_ = null;
            if (this.dagStartTimeBuilder_ != null) {
                this.dagStartTimeBuilder_.dispose();
                this.dagStartTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getDagStartTimeBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (Timestamp.Builder)this.getDagStartTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getDagStartTimeOrBuilder() {
            if (this.dagStartTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.dagStartTimeBuilder_.getMessageOrBuilder();
            }
            return this.dagStartTime_ == null ? Timestamp.getDefaultInstance() : this.dagStartTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getDagStartTimeFieldBuilder() {
            if (this.dagStartTimeBuilder_ == null) {
                this.dagStartTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDagStartTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dagStartTime_ = null;
            }
            return this.dagStartTimeBuilder_;
        }

        @Override
        public boolean hasDagEndTime() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public Timestamp getDagEndTime() {
            if (this.dagEndTimeBuilder_ == null) {
                return this.dagEndTime_ == null ? Timestamp.getDefaultInstance() : this.dagEndTime_;
            }
            return (Timestamp)this.dagEndTimeBuilder_.getMessage();
        }

        public Builder setDagEndTime(Timestamp value) {
            if (this.dagEndTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.dagEndTime_ = value;
            } else {
                this.dagEndTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setDagEndTime(Timestamp.Builder builderForValue) {
            if (this.dagEndTimeBuilder_ == null) {
                this.dagEndTime_ = builderForValue.build();
            } else {
                this.dagEndTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeDagEndTime(Timestamp value) {
            if (this.dagEndTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.dagEndTime_ != null && this.dagEndTime_ != Timestamp.getDefaultInstance()) {
                    this.getDagEndTimeBuilder().mergeFrom(value);
                } else {
                    this.dagEndTime_ = value;
                }
            } else {
                this.dagEndTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearDagEndTime() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.dagEndTime_ = null;
            if (this.dagEndTimeBuilder_ != null) {
                this.dagEndTimeBuilder_.dispose();
                this.dagEndTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getDagEndTimeBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (Timestamp.Builder)this.getDagEndTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getDagEndTimeOrBuilder() {
            if (this.dagEndTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.dagEndTimeBuilder_.getMessageOrBuilder();
            }
            return this.dagEndTime_ == null ? Timestamp.getDefaultInstance() : this.dagEndTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getDagEndTimeFieldBuilder() {
            if (this.dagEndTimeBuilder_ == null) {
                this.dagEndTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDagEndTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dagEndTime_ = null;
            }
            return this.dagEndTimeBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class ParametersDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)WorkflowTemplatesProto.internal_static_google_cloud_dataproc_v1_WorkflowMetadata_ParametersEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private ParametersDefaultEntryHolder() {
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        UNKNOWN(0),
        PENDING(1),
        RUNNING(2),
        DONE(3),
        UNRECOGNIZED(-1);

        public static final int UNKNOWN_VALUE = 0;
        public static final int PENDING_VALUE = 1;
        public static final int RUNNING_VALUE = 2;
        public static final int DONE_VALUE = 3;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return PENDING;
                }
                case 2: {
                    return RUNNING;
                }
                case 3: {
                    return DONE;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)WorkflowMetadata.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

