/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkflowTemplateName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/workflowTemplates/{workflow_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String workflowTemplate;

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getWorkflowTemplate() {
        return this.workflowTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private WorkflowTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.workflowTemplate = (String)Preconditions.checkNotNull((Object)builder.getWorkflowTemplate());
    }

    public static WorkflowTemplateName of(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build();
    }

    public static String format(String project, String region, String workflowTemplate) {
        return WorkflowTemplateName.newBuilder().setProject(project).setRegion(region).setWorkflowTemplate(workflowTemplate).build().toString();
    }

    public static WorkflowTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "WorkflowTemplateName.parse: formattedString not in valid format");
        return WorkflowTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("workflow_template"));
    }

    public static List<WorkflowTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<WorkflowTemplateName> list = new ArrayList<WorkflowTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkflowTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkflowTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkflowTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkflowTemplateName workflowTemplateName = this;
            synchronized (workflowTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"workflowTemplate", (Object)this.workflowTemplate);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "workflow_template", this.workflowTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WorkflowTemplateName) {
            WorkflowTemplateName that = (WorkflowTemplateName)o;
            return this.project.equals(that.project) && this.region.equals(that.region) && this.workflowTemplate.equals(that.workflowTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.region.hashCode();
        h *= 1000003;
        return h ^= this.workflowTemplate.hashCode();
    }

    public static class Builder {
        private String project;
        private String region;
        private String workflowTemplate;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getWorkflowTemplate() {
            return this.workflowTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setWorkflowTemplate(String workflowTemplate) {
            this.workflowTemplate = workflowTemplate;
            return this;
        }

        private Builder() {
        }

        private Builder(WorkflowTemplateName workflowTemplateName) {
            this.project = workflowTemplateName.project;
            this.region = workflowTemplateName.region;
            this.workflowTemplate = workflowTemplateName.workflowTemplate;
        }

        public WorkflowTemplateName build() {
            return new WorkflowTemplateName(this);
        }
    }
}

