/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlossaryCategoryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GLOSSARY_GLOSSARY_CATEGORY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/glossaries/{glossary}/categories/{glossary_category}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String glossary;
    private final String glossaryCategory;

    @Deprecated
    protected GlossaryCategoryName() {
        this.project = null;
        this.location = null;
        this.glossary = null;
        this.glossaryCategory = null;
    }

    private GlossaryCategoryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.glossary = (String)Preconditions.checkNotNull((Object)builder.getGlossary());
        this.glossaryCategory = (String)Preconditions.checkNotNull((Object)builder.getGlossaryCategory());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public String getGlossaryCategory() {
        return this.glossaryCategory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GlossaryCategoryName of(String project, String location, String glossary, String glossaryCategory) {
        return GlossaryCategoryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryCategory(glossaryCategory).build();
    }

    public static String format(String project, String location, String glossary, String glossaryCategory) {
        return GlossaryCategoryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryCategory(glossaryCategory).build().toString();
    }

    public static GlossaryCategoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GLOSSARY_GLOSSARY_CATEGORY.validatedMatch(formattedString, "GlossaryCategoryName.parse: formattedString not in valid format");
        return GlossaryCategoryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("glossary"), (String)matchMap.get("glossary_category"));
    }

    public static List<GlossaryCategoryName> parseList(List<String> formattedStrings) {
        ArrayList<GlossaryCategoryName> list = new ArrayList<GlossaryCategoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlossaryCategoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlossaryCategoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlossaryCategoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_CATEGORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlossaryCategoryName glossaryCategoryName = this;
            synchronized (glossaryCategoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.glossary != null) {
                        fieldMapBuilder.put((Object)"glossary", (Object)this.glossary);
                    }
                    if (this.glossaryCategory != null) {
                        fieldMapBuilder.put((Object)"glossary_category", (Object)this.glossaryCategory);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_CATEGORY.instantiate(new String[]{"project", this.project, "location", this.location, "glossary", this.glossary, "glossary_category", this.glossaryCategory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GlossaryCategoryName that = (GlossaryCategoryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.glossary, that.glossary) && Objects.equals(this.glossaryCategory, that.glossaryCategory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.glossary);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glossaryCategory);
    }

    public static class Builder {
        private String project;
        private String location;
        private String glossary;
        private String glossaryCategory;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGlossary() {
            return this.glossary;
        }

        public String getGlossaryCategory() {
            return this.glossaryCategory;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGlossary(String glossary) {
            this.glossary = glossary;
            return this;
        }

        public Builder setGlossaryCategory(String glossaryCategory) {
            this.glossaryCategory = glossaryCategory;
            return this;
        }

        private Builder(GlossaryCategoryName glossaryCategoryName) {
            this.project = glossaryCategoryName.project;
            this.location = glossaryCategoryName.location;
            this.glossary = glossaryCategoryName.glossary;
            this.glossaryCategory = glossaryCategoryName.glossaryCategory;
        }

        public GlossaryCategoryName build() {
            return new GlossaryCategoryName(this);
        }
    }
}

