/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EncryptionConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_ENCRYPTION_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/encryptionConfigs/{encryption_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String encryptionConfig;

    @Deprecated
    protected EncryptionConfigName() {
        this.organization = null;
        this.location = null;
        this.encryptionConfig = null;
    }

    private EncryptionConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.encryptionConfig = (String)Preconditions.checkNotNull((Object)builder.getEncryptionConfig());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EncryptionConfigName of(String organization, String location, String encryptionConfig) {
        return EncryptionConfigName.newBuilder().setOrganization(organization).setLocation(location).setEncryptionConfig(encryptionConfig).build();
    }

    public static String format(String organization, String location, String encryptionConfig) {
        return EncryptionConfigName.newBuilder().setOrganization(organization).setLocation(location).setEncryptionConfig(encryptionConfig).build().toString();
    }

    public static EncryptionConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_ENCRYPTION_CONFIG.validatedMatch(formattedString, "EncryptionConfigName.parse: formattedString not in valid format");
        return EncryptionConfigName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("encryption_config"));
    }

    public static List<EncryptionConfigName> parseList(List<String> formattedStrings) {
        ArrayList<EncryptionConfigName> list = new ArrayList<EncryptionConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EncryptionConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EncryptionConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EncryptionConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_ENCRYPTION_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EncryptionConfigName encryptionConfigName = this;
            synchronized (encryptionConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.encryptionConfig != null) {
                        fieldMapBuilder.put((Object)"encryption_config", (Object)this.encryptionConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_ENCRYPTION_CONFIG.instantiate(new String[]{"organization", this.organization, "location", this.location, "encryption_config", this.encryptionConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EncryptionConfigName that = (EncryptionConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.encryptionConfig, that.encryptionConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.encryptionConfig);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String encryptionConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEncryptionConfig() {
            return this.encryptionConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEncryptionConfig(String encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        private Builder(EncryptionConfigName encryptionConfigName) {
            this.organization = encryptionConfigName.organization;
            this.location = encryptionConfigName.location;
            this.encryptionConfig = encryptionConfigName.encryptionConfig;
        }

        public EncryptionConfigName build() {
            return new EncryptionConfigName(this);
        }
    }
}

