/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetadataJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_METADATAJOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/metadataJobs/{metadataJob}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String metadataJob;

    @Deprecated
    protected MetadataJobName() {
        this.project = null;
        this.location = null;
        this.metadataJob = null;
    }

    private MetadataJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.metadataJob = (String)Preconditions.checkNotNull((Object)builder.getMetadataJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMetadataJob() {
        return this.metadataJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetadataJobName of(String project, String location, String metadataJob) {
        return MetadataJobName.newBuilder().setProject(project).setLocation(location).setMetadataJob(metadataJob).build();
    }

    public static String format(String project, String location, String metadataJob) {
        return MetadataJobName.newBuilder().setProject(project).setLocation(location).setMetadataJob(metadataJob).build().toString();
    }

    public static MetadataJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_METADATAJOB.validatedMatch(formattedString, "MetadataJobName.parse: formattedString not in valid format");
        return MetadataJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("metadataJob"));
    }

    public static List<MetadataJobName> parseList(List<String> formattedStrings) {
        ArrayList<MetadataJobName> list = new ArrayList<MetadataJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetadataJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetadataJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetadataJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_METADATAJOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetadataJobName metadataJobName = this;
            synchronized (metadataJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.metadataJob != null) {
                        fieldMapBuilder.put((Object)"metadataJob", (Object)this.metadataJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_METADATAJOB.instantiate(new String[]{"project", this.project, "location", this.location, "metadataJob", this.metadataJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MetadataJobName that = (MetadataJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataJob, that.metadataJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.metadataJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String metadataJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMetadataJob() {
            return this.metadataJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMetadataJob(String metadataJob) {
            this.metadataJob = metadataJob;
            return this;
        }

        private Builder(MetadataJobName metadataJobName) {
            this.project = metadataJobName.project;
            this.location = metadataJobName.location;
            this.metadataJob = metadataJobName.metadataJob;
        }

        public MetadataJobName build() {
            return new MetadataJobName(this);
        }
    }
}

