/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LAKE_ZONE_ASSET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lake;
    private final String zone;
    private final String asset;

    @Deprecated
    protected AssetName() {
        this.project = null;
        this.location = null;
        this.lake = null;
        this.zone = null;
        this.asset = null;
    }

    private AssetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lake = (String)Preconditions.checkNotNull((Object)builder.getLake());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLake() {
        return this.lake;
    }

    public String getZone() {
        return this.zone;
    }

    public String getAsset() {
        return this.asset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetName of(String project, String location, String lake, String zone, String asset) {
        return AssetName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setAsset(asset).build();
    }

    public static String format(String project, String location, String lake, String zone, String asset) {
        return AssetName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setAsset(asset).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LAKE_ZONE_ASSET.validatedMatch(formattedString, "AssetName.parse: formattedString not in valid format");
        return AssetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lake"), (String)matchMap.get("zone"), (String)matchMap.get("asset"));
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LAKE_ZONE_ASSET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lake != null) {
                        fieldMapBuilder.put((Object)"lake", (Object)this.lake);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LAKE_ZONE_ASSET.instantiate(new String[]{"project", this.project, "location", this.location, "lake", this.lake, "zone", this.zone, "asset", this.asset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AssetName that = (AssetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lake, that.lake) && Objects.equals(this.zone, that.zone) && Objects.equals(this.asset, that.asset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.lake);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.asset);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lake;
        private String zone;
        private String asset;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLake() {
            return this.lake;
        }

        public String getZone() {
            return this.zone;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(AssetName assetName) {
            this.project = assetName.project;
            this.location = assetName.location;
            this.lake = assetName.lake;
            this.zone = assetName.zone;
            this.asset = assetName.asset;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

