/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntryTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTRY_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryTypes/{entry_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entryType;

    @Deprecated
    protected EntryTypeName() {
        this.project = null;
        this.location = null;
        this.entryType = null;
    }

    private EntryTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entryType = (String)Preconditions.checkNotNull((Object)builder.getEntryType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntryTypeName of(String project, String location, String entryType) {
        return EntryTypeName.newBuilder().setProject(project).setLocation(location).setEntryType(entryType).build();
    }

    public static String format(String project, String location, String entryType) {
        return EntryTypeName.newBuilder().setProject(project).setLocation(location).setEntryType(entryType).build().toString();
    }

    public static EntryTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTRY_TYPE.validatedMatch(formattedString, "EntryTypeName.parse: formattedString not in valid format");
        return EntryTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entry_type"));
    }

    public static List<EntryTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EntryTypeName> list = new ArrayList<EntryTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntryTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntryTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntryTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTRY_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntryTypeName entryTypeName = this;
            synchronized (entryTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entryType != null) {
                        fieldMapBuilder.put((Object)"entry_type", (Object)this.entryType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTRY_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "entry_type", this.entryType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntryTypeName that = (EntryTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entryType, that.entryType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entryType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entryType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntryType() {
            return this.entryType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntryType(String entryType) {
            this.entryType = entryType;
            return this;
        }

        private Builder(EntryTypeName entryTypeName) {
            this.project = entryTypeName.project;
            this.location = entryTypeName.location;
            this.entryType = entryTypeName.entryType;
        }

        public EntryTypeName build() {
            return new EntryTypeName(this);
        }
    }
}

