/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataTaxonomyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_TAXONOMY_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataTaxonomies/{data_taxonomy_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataTaxonomyId;

    @Deprecated
    protected DataTaxonomyName() {
        this.project = null;
        this.location = null;
        this.dataTaxonomyId = null;
    }

    private DataTaxonomyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataTaxonomyId = (String)Preconditions.checkNotNull((Object)builder.getDataTaxonomyId());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataTaxonomyId() {
        return this.dataTaxonomyId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataTaxonomyName of(String project, String location, String dataTaxonomyId) {
        return DataTaxonomyName.newBuilder().setProject(project).setLocation(location).setDataTaxonomyId(dataTaxonomyId).build();
    }

    public static String format(String project, String location, String dataTaxonomyId) {
        return DataTaxonomyName.newBuilder().setProject(project).setLocation(location).setDataTaxonomyId(dataTaxonomyId).build().toString();
    }

    public static DataTaxonomyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_TAXONOMY_ID.validatedMatch(formattedString, "DataTaxonomyName.parse: formattedString not in valid format");
        return DataTaxonomyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_taxonomy_id"));
    }

    public static List<DataTaxonomyName> parseList(List<String> formattedStrings) {
        ArrayList<DataTaxonomyName> list = new ArrayList<DataTaxonomyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataTaxonomyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataTaxonomyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataTaxonomyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_TAXONOMY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataTaxonomyName dataTaxonomyName = this;
            synchronized (dataTaxonomyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataTaxonomyId != null) {
                        fieldMapBuilder.put((Object)"data_taxonomy_id", (Object)this.dataTaxonomyId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_TAXONOMY_ID.instantiate(new String[]{"project", this.project, "location", this.location, "data_taxonomy_id", this.dataTaxonomyId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataTaxonomyName that = (DataTaxonomyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataTaxonomyId, that.dataTaxonomyId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataTaxonomyId);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataTaxonomyId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataTaxonomyId() {
            return this.dataTaxonomyId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataTaxonomyId(String dataTaxonomyId) {
            this.dataTaxonomyId = dataTaxonomyId;
            return this;
        }

        private Builder(DataTaxonomyName dataTaxonomyName) {
            this.project = dataTaxonomyName.project;
            this.location = dataTaxonomyName.location;
            this.dataTaxonomyId = dataTaxonomyName.dataTaxonomyId;
        }

        public DataTaxonomyName build() {
            return new DataTaxonomyName(this);
        }
    }
}

