/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LAKE_CONTENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lakes/{lake}/content/{content}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lake;
    private final String content;

    @Deprecated
    protected ContentName() {
        this.project = null;
        this.location = null;
        this.lake = null;
        this.content = null;
    }

    private ContentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lake = (String)Preconditions.checkNotNull((Object)builder.getLake());
        this.content = (String)Preconditions.checkNotNull((Object)builder.getContent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLake() {
        return this.lake;
    }

    public String getContent() {
        return this.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContentName of(String project, String location, String lake, String content) {
        return ContentName.newBuilder().setProject(project).setLocation(location).setLake(lake).setContent(content).build();
    }

    public static String format(String project, String location, String lake, String content) {
        return ContentName.newBuilder().setProject(project).setLocation(location).setLake(lake).setContent(content).build().toString();
    }

    public static ContentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LAKE_CONTENT.validatedMatch(formattedString, "ContentName.parse: formattedString not in valid format");
        return ContentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lake"), (String)matchMap.get("content"));
    }

    public static List<ContentName> parseList(List<String> formattedStrings) {
        ArrayList<ContentName> list = new ArrayList<ContentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LAKE_CONTENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContentName contentName = this;
            synchronized (contentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lake != null) {
                        fieldMapBuilder.put((Object)"lake", (Object)this.lake);
                    }
                    if (this.content != null) {
                        fieldMapBuilder.put((Object)"content", (Object)this.content);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LAKE_CONTENT.instantiate(new String[]{"project", this.project, "location", this.location, "lake", this.lake, "content", this.content});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ContentName that = (ContentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lake, that.lake) && Objects.equals(this.content, that.content);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.lake);
        h *= 1000003;
        return h ^= Objects.hashCode(this.content);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lake;
        private String content;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLake() {
            return this.lake;
        }

        public String getContent() {
            return this.content;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        private Builder(ContentName contentName) {
            this.project = contentName.project;
            this.location = contentName.location;
            this.lake = contentName.lake;
            this.content = contentName.content;
        }

        public ContentName build() {
            return new ContentName(this);
        }
    }
}

