/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InstructionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instructions/{instruction}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instruction;

    public String getProject() {
        return this.project;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InstructionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instruction = (String)Preconditions.checkNotNull((Object)builder.getInstruction());
    }

    public static InstructionName of(String project, String instruction) {
        return InstructionName.newBuilder().setProject(project).setInstruction(instruction).build();
    }

    public static String format(String project, String instruction) {
        return InstructionName.newBuilder().setProject(project).setInstruction(instruction).build().toString();
    }

    public static InstructionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InstructionName.parse: formattedString not in valid format");
        return InstructionName.of((String)matchMap.get("project"), (String)matchMap.get("instruction"));
    }

    public static List<InstructionName> parseList(List<String> formattedStrings) {
        ArrayList<InstructionName> list = new ArrayList<InstructionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstructionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstructionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstructionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstructionName instructionName = this;
            synchronized (instructionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"instruction", (Object)this.instruction);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instruction", this.instruction});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstructionName) {
            InstructionName that = (InstructionName)o;
            return this.project.equals(that.project) && this.instruction.equals(that.instruction);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.instruction.hashCode();
    }

    public static class Builder {
        private String project;
        private String instruction;

        public String getProject() {
            return this.project;
        }

        public String getInstruction() {
            return this.instruction;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        private Builder() {
        }

        private Builder(InstructionName instructionName) {
            this.project = instructionName.project;
            this.instruction = instructionName.instruction;
        }

        public InstructionName build() {
            return new InstructionName(this);
        }
    }
}

