/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnnotationSpecSetName
implements ResourceName {
    private static final PathTemplate PROJECT_ANNOTATION_SPEC_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/annotationSpecSets/{annotation_spec_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String annotationSpecSet;

    @Deprecated
    protected AnnotationSpecSetName() {
        this.project = null;
        this.annotationSpecSet = null;
    }

    private AnnotationSpecSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.annotationSpecSet = (String)Preconditions.checkNotNull((Object)builder.getAnnotationSpecSet());
    }

    public String getProject() {
        return this.project;
    }

    public String getAnnotationSpecSet() {
        return this.annotationSpecSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnnotationSpecSetName of(String project, String annotationSpecSet) {
        return AnnotationSpecSetName.newBuilder().setProject(project).setAnnotationSpecSet(annotationSpecSet).build();
    }

    public static String format(String project, String annotationSpecSet) {
        return AnnotationSpecSetName.newBuilder().setProject(project).setAnnotationSpecSet(annotationSpecSet).build().toString();
    }

    public static AnnotationSpecSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_ANNOTATION_SPEC_SET.validatedMatch(formattedString, "AnnotationSpecSetName.parse: formattedString not in valid format");
        return AnnotationSpecSetName.of((String)matchMap.get("project"), (String)matchMap.get("annotation_spec_set"));
    }

    public static List<AnnotationSpecSetName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotationSpecSetName> list = new ArrayList<AnnotationSpecSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotationSpecSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotationSpecSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotationSpecSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ANNOTATION_SPEC_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotationSpecSetName annotationSpecSetName = this;
            synchronized (annotationSpecSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.annotationSpecSet != null) {
                        fieldMapBuilder.put((Object)"annotation_spec_set", (Object)this.annotationSpecSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_ANNOTATION_SPEC_SET.instantiate(new String[]{"project", this.project, "annotation_spec_set", this.annotationSpecSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnnotationSpecSetName that = (AnnotationSpecSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.annotationSpecSet, that.annotationSpecSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.annotationSpecSet);
    }

    public static class Builder {
        private String project;
        private String annotationSpecSet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAnnotationSpecSet() {
            return this.annotationSpecSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAnnotationSpecSet(String annotationSpecSet) {
            this.annotationSpecSet = annotationSpecSet;
            return this;
        }

        private Builder(AnnotationSpecSetName annotationSpecSetName) {
            this.project = annotationSpecSetName.project;
            this.annotationSpecSet = annotationSpecSetName.annotationSpecSet;
        }

        public AnnotationSpecSetName build() {
            return new AnnotationSpecSetName(this);
        }
    }
}

