/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;

    @Deprecated
    protected DatasetName() {
        this.project = null;
        this.dataset = null;
    }

    private DatasetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatasetName of(String project, String dataset) {
        return DatasetName.newBuilder().setProject(project).setDataset(dataset).build();
    }

    public static String format(String project, String dataset) {
        return DatasetName.newBuilder().setProject(project).setDataset(dataset).build().toString();
    }

    public static DatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATASET.validatedMatch(formattedString, "DatasetName.parse: formattedString not in valid format");
        return DatasetName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"));
    }

    public static List<DatasetName> parseList(List<String> formattedStrings) {
        ArrayList<DatasetName> list = new ArrayList<DatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatasetName datasetName = this;
            synchronized (datasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET.instantiate(new String[]{"project", this.project, "dataset", this.dataset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatasetName that = (DatasetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataset);
    }

    public static class Builder {
        private String project;
        private String dataset;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        private Builder(DatasetName datasetName) {
            this.project = datasetName.project;
            this.dataset = datasetName.dataset;
        }

        public DatasetName build() {
            return new DatasetName(this);
        }
    }
}

