/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExampleName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET_ANNOTATED_DATASET_EXAMPLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}/examples/{example}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String annotatedDataset;
    private final String example;

    @Deprecated
    protected ExampleName() {
        this.project = null;
        this.dataset = null;
        this.annotatedDataset = null;
        this.example = null;
    }

    private ExampleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.annotatedDataset = (String)Preconditions.checkNotNull((Object)builder.getAnnotatedDataset());
        this.example = (String)Preconditions.checkNotNull((Object)builder.getExample());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getAnnotatedDataset() {
        return this.annotatedDataset;
    }

    public String getExample() {
        return this.example;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExampleName of(String project, String dataset, String annotatedDataset, String example) {
        return ExampleName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).setExample(example).build();
    }

    public static String format(String project, String dataset, String annotatedDataset, String example) {
        return ExampleName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).setExample(example).build().toString();
    }

    public static ExampleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATASET_ANNOTATED_DATASET_EXAMPLE.validatedMatch(formattedString, "ExampleName.parse: formattedString not in valid format");
        return ExampleName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("annotated_dataset"), (String)matchMap.get("example"));
    }

    public static List<ExampleName> parseList(List<String> formattedStrings) {
        ArrayList<ExampleName> list = new ArrayList<ExampleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExampleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExampleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExampleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET_ANNOTATED_DATASET_EXAMPLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExampleName exampleName = this;
            synchronized (exampleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.annotatedDataset != null) {
                        fieldMapBuilder.put((Object)"annotated_dataset", (Object)this.annotatedDataset);
                    }
                    if (this.example != null) {
                        fieldMapBuilder.put((Object)"example", (Object)this.example);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET_ANNOTATED_DATASET_EXAMPLE.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "annotated_dataset", this.annotatedDataset, "example", this.example});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExampleName that = (ExampleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.annotatedDataset, that.annotatedDataset) && Objects.equals(this.example, that.example);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        h ^= Objects.hashCode(this.annotatedDataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.example);
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String annotatedDataset;
        private String example;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getAnnotatedDataset() {
            return this.annotatedDataset;
        }

        public String getExample() {
            return this.example;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setAnnotatedDataset(String annotatedDataset) {
            this.annotatedDataset = annotatedDataset;
            return this;
        }

        public Builder setExample(String example) {
            this.example = example;
            return this;
        }

        private Builder(ExampleName exampleName) {
            this.project = exampleName.project;
            this.dataset = exampleName.dataset;
            this.annotatedDataset = exampleName.annotatedDataset;
            this.example = exampleName.example;
        }

        public ExampleName build() {
            return new ExampleName(this);
        }
    }
}

