/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkspaceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_WORKSPACE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/workspaces/{workspace}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String workspace;

    @Deprecated
    protected WorkspaceName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.workspace = null;
    }

    private WorkspaceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.workspace = (String)Preconditions.checkNotNull((Object)builder.getWorkspace());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkspaceName of(String project, String location, String repository, String workspace) {
        return WorkspaceName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setWorkspace(workspace).build();
    }

    public static String format(String project, String location, String repository, String workspace) {
        return WorkspaceName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setWorkspace(workspace).build().toString();
    }

    public static WorkspaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_WORKSPACE.validatedMatch(formattedString, "WorkspaceName.parse: formattedString not in valid format");
        return WorkspaceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("workspace"));
    }

    public static List<WorkspaceName> parseList(List<String> formattedStrings) {
        ArrayList<WorkspaceName> list = new ArrayList<WorkspaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkspaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkspaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkspaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_WORKSPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkspaceName workspaceName = this;
            synchronized (workspaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.workspace != null) {
                        fieldMapBuilder.put((Object)"workspace", (Object)this.workspace);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_WORKSPACE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "workspace", this.workspace});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkspaceName that = (WorkspaceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.workspace, that.workspace);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workspace);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String workspace;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setWorkspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        private Builder(WorkspaceName workspaceName) {
            this.project = workspaceName.project;
            this.location = workspaceName.location;
            this.repository = workspaceName.repository;
            this.workspace = workspaceName.workspace;
        }

        public WorkspaceName build() {
            return new WorkspaceName(this);
        }
    }
}

