/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a Dataform workflow configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.WorkflowConfig}
 */
public final class WorkflowConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowConfig)
    WorkflowConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkflowConfig.newBuilder() to construct.
  private WorkflowConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowConfig() {
    name_ = "";
    releaseConfig_ = "";
    cronSchedule_ = "";
    timeZone_ = "";
    recentScheduledExecutionRecords_ = java.util.Collections.emptyList();
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.WorkflowConfig.class,
            com.google.cloud.dataform.v1.WorkflowConfig.Builder.class);
  }

  public interface ScheduledExecutionRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the workflowInvocation field is set.
     */
    boolean hasWorkflowInvocation();

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The workflowInvocation.
     */
    java.lang.String getWorkflowInvocation();

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for workflowInvocation.
     */
    com.google.protobuf.ByteString getWorkflowInvocationBytes();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    boolean hasErrorStatus();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return The errorStatus.
     */
    com.google.rpc.Status getErrorStatus();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the executionTime field is set.
     */
    boolean hasExecutionTime();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The executionTime.
     */
    com.google.protobuf.Timestamp getExecutionTime();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getExecutionTimeOrBuilder();

    com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.ResultCase getResultCase();
  }

  /**
   *
   *
   * <pre>
   * A record of an attempt to create a workflow invocation for this workflow
   * config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord}
   */
  public static final class ScheduledExecutionRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)
      ScheduledExecutionRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ScheduledExecutionRecord.newBuilder() to construct.
    private ScheduledExecutionRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ScheduledExecutionRecord() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ScheduledExecutionRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowConfig_ScheduledExecutionRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowConfig_ScheduledExecutionRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.class,
              com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder.class);
    }

    private int bitField0_;
    private int resultCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object result_;

    public enum ResultCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      WORKFLOW_INVOCATION(2),
      ERROR_STATUS(3),
      RESULT_NOT_SET(0);
      private final int value;

      private ResultCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResultCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResultCase forNumber(int value) {
        switch (value) {
          case 2:
            return WORKFLOW_INVOCATION;
          case 3:
            return ERROR_STATUS;
          case 0:
            return RESULT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public static final int WORKFLOW_INVOCATION_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the workflowInvocation field is set.
     */
    public boolean hasWorkflowInvocation() {
      return resultCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The workflowInvocation.
     */
    public java.lang.String getWorkflowInvocation() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 2) {
          result_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the created workflow invocation, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
     * </pre>
     *
     * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for workflowInvocation.
     */
    public com.google.protobuf.ByteString getWorkflowInvocationBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resultCase_ == 2) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_STATUS_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    @java.lang.Override
    public boolean hasErrorStatus() {
      return resultCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return The errorStatus.
     */
    @java.lang.Override
    public com.google.rpc.Status getErrorStatus() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * workflow invocation, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    public static final int EXECUTION_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp executionTime_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the executionTime field is set.
     */
    @java.lang.Override
    public boolean hasExecutionTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The executionTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExecutionTime() {
      return executionTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : executionTime_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this execution attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExecutionTimeOrBuilder() {
      return executionTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : executionTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getExecutionTime());
      }
      if (resultCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, result_);
      }
      if (resultCase_ == 3) {
        output.writeMessage(3, (com.google.rpc.Status) result_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getExecutionTime());
      }
      if (resultCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, result_);
      }
      if (resultCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.rpc.Status) result_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord other =
          (com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord) obj;

      if (hasExecutionTime() != other.hasExecutionTime()) return false;
      if (hasExecutionTime()) {
        if (!getExecutionTime().equals(other.getExecutionTime())) return false;
      }
      if (!getResultCase().equals(other.getResultCase())) return false;
      switch (resultCase_) {
        case 2:
          if (!getWorkflowInvocation().equals(other.getWorkflowInvocation())) return false;
          break;
        case 3:
          if (!getErrorStatus().equals(other.getErrorStatus())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasExecutionTime()) {
        hash = (37 * hash) + EXECUTION_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExecutionTime().hashCode();
      }
      switch (resultCase_) {
        case 2:
          hash = (37 * hash) + WORKFLOW_INVOCATION_FIELD_NUMBER;
          hash = (53 * hash) + getWorkflowInvocation().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ERROR_STATUS_FIELD_NUMBER;
          hash = (53 * hash) + getErrorStatus().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A record of an attempt to create a workflow invocation for this workflow
     * config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowConfig_ScheduledExecutionRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowConfig_ScheduledExecutionRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.class,
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getExecutionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (errorStatusBuilder_ != null) {
          errorStatusBuilder_.clear();
        }
        executionTime_ = null;
        if (executionTimeBuilder_ != null) {
          executionTimeBuilder_.dispose();
          executionTimeBuilder_ = null;
        }
        resultCase_ = 0;
        result_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_WorkflowConfig_ScheduledExecutionRecord_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord build() {
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord buildPartial() {
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord result =
            new com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.executionTime_ =
              executionTimeBuilder_ == null ? executionTime_ : executionTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord result) {
        result.resultCase_ = resultCase_;
        result.result_ = this.result_;
        if (resultCase_ == 3 && errorStatusBuilder_ != null) {
          result.result_ = errorStatusBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord other) {
        if (other
            == com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
                .getDefaultInstance()) return this;
        if (other.hasExecutionTime()) {
          mergeExecutionTime(other.getExecutionTime());
        }
        switch (other.getResultCase()) {
          case WORKFLOW_INVOCATION:
            {
              resultCase_ = 2;
              result_ = other.result_;
              onChanged();
              break;
            }
          case ERROR_STATUS:
            {
              mergeErrorStatus(other.getErrorStatus());
              break;
            }
          case RESULT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getExecutionTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  resultCase_ = 2;
                  result_ = s;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getErrorStatusFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int resultCase_ = 0;
      private java.lang.Object result_;

      public ResultCase getResultCase() {
        return ResultCase.forNumber(resultCase_);
      }

      public Builder clearResult() {
        resultCase_ = 0;
        result_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the workflowInvocation field is set.
       */
      @java.lang.Override
      public boolean hasWorkflowInvocation() {
        return resultCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The workflowInvocation.
       */
      @java.lang.Override
      public java.lang.String getWorkflowInvocation() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resultCase_ == 2) {
            result_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for workflowInvocation.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getWorkflowInvocationBytes() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resultCase_ == 2) {
            result_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The workflowInvocation to set.
       * @return This builder for chaining.
       */
      public Builder setWorkflowInvocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWorkflowInvocation() {
        if (resultCase_ == 2) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the created workflow invocation, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowInvocations/&#42;`.
       * </pre>
       *
       * <code>string workflow_invocation = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for workflowInvocation to set.
       * @return This builder for chaining.
       */
      public Builder setWorkflowInvocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorStatusBuilder_;

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       *
       * @return Whether the errorStatus field is set.
       */
      @java.lang.Override
      public boolean hasErrorStatus() {
        return resultCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       *
       * @return The errorStatus.
       */
      @java.lang.Override
      public com.google.rpc.Status getErrorStatus() {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        } else {
          if (resultCase_ == 3) {
            return errorStatusBuilder_.getMessage();
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder setErrorStatus(com.google.rpc.Status value) {
        if (errorStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          errorStatusBuilder_.setMessage(value);
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder setErrorStatus(com.google.rpc.Status.Builder builderForValue) {
        if (errorStatusBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          errorStatusBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder mergeErrorStatus(com.google.rpc.Status value) {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3 && result_ != com.google.rpc.Status.getDefaultInstance()) {
            result_ =
                com.google.rpc.Status.newBuilder((com.google.rpc.Status) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 3) {
            errorStatusBuilder_.mergeFrom(value);
          } else {
            errorStatusBuilder_.setMessage(value);
          }
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder clearErrorStatus() {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
          }
          errorStatusBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public com.google.rpc.Status.Builder getErrorStatusBuilder() {
        return getErrorStatusFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      @java.lang.Override
      public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
        if ((resultCase_ == 3) && (errorStatusBuilder_ != null)) {
          return errorStatusBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * workflow invocation, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorStatusFieldBuilder() {
        if (errorStatusBuilder_ == null) {
          if (!(resultCase_ == 3)) {
            result_ = com.google.rpc.Status.getDefaultInstance();
          }
          errorStatusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  (com.google.rpc.Status) result_, getParentForChildren(), isClean());
          result_ = null;
        }
        resultCase_ = 3;
        onChanged();
        return errorStatusBuilder_;
      }

      private com.google.protobuf.Timestamp executionTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          executionTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the executionTime field is set.
       */
      public boolean hasExecutionTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The executionTime.
       */
      public com.google.protobuf.Timestamp getExecutionTime() {
        if (executionTimeBuilder_ == null) {
          return executionTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : executionTime_;
        } else {
          return executionTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExecutionTime(com.google.protobuf.Timestamp value) {
        if (executionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          executionTime_ = value;
        } else {
          executionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExecutionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (executionTimeBuilder_ == null) {
          executionTime_ = builderForValue.build();
        } else {
          executionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeExecutionTime(com.google.protobuf.Timestamp value) {
        if (executionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && executionTime_ != null
              && executionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getExecutionTimeBuilder().mergeFrom(value);
          } else {
            executionTime_ = value;
          }
        } else {
          executionTimeBuilder_.mergeFrom(value);
        }
        if (executionTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearExecutionTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        executionTime_ = null;
        if (executionTimeBuilder_ != null) {
          executionTimeBuilder_.dispose();
          executionTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getExecutionTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getExecutionTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getExecutionTimeOrBuilder() {
        if (executionTimeBuilder_ != null) {
          return executionTimeBuilder_.getMessageOrBuilder();
        } else {
          return executionTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : executionTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this execution attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execution_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getExecutionTimeFieldBuilder() {
        if (executionTimeBuilder_ == null) {
          executionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getExecutionTime(), getParentForChildren(), isClean());
          executionTime_ = null;
        }
        return executionTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord)
    private static final com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord();
    }

    public static com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ScheduledExecutionRecord> PARSER =
        new com.google.protobuf.AbstractParser<ScheduledExecutionRecord>() {
          @java.lang.Override
          public ScheduledExecutionRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ScheduledExecutionRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScheduledExecutionRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The workflow config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The workflow config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEASE_CONFIG_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object releaseConfig_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the release config whose release_compilation_result
   * should be executed. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The releaseConfig.
   */
  @java.lang.Override
  public java.lang.String getReleaseConfig() {
    java.lang.Object ref = releaseConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      releaseConfig_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the release config whose release_compilation_result
   * should be executed. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for releaseConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReleaseConfigBytes() {
    java.lang.Object ref = releaseConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      releaseConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOCATION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataform.v1.InvocationConfig invocationConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the invocationConfig field is set.
   */
  @java.lang.Override
  public boolean hasInvocationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The invocationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.InvocationConfig getInvocationConfig() {
    return invocationConfig_ == null
        ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
        : invocationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.InvocationConfigOrBuilder getInvocationConfigOrBuilder() {
    return invocationConfig_ == null
        ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
        : invocationConfig_;
  }

  public static final int CRON_SCHEDULE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cronSchedule_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic execution of
   * this workflow config.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cronSchedule.
   */
  @java.lang.Override
  public java.lang.String getCronSchedule() {
    java.lang.Object ref = cronSchedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cronSchedule_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic execution of
   * this workflow config.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cronSchedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCronScheduleBytes() {
    java.lang.Object ref = cronSchedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cronSchedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECENT_SCHEDULED_EXECUTION_RECORDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
      recentScheduledExecutionRecords_;

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
      getRecentScheduledExecutionRecordsList() {
    return recentScheduledExecutionRecords_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>
      getRecentScheduledExecutionRecordsOrBuilderList() {
    return recentScheduledExecutionRecords_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getRecentScheduledExecutionRecordsCount() {
    return recentScheduledExecutionRecords_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
      getRecentScheduledExecutionRecords(int index) {
    return recentScheduledExecutionRecords_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled execution attempts,
   * ordered in descending order of `execution_time`. Updated whenever automatic
   * creation of a workflow invocation is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder
      getRecentScheduledExecutionRecordsOrBuilder(int index) {
    return recentScheduledExecutionRecords_.get(index);
  }

  public static final int DISABLED_FIELD_NUMBER = 8;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Disables automatic creation of workflow invocations.
   * </pre>
   *
   * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the WorkflowConfig was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, releaseConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getInvocationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, cronSchedule_);
    }
    for (int i = 0; i < recentScheduledExecutionRecords_.size(); i++) {
      output.writeMessage(5, recentScheduledExecutionRecords_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, timeZone_);
    }
    if (disabled_ != false) {
      output.writeBool(8, disabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, releaseConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInvocationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, cronSchedule_);
    }
    for (int i = 0; i < recentScheduledExecutionRecords_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, recentScheduledExecutionRecords_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, timeZone_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, disabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.WorkflowConfig other =
        (com.google.cloud.dataform.v1.WorkflowConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getReleaseConfig().equals(other.getReleaseConfig())) return false;
    if (hasInvocationConfig() != other.hasInvocationConfig()) return false;
    if (hasInvocationConfig()) {
      if (!getInvocationConfig().equals(other.getInvocationConfig())) return false;
    }
    if (!getCronSchedule().equals(other.getCronSchedule())) return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getRecentScheduledExecutionRecordsList()
        .equals(other.getRecentScheduledExecutionRecordsList())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + RELEASE_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getReleaseConfig().hashCode();
    if (hasInvocationConfig()) {
      hash = (37 * hash) + INVOCATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInvocationConfig().hashCode();
    }
    hash = (37 * hash) + CRON_SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getCronSchedule().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (getRecentScheduledExecutionRecordsCount() > 0) {
      hash = (37 * hash) + RECENT_SCHEDULED_EXECUTION_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getRecentScheduledExecutionRecordsList().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.WorkflowConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Dataform workflow configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowConfig)
      com.google.cloud.dataform.v1.WorkflowConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowConfig.class,
              com.google.cloud.dataform.v1.WorkflowConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.WorkflowConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInvocationConfigFieldBuilder();
        getRecentScheduledExecutionRecordsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      releaseConfig_ = "";
      invocationConfig_ = null;
      if (invocationConfigBuilder_ != null) {
        invocationConfigBuilder_.dispose();
        invocationConfigBuilder_ = null;
      }
      cronSchedule_ = "";
      timeZone_ = "";
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        recentScheduledExecutionRecords_ = java.util.Collections.emptyList();
      } else {
        recentScheduledExecutionRecords_ = null;
        recentScheduledExecutionRecordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      disabled_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalMetadata_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowConfig getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.WorkflowConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowConfig build() {
      com.google.cloud.dataform.v1.WorkflowConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowConfig buildPartial() {
      com.google.cloud.dataform.v1.WorkflowConfig result =
          new com.google.cloud.dataform.v1.WorkflowConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataform.v1.WorkflowConfig result) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          recentScheduledExecutionRecords_ =
              java.util.Collections.unmodifiableList(recentScheduledExecutionRecords_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.recentScheduledExecutionRecords_ = recentScheduledExecutionRecords_;
      } else {
        result.recentScheduledExecutionRecords_ = recentScheduledExecutionRecordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.WorkflowConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.releaseConfig_ = releaseConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.invocationConfig_ =
            invocationConfigBuilder_ == null ? invocationConfig_ : invocationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cronSchedule_ = cronSchedule_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.WorkflowConfig) {
        return mergeFrom((com.google.cloud.dataform.v1.WorkflowConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.WorkflowConfig other) {
      if (other == com.google.cloud.dataform.v1.WorkflowConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getReleaseConfig().isEmpty()) {
        releaseConfig_ = other.releaseConfig_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInvocationConfig()) {
        mergeInvocationConfig(other.getInvocationConfig());
      }
      if (!other.getCronSchedule().isEmpty()) {
        cronSchedule_ = other.cronSchedule_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        if (!other.recentScheduledExecutionRecords_.isEmpty()) {
          if (recentScheduledExecutionRecords_.isEmpty()) {
            recentScheduledExecutionRecords_ = other.recentScheduledExecutionRecords_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureRecentScheduledExecutionRecordsIsMutable();
            recentScheduledExecutionRecords_.addAll(other.recentScheduledExecutionRecords_);
          }
          onChanged();
        }
      } else {
        if (!other.recentScheduledExecutionRecords_.isEmpty()) {
          if (recentScheduledExecutionRecordsBuilder_.isEmpty()) {
            recentScheduledExecutionRecordsBuilder_.dispose();
            recentScheduledExecutionRecordsBuilder_ = null;
            recentScheduledExecutionRecords_ = other.recentScheduledExecutionRecords_;
            bitField0_ = (bitField0_ & ~0x00000020);
            recentScheduledExecutionRecordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecentScheduledExecutionRecordsFieldBuilder()
                    : null;
          } else {
            recentScheduledExecutionRecordsBuilder_.addAllMessages(
                other.recentScheduledExecutionRecords_);
          }
        }
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                releaseConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getInvocationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                cronSchedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
                            .parser(),
                        extensionRegistry);
                if (recentScheduledExecutionRecordsBuilder_ == null) {
                  ensureRecentScheduledExecutionRecordsIsMutable();
                  recentScheduledExecutionRecords_.add(m);
                } else {
                  recentScheduledExecutionRecordsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 58:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The workflow config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The workflow config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The workflow config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The workflow config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The workflow config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object releaseConfig_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the release config whose release_compilation_result
     * should be executed. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The releaseConfig.
     */
    public java.lang.String getReleaseConfig() {
      java.lang.Object ref = releaseConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        releaseConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the release config whose release_compilation_result
     * should be executed. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for releaseConfig.
     */
    public com.google.protobuf.ByteString getReleaseConfigBytes() {
      java.lang.Object ref = releaseConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        releaseConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the release config whose release_compilation_result
     * should be executed. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The releaseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      releaseConfig_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the release config whose release_compilation_result
     * should be executed. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseConfig() {
      releaseConfig_ = getDefaultInstance().getReleaseConfig();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the release config whose release_compilation_result
     * should be executed. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for releaseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      releaseConfig_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.InvocationConfig invocationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.InvocationConfig,
            com.google.cloud.dataform.v1.InvocationConfig.Builder,
            com.google.cloud.dataform.v1.InvocationConfigOrBuilder>
        invocationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the invocationConfig field is set.
     */
    public boolean hasInvocationConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The invocationConfig.
     */
    public com.google.cloud.dataform.v1.InvocationConfig getInvocationConfig() {
      if (invocationConfigBuilder_ == null) {
        return invocationConfig_ == null
            ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
            : invocationConfig_;
      } else {
        return invocationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInvocationConfig(com.google.cloud.dataform.v1.InvocationConfig value) {
      if (invocationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        invocationConfig_ = value;
      } else {
        invocationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInvocationConfig(
        com.google.cloud.dataform.v1.InvocationConfig.Builder builderForValue) {
      if (invocationConfigBuilder_ == null) {
        invocationConfig_ = builderForValue.build();
      } else {
        invocationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInvocationConfig(com.google.cloud.dataform.v1.InvocationConfig value) {
      if (invocationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && invocationConfig_ != null
            && invocationConfig_
                != com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()) {
          getInvocationConfigBuilder().mergeFrom(value);
        } else {
          invocationConfig_ = value;
        }
      } else {
        invocationConfigBuilder_.mergeFrom(value);
      }
      if (invocationConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInvocationConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      invocationConfig_ = null;
      if (invocationConfigBuilder_ != null) {
        invocationConfigBuilder_.dispose();
        invocationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.InvocationConfig.Builder getInvocationConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInvocationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.InvocationConfigOrBuilder getInvocationConfigOrBuilder() {
      if (invocationConfigBuilder_ != null) {
        return invocationConfigBuilder_.getMessageOrBuilder();
      } else {
        return invocationConfig_ == null
            ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
            : invocationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.InvocationConfig,
            com.google.cloud.dataform.v1.InvocationConfig.Builder,
            com.google.cloud.dataform.v1.InvocationConfigOrBuilder>
        getInvocationConfigFieldBuilder() {
      if (invocationConfigBuilder_ == null) {
        invocationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.InvocationConfig,
                com.google.cloud.dataform.v1.InvocationConfig.Builder,
                com.google.cloud.dataform.v1.InvocationConfigOrBuilder>(
                getInvocationConfig(), getParentForChildren(), isClean());
        invocationConfig_ = null;
      }
      return invocationConfigBuilder_;
    }

    private java.lang.Object cronSchedule_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic execution of
     * this workflow config.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cronSchedule.
     */
    public java.lang.String getCronSchedule() {
      java.lang.Object ref = cronSchedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cronSchedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic execution of
     * this workflow config.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for cronSchedule.
     */
    public com.google.protobuf.ByteString getCronScheduleBytes() {
      java.lang.Object ref = cronSchedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cronSchedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic execution of
     * this workflow config.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The cronSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setCronSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cronSchedule_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic execution of
     * this workflow config.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCronSchedule() {
      cronSchedule_ = getDefaultInstance().getCronSchedule();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic execution of
     * this workflow config.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for cronSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setCronScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cronSchedule_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
        recentScheduledExecutionRecords_ = java.util.Collections.emptyList();

    private void ensureRecentScheduledExecutionRecordsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        recentScheduledExecutionRecords_ =
            new java.util.ArrayList<
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>(
                recentScheduledExecutionRecords_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord,
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder,
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>
        recentScheduledExecutionRecordsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
        getRecentScheduledExecutionRecordsList() {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(recentScheduledExecutionRecords_);
      } else {
        return recentScheduledExecutionRecordsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getRecentScheduledExecutionRecordsCount() {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        return recentScheduledExecutionRecords_.size();
      } else {
        return recentScheduledExecutionRecordsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
        getRecentScheduledExecutionRecords(int index) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        return recentScheduledExecutionRecords_.get(index);
      } else {
        return recentScheduledExecutionRecordsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecentScheduledExecutionRecords(
        int index, com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord value) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.set(index, value);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecentScheduledExecutionRecords(
        int index,
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
            builderForValue) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.set(index, builderForValue.build());
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledExecutionRecords(
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord value) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.add(value);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledExecutionRecords(
        int index, com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord value) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.add(index, value);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledExecutionRecords(
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
            builderForValue) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.add(builderForValue.build());
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledExecutionRecords(
        int index,
        com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
            builderForValue) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.add(index, builderForValue.build());
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllRecentScheduledExecutionRecords(
        java.lang.Iterable<
                ? extends com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord>
            values) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        ensureRecentScheduledExecutionRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, recentScheduledExecutionRecords_);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRecentScheduledExecutionRecords() {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        recentScheduledExecutionRecords_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeRecentScheduledExecutionRecords(int index) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        ensureRecentScheduledExecutionRecordsIsMutable();
        recentScheduledExecutionRecords_.remove(index);
        onChanged();
      } else {
        recentScheduledExecutionRecordsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
        getRecentScheduledExecutionRecordsBuilder(int index) {
      return getRecentScheduledExecutionRecordsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder
        getRecentScheduledExecutionRecordsOrBuilder(int index) {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        return recentScheduledExecutionRecords_.get(index);
      } else {
        return recentScheduledExecutionRecordsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>
        getRecentScheduledExecutionRecordsOrBuilderList() {
      if (recentScheduledExecutionRecordsBuilder_ != null) {
        return recentScheduledExecutionRecordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(recentScheduledExecutionRecords_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
        addRecentScheduledExecutionRecordsBuilder() {
      return getRecentScheduledExecutionRecordsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder
        addRecentScheduledExecutionRecordsBuilder(int index) {
      return getRecentScheduledExecutionRecordsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled execution attempts,
     * ordered in descending order of `execution_time`. Updated whenever automatic
     * creation of a workflow invocation is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord recent_scheduled_execution_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder>
        getRecentScheduledExecutionRecordsBuilderList() {
      return getRecentScheduledExecutionRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord,
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder,
            com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>
        getRecentScheduledExecutionRecordsFieldBuilder() {
      if (recentScheduledExecutionRecordsBuilder_ == null) {
        recentScheduledExecutionRecordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord,
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecord.Builder,
                com.google.cloud.dataform.v1.WorkflowConfig.ScheduledExecutionRecordOrBuilder>(
                recentScheduledExecutionRecords_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        recentScheduledExecutionRecords_ = null;
      }
      return recentScheduledExecutionRecordsBuilder_;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of workflow invocations.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of workflow invocations.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of workflow invocations.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000040);
      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the WorkflowConfig was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowConfig)
  private static final com.google.cloud.dataform.v1.WorkflowConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowConfig();
  }

  public static com.google.cloud.dataform.v1.WorkflowConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowConfig> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowConfig>() {
        @java.lang.Override
        public WorkflowConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
