/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/documents/{document}");
    private static final PathTemplate PROJECT_LOCATION_REFERENCE_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/documents/referenceId/{reference_id}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String document;
    private final String referenceId;

    @Deprecated
    protected DocumentName() {
        this.project = null;
        this.location = null;
        this.document = null;
        this.referenceId = null;
    }

    private DocumentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.referenceId = null;
        this.pathTemplate = PROJECT_LOCATION_DOCUMENT;
    }

    private DocumentName(ProjectLocationReferenceIdBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.referenceId = (String)Preconditions.checkNotNull((Object)builder.getReferenceId());
        this.document = null;
        this.pathTemplate = PROJECT_LOCATION_REFERENCE_ID;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDocument() {
        return this.document;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDocumentBuilder() {
        return new Builder();
    }

    public static ProjectLocationReferenceIdBuilder newProjectLocationReferenceIdBuilder() {
        return new ProjectLocationReferenceIdBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentName of(String project, String location, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDocument(document).build();
    }

    public static DocumentName ofProjectLocationDocumentName(String project, String location, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDocument(document).build();
    }

    public static DocumentName ofProjectLocationReferenceIdName(String project, String location, String referenceId) {
        return DocumentName.newProjectLocationReferenceIdBuilder().setProject(project).setLocation(location).setReferenceId(referenceId).build();
    }

    public static String format(String project, String location, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDocument(document).build().toString();
    }

    public static String formatProjectLocationDocumentName(String project, String location, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDocument(document).build().toString();
    }

    public static String formatProjectLocationReferenceIdName(String project, String location, String referenceId) {
        return DocumentName.newProjectLocationReferenceIdBuilder().setProject(project).setLocation(location).setReferenceId(referenceId).build().toString();
    }

    public static DocumentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DOCUMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DOCUMENT.match(formattedString);
            return DocumentName.ofProjectLocationDocumentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("document"));
        }
        if (PROJECT_LOCATION_REFERENCE_ID.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_REFERENCE_ID.match(formattedString);
            return DocumentName.ofProjectLocationReferenceIdName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reference_id"));
        }
        throw new ValidationException("DocumentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DocumentName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentName> list = new ArrayList<DocumentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DOCUMENT.matches(formattedString) || PROJECT_LOCATION_REFERENCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentName documentName = this;
            synchronized (documentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    if (this.referenceId != null) {
                        fieldMapBuilder.put((Object)"reference_id", (Object)this.referenceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DocumentName that = (DocumentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.document, that.document) && Objects.equals(this.referenceId, that.referenceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.document);
        h *= 1000003;
        return h ^= Objects.hashCode(this.referenceId);
    }

    public static class ProjectLocationReferenceIdBuilder {
        private String project;
        private String location;
        private String referenceId;

        protected ProjectLocationReferenceIdBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public ProjectLocationReferenceIdBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationReferenceIdBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationReferenceIdBuilder setReferenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String document;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDocument() {
            return this.document;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        private Builder(DocumentName documentName) {
            Preconditions.checkArgument((boolean)Objects.equals(documentName.pathTemplate, PROJECT_LOCATION_DOCUMENT), (Object)"toBuilder is only supported when DocumentName has the pattern of projects/{project}/locations/{location}/documents/{document}");
            this.project = documentName.project;
            this.location = documentName.location;
            this.document = documentName.document;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }
}

