/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SynonymSetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/synonymSets/{context}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String context;

    @Deprecated
    protected SynonymSetName() {
        this.project = null;
        this.location = null;
        this.context = null;
    }

    private SynonymSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContext() {
        return this.context;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SynonymSetName of(String project, String location, String context) {
        return SynonymSetName.newBuilder().setProject(project).setLocation(location).setContext(context).build();
    }

    public static String format(String project, String location, String context) {
        return SynonymSetName.newBuilder().setProject(project).setLocation(location).setContext(context).build().toString();
    }

    public static SynonymSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONTEXT.validatedMatch(formattedString, "SynonymSetName.parse: formattedString not in valid format");
        return SynonymSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("context"));
    }

    public static List<SynonymSetName> parseList(List<String> formattedStrings) {
        ArrayList<SynonymSetName> list = new ArrayList<SynonymSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SynonymSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SynonymSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SynonymSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONTEXT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SynonymSetName synonymSetName = this;
            synchronized (synonymSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.context != null) {
                        fieldMapBuilder.put((Object)"context", (Object)this.context);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONTEXT.instantiate(new String[]{"project", this.project, "location", this.location, "context", this.context});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SynonymSetName that = (SynonymSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.context, that.context);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.context);
    }

    public static class Builder {
        private String project;
        private String location;
        private String context;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getContext() {
            return this.context;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        private Builder(SynonymSetName synonymSetName) {
            this.project = synonymSetName.project;
            this.location = synonymSetName.location;
            this.context = synonymSetName.context;
        }

        public SynonymSetName build() {
            return new SynonymSetName(this);
        }
    }
}

