// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

package com.google.container.v1;

/**
 * <pre>
 * NodePool contains the name and configuration for a cluster's node pool.
 * Node pools are a set of nodes (i.e. VM's), with a common configuration and
 * specification, under the control of the cluster master. They may have a set
 * of Kubernetes labels applied to them, which may be used to reference them
 * during pod scheduling. They may also be resized up or down, to accommodate
 * the workload.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.NodePool}
 */
public  final class NodePool extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.container.v1.NodePool)
    NodePoolOrBuilder {
private static final long serialVersionUID = 0L;
  // Use NodePool.newBuilder() to construct.
  private NodePool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private NodePool() {
    name_ = "";
    initialNodeCount_ = 0;
    selfLink_ = "";
    version_ = "";
    instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    status_ = 0;
    statusMessage_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private NodePool(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 18: {
            com.google.container.v1.NodeConfig.Builder subBuilder = null;
            if (config_ != null) {
              subBuilder = config_.toBuilder();
            }
            config_ = input.readMessage(com.google.container.v1.NodeConfig.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(config_);
              config_ = subBuilder.buildPartial();
            }

            break;
          }
          case 24: {

            initialNodeCount_ = input.readInt32();
            break;
          }
          case 34: {
            com.google.container.v1.NodePoolAutoscaling.Builder subBuilder = null;
            if (autoscaling_ != null) {
              subBuilder = autoscaling_.toBuilder();
            }
            autoscaling_ = input.readMessage(com.google.container.v1.NodePoolAutoscaling.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(autoscaling_);
              autoscaling_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            com.google.container.v1.NodeManagement.Builder subBuilder = null;
            if (management_ != null) {
              subBuilder = management_.toBuilder();
            }
            management_ = input.readMessage(com.google.container.v1.NodeManagement.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(management_);
              management_ = subBuilder.buildPartial();
            }

            break;
          }
          case 802: {
            java.lang.String s = input.readStringRequireUtf8();

            selfLink_ = s;
            break;
          }
          case 810: {
            java.lang.String s = input.readStringRequireUtf8();

            version_ = s;
            break;
          }
          case 818: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              instanceGroupUrls_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000020;
            }
            instanceGroupUrls_.add(s);
            break;
          }
          case 824: {
            int rawValue = input.readEnum();

            status_ = rawValue;
            break;
          }
          case 834: {
            java.lang.String s = input.readStringRequireUtf8();

            statusMessage_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        instanceGroupUrls_ = instanceGroupUrls_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.container.v1.ClusterServiceProto.internal_static_google_container_v1_NodePool_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto.internal_static_google_container_v1_NodePool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.NodePool.class, com.google.container.v1.NodePool.Builder.class);
  }

  /**
   * <pre>
   * The current status of the node pool instance.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.NodePool.Status}
   */
  public enum Status
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     * <pre>
     * The PROVISIONING state indicates the node pool is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    PROVISIONING(1),
    /**
     * <pre>
     * The RUNNING state indicates the node pool has been created
     * and is fully usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     * <pre>
     * The RUNNING_WITH_ERROR state indicates the node pool has been created
     * and is partially usable. Some error state has occurred and some
     * functionality may be impaired. Customer may need to reissue a request
     * or trigger a new update.
     * </pre>
     *
     * <code>RUNNING_WITH_ERROR = 3;</code>
     */
    RUNNING_WITH_ERROR(3),
    /**
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the node pool, such as upgrading node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 4;</code>
     */
    RECONCILING(4),
    /**
     * <pre>
     * The STOPPING state indicates the node pool is being deleted.
     * </pre>
     *
     * <code>STOPPING = 5;</code>
     */
    STOPPING(5),
    /**
     * <pre>
     * The ERROR state indicates the node pool may be unusable. Details
     * can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    ERROR(6),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * The PROVISIONING state indicates the node pool is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    public static final int PROVISIONING_VALUE = 1;
    /**
     * <pre>
     * The RUNNING state indicates the node pool has been created
     * and is fully usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     * <pre>
     * The RUNNING_WITH_ERROR state indicates the node pool has been created
     * and is partially usable. Some error state has occurred and some
     * functionality may be impaired. Customer may need to reissue a request
     * or trigger a new update.
     * </pre>
     *
     * <code>RUNNING_WITH_ERROR = 3;</code>
     */
    public static final int RUNNING_WITH_ERROR_VALUE = 3;
    /**
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the node pool, such as upgrading node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 4;</code>
     */
    public static final int RECONCILING_VALUE = 4;
    /**
     * <pre>
     * The STOPPING state indicates the node pool is being deleted.
     * </pre>
     *
     * <code>STOPPING = 5;</code>
     */
    public static final int STOPPING_VALUE = 5;
    /**
     * <pre>
     * The ERROR state indicates the node pool may be unusable. Details
     * can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    public static final int ERROR_VALUE = 6;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    public static Status forNumber(int value) {
      switch (value) {
        case 0: return STATUS_UNSPECIFIED;
        case 1: return PROVISIONING;
        case 2: return RUNNING;
        case 3: return RUNNING_WITH_ERROR;
        case 4: return RECONCILING;
        case 5: return STOPPING;
        case 6: return ERROR;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Status> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Status>() {
            public Status findValueByNumber(int number) {
              return Status.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.container.v1.NodePool.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.NodePool.Status)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * The name of the node pool.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The name of the node pool.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;
  private com.google.container.v1.NodeConfig config_;
  /**
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   */
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   */
  public com.google.container.v1.NodeConfig getConfig() {
    return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
  }
  /**
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   */
  public com.google.container.v1.NodeConfigOrBuilder getConfigOrBuilder() {
    return getConfig();
  }

  public static final int INITIAL_NODE_COUNT_FIELD_NUMBER = 3;
  private int initialNodeCount_;
  /**
   * <pre>
   * The initial node count for the pool. You must ensure that your
   * Compute Engine &lt;a href="/compute/docs/resource-quotas"&gt;resource quota&lt;/a&gt;
   * is sufficient for this number of instances. You must also have available
   * firewall and routes quota.
   * </pre>
   *
   * <code>int32 initial_node_count = 3;</code>
   */
  public int getInitialNodeCount() {
    return initialNodeCount_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 100;
  private volatile java.lang.Object selfLink_;
  /**
   * <pre>
   * [Output only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100;</code>
   */
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * [Output only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100;</code>
   */
  public com.google.protobuf.ByteString
      getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 101;
  private volatile java.lang.Object version_;
  /**
   * <pre>
   * The version of the Kubernetes of this node.
   * </pre>
   *
   * <code>string version = 101;</code>
   */
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The version of the Kubernetes of this node.
   * </pre>
   *
   * <code>string version = 101;</code>
   */
  public com.google.protobuf.ByteString
      getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_GROUP_URLS_FIELD_NUMBER = 102;
  private com.google.protobuf.LazyStringList instanceGroupUrls_;
  /**
   * <pre>
   * [Output only] The resource URLs of the [managed instance
   * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getInstanceGroupUrlsList() {
    return instanceGroupUrls_;
  }
  /**
   * <pre>
   * [Output only] The resource URLs of the [managed instance
   * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102;</code>
   */
  public int getInstanceGroupUrlsCount() {
    return instanceGroupUrls_.size();
  }
  /**
   * <pre>
   * [Output only] The resource URLs of the [managed instance
   * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102;</code>
   */
  public java.lang.String getInstanceGroupUrls(int index) {
    return instanceGroupUrls_.get(index);
  }
  /**
   * <pre>
   * [Output only] The resource URLs of the [managed instance
   * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102;</code>
   */
  public com.google.protobuf.ByteString
      getInstanceGroupUrlsBytes(int index) {
    return instanceGroupUrls_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 103;
  private int status_;
  /**
   * <pre>
   * [Output only] The status of the nodes in this pool instance.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.Status status = 103;</code>
   */
  public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * [Output only] The status of the nodes in this pool instance.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.Status status = 103;</code>
   */
  public com.google.container.v1.NodePool.Status getStatus() {
    com.google.container.v1.NodePool.Status result = com.google.container.v1.NodePool.Status.valueOf(status_);
    return result == null ? com.google.container.v1.NodePool.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 104;
  private volatile java.lang.Object statusMessage_;
  /**
   * <pre>
   * [Output only] Additional information about the current status of this
   * node pool instance, if available.
   * </pre>
   *
   * <code>string status_message = 104;</code>
   */
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * [Output only] Additional information about the current status of this
   * node pool instance, if available.
   * </pre>
   *
   * <code>string status_message = 104;</code>
   */
  public com.google.protobuf.ByteString
      getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 4;
  private com.google.container.v1.NodePoolAutoscaling autoscaling_;
  /**
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   */
  public boolean hasAutoscaling() {
    return autoscaling_ != null;
  }
  /**
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   */
  public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
    return autoscaling_ == null ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance() : autoscaling_;
  }
  /**
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   */
  public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
    return getAutoscaling();
  }

  public static final int MANAGEMENT_FIELD_NUMBER = 5;
  private com.google.container.v1.NodeManagement management_;
  /**
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   */
  public boolean hasManagement() {
    return management_ != null;
  }
  /**
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   */
  public com.google.container.v1.NodeManagement getManagement() {
    return management_ == null ? com.google.container.v1.NodeManagement.getDefaultInstance() : management_;
  }
  /**
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   */
  public com.google.container.v1.NodeManagementOrBuilder getManagementOrBuilder() {
    return getManagement();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (config_ != null) {
      output.writeMessage(2, getConfig());
    }
    if (initialNodeCount_ != 0) {
      output.writeInt32(3, initialNodeCount_);
    }
    if (autoscaling_ != null) {
      output.writeMessage(4, getAutoscaling());
    }
    if (management_ != null) {
      output.writeMessage(5, getManagement());
    }
    if (!getSelfLinkBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, selfLink_);
    }
    if (!getVersionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, version_);
    }
    for (int i = 0; i < instanceGroupUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 102, instanceGroupUrls_.getRaw(i));
    }
    if (status_ != com.google.container.v1.NodePool.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(103, status_);
    }
    if (!getStatusMessageBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 104, statusMessage_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getConfig());
    }
    if (initialNodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(3, initialNodeCount_);
    }
    if (autoscaling_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getAutoscaling());
    }
    if (management_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getManagement());
    }
    if (!getSelfLinkBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, selfLink_);
    }
    if (!getVersionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, version_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceGroupUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceGroupUrls_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getInstanceGroupUrlsList().size();
    }
    if (status_ != com.google.container.v1.NodePool.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(103, status_);
    }
    if (!getStatusMessageBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(104, statusMessage_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.container.v1.NodePool)) {
      return super.equals(obj);
    }
    com.google.container.v1.NodePool other = (com.google.container.v1.NodePool) obj;

    boolean result = true;
    result = result && getName()
        .equals(other.getName());
    result = result && (hasConfig() == other.hasConfig());
    if (hasConfig()) {
      result = result && getConfig()
          .equals(other.getConfig());
    }
    result = result && (getInitialNodeCount()
        == other.getInitialNodeCount());
    result = result && getSelfLink()
        .equals(other.getSelfLink());
    result = result && getVersion()
        .equals(other.getVersion());
    result = result && getInstanceGroupUrlsList()
        .equals(other.getInstanceGroupUrlsList());
    result = result && status_ == other.status_;
    result = result && getStatusMessage()
        .equals(other.getStatusMessage());
    result = result && (hasAutoscaling() == other.hasAutoscaling());
    if (hasAutoscaling()) {
      result = result && getAutoscaling()
          .equals(other.getAutoscaling());
    }
    result = result && (hasManagement() == other.hasManagement());
    if (hasManagement()) {
      result = result && getManagement()
          .equals(other.getManagement());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    hash = (37 * hash) + INITIAL_NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getInitialNodeCount();
    hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getSelfLink().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (getInstanceGroupUrlsCount() > 0) {
      hash = (37 * hash) + INSTANCE_GROUP_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceGroupUrlsList().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    if (hasManagement()) {
      hash = (37 * hash) + MANAGEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getManagement().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.NodePool parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.container.v1.NodePool parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.container.v1.NodePool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.container.v1.NodePool parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.container.v1.NodePool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.container.v1.NodePool parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.container.v1.NodePool parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.container.v1.NodePool parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.container.v1.NodePool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * NodePool contains the name and configuration for a cluster's node pool.
   * Node pools are a set of nodes (i.e. VM's), with a common configuration and
   * specification, under the control of the cluster master. They may have a set
   * of Kubernetes labels applied to them, which may be used to reference them
   * during pod scheduling. They may also be resized up or down, to accommodate
   * the workload.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool)
      com.google.container.v1.NodePoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.container.v1.ClusterServiceProto.internal_static_google_container_v1_NodePool_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto.internal_static_google_container_v1_NodePool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.class, com.google.container.v1.NodePool.Builder.class);
    }

    // Construct using com.google.container.v1.NodePool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      name_ = "";

      if (configBuilder_ == null) {
        config_ = null;
      } else {
        config_ = null;
        configBuilder_ = null;
      }
      initialNodeCount_ = 0;

      selfLink_ = "";

      version_ = "";

      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000020);
      status_ = 0;

      statusMessage_ = "";

      if (autoscalingBuilder_ == null) {
        autoscaling_ = null;
      } else {
        autoscaling_ = null;
        autoscalingBuilder_ = null;
      }
      if (managementBuilder_ == null) {
        management_ = null;
      } else {
        management_ = null;
        managementBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto.internal_static_google_container_v1_NodePool_descriptor;
    }

    public com.google.container.v1.NodePool getDefaultInstanceForType() {
      return com.google.container.v1.NodePool.getDefaultInstance();
    }

    public com.google.container.v1.NodePool build() {
      com.google.container.v1.NodePool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.container.v1.NodePool buildPartial() {
      com.google.container.v1.NodePool result = new com.google.container.v1.NodePool(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (configBuilder_ == null) {
        result.config_ = config_;
      } else {
        result.config_ = configBuilder_.build();
      }
      result.initialNodeCount_ = initialNodeCount_;
      result.selfLink_ = selfLink_;
      result.version_ = version_;
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        instanceGroupUrls_ = instanceGroupUrls_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.instanceGroupUrls_ = instanceGroupUrls_;
      result.status_ = status_;
      result.statusMessage_ = statusMessage_;
      if (autoscalingBuilder_ == null) {
        result.autoscaling_ = autoscaling_;
      } else {
        result.autoscaling_ = autoscalingBuilder_.build();
      }
      if (managementBuilder_ == null) {
        result.management_ = management_;
      } else {
        result.management_ = managementBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.NodePool) {
        return mergeFrom((com.google.container.v1.NodePool)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.NodePool other) {
      if (other == com.google.container.v1.NodePool.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.getInitialNodeCount() != 0) {
        setInitialNodeCount(other.getInitialNodeCount());
      }
      if (!other.getSelfLink().isEmpty()) {
        selfLink_ = other.selfLink_;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        onChanged();
      }
      if (!other.instanceGroupUrls_.isEmpty()) {
        if (instanceGroupUrls_.isEmpty()) {
          instanceGroupUrls_ = other.instanceGroupUrls_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureInstanceGroupUrlsIsMutable();
          instanceGroupUrls_.addAll(other.instanceGroupUrls_);
        }
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        onChanged();
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      if (other.hasManagement()) {
        mergeManagement(other.getManagement());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.container.v1.NodePool parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.container.v1.NodePool) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodeConfig config_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodeConfig, com.google.container.v1.NodeConfig.Builder, com.google.container.v1.NodeConfigOrBuilder> configBuilder_;
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public boolean hasConfig() {
      return configBuilder_ != null || config_ != null;
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public com.google.container.v1.NodeConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder setConfig(com.google.container.v1.NodeConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        configBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder setConfig(
        com.google.container.v1.NodeConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder mergeConfig(com.google.container.v1.NodeConfig value) {
      if (configBuilder_ == null) {
        if (config_ != null) {
          config_ =
            com.google.container.v1.NodeConfig.newBuilder(config_).mergeFrom(value).buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        configBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder clearConfig() {
      if (configBuilder_ == null) {
        config_ = null;
        onChanged();
      } else {
        config_ = null;
        configBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public com.google.container.v1.NodeConfig.Builder getConfigBuilder() {
      
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public com.google.container.v1.NodeConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null ?
            com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
      }
    }
    /**
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodeConfig, com.google.container.v1.NodeConfig.Builder, com.google.container.v1.NodeConfigOrBuilder> 
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeConfig, com.google.container.v1.NodeConfig.Builder, com.google.container.v1.NodeConfigOrBuilder>(
                getConfig(),
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private int initialNodeCount_ ;
    /**
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine &lt;a href="/compute/docs/resource-quotas"&gt;resource quota&lt;/a&gt;
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     */
    public int getInitialNodeCount() {
      return initialNodeCount_;
    }
    /**
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine &lt;a href="/compute/docs/resource-quotas"&gt;resource quota&lt;/a&gt;
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     */
    public Builder setInitialNodeCount(int value) {
      
      initialNodeCount_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine &lt;a href="/compute/docs/resource-quotas"&gt;resource quota&lt;/a&gt;
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     */
    public Builder clearInitialNodeCount() {
      
      initialNodeCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100;</code>
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100;</code>
     */
    public com.google.protobuf.ByteString
        getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100;</code>
     */
    public Builder setSelfLink(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      selfLink_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100;</code>
     */
    public Builder clearSelfLink() {
      
      selfLink_ = getDefaultInstance().getSelfLink();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100;</code>
     */
    public Builder setSelfLinkBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      selfLink_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     * <pre>
     * The version of the Kubernetes of this node.
     * </pre>
     *
     * <code>string version = 101;</code>
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The version of the Kubernetes of this node.
     * </pre>
     *
     * <code>string version = 101;</code>
     */
    public com.google.protobuf.ByteString
        getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The version of the Kubernetes of this node.
     * </pre>
     *
     * <code>string version = 101;</code>
     */
    public Builder setVersion(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      version_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The version of the Kubernetes of this node.
     * </pre>
     *
     * <code>string version = 101;</code>
     */
    public Builder clearVersion() {
      
      version_ = getDefaultInstance().getVersion();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The version of the Kubernetes of this node.
     * </pre>
     *
     * <code>string version = 101;</code>
     */
    public Builder setVersionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      version_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureInstanceGroupUrlsIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        instanceGroupUrls_ = new com.google.protobuf.LazyStringArrayList(instanceGroupUrls_);
        bitField0_ |= 0x00000020;
       }
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getInstanceGroupUrlsList() {
      return instanceGroupUrls_.getUnmodifiableView();
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public int getInstanceGroupUrlsCount() {
      return instanceGroupUrls_.size();
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public java.lang.String getInstanceGroupUrls(int index) {
      return instanceGroupUrls_.get(index);
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public com.google.protobuf.ByteString
        getInstanceGroupUrlsBytes(int index) {
      return instanceGroupUrls_.getByteString(index);
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public Builder setInstanceGroupUrls(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public Builder addInstanceGroupUrls(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public Builder addAllInstanceGroupUrls(
        java.lang.Iterable<java.lang.String> values) {
      ensureInstanceGroupUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, instanceGroupUrls_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public Builder clearInstanceGroupUrls() {
      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The resource URLs of the [managed instance
     * groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102;</code>
     */
    public Builder addInstanceGroupUrlsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * [Output only] The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.Status status = 103;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * [Output only] The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.Status status = 103;</code>
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.Status status = 103;</code>
     */
    public com.google.container.v1.NodePool.Status getStatus() {
      com.google.container.v1.NodePool.Status result = com.google.container.v1.NodePool.Status.valueOf(status_);
      return result == null ? com.google.container.v1.NodePool.Status.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * [Output only] The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.Status status = 103;</code>
     */
    public Builder setStatus(com.google.container.v1.NodePool.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.Status status = 103;</code>
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     * <pre>
     * [Output only] Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>string status_message = 104;</code>
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * [Output only] Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>string status_message = 104;</code>
     */
    public com.google.protobuf.ByteString
        getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * [Output only] Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>string status_message = 104;</code>
     */
    public Builder setStatusMessage(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      statusMessage_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>string status_message = 104;</code>
     */
    public Builder clearStatusMessage() {
      
      statusMessage_ = getDefaultInstance().getStatusMessage();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Output only] Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>string status_message = 104;</code>
     */
    public Builder setStatusMessageBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      statusMessage_ = value;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePoolAutoscaling autoscaling_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodePoolAutoscaling, com.google.container.v1.NodePoolAutoscaling.Builder, com.google.container.v1.NodePoolAutoscalingOrBuilder> autoscalingBuilder_;
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public boolean hasAutoscaling() {
      return autoscalingBuilder_ != null || autoscaling_ != null;
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance() : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder setAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
        onChanged();
      } else {
        autoscalingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder setAutoscaling(
        com.google.container.v1.NodePoolAutoscaling.Builder builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
        onChanged();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder mergeAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (autoscaling_ != null) {
          autoscaling_ =
            com.google.container.v1.NodePoolAutoscaling.newBuilder(autoscaling_).mergeFrom(value).buildPartial();
        } else {
          autoscaling_ = value;
        }
        onChanged();
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder clearAutoscaling() {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = null;
        onChanged();
      } else {
        autoscaling_ = null;
        autoscalingBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public com.google.container.v1.NodePoolAutoscaling.Builder getAutoscalingBuilder() {
      
      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null ?
            com.google.container.v1.NodePoolAutoscaling.getDefaultInstance() : autoscaling_;
      }
    }
    /**
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodePoolAutoscaling, com.google.container.v1.NodePoolAutoscaling.Builder, com.google.container.v1.NodePoolAutoscalingOrBuilder> 
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoscaling, com.google.container.v1.NodePoolAutoscaling.Builder, com.google.container.v1.NodePoolAutoscalingOrBuilder>(
                getAutoscaling(),
                getParentForChildren(),
                isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    private com.google.container.v1.NodeManagement management_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodeManagement, com.google.container.v1.NodeManagement.Builder, com.google.container.v1.NodeManagementOrBuilder> managementBuilder_;
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public boolean hasManagement() {
      return managementBuilder_ != null || management_ != null;
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public com.google.container.v1.NodeManagement getManagement() {
      if (managementBuilder_ == null) {
        return management_ == null ? com.google.container.v1.NodeManagement.getDefaultInstance() : management_;
      } else {
        return managementBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder setManagement(com.google.container.v1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        management_ = value;
        onChanged();
      } else {
        managementBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder setManagement(
        com.google.container.v1.NodeManagement.Builder builderForValue) {
      if (managementBuilder_ == null) {
        management_ = builderForValue.build();
        onChanged();
      } else {
        managementBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder mergeManagement(com.google.container.v1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (management_ != null) {
          management_ =
            com.google.container.v1.NodeManagement.newBuilder(management_).mergeFrom(value).buildPartial();
        } else {
          management_ = value;
        }
        onChanged();
      } else {
        managementBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder clearManagement() {
      if (managementBuilder_ == null) {
        management_ = null;
        onChanged();
      } else {
        management_ = null;
        managementBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public com.google.container.v1.NodeManagement.Builder getManagementBuilder() {
      
      onChanged();
      return getManagementFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public com.google.container.v1.NodeManagementOrBuilder getManagementOrBuilder() {
      if (managementBuilder_ != null) {
        return managementBuilder_.getMessageOrBuilder();
      } else {
        return management_ == null ?
            com.google.container.v1.NodeManagement.getDefaultInstance() : management_;
      }
    }
    /**
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.container.v1.NodeManagement, com.google.container.v1.NodeManagement.Builder, com.google.container.v1.NodeManagementOrBuilder> 
        getManagementFieldBuilder() {
      if (managementBuilder_ == null) {
        managementBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeManagement, com.google.container.v1.NodeManagement.Builder, com.google.container.v1.NodeManagementOrBuilder>(
                getManagement(),
                getParentForChildren(),
                isClean());
        management_ = null;
      }
      return managementBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.NodePool)
  private static final com.google.container.v1.NodePool DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.container.v1.NodePool();
  }

  public static com.google.container.v1.NodePool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodePool>
      PARSER = new com.google.protobuf.AbstractParser<NodePool>() {
    public NodePool parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new NodePool(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<NodePool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodePool> getParserForType() {
    return PARSER;
  }

  public com.google.container.v1.NodePool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

