/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Cloud VPN Tunnel resource. For more information about VPN, read the the Cloud VPN Overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.VpnTunnel}
 */
public final class VpnTunnel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.VpnTunnel)
    VpnTunnelOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use VpnTunnel.newBuilder() to construct.
  private VpnTunnel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VpnTunnel() {
    creationTimestamp_ = "";
    description_ = "";
    detailedStatus_ = "";
    kind_ = "";
    labelFingerprint_ = "";
    localTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
    name_ = "";
    peerExternalGateway_ = "";
    peerGcpGateway_ = "";
    peerIp_ = "";
    region_ = "";
    remoteTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
    router_ = "";
    selfLink_ = "";
    sharedSecret_ = "";
    sharedSecretHash_ = "";
    status_ = "";
    targetVpnGateway_ = "";
    vpnGateway_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VpnTunnel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VpnTunnel_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_VpnTunnel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.VpnTunnel.class,
            com.google.cloud.compute.v1.VpnTunnel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.VpnTunnel.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Cloud VPN is in the process of allocating all required resources (specifically, a borg task).
     * </pre>
     *
     * <code>ALLOCATING_RESOURCES = 320922816;</code>
     */
    ALLOCATING_RESOURCES(320922816),
    /**
     *
     *
     * <pre>
     * Auth error (e.g. bad shared secret).
     * </pre>
     *
     * <code>AUTHORIZATION_ERROR = 23580290;</code>
     */
    AUTHORIZATION_ERROR(23580290),
    /**
     *
     *
     * <pre>
     * Resources is being deallocated for the VPN tunnel.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    DEPROVISIONING(428935662),
    /**
     *
     *
     * <pre>
     * Secure session is successfully established with peer VPN.
     * </pre>
     *
     * <code>ESTABLISHED = 88852344;</code>
     */
    ESTABLISHED(88852344),
    /**
     *
     *
     * <pre>
     * Tunnel creation has failed and the tunnel is not ready to be used.
     * </pre>
     *
     * <code>FAILED = 455706685;</code>
     */
    FAILED(455706685),
    /**
     *
     *
     * <pre>
     * Successful first handshake with peer VPN.
     * </pre>
     *
     * <code>FIRST_HANDSHAKE = 191393000;</code>
     */
    FIRST_HANDSHAKE(191393000),
    /**
     *
     *
     * <pre>
     * Handshake failed.
     * </pre>
     *
     * <code>NEGOTIATION_FAILURE = 360325868;</code>
     */
    NEGOTIATION_FAILURE(360325868),
    /**
     *
     *
     * <pre>
     * Deprecated, replaced by NO_INCOMING_PACKETS
     * </pre>
     *
     * <code>NETWORK_ERROR = 193912951;</code>
     */
    NETWORK_ERROR(193912951),
    /**
     *
     *
     * <pre>
     * No incoming packets from peer
     * </pre>
     *
     * <code>NO_INCOMING_PACKETS = 119983216;</code>
     */
    NO_INCOMING_PACKETS(119983216),
    /**
     *
     *
     * <pre>
     * Resource is being allocated for the VPN tunnel.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    PROVISIONING(290896621),
    /**
     *
     *
     * <pre>
     * Tunnel configuration was rejected, can be result of being denylisted.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    REJECTED(174130302),
    /**
     *
     *
     * <pre>
     * Tunnel is stopped due to its Forwarding Rules being deleted.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    STOPPED(444276141),
    /**
     *
     *
     * <pre>
     * Waiting to receive all VPN-related configs from user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule and Route resources are needed to setup VPN tunnel.
     * </pre>
     *
     * <code>WAITING_FOR_FULL_CONFIG = 41640522;</code>
     */
    WAITING_FOR_FULL_CONFIG(41640522),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Cloud VPN is in the process of allocating all required resources (specifically, a borg task).
     * </pre>
     *
     * <code>ALLOCATING_RESOURCES = 320922816;</code>
     */
    public static final int ALLOCATING_RESOURCES_VALUE = 320922816;

    /**
     *
     *
     * <pre>
     * Auth error (e.g. bad shared secret).
     * </pre>
     *
     * <code>AUTHORIZATION_ERROR = 23580290;</code>
     */
    public static final int AUTHORIZATION_ERROR_VALUE = 23580290;

    /**
     *
     *
     * <pre>
     * Resources is being deallocated for the VPN tunnel.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    public static final int DEPROVISIONING_VALUE = 428935662;

    /**
     *
     *
     * <pre>
     * Secure session is successfully established with peer VPN.
     * </pre>
     *
     * <code>ESTABLISHED = 88852344;</code>
     */
    public static final int ESTABLISHED_VALUE = 88852344;

    /**
     *
     *
     * <pre>
     * Tunnel creation has failed and the tunnel is not ready to be used.
     * </pre>
     *
     * <code>FAILED = 455706685;</code>
     */
    public static final int FAILED_VALUE = 455706685;

    /**
     *
     *
     * <pre>
     * Successful first handshake with peer VPN.
     * </pre>
     *
     * <code>FIRST_HANDSHAKE = 191393000;</code>
     */
    public static final int FIRST_HANDSHAKE_VALUE = 191393000;

    /**
     *
     *
     * <pre>
     * Handshake failed.
     * </pre>
     *
     * <code>NEGOTIATION_FAILURE = 360325868;</code>
     */
    public static final int NEGOTIATION_FAILURE_VALUE = 360325868;

    /**
     *
     *
     * <pre>
     * Deprecated, replaced by NO_INCOMING_PACKETS
     * </pre>
     *
     * <code>NETWORK_ERROR = 193912951;</code>
     */
    public static final int NETWORK_ERROR_VALUE = 193912951;

    /**
     *
     *
     * <pre>
     * No incoming packets from peer
     * </pre>
     *
     * <code>NO_INCOMING_PACKETS = 119983216;</code>
     */
    public static final int NO_INCOMING_PACKETS_VALUE = 119983216;

    /**
     *
     *
     * <pre>
     * Resource is being allocated for the VPN tunnel.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    public static final int PROVISIONING_VALUE = 290896621;

    /**
     *
     *
     * <pre>
     * Tunnel configuration was rejected, can be result of being denylisted.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    public static final int REJECTED_VALUE = 174130302;

    /**
     *
     *
     * <pre>
     * Tunnel is stopped due to its Forwarding Rules being deleted.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    public static final int STOPPED_VALUE = 444276141;

    /**
     *
     *
     * <pre>
     * Waiting to receive all VPN-related configs from user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule and Route resources are needed to setup VPN tunnel.
     * </pre>
     *
     * <code>WAITING_FOR_FULL_CONFIG = 41640522;</code>
     */
    public static final int WAITING_FOR_FULL_CONFIG_VALUE = 41640522;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 320922816:
          return ALLOCATING_RESOURCES;
        case 23580290:
          return AUTHORIZATION_ERROR;
        case 428935662:
          return DEPROVISIONING;
        case 88852344:
          return ESTABLISHED;
        case 455706685:
          return FAILED;
        case 191393000:
          return FIRST_HANDSHAKE;
        case 360325868:
          return NEGOTIATION_FAILURE;
        case 193912951:
          return NETWORK_ERROR;
        case 119983216:
          return NO_INCOMING_PACKETS;
        case 290896621:
          return PROVISIONING;
        case 174130302:
          return REJECTED;
        case 444276141:
          return STOPPED;
        case 41640522:
          return WAITING_FOR_FULL_CONFIG;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.VpnTunnel.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.VpnTunnel.Status)
  }

  private int bitField0_;
  public static final int CIPHER_SUITE_FIELD_NUMBER = 443788228;
  private com.google.cloud.compute.v1.VpnTunnelCipherSuite cipherSuite_;

  /**
   *
   *
   * <pre>
   * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
   *
   * @return Whether the cipherSuite field is set.
   */
  @java.lang.Override
  public boolean hasCipherSuite() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
   *
   * @return The cipherSuite.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnTunnelCipherSuite getCipherSuite() {
    return cipherSuite_ == null
        ? com.google.cloud.compute.v1.VpnTunnelCipherSuite.getDefaultInstance()
        : cipherSuite_;
  }

  /**
   *
   *
   * <pre>
   * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.VpnTunnelCipherSuiteOrBuilder getCipherSuiteOrBuilder() {
    return cipherSuite_ == null
        ? com.google.cloud.compute.v1.VpnTunnelCipherSuite.getDefaultInstance()
        : cipherSuite_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DETAILED_STATUS_FIELD_NUMBER = 333501025;

  @SuppressWarnings("serial")
  private volatile java.lang.Object detailedStatus_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Detailed status message for the VPN tunnel.
   * </pre>
   *
   * <code>optional string detailed_status = 333501025;</code>
   *
   * @return Whether the detailedStatus field is set.
   */
  @java.lang.Override
  public boolean hasDetailedStatus() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Detailed status message for the VPN tunnel.
   * </pre>
   *
   * <code>optional string detailed_status = 333501025;</code>
   *
   * @return The detailedStatus.
   */
  @java.lang.Override
  public java.lang.String getDetailedStatus() {
    java.lang.Object ref = detailedStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detailedStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Detailed status message for the VPN tunnel.
   * </pre>
   *
   * <code>optional string detailed_status = 333501025;</code>
   *
   * @return The bytes for detailedStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailedStatusBytes() {
    java.lang.Object ref = detailedStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detailedStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IKE_VERSION_FIELD_NUMBER = 218376220;
  private int ikeVersion_ = 0;

  /**
   *
   *
   * <pre>
   * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
   * </pre>
   *
   * <code>optional int32 ike_version = 218376220;</code>
   *
   * @return Whether the ikeVersion field is set.
   */
  @java.lang.Override
  public boolean hasIkeVersion() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
   * </pre>
   *
   * <code>optional int32 ike_version = 218376220;</code>
   *
   * @return The ikeVersion.
   */
  @java.lang.Override
  public int getIkeVersion() {
    return ikeVersion_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_VpnTunnel_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOCAL_TRAFFIC_SELECTOR_FIELD_NUMBER = 317314613;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList localTrafficSelector_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string local_traffic_selector = 317314613;</code>
   *
   * @return A list containing the localTrafficSelector.
   */
  public com.google.protobuf.ProtocolStringList getLocalTrafficSelectorList() {
    return localTrafficSelector_;
  }

  /**
   *
   *
   * <pre>
   * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string local_traffic_selector = 317314613;</code>
   *
   * @return The count of localTrafficSelector.
   */
  public int getLocalTrafficSelectorCount() {
    return localTrafficSelector_.size();
  }

  /**
   *
   *
   * <pre>
   * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string local_traffic_selector = 317314613;</code>
   *
   * @param index The index of the element to return.
   * @return The localTrafficSelector at the given index.
   */
  public java.lang.String getLocalTrafficSelector(int index) {
    return localTrafficSelector_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string local_traffic_selector = 317314613;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the localTrafficSelector at the given index.
   */
  public com.google.protobuf.ByteString getLocalTrafficSelectorBytes(int index) {
    return localTrafficSelector_.getByteString(index);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_EXTERNAL_GATEWAY_FIELD_NUMBER = 384956173;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerExternalGateway_ = "";

  /**
   *
   *
   * <pre>
   * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return Whether the peerExternalGateway field is set.
   */
  @java.lang.Override
  public boolean hasPeerExternalGateway() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return The peerExternalGateway.
   */
  @java.lang.Override
  public java.lang.String getPeerExternalGateway() {
    java.lang.Object ref = peerExternalGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerExternalGateway_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
   * </pre>
   *
   * <code>optional string peer_external_gateway = 384956173;</code>
   *
   * @return The bytes for peerExternalGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerExternalGatewayBytes() {
    java.lang.Object ref = peerExternalGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerExternalGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_EXTERNAL_GATEWAY_INTERFACE_FIELD_NUMBER = 452768391;
  private int peerExternalGatewayInterface_ = 0;

  /**
   *
   *
   * <pre>
   * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
   * </pre>
   *
   * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
   *
   * @return Whether the peerExternalGatewayInterface field is set.
   */
  @java.lang.Override
  public boolean hasPeerExternalGatewayInterface() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
   * </pre>
   *
   * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
   *
   * @return The peerExternalGatewayInterface.
   */
  @java.lang.Override
  public int getPeerExternalGatewayInterface() {
    return peerExternalGatewayInterface_;
  }

  public static final int PEER_GCP_GATEWAY_FIELD_NUMBER = 281867452;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerGcpGateway_ = "";

  /**
   *
   *
   * <pre>
   * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return Whether the peerGcpGateway field is set.
   */
  @java.lang.Override
  public boolean hasPeerGcpGateway() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return The peerGcpGateway.
   */
  @java.lang.Override
  public java.lang.String getPeerGcpGateway() {
    java.lang.Object ref = peerGcpGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerGcpGateway_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
   * </pre>
   *
   * <code>optional string peer_gcp_gateway = 281867452;</code>
   *
   * @return The bytes for peerGcpGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerGcpGatewayBytes() {
    java.lang.Object ref = peerGcpGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerGcpGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IP_FIELD_NUMBER = 383249700;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIp_ = "";

  /**
   *
   *
   * <pre>
   * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string peer_ip = 383249700;</code>
   *
   * @return Whether the peerIp field is set.
   */
  @java.lang.Override
  public boolean hasPeerIp() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string peer_ip = 383249700;</code>
   *
   * @return The peerIp.
   */
  @java.lang.Override
  public java.lang.String getPeerIp() {
    java.lang.Object ref = peerIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string peer_ip = 383249700;</code>
   *
   * @return The bytes for peerIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpBytes() {
    java.lang.Object ref = peerIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REMOTE_TRAFFIC_SELECTOR_FIELD_NUMBER = 358887098;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList remoteTrafficSelector_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string remote_traffic_selector = 358887098;</code>
   *
   * @return A list containing the remoteTrafficSelector.
   */
  public com.google.protobuf.ProtocolStringList getRemoteTrafficSelectorList() {
    return remoteTrafficSelector_;
  }

  /**
   *
   *
   * <pre>
   * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string remote_traffic_selector = 358887098;</code>
   *
   * @return The count of remoteTrafficSelector.
   */
  public int getRemoteTrafficSelectorCount() {
    return remoteTrafficSelector_.size();
  }

  /**
   *
   *
   * <pre>
   * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string remote_traffic_selector = 358887098;</code>
   *
   * @param index The index of the element to return.
   * @return The remoteTrafficSelector at the given index.
   */
  public java.lang.String getRemoteTrafficSelector(int index) {
    return remoteTrafficSelector_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
   * </pre>
   *
   * <code>repeated string remote_traffic_selector = 358887098;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the remoteTrafficSelector at the given index.
   */
  public com.google.protobuf.ByteString getRemoteTrafficSelectorBytes(int index) {
    return remoteTrafficSelector_.getByteString(index);
  }

  public static final int ROUTER_FIELD_NUMBER = 148608841;

  @SuppressWarnings("serial")
  private volatile java.lang.Object router_ = "";

  /**
   *
   *
   * <pre>
   * URL of the router resource to be used for dynamic routing.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return Whether the router field is set.
   */
  @java.lang.Override
  public boolean hasRouter() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the router resource to be used for dynamic routing.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The router.
   */
  @java.lang.Override
  public java.lang.String getRouter() {
    java.lang.Object ref = router_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      router_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the router resource to be used for dynamic routing.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The bytes for router.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouterBytes() {
    java.lang.Object ref = router_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      router_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARED_SECRET_FIELD_NUMBER = 381932490;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sharedSecret_ = "";

  /**
   *
   *
   * <pre>
   * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return Whether the sharedSecret field is set.
   */
  @java.lang.Override
  public boolean hasSharedSecret() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return The sharedSecret.
   */
  @java.lang.Override
  public java.lang.String getSharedSecret() {
    java.lang.Object ref = sharedSecret_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sharedSecret_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return The bytes for sharedSecret.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSharedSecretBytes() {
    java.lang.Object ref = sharedSecret_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sharedSecret_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARED_SECRET_HASH_FIELD_NUMBER = 398881891;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sharedSecretHash_ = "";

  /**
   *
   *
   * <pre>
   * Hash of the shared secret.
   * </pre>
   *
   * <code>optional string shared_secret_hash = 398881891;</code>
   *
   * @return Whether the sharedSecretHash field is set.
   */
  @java.lang.Override
  public boolean hasSharedSecretHash() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Hash of the shared secret.
   * </pre>
   *
   * <code>optional string shared_secret_hash = 398881891;</code>
   *
   * @return The sharedSecretHash.
   */
  @java.lang.Override
  public java.lang.String getSharedSecretHash() {
    java.lang.Object ref = sharedSecretHash_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sharedSecretHash_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Hash of the shared secret.
   * </pre>
   *
   * <code>optional string shared_secret_hash = 398881891;</code>
   *
   * @return The bytes for sharedSecretHash.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSharedSecretHashBytes() {
    java.lang.Object ref = sharedSecretHash_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sharedSecretHash_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_VPN_GATEWAY_FIELD_NUMBER = 532512843;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetVpnGateway_ = "";

  /**
   *
   *
   * <pre>
   * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string target_vpn_gateway = 532512843;</code>
   *
   * @return Whether the targetVpnGateway field is set.
   */
  @java.lang.Override
  public boolean hasTargetVpnGateway() {
    return ((bitField0_ & 0x00080000) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string target_vpn_gateway = 532512843;</code>
   *
   * @return The targetVpnGateway.
   */
  @java.lang.Override
  public java.lang.String getTargetVpnGateway() {
    java.lang.Object ref = targetVpnGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetVpnGateway_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
   * </pre>
   *
   * <code>optional string target_vpn_gateway = 532512843;</code>
   *
   * @return The bytes for targetVpnGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetVpnGatewayBytes() {
    java.lang.Object ref = targetVpnGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetVpnGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPN_GATEWAY_FIELD_NUMBER = 406684153;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vpnGateway_ = "";

  /**
   *
   *
   * <pre>
   * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
   * </pre>
   *
   * <code>optional string vpn_gateway = 406684153;</code>
   *
   * @return Whether the vpnGateway field is set.
   */
  @java.lang.Override
  public boolean hasVpnGateway() {
    return ((bitField0_ & 0x00100000) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
   * </pre>
   *
   * <code>optional string vpn_gateway = 406684153;</code>
   *
   * @return The vpnGateway.
   */
  @java.lang.Override
  public java.lang.String getVpnGateway() {
    java.lang.Object ref = vpnGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpnGateway_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
   * </pre>
   *
   * <code>optional string vpn_gateway = 406684153;</code>
   *
   * @return The bytes for vpnGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpnGatewayBytes() {
    java.lang.Object ref = vpnGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpnGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPN_GATEWAY_INTERFACE_FIELD_NUMBER = 95979123;
  private int vpnGatewayInterface_ = 0;

  /**
   *
   *
   * <pre>
   * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
   * </pre>
   *
   * <code>optional int32 vpn_gateway_interface = 95979123;</code>
   *
   * @return Whether the vpnGatewayInterface field is set.
   */
  @java.lang.Override
  public boolean hasVpnGatewayInterface() {
    return ((bitField0_ & 0x00200000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
   * </pre>
   *
   * <code>optional int32 vpn_gateway_interface = 95979123;</code>
   *
   * @return The vpnGatewayInterface.
   */
  @java.lang.Override
  public int getVpnGatewayInterface() {
    return vpnGatewayInterface_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeInt32(95979123, vpnGatewayInterface_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 148608841, router_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(218376220, ikeVersion_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 281867452, peerGcpGateway_);
    }
    for (int i = 0; i < localTrafficSelector_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 317314613, localTrafficSelector_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 333501025, detailedStatus_);
    }
    for (int i = 0; i < remoteTrafficSelector_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 358887098, remoteTrafficSelector_.getRaw(i));
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 381932490, sharedSecret_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 383249700, peerIp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 384956173, peerExternalGateway_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 398881891, sharedSecretHash_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 406684153, vpnGateway_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(443788228, getCipherSuite());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt32(452768391, peerExternalGatewayInterface_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 532512843, targetVpnGateway_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(95979123, vpnGatewayInterface_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(148608841, router_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(218376220, ikeVersion_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(281867452, peerGcpGateway_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < localTrafficSelector_.size(); i++) {
        dataSize += computeStringSizeNoTag(localTrafficSelector_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLocalTrafficSelectorList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(333501025, detailedStatus_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < remoteTrafficSelector_.size(); i++) {
        dataSize += computeStringSizeNoTag(remoteTrafficSelector_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getRemoteTrafficSelectorList().size();
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(381932490, sharedSecret_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(383249700, peerIp_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(384956173, peerExternalGateway_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(398881891, sharedSecretHash_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(406684153, vpnGateway_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(443788228, getCipherSuite());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              452768391, peerExternalGatewayInterface_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(532512843, targetVpnGateway_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.VpnTunnel)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.VpnTunnel other = (com.google.cloud.compute.v1.VpnTunnel) obj;

    if (hasCipherSuite() != other.hasCipherSuite()) return false;
    if (hasCipherSuite()) {
      if (!getCipherSuite().equals(other.getCipherSuite())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDetailedStatus() != other.hasDetailedStatus()) return false;
    if (hasDetailedStatus()) {
      if (!getDetailedStatus().equals(other.getDetailedStatus())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIkeVersion() != other.hasIkeVersion()) return false;
    if (hasIkeVersion()) {
      if (getIkeVersion() != other.getIkeVersion()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLocalTrafficSelectorList().equals(other.getLocalTrafficSelectorList())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPeerExternalGateway() != other.hasPeerExternalGateway()) return false;
    if (hasPeerExternalGateway()) {
      if (!getPeerExternalGateway().equals(other.getPeerExternalGateway())) return false;
    }
    if (hasPeerExternalGatewayInterface() != other.hasPeerExternalGatewayInterface()) return false;
    if (hasPeerExternalGatewayInterface()) {
      if (getPeerExternalGatewayInterface() != other.getPeerExternalGatewayInterface())
        return false;
    }
    if (hasPeerGcpGateway() != other.hasPeerGcpGateway()) return false;
    if (hasPeerGcpGateway()) {
      if (!getPeerGcpGateway().equals(other.getPeerGcpGateway())) return false;
    }
    if (hasPeerIp() != other.hasPeerIp()) return false;
    if (hasPeerIp()) {
      if (!getPeerIp().equals(other.getPeerIp())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (!getRemoteTrafficSelectorList().equals(other.getRemoteTrafficSelectorList())) return false;
    if (hasRouter() != other.hasRouter()) return false;
    if (hasRouter()) {
      if (!getRouter().equals(other.getRouter())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSharedSecret() != other.hasSharedSecret()) return false;
    if (hasSharedSecret()) {
      if (!getSharedSecret().equals(other.getSharedSecret())) return false;
    }
    if (hasSharedSecretHash() != other.hasSharedSecretHash()) return false;
    if (hasSharedSecretHash()) {
      if (!getSharedSecretHash().equals(other.getSharedSecretHash())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasTargetVpnGateway() != other.hasTargetVpnGateway()) return false;
    if (hasTargetVpnGateway()) {
      if (!getTargetVpnGateway().equals(other.getTargetVpnGateway())) return false;
    }
    if (hasVpnGateway() != other.hasVpnGateway()) return false;
    if (hasVpnGateway()) {
      if (!getVpnGateway().equals(other.getVpnGateway())) return false;
    }
    if (hasVpnGatewayInterface() != other.hasVpnGatewayInterface()) return false;
    if (hasVpnGatewayInterface()) {
      if (getVpnGatewayInterface() != other.getVpnGatewayInterface()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCipherSuite()) {
      hash = (37 * hash) + CIPHER_SUITE_FIELD_NUMBER;
      hash = (53 * hash) + getCipherSuite().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDetailedStatus()) {
      hash = (37 * hash) + DETAILED_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getDetailedStatus().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIkeVersion()) {
      hash = (37 * hash) + IKE_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getIkeVersion();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getLocalTrafficSelectorCount() > 0) {
      hash = (37 * hash) + LOCAL_TRAFFIC_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getLocalTrafficSelectorList().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPeerExternalGateway()) {
      hash = (37 * hash) + PEER_EXTERNAL_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getPeerExternalGateway().hashCode();
    }
    if (hasPeerExternalGatewayInterface()) {
      hash = (37 * hash) + PEER_EXTERNAL_GATEWAY_INTERFACE_FIELD_NUMBER;
      hash = (53 * hash) + getPeerExternalGatewayInterface();
    }
    if (hasPeerGcpGateway()) {
      hash = (37 * hash) + PEER_GCP_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getPeerGcpGateway().hashCode();
    }
    if (hasPeerIp()) {
      hash = (37 * hash) + PEER_IP_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIp().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (getRemoteTrafficSelectorCount() > 0) {
      hash = (37 * hash) + REMOTE_TRAFFIC_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getRemoteTrafficSelectorList().hashCode();
    }
    if (hasRouter()) {
      hash = (37 * hash) + ROUTER_FIELD_NUMBER;
      hash = (53 * hash) + getRouter().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSharedSecret()) {
      hash = (37 * hash) + SHARED_SECRET_FIELD_NUMBER;
      hash = (53 * hash) + getSharedSecret().hashCode();
    }
    if (hasSharedSecretHash()) {
      hash = (37 * hash) + SHARED_SECRET_HASH_FIELD_NUMBER;
      hash = (53 * hash) + getSharedSecretHash().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasTargetVpnGateway()) {
      hash = (37 * hash) + TARGET_VPN_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getTargetVpnGateway().hashCode();
    }
    if (hasVpnGateway()) {
      hash = (37 * hash) + VPN_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getVpnGateway().hashCode();
    }
    if (hasVpnGatewayInterface()) {
      hash = (37 * hash) + VPN_GATEWAY_INTERFACE_FIELD_NUMBER;
      hash = (53 * hash) + getVpnGatewayInterface();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.VpnTunnel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.VpnTunnel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Cloud VPN Tunnel resource. For more information about VPN, read the the Cloud VPN Overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.VpnTunnel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.VpnTunnel)
      com.google.cloud.compute.v1.VpnTunnelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnTunnel_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnTunnel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.VpnTunnel.class,
              com.google.cloud.compute.v1.VpnTunnel.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.VpnTunnel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCipherSuiteFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cipherSuite_ = null;
      if (cipherSuiteBuilder_ != null) {
        cipherSuiteBuilder_.dispose();
        cipherSuiteBuilder_ = null;
      }
      creationTimestamp_ = "";
      description_ = "";
      detailedStatus_ = "";
      id_ = 0L;
      ikeVersion_ = 0;
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      localTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
      name_ = "";
      peerExternalGateway_ = "";
      peerExternalGatewayInterface_ = 0;
      peerGcpGateway_ = "";
      peerIp_ = "";
      region_ = "";
      remoteTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
      router_ = "";
      selfLink_ = "";
      sharedSecret_ = "";
      sharedSecretHash_ = "";
      status_ = "";
      targetVpnGateway_ = "";
      vpnGateway_ = "";
      vpnGatewayInterface_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_VpnTunnel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnTunnel getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.VpnTunnel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnTunnel build() {
      com.google.cloud.compute.v1.VpnTunnel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.VpnTunnel buildPartial() {
      com.google.cloud.compute.v1.VpnTunnel result =
          new com.google.cloud.compute.v1.VpnTunnel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.VpnTunnel result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cipherSuite_ =
            cipherSuiteBuilder_ == null ? cipherSuite_ : cipherSuiteBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.detailedStatus_ = detailedStatus_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ikeVersion_ = ikeVersion_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        localTrafficSelector_.makeImmutable();
        result.localTrafficSelector_ = localTrafficSelector_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.peerExternalGateway_ = peerExternalGateway_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.peerExternalGatewayInterface_ = peerExternalGatewayInterface_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.peerGcpGateway_ = peerGcpGateway_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.peerIp_ = peerIp_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        remoteTrafficSelector_.makeImmutable();
        result.remoteTrafficSelector_ = remoteTrafficSelector_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.router_ = router_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.sharedSecret_ = sharedSecret_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.sharedSecretHash_ = sharedSecretHash_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.targetVpnGateway_ = targetVpnGateway_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.vpnGateway_ = vpnGateway_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.vpnGatewayInterface_ = vpnGatewayInterface_;
        to_bitField0_ |= 0x00200000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.VpnTunnel) {
        return mergeFrom((com.google.cloud.compute.v1.VpnTunnel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.VpnTunnel other) {
      if (other == com.google.cloud.compute.v1.VpnTunnel.getDefaultInstance()) return this;
      if (other.hasCipherSuite()) {
        mergeCipherSuite(other.getCipherSuite());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDetailedStatus()) {
        detailedStatus_ = other.detailedStatus_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIkeVersion()) {
        setIkeVersion(other.getIkeVersion());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000100;
      if (!other.localTrafficSelector_.isEmpty()) {
        if (localTrafficSelector_.isEmpty()) {
          localTrafficSelector_ = other.localTrafficSelector_;
          bitField0_ |= 0x00000200;
        } else {
          ensureLocalTrafficSelectorIsMutable();
          localTrafficSelector_.addAll(other.localTrafficSelector_);
        }
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasPeerExternalGateway()) {
        peerExternalGateway_ = other.peerExternalGateway_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasPeerExternalGatewayInterface()) {
        setPeerExternalGatewayInterface(other.getPeerExternalGatewayInterface());
      }
      if (other.hasPeerGcpGateway()) {
        peerGcpGateway_ = other.peerGcpGateway_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasPeerIp()) {
        peerIp_ = other.peerIp_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.remoteTrafficSelector_.isEmpty()) {
        if (remoteTrafficSelector_.isEmpty()) {
          remoteTrafficSelector_ = other.remoteTrafficSelector_;
          bitField0_ |= 0x00010000;
        } else {
          ensureRemoteTrafficSelectorIsMutable();
          remoteTrafficSelector_.addAll(other.remoteTrafficSelector_);
        }
        onChanged();
      }
      if (other.hasRouter()) {
        router_ = other.router_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasSharedSecret()) {
        sharedSecret_ = other.sharedSecret_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasSharedSecretHash()) {
        sharedSecretHash_ = other.sharedSecretHash_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasTargetVpnGateway()) {
        targetVpnGateway_ = other.targetVpnGateway_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasVpnGateway()) {
        vpnGateway_ = other.vpnGateway_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasVpnGatewayInterface()) {
        setVpnGatewayInterface(other.getVpnGatewayInterface());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 767832984:
              {
                vpnGatewayInterface_ = input.readInt32();
                bitField0_ |= 0x01000000;
                break;
              } // case 767832984
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 1111570338
            case 1188870730:
              {
                router_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1188870730
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1424998602
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 1450082194
            case 1747009760:
              {
                ikeVersion_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 1747009760
            case -2040027678:
              {
                peerGcpGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -2040027678
            case -1756450390:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocalTrafficSelectorIsMutable();
                localTrafficSelector_.add(s);
                break;
              } // case -1756450390
            case -1626959094:
              {
                detailedStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1626959094
            case -1423870510:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRemoteTrafficSelectorIsMutable();
                remoteTrafficSelector_.add(s);
                break;
              } // case -1423870510
            case -1239507374:
              {
                sharedSecret_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case -1239507374
            case -1228969694:
              {
                peerIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -1228969694
            case -1215317910:
              {
                peerExternalGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -1215317910
            case -1103912166:
              {
                sharedSecretHash_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case -1103912166
            case -1041494070:
              {
                vpnGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case -1041494070
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -744661470:
              {
                input.readMessage(getCipherSuiteFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -744661470
            case -672820168:
              {
                peerExternalGatewayInterface_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case -672820168
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -645248918
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case -293404678
            case -34864550:
              {
                targetVpnGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case -34864550
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.VpnTunnelCipherSuite cipherSuite_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.VpnTunnelCipherSuite,
            com.google.cloud.compute.v1.VpnTunnelCipherSuite.Builder,
            com.google.cloud.compute.v1.VpnTunnelCipherSuiteOrBuilder>
        cipherSuiteBuilder_;

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     *
     * @return Whether the cipherSuite field is set.
     */
    public boolean hasCipherSuite() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     *
     * @return The cipherSuite.
     */
    public com.google.cloud.compute.v1.VpnTunnelCipherSuite getCipherSuite() {
      if (cipherSuiteBuilder_ == null) {
        return cipherSuite_ == null
            ? com.google.cloud.compute.v1.VpnTunnelCipherSuite.getDefaultInstance()
            : cipherSuite_;
      } else {
        return cipherSuiteBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public Builder setCipherSuite(com.google.cloud.compute.v1.VpnTunnelCipherSuite value) {
      if (cipherSuiteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cipherSuite_ = value;
      } else {
        cipherSuiteBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public Builder setCipherSuite(
        com.google.cloud.compute.v1.VpnTunnelCipherSuite.Builder builderForValue) {
      if (cipherSuiteBuilder_ == null) {
        cipherSuite_ = builderForValue.build();
      } else {
        cipherSuiteBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public Builder mergeCipherSuite(com.google.cloud.compute.v1.VpnTunnelCipherSuite value) {
      if (cipherSuiteBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && cipherSuite_ != null
            && cipherSuite_
                != com.google.cloud.compute.v1.VpnTunnelCipherSuite.getDefaultInstance()) {
          getCipherSuiteBuilder().mergeFrom(value);
        } else {
          cipherSuite_ = value;
        }
      } else {
        cipherSuiteBuilder_.mergeFrom(value);
      }
      if (cipherSuite_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public Builder clearCipherSuite() {
      bitField0_ = (bitField0_ & ~0x00000001);
      cipherSuite_ = null;
      if (cipherSuiteBuilder_ != null) {
        cipherSuiteBuilder_.dispose();
        cipherSuiteBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public com.google.cloud.compute.v1.VpnTunnelCipherSuite.Builder getCipherSuiteBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCipherSuiteFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    public com.google.cloud.compute.v1.VpnTunnelCipherSuiteOrBuilder getCipherSuiteOrBuilder() {
      if (cipherSuiteBuilder_ != null) {
        return cipherSuiteBuilder_.getMessageOrBuilder();
      } else {
        return cipherSuite_ == null
            ? com.google.cloud.compute.v1.VpnTunnelCipherSuite.getDefaultInstance()
            : cipherSuite_;
      }
    }

    /**
     *
     *
     * <pre>
     * User specified list of ciphers to use for the phase 1 and phase 2 of the IKE protocol.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.VpnTunnelCipherSuite cipher_suite = 443788228;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.VpnTunnelCipherSuite,
            com.google.cloud.compute.v1.VpnTunnelCipherSuite.Builder,
            com.google.cloud.compute.v1.VpnTunnelCipherSuiteOrBuilder>
        getCipherSuiteFieldBuilder() {
      if (cipherSuiteBuilder_ == null) {
        cipherSuiteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.VpnTunnelCipherSuite,
                com.google.cloud.compute.v1.VpnTunnelCipherSuite.Builder,
                com.google.cloud.compute.v1.VpnTunnelCipherSuiteOrBuilder>(
                getCipherSuite(), getParentForChildren(), isClean());
        cipherSuite_ = null;
      }
      return cipherSuiteBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object detailedStatus_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @return Whether the detailedStatus field is set.
     */
    public boolean hasDetailedStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @return The detailedStatus.
     */
    public java.lang.String getDetailedStatus() {
      java.lang.Object ref = detailedStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detailedStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @return The bytes for detailedStatus.
     */
    public com.google.protobuf.ByteString getDetailedStatusBytes() {
      java.lang.Object ref = detailedStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detailedStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @param value The detailedStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detailedStatus_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetailedStatus() {
      detailedStatus_ = getDefaultInstance().getDetailedStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Detailed status message for the VPN tunnel.
     * </pre>
     *
     * <code>optional string detailed_status = 333501025;</code>
     *
     * @param value The bytes for detailedStatus to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detailedStatus_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private int ikeVersion_;

    /**
     *
     *
     * <pre>
     * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
     * </pre>
     *
     * <code>optional int32 ike_version = 218376220;</code>
     *
     * @return Whether the ikeVersion field is set.
     */
    @java.lang.Override
    public boolean hasIkeVersion() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
     * </pre>
     *
     * <code>optional int32 ike_version = 218376220;</code>
     *
     * @return The ikeVersion.
     */
    @java.lang.Override
    public int getIkeVersion() {
      return ikeVersion_;
    }

    /**
     *
     *
     * <pre>
     * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
     * </pre>
     *
     * <code>optional int32 ike_version = 218376220;</code>
     *
     * @param value The ikeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setIkeVersion(int value) {

      ikeVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
     * </pre>
     *
     * <code>optional int32 ike_version = 218376220;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIkeVersion() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ikeVersion_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this VpnTunnel, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a VpnTunnel.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000100;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList localTrafficSelector_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocalTrafficSelectorIsMutable() {
      if (!localTrafficSelector_.isModifiable()) {
        localTrafficSelector_ = new com.google.protobuf.LazyStringArrayList(localTrafficSelector_);
      }
      bitField0_ |= 0x00000200;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @return A list containing the localTrafficSelector.
     */
    public com.google.protobuf.ProtocolStringList getLocalTrafficSelectorList() {
      localTrafficSelector_.makeImmutable();
      return localTrafficSelector_;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @return The count of localTrafficSelector.
     */
    public int getLocalTrafficSelectorCount() {
      return localTrafficSelector_.size();
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param index The index of the element to return.
     * @return The localTrafficSelector at the given index.
     */
    public java.lang.String getLocalTrafficSelector(int index) {
      return localTrafficSelector_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the localTrafficSelector at the given index.
     */
    public com.google.protobuf.ByteString getLocalTrafficSelectorBytes(int index) {
      return localTrafficSelector_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param index The index to set the value at.
     * @param value The localTrafficSelector to set.
     * @return This builder for chaining.
     */
    public Builder setLocalTrafficSelector(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocalTrafficSelectorIsMutable();
      localTrafficSelector_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param value The localTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addLocalTrafficSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocalTrafficSelectorIsMutable();
      localTrafficSelector_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param values The localTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocalTrafficSelector(java.lang.Iterable<java.lang.String> values) {
      ensureLocalTrafficSelectorIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localTrafficSelector_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalTrafficSelector() {
      localTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string local_traffic_selector = 317314613;</code>
     *
     * @param value The bytes of the localTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addLocalTrafficSelectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocalTrafficSelectorIsMutable();
      localTrafficSelector_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object peerExternalGateway_ = "";

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return Whether the peerExternalGateway field is set.
     */
    public boolean hasPeerExternalGateway() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return The peerExternalGateway.
     */
    public java.lang.String getPeerExternalGateway() {
      java.lang.Object ref = peerExternalGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerExternalGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return The bytes for peerExternalGateway.
     */
    public com.google.protobuf.ByteString getPeerExternalGatewayBytes() {
      java.lang.Object ref = peerExternalGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerExternalGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @param value The peerExternalGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerExternalGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerExternalGateway_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerExternalGateway() {
      peerExternalGateway_ = getDefaultInstance().getPeerExternalGateway();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
     * </pre>
     *
     * <code>optional string peer_external_gateway = 384956173;</code>
     *
     * @param value The bytes for peerExternalGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerExternalGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerExternalGateway_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int peerExternalGatewayInterface_;

    /**
     *
     *
     * <pre>
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
     * </pre>
     *
     * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
     *
     * @return Whether the peerExternalGatewayInterface field is set.
     */
    @java.lang.Override
    public boolean hasPeerExternalGatewayInterface() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
     * </pre>
     *
     * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
     *
     * @return The peerExternalGatewayInterface.
     */
    @java.lang.Override
    public int getPeerExternalGatewayInterface() {
      return peerExternalGatewayInterface_;
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
     * </pre>
     *
     * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
     *
     * @param value The peerExternalGatewayInterface to set.
     * @return This builder for chaining.
     */
    public Builder setPeerExternalGatewayInterface(int value) {

      peerExternalGatewayInterface_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. Possible values are: `0`, `1`, `2`, `3`. The number of IDs in use depends on the external VPN gateway redundancy type.
     * </pre>
     *
     * <code>optional int32 peer_external_gateway_interface = 452768391;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerExternalGatewayInterface() {
      bitField0_ = (bitField0_ & ~0x00001000);
      peerExternalGatewayInterface_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object peerGcpGateway_ = "";

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return Whether the peerGcpGateway field is set.
     */
    public boolean hasPeerGcpGateway() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return The peerGcpGateway.
     */
    public java.lang.String getPeerGcpGateway() {
      java.lang.Object ref = peerGcpGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerGcpGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return The bytes for peerGcpGateway.
     */
    public com.google.protobuf.ByteString getPeerGcpGatewayBytes() {
      java.lang.Object ref = peerGcpGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerGcpGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @param value The peerGcpGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerGcpGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerGcpGateway_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerGcpGateway() {
      peerGcpGateway_ = getDefaultInstance().getPeerGcpGateway();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the peer side HA VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer Google Cloud VPN gateway.
     * </pre>
     *
     * <code>optional string peer_gcp_gateway = 281867452;</code>
     *
     * @param value The bytes for peerGcpGateway to set.
     * @return This builder for chaining.
     */
    public Builder setPeerGcpGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerGcpGateway_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object peerIp_ = "";

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @return Whether the peerIp field is set.
     */
    public boolean hasPeerIp() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @return The peerIp.
     */
    public java.lang.String getPeerIp() {
      java.lang.Object ref = peerIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @return The bytes for peerIp.
     */
    public com.google.protobuf.ByteString getPeerIpBytes() {
      java.lang.Object ref = peerIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @param value The peerIp to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIp_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIp() {
      peerIp_ = getDefaultInstance().getPeerIp();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the peer VPN gateway. Only IPv4 is supported. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string peer_ip = 383249700;</code>
     *
     * @param value The bytes for peerIp to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIp_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList remoteTrafficSelector_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRemoteTrafficSelectorIsMutable() {
      if (!remoteTrafficSelector_.isModifiable()) {
        remoteTrafficSelector_ =
            new com.google.protobuf.LazyStringArrayList(remoteTrafficSelector_);
      }
      bitField0_ |= 0x00010000;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @return A list containing the remoteTrafficSelector.
     */
    public com.google.protobuf.ProtocolStringList getRemoteTrafficSelectorList() {
      remoteTrafficSelector_.makeImmutable();
      return remoteTrafficSelector_;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @return The count of remoteTrafficSelector.
     */
    public int getRemoteTrafficSelectorCount() {
      return remoteTrafficSelector_.size();
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param index The index of the element to return.
     * @return The remoteTrafficSelector at the given index.
     */
    public java.lang.String getRemoteTrafficSelector(int index) {
      return remoteTrafficSelector_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the remoteTrafficSelector at the given index.
     */
    public com.google.protobuf.ByteString getRemoteTrafficSelectorBytes(int index) {
      return remoteTrafficSelector_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param index The index to set the value at.
     * @param value The remoteTrafficSelector to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteTrafficSelector(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRemoteTrafficSelectorIsMutable();
      remoteTrafficSelector_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param value The remoteTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addRemoteTrafficSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRemoteTrafficSelectorIsMutable();
      remoteTrafficSelector_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param values The remoteTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addAllRemoteTrafficSelector(java.lang.Iterable<java.lang.String> values) {
      ensureRemoteTrafficSelectorIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, remoteTrafficSelector_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteTrafficSelector() {
      remoteTrafficSelector_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported for Classic VPN tunnels. This field is output only for HA VPN tunnels.
     * </pre>
     *
     * <code>repeated string remote_traffic_selector = 358887098;</code>
     *
     * @param value The bytes of the remoteTrafficSelector to add.
     * @return This builder for chaining.
     */
    public Builder addRemoteTrafficSelectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRemoteTrafficSelectorIsMutable();
      remoteTrafficSelector_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object router_ = "";

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return Whether the router field is set.
     */
    public boolean hasRouter() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return The router.
     */
    public java.lang.String getRouter() {
      java.lang.Object ref = router_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        router_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return The bytes for router.
     */
    public com.google.protobuf.ByteString getRouterBytes() {
      java.lang.Object ref = router_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        router_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @param value The router to set.
     * @return This builder for chaining.
     */
    public Builder setRouter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      router_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouter() {
      router_ = getDefaultInstance().getRouter();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the router resource to be used for dynamic routing.
     * </pre>
     *
     * <code>optional string router = 148608841;</code>
     *
     * @param value The bytes for router to set.
     * @return This builder for chaining.
     */
    public Builder setRouterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      router_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object sharedSecret_ = "";

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return Whether the sharedSecret field is set.
     */
    public boolean hasSharedSecret() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return The sharedSecret.
     */
    public java.lang.String getSharedSecret() {
      java.lang.Object ref = sharedSecret_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sharedSecret_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return The bytes for sharedSecret.
     */
    public com.google.protobuf.ByteString getSharedSecretBytes() {
      java.lang.Object ref = sharedSecret_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sharedSecret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @param value The sharedSecret to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sharedSecret_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSharedSecret() {
      sharedSecret_ = getDefaultInstance().getSharedSecret();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @param value The bytes for sharedSecret to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sharedSecret_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object sharedSecretHash_ = "";

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @return Whether the sharedSecretHash field is set.
     */
    public boolean hasSharedSecretHash() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @return The sharedSecretHash.
     */
    public java.lang.String getSharedSecretHash() {
      java.lang.Object ref = sharedSecretHash_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sharedSecretHash_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @return The bytes for sharedSecretHash.
     */
    public com.google.protobuf.ByteString getSharedSecretHashBytes() {
      java.lang.Object ref = sharedSecretHash_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sharedSecretHash_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @param value The sharedSecretHash to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecretHash(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sharedSecretHash_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSharedSecretHash() {
      sharedSecretHash_ = getDefaultInstance().getSharedSecretHash();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Hash of the shared secret.
     * </pre>
     *
     * <code>optional string shared_secret_hash = 398881891;</code>
     *
     * @param value The bytes for sharedSecretHash to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecretHashBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sharedSecretHash_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object targetVpnGateway_ = "";

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @return Whether the targetVpnGateway field is set.
     */
    public boolean hasTargetVpnGateway() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @return The targetVpnGateway.
     */
    public java.lang.String getTargetVpnGateway() {
      java.lang.Object ref = targetVpnGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetVpnGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @return The bytes for targetVpnGateway.
     */
    public com.google.protobuf.ByteString getTargetVpnGatewayBytes() {
      java.lang.Object ref = targetVpnGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetVpnGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @param value The targetVpnGateway to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVpnGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetVpnGateway_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetVpnGateway() {
      targetVpnGateway_ = getDefaultInstance().getTargetVpnGateway();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This field can be set only for Classic VPN tunnels.
     * </pre>
     *
     * <code>optional string target_vpn_gateway = 532512843;</code>
     *
     * @param value The bytes for targetVpnGateway to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVpnGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetVpnGateway_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object vpnGateway_ = "";

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @return Whether the vpnGateway field is set.
     */
    public boolean hasVpnGateway() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @return The vpnGateway.
     */
    public java.lang.String getVpnGateway() {
      java.lang.Object ref = vpnGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpnGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @return The bytes for vpnGateway.
     */
    public com.google.protobuf.ByteString getVpnGatewayBytes() {
      java.lang.Object ref = vpnGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpnGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @param value The vpnGateway to set.
     * @return This builder for chaining.
     */
    public Builder setVpnGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vpnGateway_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpnGateway() {
      vpnGateway_ = getDefaultInstance().getVpnGateway();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
     * </pre>
     *
     * <code>optional string vpn_gateway = 406684153;</code>
     *
     * @param value The bytes for vpnGateway to set.
     * @return This builder for chaining.
     */
    public Builder setVpnGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vpnGateway_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private int vpnGatewayInterface_;

    /**
     *
     *
     * <pre>
     * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
     * </pre>
     *
     * <code>optional int32 vpn_gateway_interface = 95979123;</code>
     *
     * @return Whether the vpnGatewayInterface field is set.
     */
    @java.lang.Override
    public boolean hasVpnGatewayInterface() {
      return ((bitField0_ & 0x01000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
     * </pre>
     *
     * <code>optional int32 vpn_gateway_interface = 95979123;</code>
     *
     * @return The vpnGatewayInterface.
     */
    @java.lang.Override
    public int getVpnGatewayInterface() {
      return vpnGatewayInterface_;
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
     * </pre>
     *
     * <code>optional int32 vpn_gateway_interface = 95979123;</code>
     *
     * @param value The vpnGatewayInterface to set.
     * @return This builder for chaining.
     */
    public Builder setVpnGatewayInterface(int value) {

      vpnGatewayInterface_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The interface ID of the VPN gateway with which this VPN tunnel is associated. Possible values are: `0`, `1`.
     * </pre>
     *
     * <code>optional int32 vpn_gateway_interface = 95979123;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpnGatewayInterface() {
      bitField0_ = (bitField0_ & ~0x01000000);
      vpnGatewayInterface_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.VpnTunnel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.VpnTunnel)
  private static final com.google.cloud.compute.v1.VpnTunnel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.VpnTunnel();
  }

  public static com.google.cloud.compute.v1.VpnTunnel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VpnTunnel> PARSER =
      new com.google.protobuf.AbstractParser<VpnTunnel>() {
        @java.lang.Override
        public VpnTunnel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VpnTunnel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VpnTunnel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.VpnTunnel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
