/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Cloud Router resource. For more information about Cloud Router, read the Cloud Router overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Router}
 */
public final class Router extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Router)
    RouterOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Router.newBuilder() to construct.
  private Router(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Router() {
    bgpPeers_ = java.util.Collections.emptyList();
    creationTimestamp_ = "";
    description_ = "";
    interfaces_ = java.util.Collections.emptyList();
    kind_ = "";
    md5AuthenticationKeys_ = java.util.Collections.emptyList();
    name_ = "";
    nats_ = java.util.Collections.emptyList();
    network_ = "";
    region_ = "";
    selfLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Router();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Router_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Router_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Router.class,
            com.google.cloud.compute.v1.Router.Builder.class);
  }

  private int bitField0_;
  public static final int BGP_FIELD_NUMBER = 97483;
  private com.google.cloud.compute.v1.RouterBgp bgp_;

  /**
   *
   *
   * <pre>
   * BGP information specific to this router.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
   *
   * @return Whether the bgp field is set.
   */
  @java.lang.Override
  public boolean hasBgp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * BGP information specific to this router.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
   *
   * @return The bgp.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgp getBgp() {
    return bgp_ == null ? com.google.cloud.compute.v1.RouterBgp.getDefaultInstance() : bgp_;
  }

  /**
   *
   *
   * <pre>
   * BGP information specific to this router.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpOrBuilder getBgpOrBuilder() {
    return bgp_ == null ? com.google.cloud.compute.v1.RouterBgp.getDefaultInstance() : bgp_;
  }

  public static final int BGP_PEERS_FIELD_NUMBER = 452695773;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterBgpPeer> bgpPeers_;

  /**
   *
   *
   * <pre>
   * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterBgpPeer> getBgpPeersList() {
    return bgpPeers_;
  }

  /**
   *
   *
   * <pre>
   * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterBgpPeerOrBuilder>
      getBgpPeersOrBuilderList() {
    return bgpPeers_;
  }

  /**
   *
   *
   * <pre>
   * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
   */
  @java.lang.Override
  public int getBgpPeersCount() {
    return bgpPeers_.size();
  }

  /**
   *
   *
   * <pre>
   * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeer getBgpPeers(int index) {
    return bgpPeers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerOrBuilder getBgpPeersOrBuilder(int index) {
    return bgpPeers_.get(index);
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTED_INTERCONNECT_ROUTER_FIELD_NUMBER = 297996575;
  private boolean encryptedInterconnectRouter_ = false;

  /**
   *
   *
   * <pre>
   * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
   * </pre>
   *
   * <code>optional bool encrypted_interconnect_router = 297996575;</code>
   *
   * @return Whether the encryptedInterconnectRouter field is set.
   */
  @java.lang.Override
  public boolean hasEncryptedInterconnectRouter() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
   * </pre>
   *
   * <code>optional bool encrypted_interconnect_router = 297996575;</code>
   *
   * @return The encryptedInterconnectRouter.
   */
  @java.lang.Override
  public boolean getEncryptedInterconnectRouter() {
    return encryptedInterconnectRouter_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERFACES_FIELD_NUMBER = 12073562;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterInterface> interfaces_;

  /**
   *
   *
   * <pre>
   * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterInterface> getInterfacesList() {
    return interfaces_;
  }

  /**
   *
   *
   * <pre>
   * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterInterfaceOrBuilder>
      getInterfacesOrBuilderList() {
    return interfaces_;
  }

  /**
   *
   *
   * <pre>
   * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
   */
  @java.lang.Override
  public int getInterfacesCount() {
    return interfaces_.size();
  }

  /**
   *
   *
   * <pre>
   * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterInterface getInterfaces(int index) {
    return interfaces_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterInterfaceOrBuilder getInterfacesOrBuilder(int index) {
    return interfaces_.get(index);
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#router for routers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#router for routers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#router for routers.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MD5_AUTHENTICATION_KEYS_FIELD_NUMBER = 71063322;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterMd5AuthenticationKey>
      md5AuthenticationKeys_;

  /**
   *
   *
   * <pre>
   * Keys used for MD5 authentication.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterMd5AuthenticationKey>
      getMd5AuthenticationKeysList() {
    return md5AuthenticationKeys_;
  }

  /**
   *
   *
   * <pre>
   * Keys used for MD5 authentication.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder>
      getMd5AuthenticationKeysOrBuilderList() {
    return md5AuthenticationKeys_;
  }

  /**
   *
   *
   * <pre>
   * Keys used for MD5 authentication.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
   * </code>
   */
  @java.lang.Override
  public int getMd5AuthenticationKeysCount() {
    return md5AuthenticationKeys_.size();
  }

  /**
   *
   *
   * <pre>
   * Keys used for MD5 authentication.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterMd5AuthenticationKey getMd5AuthenticationKeys(
      int index) {
    return md5AuthenticationKeys_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Keys used for MD5 authentication.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder
      getMd5AuthenticationKeysOrBuilder(int index) {
    return md5AuthenticationKeys_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NATS_FIELD_NUMBER = 3373938;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterNat> nats_;

  /**
   *
   *
   * <pre>
   * A list of NAT services created in this router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterNat> getNatsList() {
    return nats_;
  }

  /**
   *
   *
   * <pre>
   * A list of NAT services created in this router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterNatOrBuilder>
      getNatsOrBuilderList() {
    return nats_;
  }

  /**
   *
   *
   * <pre>
   * A list of NAT services created in this router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
   */
  @java.lang.Override
  public int getNatsCount() {
    return nats_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of NAT services created in this router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNat getNats(int index) {
    return nats_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of NAT services created in this router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatOrBuilder getNatsOrBuilder(int index) {
    return nats_.get(index);
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 78313862;
  private com.google.cloud.compute.v1.RouterParams params_;

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterParams getParams() {
    return params_ == null
        ? com.google.cloud.compute.v1.RouterParams.getDefaultInstance()
        : params_;
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterParamsOrBuilder getParamsOrBuilder() {
    return params_ == null
        ? com.google.cloud.compute.v1.RouterParams.getDefaultInstance()
        : params_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(97483, getBgp());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < nats_.size(); i++) {
      output.writeMessage(3373938, nats_.get(i));
    }
    for (int i = 0; i < interfaces_.size(); i++) {
      output.writeMessage(12073562, interfaces_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    for (int i = 0; i < md5AuthenticationKeys_.size(); i++) {
      output.writeMessage(71063322, md5AuthenticationKeys_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(78313862, getParams());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(297996575, encryptedInterconnectRouter_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < bgpPeers_.size(); i++) {
      output.writeMessage(452695773, bgpPeers_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(97483, getBgp());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    for (int i = 0; i < nats_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3373938, nats_.get(i));
    }
    for (int i = 0; i < interfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12073562, interfaces_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    for (int i = 0; i < md5AuthenticationKeys_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              71063322, md5AuthenticationKeys_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(78313862, getParams());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              297996575, encryptedInterconnectRouter_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < bgpPeers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(452695773, bgpPeers_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Router)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Router other = (com.google.cloud.compute.v1.Router) obj;

    if (hasBgp() != other.hasBgp()) return false;
    if (hasBgp()) {
      if (!getBgp().equals(other.getBgp())) return false;
    }
    if (!getBgpPeersList().equals(other.getBgpPeersList())) return false;
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEncryptedInterconnectRouter() != other.hasEncryptedInterconnectRouter()) return false;
    if (hasEncryptedInterconnectRouter()) {
      if (getEncryptedInterconnectRouter() != other.getEncryptedInterconnectRouter()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (!getInterfacesList().equals(other.getInterfacesList())) return false;
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (!getMd5AuthenticationKeysList().equals(other.getMd5AuthenticationKeysList())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getNatsList().equals(other.getNatsList())) return false;
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBgp()) {
      hash = (37 * hash) + BGP_FIELD_NUMBER;
      hash = (53 * hash) + getBgp().hashCode();
    }
    if (getBgpPeersCount() > 0) {
      hash = (37 * hash) + BGP_PEERS_FIELD_NUMBER;
      hash = (53 * hash) + getBgpPeersList().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEncryptedInterconnectRouter()) {
      hash = (37 * hash) + ENCRYPTED_INTERCONNECT_ROUTER_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEncryptedInterconnectRouter());
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (getInterfacesCount() > 0) {
      hash = (37 * hash) + INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getInterfacesList().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (getMd5AuthenticationKeysCount() > 0) {
      hash = (37 * hash) + MD5_AUTHENTICATION_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getMd5AuthenticationKeysList().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getNatsCount() > 0) {
      hash = (37 * hash) + NATS_FIELD_NUMBER;
      hash = (53 * hash) + getNatsList().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Router parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Router parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Router parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Router parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Router prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Cloud Router resource. For more information about Cloud Router, read the Cloud Router overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Router}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Router)
      com.google.cloud.compute.v1.RouterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Router_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Router_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Router.class,
              com.google.cloud.compute.v1.Router.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Router.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBgpFieldBuilder();
        getBgpPeersFieldBuilder();
        getInterfacesFieldBuilder();
        getMd5AuthenticationKeysFieldBuilder();
        getNatsFieldBuilder();
        getParamsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bgp_ = null;
      if (bgpBuilder_ != null) {
        bgpBuilder_.dispose();
        bgpBuilder_ = null;
      }
      if (bgpPeersBuilder_ == null) {
        bgpPeers_ = java.util.Collections.emptyList();
      } else {
        bgpPeers_ = null;
        bgpPeersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      creationTimestamp_ = "";
      description_ = "";
      encryptedInterconnectRouter_ = false;
      id_ = 0L;
      if (interfacesBuilder_ == null) {
        interfaces_ = java.util.Collections.emptyList();
      } else {
        interfaces_ = null;
        interfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      kind_ = "";
      if (md5AuthenticationKeysBuilder_ == null) {
        md5AuthenticationKeys_ = java.util.Collections.emptyList();
      } else {
        md5AuthenticationKeys_ = null;
        md5AuthenticationKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      name_ = "";
      if (natsBuilder_ == null) {
        nats_ = java.util.Collections.emptyList();
      } else {
        nats_ = null;
        natsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      network_ = "";
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      region_ = "";
      selfLink_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Router_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Router getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Router.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Router build() {
      com.google.cloud.compute.v1.Router result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Router buildPartial() {
      com.google.cloud.compute.v1.Router result = new com.google.cloud.compute.v1.Router(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Router result) {
      if (bgpPeersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bgpPeers_ = java.util.Collections.unmodifiableList(bgpPeers_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bgpPeers_ = bgpPeers_;
      } else {
        result.bgpPeers_ = bgpPeersBuilder_.build();
      }
      if (interfacesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          interfaces_ = java.util.Collections.unmodifiableList(interfaces_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.interfaces_ = interfaces_;
      } else {
        result.interfaces_ = interfacesBuilder_.build();
      }
      if (md5AuthenticationKeysBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          md5AuthenticationKeys_ = java.util.Collections.unmodifiableList(md5AuthenticationKeys_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.md5AuthenticationKeys_ = md5AuthenticationKeys_;
      } else {
        result.md5AuthenticationKeys_ = md5AuthenticationKeysBuilder_.build();
      }
      if (natsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          nats_ = java.util.Collections.unmodifiableList(nats_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.nats_ = nats_;
      } else {
        result.nats_ = natsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Router result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bgp_ = bgpBuilder_ == null ? bgp_ : bgpBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.encryptedInterconnectRouter_ = encryptedInterconnectRouter_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Router) {
        return mergeFrom((com.google.cloud.compute.v1.Router) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Router other) {
      if (other == com.google.cloud.compute.v1.Router.getDefaultInstance()) return this;
      if (other.hasBgp()) {
        mergeBgp(other.getBgp());
      }
      if (bgpPeersBuilder_ == null) {
        if (!other.bgpPeers_.isEmpty()) {
          if (bgpPeers_.isEmpty()) {
            bgpPeers_ = other.bgpPeers_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBgpPeersIsMutable();
            bgpPeers_.addAll(other.bgpPeers_);
          }
          onChanged();
        }
      } else {
        if (!other.bgpPeers_.isEmpty()) {
          if (bgpPeersBuilder_.isEmpty()) {
            bgpPeersBuilder_.dispose();
            bgpPeersBuilder_ = null;
            bgpPeers_ = other.bgpPeers_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bgpPeersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBgpPeersFieldBuilder()
                    : null;
          } else {
            bgpPeersBuilder_.addAllMessages(other.bgpPeers_);
          }
        }
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEncryptedInterconnectRouter()) {
        setEncryptedInterconnectRouter(other.getEncryptedInterconnectRouter());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (interfacesBuilder_ == null) {
        if (!other.interfaces_.isEmpty()) {
          if (interfaces_.isEmpty()) {
            interfaces_ = other.interfaces_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureInterfacesIsMutable();
            interfaces_.addAll(other.interfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.interfaces_.isEmpty()) {
          if (interfacesBuilder_.isEmpty()) {
            interfacesBuilder_.dispose();
            interfacesBuilder_ = null;
            interfaces_ = other.interfaces_;
            bitField0_ = (bitField0_ & ~0x00000040);
            interfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInterfacesFieldBuilder()
                    : null;
          } else {
            interfacesBuilder_.addAllMessages(other.interfaces_);
          }
        }
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (md5AuthenticationKeysBuilder_ == null) {
        if (!other.md5AuthenticationKeys_.isEmpty()) {
          if (md5AuthenticationKeys_.isEmpty()) {
            md5AuthenticationKeys_ = other.md5AuthenticationKeys_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureMd5AuthenticationKeysIsMutable();
            md5AuthenticationKeys_.addAll(other.md5AuthenticationKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.md5AuthenticationKeys_.isEmpty()) {
          if (md5AuthenticationKeysBuilder_.isEmpty()) {
            md5AuthenticationKeysBuilder_.dispose();
            md5AuthenticationKeysBuilder_ = null;
            md5AuthenticationKeys_ = other.md5AuthenticationKeys_;
            bitField0_ = (bitField0_ & ~0x00000100);
            md5AuthenticationKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMd5AuthenticationKeysFieldBuilder()
                    : null;
          } else {
            md5AuthenticationKeysBuilder_.addAllMessages(other.md5AuthenticationKeys_);
          }
        }
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (natsBuilder_ == null) {
        if (!other.nats_.isEmpty()) {
          if (nats_.isEmpty()) {
            nats_ = other.nats_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureNatsIsMutable();
            nats_.addAll(other.nats_);
          }
          onChanged();
        }
      } else {
        if (!other.nats_.isEmpty()) {
          if (natsBuilder_.isEmpty()) {
            natsBuilder_.dispose();
            natsBuilder_ = null;
            nats_ = other.nats_;
            bitField0_ = (bitField0_ & ~0x00000400);
            natsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNatsFieldBuilder()
                    : null;
          } else {
            natsBuilder_.addAllMessages(other.nats_);
          }
        }
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 779866:
              {
                input.readMessage(getBgpFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 779866
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 26991506:
              {
                com.google.cloud.compute.v1.RouterNat m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterNat.parser(), extensionRegistry);
                if (natsBuilder_ == null) {
                  ensureNatsIsMutable();
                  nats_.add(m);
                } else {
                  natsBuilder_.addMessage(m);
                }
                break;
              } // case 26991506
            case 96588498:
              {
                com.google.cloud.compute.v1.RouterInterface m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterInterface.parser(), extensionRegistry);
                if (interfacesBuilder_ == null) {
                  ensureInterfacesIsMutable();
                  interfaces_.add(m);
                } else {
                  interfacesBuilder_.addMessage(m);
                }
                break;
              } // case 96588498
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 568506578:
              {
                com.google.cloud.compute.v1.RouterMd5AuthenticationKey m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterMd5AuthenticationKey.parser(),
                        extensionRegistry);
                if (md5AuthenticationKeysBuilder_ == null) {
                  ensureMd5AuthenticationKeysIsMutable();
                  md5AuthenticationKeys_.add(m);
                } else {
                  md5AuthenticationKeysBuilder_.addMessage(m);
                }
                break;
              } // case 568506578
            case 626510898:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 626510898
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1111570338
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1862979954
            case -1910994696:
              {
                encryptedInterconnectRouter_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case -1910994696
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -673401110:
              {
                com.google.cloud.compute.v1.RouterBgpPeer m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterBgpPeer.parser(), extensionRegistry);
                if (bgpPeersBuilder_ == null) {
                  ensureBgpPeersIsMutable();
                  bgpPeers_.add(m);
                } else {
                  bgpPeersBuilder_.addMessage(m);
                }
                break;
              } // case -673401110
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.RouterBgp bgp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgp,
            com.google.cloud.compute.v1.RouterBgp.Builder,
            com.google.cloud.compute.v1.RouterBgpOrBuilder>
        bgpBuilder_;

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     *
     * @return Whether the bgp field is set.
     */
    public boolean hasBgp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     *
     * @return The bgp.
     */
    public com.google.cloud.compute.v1.RouterBgp getBgp() {
      if (bgpBuilder_ == null) {
        return bgp_ == null ? com.google.cloud.compute.v1.RouterBgp.getDefaultInstance() : bgp_;
      } else {
        return bgpBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public Builder setBgp(com.google.cloud.compute.v1.RouterBgp value) {
      if (bgpBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bgp_ = value;
      } else {
        bgpBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public Builder setBgp(com.google.cloud.compute.v1.RouterBgp.Builder builderForValue) {
      if (bgpBuilder_ == null) {
        bgp_ = builderForValue.build();
      } else {
        bgpBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public Builder mergeBgp(com.google.cloud.compute.v1.RouterBgp value) {
      if (bgpBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && bgp_ != null
            && bgp_ != com.google.cloud.compute.v1.RouterBgp.getDefaultInstance()) {
          getBgpBuilder().mergeFrom(value);
        } else {
          bgp_ = value;
        }
      } else {
        bgpBuilder_.mergeFrom(value);
      }
      if (bgp_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public Builder clearBgp() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bgp_ = null;
      if (bgpBuilder_ != null) {
        bgpBuilder_.dispose();
        bgpBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public com.google.cloud.compute.v1.RouterBgp.Builder getBgpBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBgpFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpOrBuilder getBgpOrBuilder() {
      if (bgpBuilder_ != null) {
        return bgpBuilder_.getMessageOrBuilder();
      } else {
        return bgp_ == null ? com.google.cloud.compute.v1.RouterBgp.getDefaultInstance() : bgp_;
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information specific to this router.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgp bgp = 97483;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgp,
            com.google.cloud.compute.v1.RouterBgp.Builder,
            com.google.cloud.compute.v1.RouterBgpOrBuilder>
        getBgpFieldBuilder() {
      if (bgpBuilder_ == null) {
        bgpBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RouterBgp,
                com.google.cloud.compute.v1.RouterBgp.Builder,
                com.google.cloud.compute.v1.RouterBgpOrBuilder>(
                getBgp(), getParentForChildren(), isClean());
        bgp_ = null;
      }
      return bgpBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterBgpPeer> bgpPeers_ =
        java.util.Collections.emptyList();

    private void ensureBgpPeersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bgpPeers_ = new java.util.ArrayList<com.google.cloud.compute.v1.RouterBgpPeer>(bgpPeers_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeer,
            com.google.cloud.compute.v1.RouterBgpPeer.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerOrBuilder>
        bgpPeersBuilder_;

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterBgpPeer> getBgpPeersList() {
      if (bgpPeersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bgpPeers_);
      } else {
        return bgpPeersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public int getBgpPeersCount() {
      if (bgpPeersBuilder_ == null) {
        return bgpPeers_.size();
      } else {
        return bgpPeersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeer getBgpPeers(int index) {
      if (bgpPeersBuilder_ == null) {
        return bgpPeers_.get(index);
      } else {
        return bgpPeersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder setBgpPeers(int index, com.google.cloud.compute.v1.RouterBgpPeer value) {
      if (bgpPeersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeersIsMutable();
        bgpPeers_.set(index, value);
        onChanged();
      } else {
        bgpPeersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder setBgpPeers(
        int index, com.google.cloud.compute.v1.RouterBgpPeer.Builder builderForValue) {
      if (bgpPeersBuilder_ == null) {
        ensureBgpPeersIsMutable();
        bgpPeers_.set(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder addBgpPeers(com.google.cloud.compute.v1.RouterBgpPeer value) {
      if (bgpPeersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeersIsMutable();
        bgpPeers_.add(value);
        onChanged();
      } else {
        bgpPeersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder addBgpPeers(int index, com.google.cloud.compute.v1.RouterBgpPeer value) {
      if (bgpPeersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeersIsMutable();
        bgpPeers_.add(index, value);
        onChanged();
      } else {
        bgpPeersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder addBgpPeers(com.google.cloud.compute.v1.RouterBgpPeer.Builder builderForValue) {
      if (bgpPeersBuilder_ == null) {
        ensureBgpPeersIsMutable();
        bgpPeers_.add(builderForValue.build());
        onChanged();
      } else {
        bgpPeersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder addBgpPeers(
        int index, com.google.cloud.compute.v1.RouterBgpPeer.Builder builderForValue) {
      if (bgpPeersBuilder_ == null) {
        ensureBgpPeersIsMutable();
        bgpPeers_.add(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder addAllBgpPeers(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterBgpPeer> values) {
      if (bgpPeersBuilder_ == null) {
        ensureBgpPeersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bgpPeers_);
        onChanged();
      } else {
        bgpPeersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder clearBgpPeers() {
      if (bgpPeersBuilder_ == null) {
        bgpPeers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bgpPeersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public Builder removeBgpPeers(int index) {
      if (bgpPeersBuilder_ == null) {
        ensureBgpPeersIsMutable();
        bgpPeers_.remove(index);
        onChanged();
      } else {
        bgpPeersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeer.Builder getBgpPeersBuilder(int index) {
      return getBgpPeersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerOrBuilder getBgpPeersOrBuilder(int index) {
      if (bgpPeersBuilder_ == null) {
        return bgpPeers_.get(index);
      } else {
        return bgpPeersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterBgpPeerOrBuilder>
        getBgpPeersOrBuilderList() {
      if (bgpPeersBuilder_ != null) {
        return bgpPeersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bgpPeers_);
      }
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeer.Builder addBgpPeersBuilder() {
      return getBgpPeersFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterBgpPeer.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeer.Builder addBgpPeersBuilder(int index) {
      return getBgpPeersFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.RouterBgpPeer.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * BGP information that must be configured into the routing stack to establish BGP peering. This information must specify the peer ASN and either the interface name, IP address, or peer IP address. Please refer to RFC4273.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterBgpPeer bgp_peers = 452695773;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterBgpPeer.Builder>
        getBgpPeersBuilderList() {
      return getBgpPeersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeer,
            com.google.cloud.compute.v1.RouterBgpPeer.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerOrBuilder>
        getBgpPeersFieldBuilder() {
      if (bgpPeersBuilder_ == null) {
        bgpPeersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterBgpPeer,
                com.google.cloud.compute.v1.RouterBgpPeer.Builder,
                com.google.cloud.compute.v1.RouterBgpPeerOrBuilder>(
                bgpPeers_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        bgpPeers_ = null;
      }
      return bgpPeersBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean encryptedInterconnectRouter_;

    /**
     *
     *
     * <pre>
     * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
     * </pre>
     *
     * <code>optional bool encrypted_interconnect_router = 297996575;</code>
     *
     * @return Whether the encryptedInterconnectRouter field is set.
     */
    @java.lang.Override
    public boolean hasEncryptedInterconnectRouter() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
     * </pre>
     *
     * <code>optional bool encrypted_interconnect_router = 297996575;</code>
     *
     * @return The encryptedInterconnectRouter.
     */
    @java.lang.Override
    public boolean getEncryptedInterconnectRouter() {
      return encryptedInterconnectRouter_;
    }

    /**
     *
     *
     * <pre>
     * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
     * </pre>
     *
     * <code>optional bool encrypted_interconnect_router = 297996575;</code>
     *
     * @param value The encryptedInterconnectRouter to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptedInterconnectRouter(boolean value) {

      encryptedInterconnectRouter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates if a router is dedicated for use with encrypted VLAN attachments (interconnectAttachments).
     * </pre>
     *
     * <code>optional bool encrypted_interconnect_router = 297996575;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptedInterconnectRouter() {
      bitField0_ = (bitField0_ & ~0x00000010);
      encryptedInterconnectRouter_ = false;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterInterface> interfaces_ =
        java.util.Collections.emptyList();

    private void ensureInterfacesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        interfaces_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterInterface>(interfaces_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterInterface,
            com.google.cloud.compute.v1.RouterInterface.Builder,
            com.google.cloud.compute.v1.RouterInterfaceOrBuilder>
        interfacesBuilder_;

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterInterface> getInterfacesList() {
      if (interfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(interfaces_);
      } else {
        return interfacesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public int getInterfacesCount() {
      if (interfacesBuilder_ == null) {
        return interfaces_.size();
      } else {
        return interfacesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public com.google.cloud.compute.v1.RouterInterface getInterfaces(int index) {
      if (interfacesBuilder_ == null) {
        return interfaces_.get(index);
      } else {
        return interfacesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder setInterfaces(int index, com.google.cloud.compute.v1.RouterInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.set(index, value);
        onChanged();
      } else {
        interfacesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder setInterfaces(
        int index, com.google.cloud.compute.v1.RouterInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder addInterfaces(com.google.cloud.compute.v1.RouterInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.add(value);
        onChanged();
      } else {
        interfacesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder addInterfaces(int index, com.google.cloud.compute.v1.RouterInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.add(index, value);
        onChanged();
      } else {
        interfacesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder addInterfaces(
        com.google.cloud.compute.v1.RouterInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.add(builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder addInterfaces(
        int index, com.google.cloud.compute.v1.RouterInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder addAllInterfaces(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterInterface> values) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, interfaces_);
        onChanged();
      } else {
        interfacesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder clearInterfaces() {
      if (interfacesBuilder_ == null) {
        interfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        interfacesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public Builder removeInterfaces(int index) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.remove(index);
        onChanged();
      } else {
        interfacesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public com.google.cloud.compute.v1.RouterInterface.Builder getInterfacesBuilder(int index) {
      return getInterfacesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public com.google.cloud.compute.v1.RouterInterfaceOrBuilder getInterfacesOrBuilder(int index) {
      if (interfacesBuilder_ == null) {
        return interfaces_.get(index);
      } else {
        return interfacesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterInterfaceOrBuilder>
        getInterfacesOrBuilderList() {
      if (interfacesBuilder_ != null) {
        return interfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(interfaces_);
      }
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public com.google.cloud.compute.v1.RouterInterface.Builder addInterfacesBuilder() {
      return getInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public com.google.cloud.compute.v1.RouterInterface.Builder addInterfacesBuilder(int index) {
      return getInterfacesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.RouterInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Router interfaces. To create a BGP peer that uses a router interface, the interface must have one of the following fields specified: - linkedVpnTunnel - linkedInterconnectAttachment - subnetwork You can create a router interface without any of these fields specified. However, you cannot create a BGP peer that uses that interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterInterface interfaces = 12073562;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterInterface.Builder>
        getInterfacesBuilderList() {
      return getInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterInterface,
            com.google.cloud.compute.v1.RouterInterface.Builder,
            com.google.cloud.compute.v1.RouterInterfaceOrBuilder>
        getInterfacesFieldBuilder() {
      if (interfacesBuilder_ == null) {
        interfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterInterface,
                com.google.cloud.compute.v1.RouterInterface.Builder,
                com.google.cloud.compute.v1.RouterInterfaceOrBuilder>(
                interfaces_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        interfaces_ = null;
      }
      return interfacesBuilder_;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#router for routers.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterMd5AuthenticationKey>
        md5AuthenticationKeys_ = java.util.Collections.emptyList();

    private void ensureMd5AuthenticationKeysIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        md5AuthenticationKeys_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterMd5AuthenticationKey>(
                md5AuthenticationKeys_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterMd5AuthenticationKey,
            com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder,
            com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder>
        md5AuthenticationKeysBuilder_;

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterMd5AuthenticationKey>
        getMd5AuthenticationKeysList() {
      if (md5AuthenticationKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(md5AuthenticationKeys_);
      } else {
        return md5AuthenticationKeysBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public int getMd5AuthenticationKeysCount() {
      if (md5AuthenticationKeysBuilder_ == null) {
        return md5AuthenticationKeys_.size();
      } else {
        return md5AuthenticationKeysBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterMd5AuthenticationKey getMd5AuthenticationKeys(
        int index) {
      if (md5AuthenticationKeysBuilder_ == null) {
        return md5AuthenticationKeys_.get(index);
      } else {
        return md5AuthenticationKeysBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder setMd5AuthenticationKeys(
        int index, com.google.cloud.compute.v1.RouterMd5AuthenticationKey value) {
      if (md5AuthenticationKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.set(index, value);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder setMd5AuthenticationKeys(
        int index, com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder builderForValue) {
      if (md5AuthenticationKeysBuilder_ == null) {
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder addMd5AuthenticationKeys(
        com.google.cloud.compute.v1.RouterMd5AuthenticationKey value) {
      if (md5AuthenticationKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.add(value);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder addMd5AuthenticationKeys(
        int index, com.google.cloud.compute.v1.RouterMd5AuthenticationKey value) {
      if (md5AuthenticationKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.add(index, value);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder addMd5AuthenticationKeys(
        com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder builderForValue) {
      if (md5AuthenticationKeysBuilder_ == null) {
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.add(builderForValue.build());
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder addMd5AuthenticationKeys(
        int index, com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder builderForValue) {
      if (md5AuthenticationKeysBuilder_ == null) {
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder addAllMd5AuthenticationKeys(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterMd5AuthenticationKey>
            values) {
      if (md5AuthenticationKeysBuilder_ == null) {
        ensureMd5AuthenticationKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, md5AuthenticationKeys_);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder clearMd5AuthenticationKeys() {
      if (md5AuthenticationKeysBuilder_ == null) {
        md5AuthenticationKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public Builder removeMd5AuthenticationKeys(int index) {
      if (md5AuthenticationKeysBuilder_ == null) {
        ensureMd5AuthenticationKeysIsMutable();
        md5AuthenticationKeys_.remove(index);
        onChanged();
      } else {
        md5AuthenticationKeysBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder
        getMd5AuthenticationKeysBuilder(int index) {
      return getMd5AuthenticationKeysFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder
        getMd5AuthenticationKeysOrBuilder(int index) {
      if (md5AuthenticationKeysBuilder_ == null) {
        return md5AuthenticationKeys_.get(index);
      } else {
        return md5AuthenticationKeysBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder>
        getMd5AuthenticationKeysOrBuilderList() {
      if (md5AuthenticationKeysBuilder_ != null) {
        return md5AuthenticationKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(md5AuthenticationKeys_);
      }
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder
        addMd5AuthenticationKeysBuilder() {
      return getMd5AuthenticationKeysFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterMd5AuthenticationKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder
        addMd5AuthenticationKeysBuilder(int index) {
      return getMd5AuthenticationKeysFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterMd5AuthenticationKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Keys used for MD5 authentication.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterMd5AuthenticationKey md5_authentication_keys = 71063322;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder>
        getMd5AuthenticationKeysBuilderList() {
      return getMd5AuthenticationKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterMd5AuthenticationKey,
            com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder,
            com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder>
        getMd5AuthenticationKeysFieldBuilder() {
      if (md5AuthenticationKeysBuilder_ == null) {
        md5AuthenticationKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterMd5AuthenticationKey,
                com.google.cloud.compute.v1.RouterMd5AuthenticationKey.Builder,
                com.google.cloud.compute.v1.RouterMd5AuthenticationKeyOrBuilder>(
                md5AuthenticationKeys_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        md5AuthenticationKeys_ = null;
      }
      return md5AuthenticationKeysBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterNat> nats_ =
        java.util.Collections.emptyList();

    private void ensureNatsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        nats_ = new java.util.ArrayList<com.google.cloud.compute.v1.RouterNat>(nats_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNat,
            com.google.cloud.compute.v1.RouterNat.Builder,
            com.google.cloud.compute.v1.RouterNatOrBuilder>
        natsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNat> getNatsList() {
      if (natsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nats_);
      } else {
        return natsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public int getNatsCount() {
      if (natsBuilder_ == null) {
        return nats_.size();
      } else {
        return natsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public com.google.cloud.compute.v1.RouterNat getNats(int index) {
      if (natsBuilder_ == null) {
        return nats_.get(index);
      } else {
        return natsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder setNats(int index, com.google.cloud.compute.v1.RouterNat value) {
      if (natsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatsIsMutable();
        nats_.set(index, value);
        onChanged();
      } else {
        natsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder setNats(
        int index, com.google.cloud.compute.v1.RouterNat.Builder builderForValue) {
      if (natsBuilder_ == null) {
        ensureNatsIsMutable();
        nats_.set(index, builderForValue.build());
        onChanged();
      } else {
        natsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder addNats(com.google.cloud.compute.v1.RouterNat value) {
      if (natsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatsIsMutable();
        nats_.add(value);
        onChanged();
      } else {
        natsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder addNats(int index, com.google.cloud.compute.v1.RouterNat value) {
      if (natsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatsIsMutable();
        nats_.add(index, value);
        onChanged();
      } else {
        natsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder addNats(com.google.cloud.compute.v1.RouterNat.Builder builderForValue) {
      if (natsBuilder_ == null) {
        ensureNatsIsMutable();
        nats_.add(builderForValue.build());
        onChanged();
      } else {
        natsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder addNats(
        int index, com.google.cloud.compute.v1.RouterNat.Builder builderForValue) {
      if (natsBuilder_ == null) {
        ensureNatsIsMutable();
        nats_.add(index, builderForValue.build());
        onChanged();
      } else {
        natsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder addAllNats(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterNat> values) {
      if (natsBuilder_ == null) {
        ensureNatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nats_);
        onChanged();
      } else {
        natsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder clearNats() {
      if (natsBuilder_ == null) {
        nats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        natsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public Builder removeNats(int index) {
      if (natsBuilder_ == null) {
        ensureNatsIsMutable();
        nats_.remove(index);
        onChanged();
      } else {
        natsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public com.google.cloud.compute.v1.RouterNat.Builder getNatsBuilder(int index) {
      return getNatsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public com.google.cloud.compute.v1.RouterNatOrBuilder getNatsOrBuilder(int index) {
      if (natsBuilder_ == null) {
        return nats_.get(index);
      } else {
        return natsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterNatOrBuilder>
        getNatsOrBuilderList() {
      if (natsBuilder_ != null) {
        return natsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nats_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public com.google.cloud.compute.v1.RouterNat.Builder addNatsBuilder() {
      return getNatsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterNat.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public com.google.cloud.compute.v1.RouterNat.Builder addNatsBuilder(int index) {
      return getNatsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.RouterNat.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of NAT services created in this router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNat nats = 3373938;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNat.Builder> getNatsBuilderList() {
      return getNatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNat,
            com.google.cloud.compute.v1.RouterNat.Builder,
            com.google.cloud.compute.v1.RouterNatOrBuilder>
        getNatsFieldBuilder() {
      if (natsBuilder_ == null) {
        natsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNat,
                com.google.cloud.compute.v1.RouterNat.Builder,
                com.google.cloud.compute.v1.RouterNatOrBuilder>(
                nats_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        nats_ = null;
      }
      return natsBuilder_;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.RouterParams params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterParams,
            com.google.cloud.compute.v1.RouterParams.Builder,
            com.google.cloud.compute.v1.RouterParamsOrBuilder>
        paramsBuilder_;

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     *
     * @return The params.
     */
    public com.google.cloud.compute.v1.RouterParams getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null
            ? com.google.cloud.compute.v1.RouterParams.getDefaultInstance()
            : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.RouterParams value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.RouterParams.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public Builder mergeParams(com.google.cloud.compute.v1.RouterParams value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && params_ != null
            && params_ != com.google.cloud.compute.v1.RouterParams.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00001000);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.RouterParams.Builder getParamsBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.RouterParamsOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null
            ? com.google.cloud.compute.v1.RouterParams.getDefaultInstance()
            : params_;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterParams params = 78313862;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterParams,
            com.google.cloud.compute.v1.RouterParams.Builder,
            com.google.cloud.compute.v1.RouterParamsOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RouterParams,
                com.google.cloud.compute.v1.RouterParams.Builder,
                com.google.cloud.compute.v1.RouterParamsOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URI of the region where the router resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Router)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Router)
  private static final com.google.cloud.compute.v1.Router DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Router();
  }

  public static com.google.cloud.compute.v1.Router getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Router> PARSER =
      new com.google.protobuf.AbstractParser<Router>() {
        @java.lang.Override
        public Router parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Router> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Router> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Router getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
