/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents the workload policy.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ResourcePolicyWorkloadPolicy}
 */
public final class ResourcePolicyWorkloadPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy)
    ResourcePolicyWorkloadPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ResourcePolicyWorkloadPolicy.newBuilder() to construct.
  private ResourcePolicyWorkloadPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePolicyWorkloadPolicy() {
    acceleratorTopology_ = "";
    maxTopologyDistance_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePolicyWorkloadPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicyWorkloadPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicyWorkloadPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.class,
            com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the maximum distance between instances.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.MaxTopologyDistance}
   */
  public enum MaxTopologyDistance implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAX_TOPOLOGY_DISTANCE = 0;</code>
     */
    UNDEFINED_MAX_TOPOLOGY_DISTANCE(0),
    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same block.
     * </pre>
     *
     * <code>BLOCK = 63294573;</code>
     */
    BLOCK(63294573),
    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same cluster.
     * </pre>
     *
     * <code>CLUSTER = 516333018;</code>
     */
    CLUSTER(516333018),
    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same subblock.
     * </pre>
     *
     * <code>SUBBLOCK = 316202573;</code>
     */
    SUBBLOCK(316202573),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAX_TOPOLOGY_DISTANCE = 0;</code>
     */
    public static final int UNDEFINED_MAX_TOPOLOGY_DISTANCE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same block.
     * </pre>
     *
     * <code>BLOCK = 63294573;</code>
     */
    public static final int BLOCK_VALUE = 63294573;

    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same cluster.
     * </pre>
     *
     * <code>CLUSTER = 516333018;</code>
     */
    public static final int CLUSTER_VALUE = 516333018;

    /**
     *
     *
     * <pre>
     * VMs must be provisioned in the same subblock.
     * </pre>
     *
     * <code>SUBBLOCK = 316202573;</code>
     */
    public static final int SUBBLOCK_VALUE = 316202573;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaxTopologyDistance valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaxTopologyDistance forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MAX_TOPOLOGY_DISTANCE;
        case 63294573:
          return BLOCK;
        case 516333018:
          return CLUSTER;
        case 316202573:
          return SUBBLOCK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaxTopologyDistance>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MaxTopologyDistance>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MaxTopologyDistance>() {
              public MaxTopologyDistance findValueByNumber(int number) {
                return MaxTopologyDistance.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MaxTopologyDistance[] VALUES = values();

    public static MaxTopologyDistance valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaxTopologyDistance(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.MaxTopologyDistance)
  }

  /**
   *
   *
   * <pre>
   * Specifies the intent of the instance placement in the MIG.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * MIG spreads out the instances as much as possible for high availability.
     * </pre>
     *
     * <code>HIGH_AVAILABILITY = 409487576;</code>
     */
    HIGH_AVAILABILITY(409487576),
    /**
     *
     *
     * <pre>
     * MIG provisions instances as close to each other as possible for high throughput.
     * </pre>
     *
     * <code>HIGH_THROUGHPUT = 146499815;</code>
     */
    HIGH_THROUGHPUT(146499815),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * MIG spreads out the instances as much as possible for high availability.
     * </pre>
     *
     * <code>HIGH_AVAILABILITY = 409487576;</code>
     */
    public static final int HIGH_AVAILABILITY_VALUE = 409487576;

    /**
     *
     *
     * <pre>
     * MIG provisions instances as close to each other as possible for high throughput.
     * </pre>
     *
     * <code>HIGH_THROUGHPUT = 146499815;</code>
     */
    public static final int HIGH_THROUGHPUT_VALUE = 146499815;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 409487576:
          return HIGH_AVAILABILITY;
        case 146499815:
          return HIGH_THROUGHPUT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.Type)
  }

  private int bitField0_;
  public static final int ACCELERATOR_TOPOLOGY_FIELD_NUMBER = 389323203;

  @SuppressWarnings("serial")
  private volatile java.lang.Object acceleratorTopology_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * </pre>
   *
   * <code>optional string accelerator_topology = 389323203;</code>
   *
   * @return Whether the acceleratorTopology field is set.
   */
  @java.lang.Override
  public boolean hasAcceleratorTopology() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * </pre>
   *
   * <code>optional string accelerator_topology = 389323203;</code>
   *
   * @return The acceleratorTopology.
   */
  @java.lang.Override
  public java.lang.String getAcceleratorTopology() {
    java.lang.Object ref = acceleratorTopology_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      acceleratorTopology_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
   * </pre>
   *
   * <code>optional string accelerator_topology = 389323203;</code>
   *
   * @return The bytes for acceleratorTopology.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAcceleratorTopologyBytes() {
    java.lang.Object ref = acceleratorTopology_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      acceleratorTopology_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_TOPOLOGY_DISTANCE_FIELD_NUMBER = 7521706;

  @SuppressWarnings("serial")
  private volatile java.lang.Object maxTopologyDistance_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the maximum distance between instances.
   * Check the MaxTopologyDistance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string max_topology_distance = 7521706;</code>
   *
   * @return Whether the maxTopologyDistance field is set.
   */
  @java.lang.Override
  public boolean hasMaxTopologyDistance() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the maximum distance between instances.
   * Check the MaxTopologyDistance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string max_topology_distance = 7521706;</code>
   *
   * @return The maxTopologyDistance.
   */
  @java.lang.Override
  public java.lang.String getMaxTopologyDistance() {
    java.lang.Object ref = maxTopologyDistance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maxTopologyDistance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the maximum distance between instances.
   * Check the MaxTopologyDistance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string max_topology_distance = 7521706;</code>
   *
   * @return The bytes for maxTopologyDistance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaxTopologyDistanceBytes() {
    java.lang.Object ref = maxTopologyDistance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maxTopologyDistance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the intent of the instance placement in the MIG.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the intent of the instance placement in the MIG.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the intent of the instance placement in the MIG.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7521706, maxTopologyDistance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 389323203, acceleratorTopology_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(7521706, maxTopologyDistance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(389323203, acceleratorTopology_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy other =
        (com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy) obj;

    if (hasAcceleratorTopology() != other.hasAcceleratorTopology()) return false;
    if (hasAcceleratorTopology()) {
      if (!getAcceleratorTopology().equals(other.getAcceleratorTopology())) return false;
    }
    if (hasMaxTopologyDistance() != other.hasMaxTopologyDistance()) return false;
    if (hasMaxTopologyDistance()) {
      if (!getMaxTopologyDistance().equals(other.getMaxTopologyDistance())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAcceleratorTopology()) {
      hash = (37 * hash) + ACCELERATOR_TOPOLOGY_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorTopology().hashCode();
    }
    if (hasMaxTopologyDistance()) {
      hash = (37 * hash) + MAX_TOPOLOGY_DISTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxTopologyDistance().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents the workload policy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ResourcePolicyWorkloadPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy)
      com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyWorkloadPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyWorkloadPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.class,
              com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      acceleratorTopology_ = "";
      maxTopologyDistance_ = "";
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicyWorkloadPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy build() {
      com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy buildPartial() {
      com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy result =
          new com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.acceleratorTopology_ = acceleratorTopology_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxTopologyDistance_ = maxTopologyDistance_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy other) {
      if (other == com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy.getDefaultInstance())
        return this;
      if (other.hasAcceleratorTopology()) {
        acceleratorTopology_ = other.acceleratorTopology_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMaxTopologyDistance()) {
        maxTopologyDistance_ = other.maxTopologyDistance_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 28604882
            case 60173650:
              {
                maxTopologyDistance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 60173650
            case -1180381670:
              {
                acceleratorTopology_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1180381670
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object acceleratorTopology_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @return Whether the acceleratorTopology field is set.
     */
    public boolean hasAcceleratorTopology() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @return The acceleratorTopology.
     */
    public java.lang.String getAcceleratorTopology() {
      java.lang.Object ref = acceleratorTopology_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        acceleratorTopology_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @return The bytes for acceleratorTopology.
     */
    public com.google.protobuf.ByteString getAcceleratorTopologyBytes() {
      java.lang.Object ref = acceleratorTopology_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        acceleratorTopology_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @param value The acceleratorTopology to set.
     * @return This builder for chaining.
     */
    public Builder setAcceleratorTopology(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      acceleratorTopology_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAcceleratorTopology() {
      acceleratorTopology_ = getDefaultInstance().getAcceleratorTopology();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the topology required to create a partition for VMs that have interconnected GPUs.
     * </pre>
     *
     * <code>optional string accelerator_topology = 389323203;</code>
     *
     * @param value The bytes for acceleratorTopology to set.
     * @return This builder for chaining.
     */
    public Builder setAcceleratorTopologyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      acceleratorTopology_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object maxTopologyDistance_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @return Whether the maxTopologyDistance field is set.
     */
    public boolean hasMaxTopologyDistance() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @return The maxTopologyDistance.
     */
    public java.lang.String getMaxTopologyDistance() {
      java.lang.Object ref = maxTopologyDistance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maxTopologyDistance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @return The bytes for maxTopologyDistance.
     */
    public com.google.protobuf.ByteString getMaxTopologyDistanceBytes() {
      java.lang.Object ref = maxTopologyDistance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maxTopologyDistance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @param value The maxTopologyDistance to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTopologyDistance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      maxTopologyDistance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxTopologyDistance() {
      maxTopologyDistance_ = getDefaultInstance().getMaxTopologyDistance();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the maximum distance between instances.
     * Check the MaxTopologyDistance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string max_topology_distance = 7521706;</code>
     *
     * @param value The bytes for maxTopologyDistance to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTopologyDistanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      maxTopologyDistance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the intent of the instance placement in the MIG.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourcePolicyWorkloadPolicy)
  private static final com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy();
  }

  public static com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourcePolicyWorkloadPolicy> PARSER =
      new com.google.protobuf.AbstractParser<ResourcePolicyWorkloadPolicy>() {
        @java.lang.Override
        public ResourcePolicyWorkloadPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourcePolicyWorkloadPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePolicyWorkloadPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyWorkloadPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
