/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Additional details for quota exceeded error for resource quota.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.QuotaExceededInfo}
 */
public final class QuotaExceededInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.QuotaExceededInfo)
    QuotaExceededInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use QuotaExceededInfo.newBuilder() to construct.
  private QuotaExceededInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaExceededInfo() {
    limitName_ = "";
    metricName_ = "";
    rolloutStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaExceededInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_QuotaExceededInfo_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 414334925:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_QuotaExceededInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.QuotaExceededInfo.class,
            com.google.cloud.compute.v1.QuotaExceededInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Rollout status of the future quota limit.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.QuotaExceededInfo.RolloutStatus}
   */
  public enum RolloutStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROLLOUT_STATUS = 0;</code>
     */
    UNDEFINED_ROLLOUT_STATUS(0),
    /**
     *
     *
     * <pre>
     * IN_PROGRESS - A rollout is in process which will change the limit value to future limit.
     * </pre>
     *
     * <code>IN_PROGRESS = 469193735;</code>
     */
    IN_PROGRESS(469193735),
    /**
     *
     *
     * <pre>
     * ROLLOUT_STATUS_UNSPECIFIED - Rollout status is not specified. The default value.
     * </pre>
     *
     * <code>ROLLOUT_STATUS_UNSPECIFIED = 26864568;</code>
     */
    ROLLOUT_STATUS_UNSPECIFIED(26864568),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROLLOUT_STATUS = 0;</code>
     */
    public static final int UNDEFINED_ROLLOUT_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * IN_PROGRESS - A rollout is in process which will change the limit value to future limit.
     * </pre>
     *
     * <code>IN_PROGRESS = 469193735;</code>
     */
    public static final int IN_PROGRESS_VALUE = 469193735;

    /**
     *
     *
     * <pre>
     * ROLLOUT_STATUS_UNSPECIFIED - Rollout status is not specified. The default value.
     * </pre>
     *
     * <code>ROLLOUT_STATUS_UNSPECIFIED = 26864568;</code>
     */
    public static final int ROLLOUT_STATUS_UNSPECIFIED_VALUE = 26864568;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ROLLOUT_STATUS;
        case 469193735:
          return IN_PROGRESS;
        case 26864568:
          return ROLLOUT_STATUS_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolloutStatus>() {
          public RolloutStatus findValueByNumber(int number) {
            return RolloutStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.QuotaExceededInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final RolloutStatus[] VALUES = values();

    public static RolloutStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.QuotaExceededInfo.RolloutStatus)
  }

  private int bitField0_;
  public static final int DIMENSIONS_FIELD_NUMBER = 414334925;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_QuotaExceededInfo_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The map holding related quota dimensions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }

  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }

  /**
   *
   *
   * <pre>
   * The map holding related quota dimensions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }

  /**
   *
   *
   * <pre>
   * The map holding related quota dimensions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDimensionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The map holding related quota dimensions.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FUTURE_LIMIT_FIELD_NUMBER = 456564287;
  private double futureLimit_ = 0D;

  /**
   *
   *
   * <pre>
   * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
   * </pre>
   *
   * <code>optional double future_limit = 456564287;</code>
   *
   * @return Whether the futureLimit field is set.
   */
  @java.lang.Override
  public boolean hasFutureLimit() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
   * </pre>
   *
   * <code>optional double future_limit = 456564287;</code>
   *
   * @return The futureLimit.
   */
  @java.lang.Override
  public double getFutureLimit() {
    return futureLimit_;
  }

  public static final int LIMIT_FIELD_NUMBER = 102976443;
  private double limit_ = 0D;

  /**
   *
   *
   * <pre>
   * Current effective quota limit. The limit's unit depends on the quota type or metric.
   * </pre>
   *
   * <code>optional double limit = 102976443;</code>
   *
   * @return Whether the limit field is set.
   */
  @java.lang.Override
  public boolean hasLimit() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Current effective quota limit. The limit's unit depends on the quota type or metric.
   * </pre>
   *
   * <code>optional double limit = 102976443;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public double getLimit() {
    return limit_;
  }

  public static final int LIMIT_NAME_FIELD_NUMBER = 398197903;

  @SuppressWarnings("serial")
  private volatile java.lang.Object limitName_ = "";

  /**
   *
   *
   * <pre>
   * The name of the quota limit.
   * </pre>
   *
   * <code>optional string limit_name = 398197903;</code>
   *
   * @return Whether the limitName field is set.
   */
  @java.lang.Override
  public boolean hasLimitName() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of the quota limit.
   * </pre>
   *
   * <code>optional string limit_name = 398197903;</code>
   *
   * @return The limitName.
   */
  @java.lang.Override
  public java.lang.String getLimitName() {
    java.lang.Object ref = limitName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      limitName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the quota limit.
   * </pre>
   *
   * <code>optional string limit_name = 398197903;</code>
   *
   * @return The bytes for limitName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLimitNameBytes() {
    java.lang.Object ref = limitName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      limitName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_NAME_FIELD_NUMBER = 409881530;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricName_ = "";

  /**
   *
   *
   * <pre>
   * The Compute Engine quota metric name.
   * </pre>
   *
   * <code>optional string metric_name = 409881530;</code>
   *
   * @return Whether the metricName field is set.
   */
  @java.lang.Override
  public boolean hasMetricName() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The Compute Engine quota metric name.
   * </pre>
   *
   * <code>optional string metric_name = 409881530;</code>
   *
   * @return The metricName.
   */
  @java.lang.Override
  public java.lang.String getMetricName() {
    java.lang.Object ref = metricName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Compute Engine quota metric name.
   * </pre>
   *
   * <code>optional string metric_name = 409881530;</code>
   *
   * @return The bytes for metricName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricNameBytes() {
    java.lang.Object ref = metricName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_STATUS_FIELD_NUMBER = 476426816;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rolloutStatus_ = "";

  /**
   *
   *
   * <pre>
   * Rollout status of the future quota limit.
   * Check the RolloutStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rollout_status = 476426816;</code>
   *
   * @return Whether the rolloutStatus field is set.
   */
  @java.lang.Override
  public boolean hasRolloutStatus() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Rollout status of the future quota limit.
   * Check the RolloutStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rollout_status = 476426816;</code>
   *
   * @return The rolloutStatus.
   */
  @java.lang.Override
  public java.lang.String getRolloutStatus() {
    java.lang.Object ref = rolloutStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Rollout status of the future quota limit.
   * Check the RolloutStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rollout_status = 476426816;</code>
   *
   * @return The bytes for rolloutStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutStatusBytes() {
    java.lang.Object ref = rolloutStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(102976443, limit_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 398197903, limitName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 409881530, metricName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 414334925);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(456564287, futureLimit_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 476426816, rolloutStatus_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(102976443, limit_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(398197903, limitName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(409881530, metricName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(414334925, dimensions__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(456564287, futureLimit_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(476426816, rolloutStatus_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.QuotaExceededInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.QuotaExceededInfo other =
        (com.google.cloud.compute.v1.QuotaExceededInfo) obj;

    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (hasFutureLimit() != other.hasFutureLimit()) return false;
    if (hasFutureLimit()) {
      if (java.lang.Double.doubleToLongBits(getFutureLimit())
          != java.lang.Double.doubleToLongBits(other.getFutureLimit())) return false;
    }
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (java.lang.Double.doubleToLongBits(getLimit())
          != java.lang.Double.doubleToLongBits(other.getLimit())) return false;
    }
    if (hasLimitName() != other.hasLimitName()) return false;
    if (hasLimitName()) {
      if (!getLimitName().equals(other.getLimitName())) return false;
    }
    if (hasMetricName() != other.hasMetricName()) return false;
    if (hasMetricName()) {
      if (!getMetricName().equals(other.getMetricName())) return false;
    }
    if (hasRolloutStatus() != other.hasRolloutStatus()) return false;
    if (hasRolloutStatus()) {
      if (!getRolloutStatus().equals(other.getRolloutStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    if (hasFutureLimit()) {
      hash = (37 * hash) + FUTURE_LIMIT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getFutureLimit()));
    }
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getLimit()));
    }
    if (hasLimitName()) {
      hash = (37 * hash) + LIMIT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getLimitName().hashCode();
    }
    if (hasMetricName()) {
      hash = (37 * hash) + METRIC_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getMetricName().hashCode();
    }
    if (hasRolloutStatus()) {
      hash = (37 * hash) + ROLLOUT_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.QuotaExceededInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Additional details for quota exceeded error for resource quota.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.QuotaExceededInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.QuotaExceededInfo)
      com.google.cloud.compute.v1.QuotaExceededInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_QuotaExceededInfo_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 414334925:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 414334925:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_QuotaExceededInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.QuotaExceededInfo.class,
              com.google.cloud.compute.v1.QuotaExceededInfo.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.QuotaExceededInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableDimensions().clear();
      futureLimit_ = 0D;
      limit_ = 0D;
      limitName_ = "";
      metricName_ = "";
      rolloutStatus_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_QuotaExceededInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.QuotaExceededInfo getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.QuotaExceededInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.QuotaExceededInfo build() {
      com.google.cloud.compute.v1.QuotaExceededInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.QuotaExceededInfo buildPartial() {
      com.google.cloud.compute.v1.QuotaExceededInfo result =
          new com.google.cloud.compute.v1.QuotaExceededInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.QuotaExceededInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dimensions_ = internalGetDimensions();
        result.dimensions_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.futureLimit_ = futureLimit_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.limit_ = limit_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.limitName_ = limitName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metricName_ = metricName_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rolloutStatus_ = rolloutStatus_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.QuotaExceededInfo) {
        return mergeFrom((com.google.cloud.compute.v1.QuotaExceededInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.QuotaExceededInfo other) {
      if (other == com.google.cloud.compute.v1.QuotaExceededInfo.getDefaultInstance()) return this;
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      bitField0_ |= 0x00000001;
      if (other.hasFutureLimit()) {
        setFutureLimit(other.getFutureLimit());
      }
      if (other.hasLimit()) {
        setLimit(other.getLimit());
      }
      if (other.hasLimitName()) {
        limitName_ = other.limitName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMetricName()) {
        metricName_ = other.metricName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasRolloutStatus()) {
        rolloutStatus_ = other.rolloutStatus_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 823811545:
              {
                limit_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 823811545
            case -1109384070:
              {
                limitName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1109384070
            case -1015915054:
              {
                metricName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1015915054
            case -980287894:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case -980287894
            case -642452999:
              {
                futureLimit_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case -642452999
            case -483552766:
              {
                rolloutStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -483552766
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }

    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDimensionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      bitField0_ |= 0x00000001;
      return internalGetMutableDimensions().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDimensions().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The map holding related quota dimensions.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 414334925;</code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private double futureLimit_;

    /**
     *
     *
     * <pre>
     * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double future_limit = 456564287;</code>
     *
     * @return Whether the futureLimit field is set.
     */
    @java.lang.Override
    public boolean hasFutureLimit() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double future_limit = 456564287;</code>
     *
     * @return The futureLimit.
     */
    @java.lang.Override
    public double getFutureLimit() {
      return futureLimit_;
    }

    /**
     *
     *
     * <pre>
     * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double future_limit = 456564287;</code>
     *
     * @param value The futureLimit to set.
     * @return This builder for chaining.
     */
    public Builder setFutureLimit(double value) {

      futureLimit_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Future quota limit being rolled out. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double future_limit = 456564287;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFutureLimit() {
      bitField0_ = (bitField0_ & ~0x00000002);
      futureLimit_ = 0D;
      onChanged();
      return this;
    }

    private double limit_;

    /**
     *
     *
     * <pre>
     * Current effective quota limit. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double limit = 102976443;</code>
     *
     * @return Whether the limit field is set.
     */
    @java.lang.Override
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Current effective quota limit. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double limit = 102976443;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public double getLimit() {
      return limit_;
    }

    /**
     *
     *
     * <pre>
     * Current effective quota limit. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double limit = 102976443;</code>
     *
     * @param value The limit to set.
     * @return This builder for chaining.
     */
    public Builder setLimit(double value) {

      limit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Current effective quota limit. The limit's unit depends on the quota type or metric.
     * </pre>
     *
     * <code>optional double limit = 102976443;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000004);
      limit_ = 0D;
      onChanged();
      return this;
    }

    private java.lang.Object limitName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @return Whether the limitName field is set.
     */
    public boolean hasLimitName() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @return The limitName.
     */
    public java.lang.String getLimitName() {
      java.lang.Object ref = limitName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        limitName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @return The bytes for limitName.
     */
    public com.google.protobuf.ByteString getLimitNameBytes() {
      java.lang.Object ref = limitName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        limitName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @param value The limitName to set.
     * @return This builder for chaining.
     */
    public Builder setLimitName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      limitName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimitName() {
      limitName_ = getDefaultInstance().getLimitName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the quota limit.
     * </pre>
     *
     * <code>optional string limit_name = 398197903;</code>
     *
     * @param value The bytes for limitName to set.
     * @return This builder for chaining.
     */
    public Builder setLimitNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      limitName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object metricName_ = "";

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @return Whether the metricName field is set.
     */
    public boolean hasMetricName() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @return The metricName.
     */
    public java.lang.String getMetricName() {
      java.lang.Object ref = metricName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @return The bytes for metricName.
     */
    public com.google.protobuf.ByteString getMetricNameBytes() {
      java.lang.Object ref = metricName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @param value The metricName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricName() {
      metricName_ = getDefaultInstance().getMetricName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine quota metric name.
     * </pre>
     *
     * <code>optional string metric_name = 409881530;</code>
     *
     * @param value The bytes for metricName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object rolloutStatus_ = "";

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @return Whether the rolloutStatus field is set.
     */
    public boolean hasRolloutStatus() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @return The rolloutStatus.
     */
    public java.lang.String getRolloutStatus() {
      java.lang.Object ref = rolloutStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @return The bytes for rolloutStatus.
     */
    public com.google.protobuf.ByteString getRolloutStatusBytes() {
      java.lang.Object ref = rolloutStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @param value The rolloutStatus to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rolloutStatus_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutStatus() {
      rolloutStatus_ = getDefaultInstance().getRolloutStatus();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rollout status of the future quota limit.
     * Check the RolloutStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rollout_status = 476426816;</code>
     *
     * @param value The bytes for rolloutStatus to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rolloutStatus_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.QuotaExceededInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.QuotaExceededInfo)
  private static final com.google.cloud.compute.v1.QuotaExceededInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.QuotaExceededInfo();
  }

  public static com.google.cloud.compute.v1.QuotaExceededInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaExceededInfo> PARSER =
      new com.google.protobuf.AbstractParser<QuotaExceededInfo>() {
        @java.lang.Override
        public QuotaExceededInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaExceededInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaExceededInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.QuotaExceededInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
