/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration}
 */
public final class NetworkPeeringConnectionStatusTrafficConfiguration
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration)
    NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NetworkPeeringConnectionStatusTrafficConfiguration.newBuilder() to construct.
  private NetworkPeeringConnectionStatusTrafficConfiguration(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkPeeringConnectionStatusTrafficConfiguration() {
    stackType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkPeeringConnectionStatusTrafficConfiguration();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusTrafficConfiguration_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusTrafficConfiguration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.class,
            com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.StackType}
   */
  public enum StackType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    UNDEFINED_STACK_TYPE(0),
    /**
     *
     *
     * <pre>
     * This Peering will allow IPv4 traffic and routes to be exchanged. Additionally if the matching peering is IPV4_IPV6, IPv6 traffic and routes will be exchanged as well.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    IPV4_IPV6(22197249),
    /**
     *
     *
     * <pre>
     * This Peering will only allow IPv4 traffic and routes to be exchanged, even if the matching peering is IPV4_IPV6.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    IPV4_ONLY(22373798),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STACK_TYPE = 0;</code>
     */
    public static final int UNDEFINED_STACK_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * This Peering will allow IPv4 traffic and routes to be exchanged. Additionally if the matching peering is IPV4_IPV6, IPv6 traffic and routes will be exchanged as well.
     * </pre>
     *
     * <code>IPV4_IPV6 = 22197249;</code>
     */
    public static final int IPV4_IPV6_VALUE = 22197249;

    /**
     *
     *
     * <pre>
     * This Peering will only allow IPv4 traffic and routes to be exchanged, even if the matching peering is IPV4_IPV6.
     * </pre>
     *
     * <code>IPV4_ONLY = 22373798;</code>
     */
    public static final int IPV4_ONLY_VALUE = 22373798;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StackType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StackType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STACK_TYPE;
        case 22197249:
          return IPV4_IPV6;
        case 22373798:
          return IPV4_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StackType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StackType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StackType>() {
          public StackType findValueByNumber(int number) {
            return StackType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final StackType[] VALUES = values();

    public static StackType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StackType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.StackType)
  }

  private int bitField0_;
  public static final int EXPORT_CUSTOM_ROUTES_TO_PEER_FIELD_NUMBER = 286428404;
  private boolean exportCustomRoutesToPeer_ = false;

  /**
   *
   *
   * <pre>
   * Whether custom routes are being exported to the peer network.
   * </pre>
   *
   * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
   *
   * @return Whether the exportCustomRoutesToPeer field is set.
   */
  @java.lang.Override
  public boolean hasExportCustomRoutesToPeer() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether custom routes are being exported to the peer network.
   * </pre>
   *
   * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
   *
   * @return The exportCustomRoutesToPeer.
   */
  @java.lang.Override
  public boolean getExportCustomRoutesToPeer() {
    return exportCustomRoutesToPeer_;
  }

  public static final int EXPORT_SUBNET_ROUTES_WITH_PUBLIC_IP_TO_PEER_FIELD_NUMBER = 8358601;
  private boolean exportSubnetRoutesWithPublicIpToPeer_ = false;

  /**
   *
   *
   * <pre>
   * Whether subnet routes with public IP ranges are being exported to the peer network.
   * </pre>
   *
   * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
   *
   * @return Whether the exportSubnetRoutesWithPublicIpToPeer field is set.
   */
  @java.lang.Override
  public boolean hasExportSubnetRoutesWithPublicIpToPeer() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether subnet routes with public IP ranges are being exported to the peer network.
   * </pre>
   *
   * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
   *
   * @return The exportSubnetRoutesWithPublicIpToPeer.
   */
  @java.lang.Override
  public boolean getExportSubnetRoutesWithPublicIpToPeer() {
    return exportSubnetRoutesWithPublicIpToPeer_;
  }

  public static final int IMPORT_CUSTOM_ROUTES_FROM_PEER_FIELD_NUMBER = 398584470;
  private boolean importCustomRoutesFromPeer_ = false;

  /**
   *
   *
   * <pre>
   * Whether custom routes are being imported from the peer network.
   * </pre>
   *
   * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
   *
   * @return Whether the importCustomRoutesFromPeer field is set.
   */
  @java.lang.Override
  public boolean hasImportCustomRoutesFromPeer() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether custom routes are being imported from the peer network.
   * </pre>
   *
   * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
   *
   * @return The importCustomRoutesFromPeer.
   */
  @java.lang.Override
  public boolean getImportCustomRoutesFromPeer() {
    return importCustomRoutesFromPeer_;
  }

  public static final int IMPORT_SUBNET_ROUTES_WITH_PUBLIC_IP_FROM_PEER_FIELD_NUMBER = 234712361;
  private boolean importSubnetRoutesWithPublicIpFromPeer_ = false;

  /**
   *
   *
   * <pre>
   * Whether subnet routes with public IP ranges are being imported from the peer network.
   * </pre>
   *
   * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
   *
   * @return Whether the importSubnetRoutesWithPublicIpFromPeer field is set.
   */
  @java.lang.Override
  public boolean hasImportSubnetRoutesWithPublicIpFromPeer() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether subnet routes with public IP ranges are being imported from the peer network.
   * </pre>
   *
   * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
   *
   * @return The importSubnetRoutesWithPublicIpFromPeer.
   */
  @java.lang.Override
  public boolean getImportSubnetRoutesWithPublicIpFromPeer() {
    return importSubnetRoutesWithPublicIpFromPeer_;
  }

  public static final int STACK_TYPE_FIELD_NUMBER = 425908881;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stackType_ = "";

  /**
   *
   *
   * <pre>
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return Whether the stackType field is set.
   */
  @java.lang.Override
  public boolean hasStackType() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The stackType.
   */
  @java.lang.Override
  public java.lang.String getStackType() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stackType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The bytes for stackType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStackTypeBytes() {
    java.lang.Object ref = stackType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stackType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(8358601, exportSubnetRoutesWithPublicIpToPeer_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(234712361, importSubnetRoutesWithPublicIpFromPeer_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(286428404, exportCustomRoutesToPeer_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(398584470, importCustomRoutesFromPeer_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 425908881, stackType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              8358601, exportSubnetRoutesWithPublicIpToPeer_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              234712361, importSubnetRoutesWithPublicIpFromPeer_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              286428404, exportCustomRoutesToPeer_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              398584470, importCustomRoutesFromPeer_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(425908881, stackType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration other =
        (com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration) obj;

    if (hasExportCustomRoutesToPeer() != other.hasExportCustomRoutesToPeer()) return false;
    if (hasExportCustomRoutesToPeer()) {
      if (getExportCustomRoutesToPeer() != other.getExportCustomRoutesToPeer()) return false;
    }
    if (hasExportSubnetRoutesWithPublicIpToPeer()
        != other.hasExportSubnetRoutesWithPublicIpToPeer()) return false;
    if (hasExportSubnetRoutesWithPublicIpToPeer()) {
      if (getExportSubnetRoutesWithPublicIpToPeer()
          != other.getExportSubnetRoutesWithPublicIpToPeer()) return false;
    }
    if (hasImportCustomRoutesFromPeer() != other.hasImportCustomRoutesFromPeer()) return false;
    if (hasImportCustomRoutesFromPeer()) {
      if (getImportCustomRoutesFromPeer() != other.getImportCustomRoutesFromPeer()) return false;
    }
    if (hasImportSubnetRoutesWithPublicIpFromPeer()
        != other.hasImportSubnetRoutesWithPublicIpFromPeer()) return false;
    if (hasImportSubnetRoutesWithPublicIpFromPeer()) {
      if (getImportSubnetRoutesWithPublicIpFromPeer()
          != other.getImportSubnetRoutesWithPublicIpFromPeer()) return false;
    }
    if (hasStackType() != other.hasStackType()) return false;
    if (hasStackType()) {
      if (!getStackType().equals(other.getStackType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExportCustomRoutesToPeer()) {
      hash = (37 * hash) + EXPORT_CUSTOM_ROUTES_TO_PEER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExportCustomRoutesToPeer());
    }
    if (hasExportSubnetRoutesWithPublicIpToPeer()) {
      hash = (37 * hash) + EXPORT_SUBNET_ROUTES_WITH_PUBLIC_IP_TO_PEER_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getExportSubnetRoutesWithPublicIpToPeer());
    }
    if (hasImportCustomRoutesFromPeer()) {
      hash = (37 * hash) + IMPORT_CUSTOM_ROUTES_FROM_PEER_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportCustomRoutesFromPeer());
    }
    if (hasImportSubnetRoutesWithPublicIpFromPeer()) {
      hash = (37 * hash) + IMPORT_SUBNET_ROUTES_WITH_PUBLIC_IP_FROM_PEER_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(
                  getImportSubnetRoutesWithPublicIpFromPeer());
    }
    if (hasStackType()) {
      hash = (37 * hash) + STACK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getStackType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration)
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfigurationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusTrafficConfiguration_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusTrafficConfiguration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.class,
              com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      exportCustomRoutesToPeer_ = false;
      exportSubnetRoutesWithPublicIpToPeer_ = false;
      importCustomRoutesFromPeer_ = false;
      importSubnetRoutesWithPublicIpFromPeer_ = false;
      stackType_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkPeeringConnectionStatusTrafficConfiguration_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration build() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
        buildPartial() {
      com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration result =
          new com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.exportCustomRoutesToPeer_ = exportCustomRoutesToPeer_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.exportSubnetRoutesWithPublicIpToPeer_ = exportSubnetRoutesWithPublicIpToPeer_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.importCustomRoutesFromPeer_ = importCustomRoutesFromPeer_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.importSubnetRoutesWithPublicIpFromPeer_ = importSubnetRoutesWithPublicIpFromPeer_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.stackType_ = stackType_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration) {
        return mergeFrom(
            (com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration other) {
      if (other
          == com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
              .getDefaultInstance()) return this;
      if (other.hasExportCustomRoutesToPeer()) {
        setExportCustomRoutesToPeer(other.getExportCustomRoutesToPeer());
      }
      if (other.hasExportSubnetRoutesWithPublicIpToPeer()) {
        setExportSubnetRoutesWithPublicIpToPeer(other.getExportSubnetRoutesWithPublicIpToPeer());
      }
      if (other.hasImportCustomRoutesFromPeer()) {
        setImportCustomRoutesFromPeer(other.getImportCustomRoutesFromPeer());
      }
      if (other.hasImportSubnetRoutesWithPublicIpFromPeer()) {
        setImportSubnetRoutesWithPublicIpFromPeer(
            other.getImportSubnetRoutesWithPublicIpFromPeer());
      }
      if (other.hasStackType()) {
        stackType_ = other.stackType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 66868808:
              {
                exportSubnetRoutesWithPublicIpToPeer_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 66868808
            case 1877698888:
              {
                importSubnetRoutesWithPublicIpFromPeer_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 1877698888
            case -2003540064:
              {
                exportCustomRoutesToPeer_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -2003540064
            case -1106291536:
              {
                importCustomRoutesFromPeer_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -1106291536
            case -887696246:
              {
                stackType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -887696246
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean exportCustomRoutesToPeer_;

    /**
     *
     *
     * <pre>
     * Whether custom routes are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
     *
     * @return Whether the exportCustomRoutesToPeer field is set.
     */
    @java.lang.Override
    public boolean hasExportCustomRoutesToPeer() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
     *
     * @return The exportCustomRoutesToPeer.
     */
    @java.lang.Override
    public boolean getExportCustomRoutesToPeer() {
      return exportCustomRoutesToPeer_;
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
     *
     * @param value The exportCustomRoutesToPeer to set.
     * @return This builder for chaining.
     */
    public Builder setExportCustomRoutesToPeer(boolean value) {

      exportCustomRoutesToPeer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_custom_routes_to_peer = 286428404;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExportCustomRoutesToPeer() {
      bitField0_ = (bitField0_ & ~0x00000001);
      exportCustomRoutesToPeer_ = false;
      onChanged();
      return this;
    }

    private boolean exportSubnetRoutesWithPublicIpToPeer_;

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
     *
     * @return Whether the exportSubnetRoutesWithPublicIpToPeer field is set.
     */
    @java.lang.Override
    public boolean hasExportSubnetRoutesWithPublicIpToPeer() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
     *
     * @return The exportSubnetRoutesWithPublicIpToPeer.
     */
    @java.lang.Override
    public boolean getExportSubnetRoutesWithPublicIpToPeer() {
      return exportSubnetRoutesWithPublicIpToPeer_;
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
     *
     * @param value The exportSubnetRoutesWithPublicIpToPeer to set.
     * @return This builder for chaining.
     */
    public Builder setExportSubnetRoutesWithPublicIpToPeer(boolean value) {

      exportSubnetRoutesWithPublicIpToPeer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being exported to the peer network.
     * </pre>
     *
     * <code>optional bool export_subnet_routes_with_public_ip_to_peer = 8358601;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExportSubnetRoutesWithPublicIpToPeer() {
      bitField0_ = (bitField0_ & ~0x00000002);
      exportSubnetRoutesWithPublicIpToPeer_ = false;
      onChanged();
      return this;
    }

    private boolean importCustomRoutesFromPeer_;

    /**
     *
     *
     * <pre>
     * Whether custom routes are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
     *
     * @return Whether the importCustomRoutesFromPeer field is set.
     */
    @java.lang.Override
    public boolean hasImportCustomRoutesFromPeer() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
     *
     * @return The importCustomRoutesFromPeer.
     */
    @java.lang.Override
    public boolean getImportCustomRoutesFromPeer() {
      return importCustomRoutesFromPeer_;
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
     *
     * @param value The importCustomRoutesFromPeer to set.
     * @return This builder for chaining.
     */
    public Builder setImportCustomRoutesFromPeer(boolean value) {

      importCustomRoutesFromPeer_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether custom routes are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_custom_routes_from_peer = 398584470;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportCustomRoutesFromPeer() {
      bitField0_ = (bitField0_ & ~0x00000004);
      importCustomRoutesFromPeer_ = false;
      onChanged();
      return this;
    }

    private boolean importSubnetRoutesWithPublicIpFromPeer_;

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
     *
     * @return Whether the importSubnetRoutesWithPublicIpFromPeer field is set.
     */
    @java.lang.Override
    public boolean hasImportSubnetRoutesWithPublicIpFromPeer() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
     *
     * @return The importSubnetRoutesWithPublicIpFromPeer.
     */
    @java.lang.Override
    public boolean getImportSubnetRoutesWithPublicIpFromPeer() {
      return importSubnetRoutesWithPublicIpFromPeer_;
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
     *
     * @param value The importSubnetRoutesWithPublicIpFromPeer to set.
     * @return This builder for chaining.
     */
    public Builder setImportSubnetRoutesWithPublicIpFromPeer(boolean value) {

      importSubnetRoutesWithPublicIpFromPeer_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether subnet routes with public IP ranges are being imported from the peer network.
     * </pre>
     *
     * <code>optional bool import_subnet_routes_with_public_ip_from_peer = 234712361;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportSubnetRoutesWithPublicIpFromPeer() {
      bitField0_ = (bitField0_ & ~0x00000008);
      importSubnetRoutesWithPublicIpFromPeer_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object stackType_ = "";

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return Whether the stackType field is set.
     */
    public boolean hasStackType() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The stackType.
     */
    public java.lang.String getStackType() {
      java.lang.Object ref = stackType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stackType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return The bytes for stackType.
     */
    public com.google.protobuf.ByteString getStackTypeBytes() {
      java.lang.Object ref = stackType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stackType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stackType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStackType() {
      stackType_ = getDefaultInstance().getStackType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
     * Check the StackType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string stack_type = 425908881;</code>
     *
     * @param value The bytes for stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stackType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration)
  private static final com.google.cloud.compute.v1
          .NetworkPeeringConnectionStatusTrafficConfiguration
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration();
  }

  public static com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          NetworkPeeringConnectionStatusTrafficConfiguration>
      PARSER =
          new com.google.protobuf.AbstractParser<
              NetworkPeeringConnectionStatusTrafficConfiguration>() {
            @java.lang.Override
            public NetworkPeeringConnectionStatusTrafficConfiguration parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<NetworkPeeringConnectionStatusTrafficConfiguration>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkPeeringConnectionStatusTrafficConfiguration>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPeeringConnectionStatusTrafficConfiguration
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
