/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

public interface InterconnectAttachmentOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.InterconnectAttachment)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  boolean hasAdminEnabled();

  /**
   *
   *
   * <pre>
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  boolean getAdminEnabled();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the AttachmentGroup that includes this Attachment.
   * </pre>
   *
   * <code>optional string attachment_group = 63442019;</code>
   *
   * @return Whether the attachmentGroup field is set.
   */
  boolean hasAttachmentGroup();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the AttachmentGroup that includes this Attachment.
   * </pre>
   *
   * <code>optional string attachment_group = 63442019;</code>
   *
   * @return The attachmentGroup.
   */
  java.lang.String getAttachmentGroup();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the AttachmentGroup that includes this Attachment.
   * </pre>
   *
   * <code>optional string attachment_group = 63442019;</code>
   *
   * @return The bytes for attachmentGroup.
   */
  com.google.protobuf.ByteString getAttachmentGroupBytes();

  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return Whether the bandwidth field is set.
   */
  boolean hasBandwidth();

  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return The bandwidth.
   */
  java.lang.String getBandwidth();

  /**
   *
   *
   * <pre>
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * Check the Bandwidth enum for the list of possible values.
   * </pre>
   *
   * <code>optional string bandwidth = 181715121;</code>
   *
   * @return The bytes for bandwidth.
   */
  com.google.protobuf.ByteString getBandwidthBytes();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @return A list containing the candidateIpv6Subnets.
   */
  java.util.List<java.lang.String> getCandidateIpv6SubnetsList();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @return The count of candidateIpv6Subnets.
   */
  int getCandidateIpv6SubnetsCount();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @param index The index of the element to return.
   * @return The candidateIpv6Subnets at the given index.
   */
  java.lang.String getCandidateIpv6Subnets(int index);

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>repeated string candidate_ipv6_subnets = 70682522;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the candidateIpv6Subnets at the given index.
   */
  com.google.protobuf.ByteString getCandidateIpv6SubnetsBytes(int index);

  /**
   *
   *
   * <pre>
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @return A list containing the candidateSubnets.
   */
  java.util.List<java.lang.String> getCandidateSubnetsList();

  /**
   *
   *
   * <pre>
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @return The count of candidateSubnets.
   */
  int getCandidateSubnetsCount();

  /**
   *
   *
   * <pre>
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @param index The index of the element to return.
   * @return The candidateSubnets at the given index.
   */
  java.lang.String getCandidateSubnets(int index);

  /**
   *
   *
   * <pre>
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
   * </pre>
   *
   * <code>repeated string candidate_subnets = 237842938;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the candidateSubnets at the given index.
   */
  com.google.protobuf.ByteString getCandidateSubnetsBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return Whether the cloudRouterIpAddress field is set.
   */
  boolean hasCloudRouterIpAddress();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return The cloudRouterIpAddress.
   */
  java.lang.String getCloudRouterIpAddress();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ip_address = 287392776;</code>
   *
   * @return The bytes for cloudRouterIpAddress.
   */
  com.google.protobuf.ByteString getCloudRouterIpAddressBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return Whether the cloudRouterIpv6Address field is set.
   */
  boolean hasCloudRouterIpv6Address();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return The cloudRouterIpv6Address.
   */
  java.lang.String getCloudRouterIpv6Address();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_address = 451922376;</code>
   *
   * @return The bytes for cloudRouterIpv6Address.
   */
  com.google.protobuf.ByteString getCloudRouterIpv6AddressBytes();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return Whether the cloudRouterIpv6InterfaceId field is set.
   */
  boolean hasCloudRouterIpv6InterfaceId();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return The cloudRouterIpv6InterfaceId.
   */
  java.lang.String getCloudRouterIpv6InterfaceId();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string cloud_router_ipv6_interface_id = 521282701;</code>
   *
   * @return The bytes for cloudRouterIpv6InterfaceId.
   */
  com.google.protobuf.ByteString getCloudRouterIpv6InterfaceIdBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   *
   * @return Whether the configurationConstraints field is set.
   */
  boolean hasConfigurationConstraints();

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   *
   * @return The configurationConstraints.
   */
  com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      getConfigurationConstraints();

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints for this attachment, if any. The attachment does not work if these constraints are not met.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints configuration_constraints = 179681389;
   * </code>
   */
  com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder
      getConfigurationConstraintsOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return Whether the customerRouterIpAddress field is set.
   */
  boolean hasCustomerRouterIpAddress();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return The customerRouterIpAddress.
   */
  java.lang.String getCustomerRouterIpAddress();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ip_address = 332475761;</code>
   *
   * @return The bytes for customerRouterIpAddress.
   */
  com.google.protobuf.ByteString getCustomerRouterIpAddressBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return Whether the customerRouterIpv6Address field is set.
   */
  boolean hasCustomerRouterIpv6Address();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return The customerRouterIpv6Address.
   */
  java.lang.String getCustomerRouterIpv6Address();

  /**
   *
   *
   * <pre>
   * [Output Only] IPv6 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_address = 290127089;</code>
   *
   * @return The bytes for customerRouterIpv6Address.
   */
  com.google.protobuf.ByteString getCustomerRouterIpv6AddressBytes();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return Whether the customerRouterIpv6InterfaceId field is set.
   */
  boolean hasCustomerRouterIpv6InterfaceId();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return The customerRouterIpv6InterfaceId.
   */
  java.lang.String getCustomerRouterIpv6InterfaceId();

  /**
   *
   *
   * <pre>
   * This field is not available.
   * </pre>
   *
   * <code>optional string customer_router_ipv6_interface_id = 380994308;</code>
   *
   * @return The bytes for customerRouterIpv6InterfaceId.
   */
  com.google.protobuf.ByteString getCustomerRouterIpv6InterfaceIdBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
   * </pre>
   *
   * <code>optional int32 dataplane_version = 34920075;</code>
   *
   * @return Whether the dataplaneVersion field is set.
   */
  boolean hasDataplaneVersion();

  /**
   *
   *
   * <pre>
   * [Output Only] Dataplane version for this InterconnectAttachment. This field is only present for Dataplane version 2 and higher. Absence of this field in the API output indicates that the Dataplane is version 1.
   * </pre>
   *
   * <code>optional int32 dataplane_version = 34920075;</code>
   *
   * @return The dataplaneVersion.
   */
  int getDataplaneVersion();

  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return Whether the edgeAvailabilityDomain field is set.
   */
  boolean hasEdgeAvailabilityDomain();

  /**
   *
   *
   * <pre>
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return The edgeAvailabilityDomain.
   */
  java.lang.String getEdgeAvailabilityDomain();

  /**
   *
   *
   * <pre>
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * Check the EdgeAvailabilityDomain enum for the list of possible values.
   * </pre>
   *
   * <code>optional string edge_availability_domain = 71289510;</code>
   *
   * @return The bytes for edgeAvailabilityDomain.
   */
  com.google.protobuf.ByteString getEdgeAvailabilityDomainBytes();

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return Whether the encryption field is set.
   */
  boolean hasEncryption();

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return The encryption.
   */
  java.lang.String getEncryption();

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
   * Check the Encryption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string encryption = 97980291;</code>
   *
   * @return The bytes for encryption.
   */
  com.google.protobuf.ByteString getEncryptionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return Whether the googleReferenceId field is set.
   */
  boolean hasGoogleReferenceId();

  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The googleReferenceId.
   */
  java.lang.String getGoogleReferenceId();

  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The bytes for googleReferenceId.
   */
  com.google.protobuf.ByteString getGoogleReferenceIdBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return Whether the interconnect field is set.
   */
  boolean hasInterconnect();

  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The interconnect.
   */
  java.lang.String getInterconnect();

  /**
   *
   *
   * <pre>
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The bytes for interconnect.
   */
  com.google.protobuf.ByteString getInterconnectBytes();

  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @return A list containing the ipsecInternalAddresses.
   */
  java.util.List<java.lang.String> getIpsecInternalAddressesList();

  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @return The count of ipsecInternalAddresses.
   */
  int getIpsecInternalAddressesCount();

  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @param index The index of the element to return.
   * @return The ipsecInternalAddresses at the given index.
   */
  java.lang.String getIpsecInternalAddresses(int index);

  /**
   *
   *
   * <pre>
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the VLAN attachment that has the encryption option as IPSEC. The addresses must be regional internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the attachment is configured to use a regional internal IP address, then the VPN gateway's IP address is allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN attachment. If this field is not specified when creating the VLAN attachment, then later on when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is allocated from the regional external IP address pool.
   * </pre>
   *
   * <code>repeated string ipsec_internal_addresses = 407648565;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipsecInternalAddresses at the given index.
   */
  com.google.protobuf.ByteString getIpsecInternalAddressesBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  boolean hasLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  java.lang.String getLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  com.google.protobuf.ByteString getLabelFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return Whether the mtu field is set.
   */
  boolean hasMtu();

  /**
   *
   *
   * <pre>
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
   * </pre>
   *
   * <code>optional int32 mtu = 108462;</code>
   *
   * @return The mtu.
   */
  int getMtu();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return Whether the operationalStatus field is set.
   */
  boolean hasOperationalStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The operationalStatus.
   */
  java.lang.String getOperationalStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The bytes for operationalStatus.
   */
  com.google.protobuf.ByteString getOperationalStatusBytes();

  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of a PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return Whether the pairingKey field is set.
   */
  boolean hasPairingKey();

  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of a PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return The pairingKey.
   */
  java.lang.String getPairingKey();

  /**
   *
   *
   * <pre>
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of a PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
   * </pre>
   *
   * <code>optional string pairing_key = 439695464;</code>
   *
   * @return The bytes for pairingKey.
   */
  com.google.protobuf.ByteString getPairingKeyBytes();

  /**
   *
   *
   * <pre>
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>optional int64 partner_asn = 438166149;</code>
   *
   * @return Whether the partnerAsn field is set.
   */
  boolean hasPartnerAsn();

  /**
   *
   *
   * <pre>
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>optional int64 partner_asn = 438166149;</code>
   *
   * @return The partnerAsn.
   */
  long getPartnerAsn();

  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   *
   * @return Whether the partnerMetadata field is set.
   */
  boolean hasPartnerMetadata();

  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   *
   * @return The partnerMetadata.
   */
  com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata getPartnerMetadata();

  /**
   *
   *
   * <pre>
   * Informational metadata about Partner attachments from Partners to display to customers. Output only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPartnerMetadata partner_metadata = 65908934;
   * </code>
   */
  com.google.cloud.compute.v1.InterconnectAttachmentPartnerMetadataOrBuilder
      getPartnerMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   *
   * @return Whether the privateInterconnectInfo field is set.
   */
  boolean hasPrivateInterconnectInfo();

  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   *
   * @return The privateInterconnectInfo.
   */
  com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfo getPrivateInterconnectInfo();

  /**
   *
   *
   * <pre>
   * [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentPrivateInfo private_interconnect_info = 237270531;
   * </code>
   */
  com.google.cloud.compute.v1.InterconnectAttachmentPrivateInfoOrBuilder
      getPrivateInterconnectInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  boolean hasRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return Whether the remoteService field is set.
   */
  boolean hasRemoteService();

  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The remoteService.
   */
  java.lang.String getRemoteService();

  /**
   *
   *
   * <pre>
   * [Output Only] If the attachment is on a Cross-Cloud Interconnect connection, this field contains the interconnect's remote location service provider. Example values: "Amazon Web Services" "Microsoft Azure". The field is set only for attachments on Cross-Cloud Interconnect connections. Its value is copied from the InterconnectRemoteLocation remoteService field.
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The bytes for remoteService.
   */
  com.google.protobuf.ByteString getRemoteServiceBytes();

  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return Whether the router field is set.
   */
  boolean hasRouter();

  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The router.
   */
  java.lang.String getRouter();

  /**
   *
   *
   * <pre>
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network &amp; region within which the Cloud Router is configured.
   * </pre>
   *
   * <code>optional string router = 148608841;</code>
   *
   * @return The bytes for router.
   */
  com.google.protobuf.ByteString getRouterBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  boolean hasSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return Whether the stackType field is set.
   */
  boolean hasStackType();

  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The stackType.
   */
  java.lang.String getStackType();

  /**
   *
   *
   * <pre>
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
   * Check the StackType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string stack_type = 425908881;</code>
   *
   * @return The bytes for stackType.
   */
  com.google.protobuf.ByteString getStackTypeBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  boolean hasState();

  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  java.lang.String getState();

  /**
   *
   *
   * <pre>
   * [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  com.google.protobuf.ByteString getStateBytes();

  /**
   *
   *
   * <pre>
   * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
   * </pre>
   *
   * <code>optional int32 subnet_length = 279831048;</code>
   *
   * @return Whether the subnetLength field is set.
   */
  boolean hasSubnetLength();

  /**
   *
   *
   * <pre>
   * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default value is 29, except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure remote location fall into this category. In these cases, the default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it gives Google Cloud Support more debugging visibility.
   * </pre>
   *
   * <code>optional int32 subnet_length = 279831048;</code>
   *
   * @return The subnetLength.
   */
  int getSubnetLength();

  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  boolean hasType();

  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  java.lang.String getType();

  /**
   *
   *
   * <pre>
   * The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
   * </pre>
   *
   * <code>optional int32 vlan_tag8021q = 119927836;</code>
   *
   * @return Whether the vlanTag8021q field is set.
   */
  boolean hasVlanTag8021Q();

  /**
   *
   *
   * <pre>
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation time.
   * </pre>
   *
   * <code>optional int32 vlan_tag8021q = 119927836;</code>
   *
   * @return The vlanTag8021q.
   */
  int getVlanTag8021Q();
}
