/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Specify bandwidth percentages [1-100] for various traffic classes in BandwidthPercentagePolicy. The sum of all percentages must equal 100. All traffic classes must have a percentage value specified.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage}
 */
public final class InterconnectApplicationAwareInterconnectBandwidthPercentage
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)
    InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectApplicationAwareInterconnectBandwidthPercentage.newBuilder() to construct.
  private InterconnectApplicationAwareInterconnectBandwidthPercentage(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectApplicationAwareInterconnectBandwidthPercentage() {
    trafficClass_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectApplicationAwareInterconnectBandwidthPercentage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnectBandwidthPercentage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnectBandwidthPercentage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .class,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder.class);
  }

  /**
   *
   *
   * <pre>
   * TrafficClass whose bandwidth percentage is being specified.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage.TrafficClass}
   */
  public enum TrafficClass implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TRAFFIC_CLASS = 0;</code>
     */
    UNDEFINED_TRAFFIC_CLASS(0),
    /**
     *
     *
     * <pre>
     * Traffic Class 1, corresponding to DSCP ranges (0-7) 000xxx.
     * </pre>
     *
     * <code>TC1 = 82850;</code>
     */
    TC1(82850),
    /**
     *
     *
     * <pre>
     * Traffic Class 2, corresponding to DSCP ranges (8-15) 001xxx.
     * </pre>
     *
     * <code>TC2 = 82851;</code>
     */
    TC2(82851),
    /**
     *
     *
     * <pre>
     * Traffic Class 3, corresponding to DSCP ranges (16-23) 010xxx.
     * </pre>
     *
     * <code>TC3 = 82852;</code>
     */
    TC3(82852),
    /**
     *
     *
     * <pre>
     * Traffic Class 4, corresponding to DSCP ranges (24-31) 011xxx.
     * </pre>
     *
     * <code>TC4 = 82853;</code>
     */
    TC4(82853),
    /**
     *
     *
     * <pre>
     * Traffic Class 5, corresponding to DSCP ranges (32-47) 10xxxx.
     * </pre>
     *
     * <code>TC5 = 82854;</code>
     */
    TC5(82854),
    /**
     *
     *
     * <pre>
     * Traffic Class 6, corresponding to DSCP ranges (48-63) 11xxxx.
     * </pre>
     *
     * <code>TC6 = 82855;</code>
     */
    TC6(82855),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TRAFFIC_CLASS = 0;</code>
     */
    public static final int UNDEFINED_TRAFFIC_CLASS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Traffic Class 1, corresponding to DSCP ranges (0-7) 000xxx.
     * </pre>
     *
     * <code>TC1 = 82850;</code>
     */
    public static final int TC1_VALUE = 82850;

    /**
     *
     *
     * <pre>
     * Traffic Class 2, corresponding to DSCP ranges (8-15) 001xxx.
     * </pre>
     *
     * <code>TC2 = 82851;</code>
     */
    public static final int TC2_VALUE = 82851;

    /**
     *
     *
     * <pre>
     * Traffic Class 3, corresponding to DSCP ranges (16-23) 010xxx.
     * </pre>
     *
     * <code>TC3 = 82852;</code>
     */
    public static final int TC3_VALUE = 82852;

    /**
     *
     *
     * <pre>
     * Traffic Class 4, corresponding to DSCP ranges (24-31) 011xxx.
     * </pre>
     *
     * <code>TC4 = 82853;</code>
     */
    public static final int TC4_VALUE = 82853;

    /**
     *
     *
     * <pre>
     * Traffic Class 5, corresponding to DSCP ranges (32-47) 10xxxx.
     * </pre>
     *
     * <code>TC5 = 82854;</code>
     */
    public static final int TC5_VALUE = 82854;

    /**
     *
     *
     * <pre>
     * Traffic Class 6, corresponding to DSCP ranges (48-63) 11xxxx.
     * </pre>
     *
     * <code>TC6 = 82855;</code>
     */
    public static final int TC6_VALUE = 82855;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrafficClass valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrafficClass forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TRAFFIC_CLASS;
        case 82850:
          return TC1;
        case 82851:
          return TC2;
        case 82852:
          return TC3;
        case 82853:
          return TC4;
        case 82854:
          return TC5;
        case 82855:
          return TC6;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrafficClass> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrafficClass> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrafficClass>() {
          public TrafficClass findValueByNumber(int number) {
            return TrafficClass.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TrafficClass[] VALUES = values();

    public static TrafficClass valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrafficClass(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage.TrafficClass)
  }

  private int bitField0_;
  public static final int PERCENTAGE_FIELD_NUMBER = 151909018;
  private int percentage_ = 0;

  /**
   *
   *
   * <pre>
   * Bandwidth percentage for a specific traffic class.
   * </pre>
   *
   * <code>optional uint32 percentage = 151909018;</code>
   *
   * @return Whether the percentage field is set.
   */
  @java.lang.Override
  public boolean hasPercentage() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Bandwidth percentage for a specific traffic class.
   * </pre>
   *
   * <code>optional uint32 percentage = 151909018;</code>
   *
   * @return The percentage.
   */
  @java.lang.Override
  public int getPercentage() {
    return percentage_;
  }

  public static final int TRAFFIC_CLASS_FIELD_NUMBER = 198180022;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trafficClass_ = "";

  /**
   *
   *
   * <pre>
   * TrafficClass whose bandwidth percentage is being specified.
   * Check the TrafficClass enum for the list of possible values.
   * </pre>
   *
   * <code>optional string traffic_class = 198180022;</code>
   *
   * @return Whether the trafficClass field is set.
   */
  @java.lang.Override
  public boolean hasTrafficClass() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * TrafficClass whose bandwidth percentage is being specified.
   * Check the TrafficClass enum for the list of possible values.
   * </pre>
   *
   * <code>optional string traffic_class = 198180022;</code>
   *
   * @return The trafficClass.
   */
  @java.lang.Override
  public java.lang.String getTrafficClass() {
    java.lang.Object ref = trafficClass_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trafficClass_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * TrafficClass whose bandwidth percentage is being specified.
   * Check the TrafficClass enum for the list of possible values.
   * </pre>
   *
   * <code>optional string traffic_class = 198180022;</code>
   *
   * @return The bytes for trafficClass.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrafficClassBytes() {
    java.lang.Object ref = trafficClass_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trafficClass_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeUInt32(151909018, percentage_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 198180022, trafficClass_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(151909018, percentage_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(198180022, trafficClass_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage other =
        (com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)
            obj;

    if (hasPercentage() != other.hasPercentage()) return false;
    if (hasPercentage()) {
      if (getPercentage() != other.getPercentage()) return false;
    }
    if (hasTrafficClass() != other.hasTrafficClass()) return false;
    if (hasTrafficClass()) {
      if (!getTrafficClass().equals(other.getTrafficClass())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPercentage()) {
      hash = (37 * hash) + PERCENTAGE_FIELD_NUMBER;
      hash = (53 * hash) + getPercentage();
    }
    if (hasTrafficClass()) {
      hash = (37 * hash) + TRAFFIC_CLASS_FIELD_NUMBER;
      hash = (53 * hash) + getTrafficClass().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specify bandwidth percentages [1-100] for various traffic classes in BandwidthPercentagePolicy. The sum of all percentages must equal 100. All traffic classes must have a percentage value specified.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)
      com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnectBandwidthPercentage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnectBandwidthPercentage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentage.class,
              com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentage.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      percentage_ = 0;
      trafficClass_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnectBandwidthPercentage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
        build() {
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
        buildPartial() {
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
          result =
              new com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentage(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.percentage_ = percentage_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trafficClass_ = trafficClass_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage) {
        return mergeFrom(
            (com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentage)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
              .getDefaultInstance()) return this;
      if (other.hasPercentage()) {
        setPercentage(other.getPercentage());
      }
      if (other.hasTrafficClass()) {
        trafficClass_ = other.trafficClass_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1215272144:
              {
                percentage_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 1215272144
            case 1585440178:
              {
                trafficClass_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1585440178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int percentage_;

    /**
     *
     *
     * <pre>
     * Bandwidth percentage for a specific traffic class.
     * </pre>
     *
     * <code>optional uint32 percentage = 151909018;</code>
     *
     * @return Whether the percentage field is set.
     */
    @java.lang.Override
    public boolean hasPercentage() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Bandwidth percentage for a specific traffic class.
     * </pre>
     *
     * <code>optional uint32 percentage = 151909018;</code>
     *
     * @return The percentage.
     */
    @java.lang.Override
    public int getPercentage() {
      return percentage_;
    }

    /**
     *
     *
     * <pre>
     * Bandwidth percentage for a specific traffic class.
     * </pre>
     *
     * <code>optional uint32 percentage = 151909018;</code>
     *
     * @param value The percentage to set.
     * @return This builder for chaining.
     */
    public Builder setPercentage(int value) {

      percentage_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bandwidth percentage for a specific traffic class.
     * </pre>
     *
     * <code>optional uint32 percentage = 151909018;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPercentage() {
      bitField0_ = (bitField0_ & ~0x00000001);
      percentage_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object trafficClass_ = "";

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @return Whether the trafficClass field is set.
     */
    public boolean hasTrafficClass() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @return The trafficClass.
     */
    public java.lang.String getTrafficClass() {
      java.lang.Object ref = trafficClass_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trafficClass_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @return The bytes for trafficClass.
     */
    public com.google.protobuf.ByteString getTrafficClassBytes() {
      java.lang.Object ref = trafficClass_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trafficClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @param value The trafficClass to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficClass(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trafficClass_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrafficClass() {
      trafficClass_ = getDefaultInstance().getTrafficClass();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * TrafficClass whose bandwidth percentage is being specified.
     * Check the TrafficClass enum for the list of possible values.
     * </pre>
     *
     * <code>optional string traffic_class = 198180022;</code>
     *
     * @param value The bytes for trafficClass to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficClassBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trafficClass_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage)
  private static final com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentage();
  }

  public static com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentage
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          InterconnectApplicationAwareInterconnectBandwidthPercentage>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectApplicationAwareInterconnectBandwidthPercentage>() {
            @java.lang.Override
            public InterconnectApplicationAwareInterconnectBandwidthPercentage parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          InterconnectApplicationAwareInterconnectBandwidthPercentage>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectApplicationAwareInterconnectBandwidthPercentage>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
