/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Firewall Rule resource. Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Firewall}
 */
public final class Firewall extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Firewall)
    FirewallOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Firewall.newBuilder() to construct.
  private Firewall(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Firewall() {
    allowed_ = java.util.Collections.emptyList();
    creationTimestamp_ = "";
    denied_ = java.util.Collections.emptyList();
    description_ = "";
    destinationRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    direction_ = "";
    kind_ = "";
    name_ = "";
    network_ = "";
    selfLink_ = "";
    sourceRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
    targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Firewall();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Firewall_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Firewall_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Firewall.class,
            com.google.cloud.compute.v1.Firewall.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Firewall.Direction}
   */
  public enum Direction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    UNDEFINED_DIRECTION(0),
    /**
     *
     *
     * <pre>
     * Indicates that firewall should apply to outgoing traffic.
     * </pre>
     *
     * <code>EGRESS = 432880501;</code>
     */
    EGRESS(432880501),
    /**
     *
     *
     * <pre>
     * Indicates that firewall should apply to incoming traffic.
     * </pre>
     *
     * <code>INGRESS = 516931221;</code>
     */
    INGRESS(516931221),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    public static final int UNDEFINED_DIRECTION_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Indicates that firewall should apply to outgoing traffic.
     * </pre>
     *
     * <code>EGRESS = 432880501;</code>
     */
    public static final int EGRESS_VALUE = 432880501;

    /**
     *
     *
     * <pre>
     * Indicates that firewall should apply to incoming traffic.
     * </pre>
     *
     * <code>INGRESS = 516931221;</code>
     */
    public static final int INGRESS_VALUE = 516931221;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Direction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Direction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DIRECTION;
        case 432880501:
          return EGRESS;
        case 516931221:
          return INGRESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Direction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Direction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
          public Direction findValueByNumber(int number) {
            return Direction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Firewall.getDescriptor().getEnumTypes().get(0);
    }

    private static final Direction[] VALUES = values();

    public static Direction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Direction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Firewall.Direction)
  }

  private int bitField0_;
  public static final int ALLOWED_FIELD_NUMBER = 162398632;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Allowed> allowed_;

  /**
   *
   *
   * <pre>
   * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Allowed> getAllowedList() {
    return allowed_;
  }

  /**
   *
   *
   * <pre>
   * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AllowedOrBuilder>
      getAllowedOrBuilderList() {
    return allowed_;
  }

  /**
   *
   *
   * <pre>
   * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
   */
  @java.lang.Override
  public int getAllowedCount() {
    return allowed_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Allowed getAllowed(int index) {
    return allowed_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllowedOrBuilder getAllowedOrBuilder(int index) {
    return allowed_.get(index);
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DENIED_FIELD_NUMBER = 275217307;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Denied> denied_;

  /**
   *
   *
   * <pre>
   * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Denied> getDeniedList() {
    return denied_;
  }

  /**
   *
   *
   * <pre>
   * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.DeniedOrBuilder>
      getDeniedOrBuilderList() {
    return denied_;
  }

  /**
   *
   *
   * <pre>
   * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
   */
  @java.lang.Override
  public int getDeniedCount() {
    return denied_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Denied getDenied(int index) {
    return denied_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DeniedOrBuilder getDeniedOrBuilder(int index) {
    return denied_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_RANGES_FIELD_NUMBER = 305699879;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList destinationRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string destination_ranges = 305699879;</code>
   *
   * @return A list containing the destinationRanges.
   */
  public com.google.protobuf.ProtocolStringList getDestinationRangesList() {
    return destinationRanges_;
  }

  /**
   *
   *
   * <pre>
   * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string destination_ranges = 305699879;</code>
   *
   * @return The count of destinationRanges.
   */
  public int getDestinationRangesCount() {
    return destinationRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string destination_ranges = 305699879;</code>
   *
   * @param index The index of the element to return.
   * @return The destinationRanges at the given index.
   */
  public java.lang.String getDestinationRanges(int index) {
    return destinationRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string destination_ranges = 305699879;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destinationRanges at the given index.
   */
  public com.google.protobuf.ByteString getDestinationRangesBytes(int index) {
    return destinationRanges_.getByteString(index);
  }

  public static final int DIRECTION_FIELD_NUMBER = 111150975;

  @SuppressWarnings("serial")
  private volatile java.lang.Object direction_ = "";

  /**
   *
   *
   * <pre>
   * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return Whether the direction field is set.
   */
  @java.lang.Override
  public boolean hasDirection() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The direction.
   */
  @java.lang.Override
  public java.lang.String getDirection() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      direction_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The bytes for direction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirectionBytes() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      direction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 270940796;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_CONFIG_FIELD_NUMBER = 351299741;
  private com.google.cloud.compute.v1.FirewallLogConfig logConfig_;

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  @java.lang.Override
  public boolean hasLogConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallLogConfig getLogConfig() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.FirewallLogConfig.getDefaultInstance()
        : logConfig_;
  }

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallLogConfigOrBuilder getLogConfigOrBuilder() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.FirewallLogConfig.getDefaultInstance()
        : logConfig_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMS_FIELD_NUMBER = 78313862;
  private com.google.cloud.compute.v1.FirewallParams params_;

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallParams getParams() {
    return params_ == null
        ? com.google.cloud.compute.v1.FirewallParams.getDefaultInstance()
        : params_;
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallParamsOrBuilder getParamsOrBuilder() {
    return params_ == null
        ? com.google.cloud.compute.v1.FirewallParams.getDefaultInstance()
        : params_;
  }

  public static final int PRIORITY_FIELD_NUMBER = 445151652;
  private int priority_ = 0;

  /**
   *
   *
   * <pre>
   * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return Whether the priority field is set.
   */
  @java.lang.Override
  public boolean hasPriority() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_RANGES_FIELD_NUMBER = 200097658;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string source_ranges = 200097658;</code>
   *
   * @return A list containing the sourceRanges.
   */
  public com.google.protobuf.ProtocolStringList getSourceRangesList() {
    return sourceRanges_;
  }

  /**
   *
   *
   * <pre>
   * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string source_ranges = 200097658;</code>
   *
   * @return The count of sourceRanges.
   */
  public int getSourceRangesCount() {
    return sourceRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string source_ranges = 200097658;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceRanges at the given index.
   */
  public java.lang.String getSourceRanges(int index) {
    return sourceRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
   * </pre>
   *
   * <code>repeated string source_ranges = 200097658;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceRanges at the given index.
   */
  public com.google.protobuf.ByteString getSourceRangesBytes(int index) {
    return sourceRanges_.getByteString(index);
  }

  public static final int SOURCE_SERVICE_ACCOUNTS_FIELD_NUMBER = 105100756;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceServiceAccounts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
   * </pre>
   *
   * <code>repeated string source_service_accounts = 105100756;</code>
   *
   * @return A list containing the sourceServiceAccounts.
   */
  public com.google.protobuf.ProtocolStringList getSourceServiceAccountsList() {
    return sourceServiceAccounts_;
  }

  /**
   *
   *
   * <pre>
   * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
   * </pre>
   *
   * <code>repeated string source_service_accounts = 105100756;</code>
   *
   * @return The count of sourceServiceAccounts.
   */
  public int getSourceServiceAccountsCount() {
    return sourceServiceAccounts_.size();
  }

  /**
   *
   *
   * <pre>
   * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
   * </pre>
   *
   * <code>repeated string source_service_accounts = 105100756;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceServiceAccounts at the given index.
   */
  public java.lang.String getSourceServiceAccounts(int index) {
    return sourceServiceAccounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
   * </pre>
   *
   * <code>repeated string source_service_accounts = 105100756;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceServiceAccounts at the given index.
   */
  public com.google.protobuf.ByteString getSourceServiceAccountsBytes(int index) {
    return sourceServiceAccounts_.getByteString(index);
  }

  public static final int SOURCE_TAGS_FIELD_NUMBER = 452222397;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
   * </pre>
   *
   * <code>repeated string source_tags = 452222397;</code>
   *
   * @return A list containing the sourceTags.
   */
  public com.google.protobuf.ProtocolStringList getSourceTagsList() {
    return sourceTags_;
  }

  /**
   *
   *
   * <pre>
   * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
   * </pre>
   *
   * <code>repeated string source_tags = 452222397;</code>
   *
   * @return The count of sourceTags.
   */
  public int getSourceTagsCount() {
    return sourceTags_.size();
  }

  /**
   *
   *
   * <pre>
   * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
   * </pre>
   *
   * <code>repeated string source_tags = 452222397;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceTags at the given index.
   */
  public java.lang.String getSourceTags(int index) {
    return sourceTags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
   * </pre>
   *
   * <code>repeated string source_tags = 452222397;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceTags at the given index.
   */
  public com.google.protobuf.ByteString getSourceTagsBytes(int index) {
    return sourceTags_.getByteString(index);
  }

  public static final int TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER = 457639710;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @return A list containing the targetServiceAccounts.
   */
  public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
    return targetServiceAccounts_;
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @return The count of targetServiceAccounts.
   */
  public int getTargetServiceAccountsCount() {
    return targetServiceAccounts_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @param index The index of the element to return.
   * @return The targetServiceAccounts at the given index.
   */
  public java.lang.String getTargetServiceAccounts(int index) {
    return targetServiceAccounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetServiceAccounts at the given index.
   */
  public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
    return targetServiceAccounts_.getByteString(index);
  }

  public static final int TARGET_TAGS_FIELD_NUMBER = 62901767;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_tags = 62901767;</code>
   *
   * @return A list containing the targetTags.
   */
  public com.google.protobuf.ProtocolStringList getTargetTagsList() {
    return targetTags_;
  }

  /**
   *
   *
   * <pre>
   * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_tags = 62901767;</code>
   *
   * @return The count of targetTags.
   */
  public int getTargetTagsCount() {
    return targetTags_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_tags = 62901767;</code>
   *
   * @param index The index of the element to return.
   * @return The targetTags at the given index.
   */
  public java.lang.String getTargetTags(int index) {
    return targetTags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
   * </pre>
   *
   * <code>repeated string target_tags = 62901767;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetTags at the given index.
   */
  public com.google.protobuf.ByteString getTargetTagsBytes(int index) {
    return targetTags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    for (int i = 0; i < targetTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 62901767, targetTags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(78313862, getParams());
    }
    for (int i = 0; i < sourceServiceAccounts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 105100756, sourceServiceAccounts_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 111150975, direction_);
    }
    for (int i = 0; i < allowed_.size(); i++) {
      output.writeMessage(162398632, allowed_.get(i));
    }
    for (int i = 0; i < sourceRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 200097658, sourceRanges_.getRaw(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(270940796, disabled_);
    }
    for (int i = 0; i < denied_.size(); i++) {
      output.writeMessage(275217307, denied_.get(i));
    }
    for (int i = 0; i < destinationRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 305699879, destinationRanges_.getRaw(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt32(445151652, priority_);
    }
    for (int i = 0; i < sourceTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 452222397, sourceTags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < targetServiceAccounts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 457639710, targetServiceAccounts_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetTags_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getTargetTagsList().size();
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(78313862, getParams());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceServiceAccounts_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceServiceAccounts_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceServiceAccountsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(111150975, direction_);
    }
    for (int i = 0; i < allowed_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(162398632, allowed_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceRangesList().size();
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(270940796, disabled_);
    }
    for (int i = 0; i < denied_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(275217307, denied_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < destinationRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(destinationRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDestinationRangesList().size();
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(445151652, priority_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceTags_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceTagsList().size();
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetServiceAccounts_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetServiceAccounts_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getTargetServiceAccountsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Firewall)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Firewall other = (com.google.cloud.compute.v1.Firewall) obj;

    if (!getAllowedList().equals(other.getAllowedList())) return false;
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (!getDeniedList().equals(other.getDeniedList())) return false;
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDestinationRangesList().equals(other.getDestinationRangesList())) return false;
    if (hasDirection() != other.hasDirection()) return false;
    if (hasDirection()) {
      if (!getDirection().equals(other.getDirection())) return false;
    }
    if (hasDisabled() != other.hasDisabled()) return false;
    if (hasDisabled()) {
      if (getDisabled() != other.getDisabled()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLogConfig() != other.hasLogConfig()) return false;
    if (hasLogConfig()) {
      if (!getLogConfig().equals(other.getLogConfig())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (hasPriority() != other.hasPriority()) return false;
    if (hasPriority()) {
      if (getPriority() != other.getPriority()) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getSourceRangesList().equals(other.getSourceRangesList())) return false;
    if (!getSourceServiceAccountsList().equals(other.getSourceServiceAccountsList())) return false;
    if (!getSourceTagsList().equals(other.getSourceTagsList())) return false;
    if (!getTargetServiceAccountsList().equals(other.getTargetServiceAccountsList())) return false;
    if (!getTargetTagsList().equals(other.getTargetTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedCount() > 0) {
      hash = (37 * hash) + ALLOWED_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedList().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (getDeniedCount() > 0) {
      hash = (37 * hash) + DENIED_FIELD_NUMBER;
      hash = (53 * hash) + getDeniedList().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDestinationRangesCount() > 0) {
      hash = (37 * hash) + DESTINATION_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationRangesList().hashCode();
    }
    if (hasDirection()) {
      hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
      hash = (53 * hash) + getDirection().hashCode();
    }
    if (hasDisabled()) {
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLogConfig()) {
      hash = (37 * hash) + LOG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLogConfig().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (hasPriority()) {
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getSourceRangesCount() > 0) {
      hash = (37 * hash) + SOURCE_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSourceRangesList().hashCode();
    }
    if (getSourceServiceAccountsCount() > 0) {
      hash = (37 * hash) + SOURCE_SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceServiceAccountsList().hashCode();
    }
    if (getSourceTagsCount() > 0) {
      hash = (37 * hash) + SOURCE_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceTagsList().hashCode();
    }
    if (getTargetServiceAccountsCount() > 0) {
      hash = (37 * hash) + TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetServiceAccountsList().hashCode();
    }
    if (getTargetTagsCount() > 0) {
      hash = (37 * hash) + TARGET_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Firewall parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Firewall parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Firewall parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Firewall prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Firewall Rule resource. Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Firewall}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Firewall)
      com.google.cloud.compute.v1.FirewallOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Firewall_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Firewall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Firewall.class,
              com.google.cloud.compute.v1.Firewall.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Firewall.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAllowedFieldBuilder();
        getDeniedFieldBuilder();
        getLogConfigFieldBuilder();
        getParamsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (allowedBuilder_ == null) {
        allowed_ = java.util.Collections.emptyList();
      } else {
        allowed_ = null;
        allowedBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      creationTimestamp_ = "";
      if (deniedBuilder_ == null) {
        denied_ = java.util.Collections.emptyList();
      } else {
        denied_ = null;
        deniedBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      description_ = "";
      destinationRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      direction_ = "";
      disabled_ = false;
      id_ = 0L;
      kind_ = "";
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      name_ = "";
      network_ = "";
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      priority_ = 0;
      selfLink_ = "";
      sourceRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Firewall_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Firewall getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Firewall.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Firewall build() {
      com.google.cloud.compute.v1.Firewall result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Firewall buildPartial() {
      com.google.cloud.compute.v1.Firewall result = new com.google.cloud.compute.v1.Firewall(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Firewall result) {
      if (allowedBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          allowed_ = java.util.Collections.unmodifiableList(allowed_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.allowed_ = allowed_;
      } else {
        result.allowed_ = allowedBuilder_.build();
      }
      if (deniedBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          denied_ = java.util.Collections.unmodifiableList(denied_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.denied_ = denied_;
      } else {
        result.denied_ = deniedBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Firewall result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        destinationRanges_.makeImmutable();
        result.destinationRanges_ = destinationRanges_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.direction_ = direction_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.disabled_ = disabled_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.logConfig_ = logConfigBuilder_ == null ? logConfig_ : logConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.priority_ = priority_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        sourceRanges_.makeImmutable();
        result.sourceRanges_ = sourceRanges_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        sourceServiceAccounts_.makeImmutable();
        result.sourceServiceAccounts_ = sourceServiceAccounts_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        sourceTags_.makeImmutable();
        result.sourceTags_ = sourceTags_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        targetServiceAccounts_.makeImmutable();
        result.targetServiceAccounts_ = targetServiceAccounts_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        targetTags_.makeImmutable();
        result.targetTags_ = targetTags_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Firewall) {
        return mergeFrom((com.google.cloud.compute.v1.Firewall) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Firewall other) {
      if (other == com.google.cloud.compute.v1.Firewall.getDefaultInstance()) return this;
      if (allowedBuilder_ == null) {
        if (!other.allowed_.isEmpty()) {
          if (allowed_.isEmpty()) {
            allowed_ = other.allowed_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAllowedIsMutable();
            allowed_.addAll(other.allowed_);
          }
          onChanged();
        }
      } else {
        if (!other.allowed_.isEmpty()) {
          if (allowedBuilder_.isEmpty()) {
            allowedBuilder_.dispose();
            allowedBuilder_ = null;
            allowed_ = other.allowed_;
            bitField0_ = (bitField0_ & ~0x00000001);
            allowedBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAllowedFieldBuilder()
                    : null;
          } else {
            allowedBuilder_.addAllMessages(other.allowed_);
          }
        }
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (deniedBuilder_ == null) {
        if (!other.denied_.isEmpty()) {
          if (denied_.isEmpty()) {
            denied_ = other.denied_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureDeniedIsMutable();
            denied_.addAll(other.denied_);
          }
          onChanged();
        }
      } else {
        if (!other.denied_.isEmpty()) {
          if (deniedBuilder_.isEmpty()) {
            deniedBuilder_.dispose();
            deniedBuilder_ = null;
            denied_ = other.denied_;
            bitField0_ = (bitField0_ & ~0x00000004);
            deniedBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeniedFieldBuilder()
                    : null;
          } else {
            deniedBuilder_.addAllMessages(other.denied_);
          }
        }
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.destinationRanges_.isEmpty()) {
        if (destinationRanges_.isEmpty()) {
          destinationRanges_ = other.destinationRanges_;
          bitField0_ |= 0x00000010;
        } else {
          ensureDestinationRangesIsMutable();
          destinationRanges_.addAll(other.destinationRanges_);
        }
        onChanged();
      }
      if (other.hasDirection()) {
        direction_ = other.direction_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasDisabled()) {
        setDisabled(other.getDisabled());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasLogConfig()) {
        mergeLogConfig(other.getLogConfig());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      if (other.hasPriority()) {
        setPriority(other.getPriority());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.sourceRanges_.isEmpty()) {
        if (sourceRanges_.isEmpty()) {
          sourceRanges_ = other.sourceRanges_;
          bitField0_ |= 0x00008000;
        } else {
          ensureSourceRangesIsMutable();
          sourceRanges_.addAll(other.sourceRanges_);
        }
        onChanged();
      }
      if (!other.sourceServiceAccounts_.isEmpty()) {
        if (sourceServiceAccounts_.isEmpty()) {
          sourceServiceAccounts_ = other.sourceServiceAccounts_;
          bitField0_ |= 0x00010000;
        } else {
          ensureSourceServiceAccountsIsMutable();
          sourceServiceAccounts_.addAll(other.sourceServiceAccounts_);
        }
        onChanged();
      }
      if (!other.sourceTags_.isEmpty()) {
        if (sourceTags_.isEmpty()) {
          sourceTags_ = other.sourceTags_;
          bitField0_ |= 0x00020000;
        } else {
          ensureSourceTagsIsMutable();
          sourceTags_.addAll(other.sourceTags_);
        }
        onChanged();
      }
      if (!other.targetServiceAccounts_.isEmpty()) {
        if (targetServiceAccounts_.isEmpty()) {
          targetServiceAccounts_ = other.targetServiceAccounts_;
          bitField0_ |= 0x00040000;
        } else {
          ensureTargetServiceAccountsIsMutable();
          targetServiceAccounts_.addAll(other.targetServiceAccounts_);
        }
        onChanged();
      }
      if (!other.targetTags_.isEmpty()) {
        if (targetTags_.isEmpty()) {
          targetTags_ = other.targetTags_;
          bitField0_ |= 0x00080000;
        } else {
          ensureTargetTagsIsMutable();
          targetTags_.addAll(other.targetTags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 503214138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetTagsIsMutable();
                targetTags_.add(s);
                break;
              } // case 503214138
            case 626510898:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 626510898
            case 840806050:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceServiceAccountsIsMutable();
                sourceServiceAccounts_.add(s);
                break;
              } // case 840806050
            case 889207802:
              {
                direction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 889207802
            case 1299189058:
              {
                com.google.cloud.compute.v1.Allowed m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Allowed.parser(), extensionRegistry);
                if (allowedBuilder_ == null) {
                  ensureAllowedIsMutable();
                  allowed_.add(m);
                } else {
                  allowedBuilder_.addMessage(m);
                }
                break;
              } // case 1299189058
            case 1600781266:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceRangesIsMutable();
                sourceRanges_.add(s);
                break;
              } // case 1600781266
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1862979954
            case -2127440928:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case -2127440928
            case -2093228838:
              {
                com.google.cloud.compute.v1.Denied m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Denied.parser(), extensionRegistry);
                if (deniedBuilder_ == null) {
                  ensureDeniedIsMutable();
                  denied_.add(m);
                } else {
                  deniedBuilder_.addMessage(m);
                }
                break;
              } // case -2093228838
            case -1849368262:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestinationRangesIsMutable();
                destinationRanges_.add(s);
                break;
              } // case -1849368262
            case -1484569366:
              {
                input.readMessage(getLogConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case -1484569366
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -733754080:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case -733754080
            case -677188118:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceTagsIsMutable();
                sourceTags_.add(s);
                break;
              } // case -677188118
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            case -633849614:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetServiceAccountsIsMutable();
                targetServiceAccounts_.add(s);
                break;
              } // case -633849614
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.Allowed> allowed_ =
        java.util.Collections.emptyList();

    private void ensureAllowedIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowed_ = new java.util.ArrayList<com.google.cloud.compute.v1.Allowed>(allowed_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Allowed,
            com.google.cloud.compute.v1.Allowed.Builder,
            com.google.cloud.compute.v1.AllowedOrBuilder>
        allowedBuilder_;

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Allowed> getAllowedList() {
      if (allowedBuilder_ == null) {
        return java.util.Collections.unmodifiableList(allowed_);
      } else {
        return allowedBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public int getAllowedCount() {
      if (allowedBuilder_ == null) {
        return allowed_.size();
      } else {
        return allowedBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public com.google.cloud.compute.v1.Allowed getAllowed(int index) {
      if (allowedBuilder_ == null) {
        return allowed_.get(index);
      } else {
        return allowedBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder setAllowed(int index, com.google.cloud.compute.v1.Allowed value) {
      if (allowedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIsMutable();
        allowed_.set(index, value);
        onChanged();
      } else {
        allowedBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder setAllowed(
        int index, com.google.cloud.compute.v1.Allowed.Builder builderForValue) {
      if (allowedBuilder_ == null) {
        ensureAllowedIsMutable();
        allowed_.set(index, builderForValue.build());
        onChanged();
      } else {
        allowedBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder addAllowed(com.google.cloud.compute.v1.Allowed value) {
      if (allowedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIsMutable();
        allowed_.add(value);
        onChanged();
      } else {
        allowedBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder addAllowed(int index, com.google.cloud.compute.v1.Allowed value) {
      if (allowedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIsMutable();
        allowed_.add(index, value);
        onChanged();
      } else {
        allowedBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder addAllowed(com.google.cloud.compute.v1.Allowed.Builder builderForValue) {
      if (allowedBuilder_ == null) {
        ensureAllowedIsMutable();
        allowed_.add(builderForValue.build());
        onChanged();
      } else {
        allowedBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder addAllowed(
        int index, com.google.cloud.compute.v1.Allowed.Builder builderForValue) {
      if (allowedBuilder_ == null) {
        ensureAllowedIsMutable();
        allowed_.add(index, builderForValue.build());
        onChanged();
      } else {
        allowedBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder addAllAllowed(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Allowed> values) {
      if (allowedBuilder_ == null) {
        ensureAllowedIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowed_);
        onChanged();
      } else {
        allowedBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder clearAllowed() {
      if (allowedBuilder_ == null) {
        allowed_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        allowedBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public Builder removeAllowed(int index) {
      if (allowedBuilder_ == null) {
        ensureAllowedIsMutable();
        allowed_.remove(index);
        onChanged();
      } else {
        allowedBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public com.google.cloud.compute.v1.Allowed.Builder getAllowedBuilder(int index) {
      return getAllowedFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public com.google.cloud.compute.v1.AllowedOrBuilder getAllowedOrBuilder(int index) {
      if (allowedBuilder_ == null) {
        return allowed_.get(index);
      } else {
        return allowedBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AllowedOrBuilder>
        getAllowedOrBuilderList() {
      if (allowedBuilder_ != null) {
        return allowedBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(allowed_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public com.google.cloud.compute.v1.Allowed.Builder addAllowedBuilder() {
      return getAllowedFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Allowed.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public com.google.cloud.compute.v1.Allowed.Builder addAllowedBuilder(int index) {
      return getAllowedFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Allowed.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Allowed allowed = 162398632;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Allowed.Builder> getAllowedBuilderList() {
      return getAllowedFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Allowed,
            com.google.cloud.compute.v1.Allowed.Builder,
            com.google.cloud.compute.v1.AllowedOrBuilder>
        getAllowedFieldBuilder() {
      if (allowedBuilder_ == null) {
        allowedBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Allowed,
                com.google.cloud.compute.v1.Allowed.Builder,
                com.google.cloud.compute.v1.AllowedOrBuilder>(
                allowed_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        allowed_ = null;
      }
      return allowedBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Denied> denied_ =
        java.util.Collections.emptyList();

    private void ensureDeniedIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        denied_ = new java.util.ArrayList<com.google.cloud.compute.v1.Denied>(denied_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Denied,
            com.google.cloud.compute.v1.Denied.Builder,
            com.google.cloud.compute.v1.DeniedOrBuilder>
        deniedBuilder_;

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Denied> getDeniedList() {
      if (deniedBuilder_ == null) {
        return java.util.Collections.unmodifiableList(denied_);
      } else {
        return deniedBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public int getDeniedCount() {
      if (deniedBuilder_ == null) {
        return denied_.size();
      } else {
        return deniedBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public com.google.cloud.compute.v1.Denied getDenied(int index) {
      if (deniedBuilder_ == null) {
        return denied_.get(index);
      } else {
        return deniedBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder setDenied(int index, com.google.cloud.compute.v1.Denied value) {
      if (deniedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedIsMutable();
        denied_.set(index, value);
        onChanged();
      } else {
        deniedBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder setDenied(
        int index, com.google.cloud.compute.v1.Denied.Builder builderForValue) {
      if (deniedBuilder_ == null) {
        ensureDeniedIsMutable();
        denied_.set(index, builderForValue.build());
        onChanged();
      } else {
        deniedBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder addDenied(com.google.cloud.compute.v1.Denied value) {
      if (deniedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedIsMutable();
        denied_.add(value);
        onChanged();
      } else {
        deniedBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder addDenied(int index, com.google.cloud.compute.v1.Denied value) {
      if (deniedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedIsMutable();
        denied_.add(index, value);
        onChanged();
      } else {
        deniedBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder addDenied(com.google.cloud.compute.v1.Denied.Builder builderForValue) {
      if (deniedBuilder_ == null) {
        ensureDeniedIsMutable();
        denied_.add(builderForValue.build());
        onChanged();
      } else {
        deniedBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder addDenied(
        int index, com.google.cloud.compute.v1.Denied.Builder builderForValue) {
      if (deniedBuilder_ == null) {
        ensureDeniedIsMutable();
        denied_.add(index, builderForValue.build());
        onChanged();
      } else {
        deniedBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder addAllDenied(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Denied> values) {
      if (deniedBuilder_ == null) {
        ensureDeniedIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, denied_);
        onChanged();
      } else {
        deniedBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder clearDenied() {
      if (deniedBuilder_ == null) {
        denied_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        deniedBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public Builder removeDenied(int index) {
      if (deniedBuilder_ == null) {
        ensureDeniedIsMutable();
        denied_.remove(index);
        onChanged();
      } else {
        deniedBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public com.google.cloud.compute.v1.Denied.Builder getDeniedBuilder(int index) {
      return getDeniedFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public com.google.cloud.compute.v1.DeniedOrBuilder getDeniedOrBuilder(int index) {
      if (deniedBuilder_ == null) {
        return denied_.get(index);
      } else {
        return deniedBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.DeniedOrBuilder>
        getDeniedOrBuilderList() {
      if (deniedBuilder_ != null) {
        return deniedBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(denied_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public com.google.cloud.compute.v1.Denied.Builder addDeniedBuilder() {
      return getDeniedFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Denied.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public com.google.cloud.compute.v1.Denied.Builder addDeniedBuilder(int index) {
      return getDeniedFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Denied.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Denied denied = 275217307;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Denied.Builder> getDeniedBuilderList() {
      return getDeniedFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Denied,
            com.google.cloud.compute.v1.Denied.Builder,
            com.google.cloud.compute.v1.DeniedOrBuilder>
        getDeniedFieldBuilder() {
      if (deniedBuilder_ == null) {
        deniedBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Denied,
                com.google.cloud.compute.v1.Denied.Builder,
                com.google.cloud.compute.v1.DeniedOrBuilder>(
                denied_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        denied_ = null;
      }
      return deniedBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList destinationRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDestinationRangesIsMutable() {
      if (!destinationRanges_.isModifiable()) {
        destinationRanges_ = new com.google.protobuf.LazyStringArrayList(destinationRanges_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @return A list containing the destinationRanges.
     */
    public com.google.protobuf.ProtocolStringList getDestinationRangesList() {
      destinationRanges_.makeImmutable();
      return destinationRanges_;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @return The count of destinationRanges.
     */
    public int getDestinationRangesCount() {
      return destinationRanges_.size();
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param index The index of the element to return.
     * @return The destinationRanges at the given index.
     */
    public java.lang.String getDestinationRanges(int index) {
      return destinationRanges_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destinationRanges at the given index.
     */
    public com.google.protobuf.ByteString getDestinationRangesBytes(int index) {
      return destinationRanges_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param index The index to set the value at.
     * @param value The destinationRanges to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestinationRangesIsMutable();
      destinationRanges_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param value The destinationRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestinationRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestinationRangesIsMutable();
      destinationRanges_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param values The destinationRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestinationRanges(java.lang.Iterable<java.lang.String> values) {
      ensureDestinationRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destinationRanges_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationRanges() {
      destinationRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string destination_ranges = 305699879;</code>
     *
     * @param value The bytes of the destinationRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestinationRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestinationRangesIsMutable();
      destinationRanges_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object direction_ = "";

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return Whether the direction field is set.
     */
    public boolean hasDirection() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The direction.
     */
    public java.lang.String getDirection() {
      java.lang.Object ref = direction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        direction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The bytes for direction.
     */
    public com.google.protobuf.ByteString getDirectionBytes() {
      java.lang.Object ref = direction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        direction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirection(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      direction_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirection() {
      direction_ = getDefaultInstance().getDirection();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The bytes for direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirectionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      direction_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000040);
      disabled_ = false;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#firewall for firewall rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.FirewallLogConfig logConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallLogConfig,
            com.google.cloud.compute.v1.FirewallLogConfig.Builder,
            com.google.cloud.compute.v1.FirewallLogConfigOrBuilder>
        logConfigBuilder_;

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     *
     * @return Whether the logConfig field is set.
     */
    public boolean hasLogConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     *
     * @return The logConfig.
     */
    public com.google.cloud.compute.v1.FirewallLogConfig getLogConfig() {
      if (logConfigBuilder_ == null) {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.FirewallLogConfig.getDefaultInstance()
            : logConfig_;
      } else {
        return logConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(com.google.cloud.compute.v1.FirewallLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logConfig_ = value;
      } else {
        logConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(
        com.google.cloud.compute.v1.FirewallLogConfig.Builder builderForValue) {
      if (logConfigBuilder_ == null) {
        logConfig_ = builderForValue.build();
      } else {
        logConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public Builder mergeLogConfig(com.google.cloud.compute.v1.FirewallLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && logConfig_ != null
            && logConfig_ != com.google.cloud.compute.v1.FirewallLogConfig.getDefaultInstance()) {
          getLogConfigBuilder().mergeFrom(value);
        } else {
          logConfig_ = value;
        }
      } else {
        logConfigBuilder_.mergeFrom(value);
      }
      if (logConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public Builder clearLogConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.FirewallLogConfig.Builder getLogConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLogConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.FirewallLogConfigOrBuilder getLogConfigOrBuilder() {
      if (logConfigBuilder_ != null) {
        return logConfigBuilder_.getMessageOrBuilder();
      } else {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.FirewallLogConfig.getDefaultInstance()
            : logConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallLogConfig log_config = 351299741;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallLogConfig,
            com.google.cloud.compute.v1.FirewallLogConfig.Builder,
            com.google.cloud.compute.v1.FirewallLogConfigOrBuilder>
        getLogConfigFieldBuilder() {
      if (logConfigBuilder_ == null) {
        logConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallLogConfig,
                com.google.cloud.compute.v1.FirewallLogConfig.Builder,
                com.google.cloud.compute.v1.FirewallLogConfigOrBuilder>(
                getLogConfig(), getParentForChildren(), isClean());
        logConfig_ = null;
      }
      return logConfigBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used: global/networks/default If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs: - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network - projects/myproject/global/networks/my-network - global/networks/default
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.FirewallParams params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallParams,
            com.google.cloud.compute.v1.FirewallParams.Builder,
            com.google.cloud.compute.v1.FirewallParamsOrBuilder>
        paramsBuilder_;

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     *
     * @return The params.
     */
    public com.google.cloud.compute.v1.FirewallParams getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null
            ? com.google.cloud.compute.v1.FirewallParams.getDefaultInstance()
            : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.FirewallParams value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.FirewallParams.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public Builder mergeParams(com.google.cloud.compute.v1.FirewallParams value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && params_ != null
            && params_ != com.google.cloud.compute.v1.FirewallParams.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00001000);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.FirewallParams.Builder getParamsBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.FirewallParamsOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null
            ? com.google.cloud.compute.v1.FirewallParams.getDefaultInstance()
            : params_;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallParams params = 78313862;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallParams,
            com.google.cloud.compute.v1.FirewallParams.Builder,
            com.google.cloud.compute.v1.FirewallParamsOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallParams,
                com.google.cloud.compute.v1.FirewallParams.Builder,
                com.google.cloud.compute.v1.FirewallParamsOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private int priority_;

    /**
     *
     *
     * <pre>
     * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    public boolean hasPriority() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }

    /**
     *
     *
     * <pre>
     * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00002000);
      priority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceRangesIsMutable() {
      if (!sourceRanges_.isModifiable()) {
        sourceRanges_ = new com.google.protobuf.LazyStringArrayList(sourceRanges_);
      }
      bitField0_ |= 0x00008000;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @return A list containing the sourceRanges.
     */
    public com.google.protobuf.ProtocolStringList getSourceRangesList() {
      sourceRanges_.makeImmutable();
      return sourceRanges_;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @return The count of sourceRanges.
     */
    public int getSourceRangesCount() {
      return sourceRanges_.size();
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceRanges at the given index.
     */
    public java.lang.String getSourceRanges(int index) {
      return sourceRanges_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceRanges at the given index.
     */
    public com.google.protobuf.ByteString getSourceRangesBytes(int index) {
      return sourceRanges_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSourceRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceRangesIsMutable();
      sourceRanges_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param value The sourceRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceRangesIsMutable();
      sourceRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param values The sourceRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSourceRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceRanges_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceRanges() {
      sourceRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Both IPv4 and IPv6 are supported.
     * </pre>
     *
     * <code>repeated string source_ranges = 200097658;</code>
     *
     * @param value The bytes of the sourceRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceRangesIsMutable();
      sourceRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceServiceAccounts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceServiceAccountsIsMutable() {
      if (!sourceServiceAccounts_.isModifiable()) {
        sourceServiceAccounts_ =
            new com.google.protobuf.LazyStringArrayList(sourceServiceAccounts_);
      }
      bitField0_ |= 0x00010000;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @return A list containing the sourceServiceAccounts.
     */
    public com.google.protobuf.ProtocolStringList getSourceServiceAccountsList() {
      sourceServiceAccounts_.makeImmutable();
      return sourceServiceAccounts_;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @return The count of sourceServiceAccounts.
     */
    public int getSourceServiceAccountsCount() {
      return sourceServiceAccounts_.size();
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceServiceAccounts at the given index.
     */
    public java.lang.String getSourceServiceAccounts(int index) {
      return sourceServiceAccounts_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceServiceAccounts at the given index.
     */
    public com.google.protobuf.ByteString getSourceServiceAccountsBytes(int index) {
      return sourceServiceAccounts_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceServiceAccounts to set.
     * @return This builder for chaining.
     */
    public Builder setSourceServiceAccounts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceServiceAccountsIsMutable();
      sourceServiceAccounts_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param value The sourceServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addSourceServiceAccounts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceServiceAccountsIsMutable();
      sourceServiceAccounts_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param values The sourceServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceServiceAccounts(java.lang.Iterable<java.lang.String> values) {
      ensureSourceServiceAccountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceServiceAccounts_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceServiceAccounts() {
      sourceServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
     * </pre>
     *
     * <code>repeated string source_service_accounts = 105100756;</code>
     *
     * @param value The bytes of the sourceServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addSourceServiceAccountsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceServiceAccountsIsMutable();
      sourceServiceAccounts_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceTagsIsMutable() {
      if (!sourceTags_.isModifiable()) {
        sourceTags_ = new com.google.protobuf.LazyStringArrayList(sourceTags_);
      }
      bitField0_ |= 0x00020000;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @return A list containing the sourceTags.
     */
    public com.google.protobuf.ProtocolStringList getSourceTagsList() {
      sourceTags_.makeImmutable();
      return sourceTags_;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @return The count of sourceTags.
     */
    public int getSourceTagsCount() {
      return sourceTags_.size();
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceTags at the given index.
     */
    public java.lang.String getSourceTags(int index) {
      return sourceTags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceTags at the given index.
     */
    public com.google.protobuf.ByteString getSourceTagsBytes(int index) {
      return sourceTags_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceTags to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceTagsIsMutable();
      sourceTags_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param value The sourceTags to add.
     * @return This builder for chaining.
     */
    public Builder addSourceTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceTagsIsMutable();
      sourceTags_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param values The sourceTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceTags(java.lang.Iterable<java.lang.String> values) {
      ensureSourceTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceTags_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceTags() {
      sourceTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
     * </pre>
     *
     * <code>repeated string source_tags = 452222397;</code>
     *
     * @param value The bytes of the sourceTags to add.
     * @return This builder for chaining.
     */
    public Builder addSourceTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceTagsIsMutable();
      sourceTags_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetServiceAccountsIsMutable() {
      if (!targetServiceAccounts_.isModifiable()) {
        targetServiceAccounts_ =
            new com.google.protobuf.LazyStringArrayList(targetServiceAccounts_);
      }
      bitField0_ |= 0x00040000;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return A list containing the targetServiceAccounts.
     */
    public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
      targetServiceAccounts_.makeImmutable();
      return targetServiceAccounts_;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return The count of targetServiceAccounts.
     */
    public int getTargetServiceAccountsCount() {
      return targetServiceAccounts_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index of the element to return.
     * @return The targetServiceAccounts at the given index.
     */
    public java.lang.String getTargetServiceAccounts(int index) {
      return targetServiceAccounts_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetServiceAccounts at the given index.
     */
    public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
      return targetServiceAccounts_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetServiceAccounts to set.
     * @return This builder for chaining.
     */
    public Builder setTargetServiceAccounts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.set(index, value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param value The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccounts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param values The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetServiceAccounts(java.lang.Iterable<java.lang.String> values) {
      ensureTargetServiceAccountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetServiceAccounts_);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetServiceAccounts() {
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00040000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param value The bytes of the targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccountsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetTagsIsMutable() {
      if (!targetTags_.isModifiable()) {
        targetTags_ = new com.google.protobuf.LazyStringArrayList(targetTags_);
      }
      bitField0_ |= 0x00080000;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @return A list containing the targetTags.
     */
    public com.google.protobuf.ProtocolStringList getTargetTagsList() {
      targetTags_.makeImmutable();
      return targetTags_;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @return The count of targetTags.
     */
    public int getTargetTagsCount() {
      return targetTags_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param index The index of the element to return.
     * @return The targetTags at the given index.
     */
    public java.lang.String getTargetTags(int index) {
      return targetTags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetTags at the given index.
     */
    public com.google.protobuf.ByteString getTargetTagsBytes(int index) {
      return targetTags_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetTags to set.
     * @return This builder for chaining.
     */
    public Builder setTargetTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetTagsIsMutable();
      targetTags_.set(index, value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param value The targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addTargetTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetTagsIsMutable();
      targetTags_.add(value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param values The targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetTags(java.lang.Iterable<java.lang.String> values) {
      ensureTargetTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetTags_);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetTags() {
      targetTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00080000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
     * </pre>
     *
     * <code>repeated string target_tags = 62901767;</code>
     *
     * @param value The bytes of the targetTags to add.
     * @return This builder for chaining.
     */
    public Builder addTargetTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetTagsIsMutable();
      targetTags_.add(value);
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Firewall)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Firewall)
  private static final com.google.cloud.compute.v1.Firewall DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Firewall();
  }

  public static com.google.cloud.compute.v1.Firewall getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Firewall> PARSER =
      new com.google.protobuf.AbstractParser<Firewall>() {
        @java.lang.Override
        public Firewall parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Firewall> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Firewall> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Firewall getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
