/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Deprecation status for a public resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.DeprecationStatus}
 */
public final class DeprecationStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.DeprecationStatus)
    DeprecationStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DeprecationStatus.newBuilder() to construct.
  private DeprecationStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeprecationStatus() {
    deleted_ = "";
    deprecated_ = "";
    obsolete_ = "";
    replacement_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeprecationStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DeprecationStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DeprecationStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.DeprecationStatus.class,
            com.google.cloud.compute.v1.DeprecationStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.DeprecationStatus.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>DELETED = 120962041;</code> */
    DELETED(120962041),
    /** <code>DEPRECATED = 463360435;</code> */
    DEPRECATED(463360435),
    /** <code>OBSOLETE = 66532761;</code> */
    OBSOLETE(66532761),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;

    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;

    /** <code>DELETED = 120962041;</code> */
    public static final int DELETED_VALUE = 120962041;

    /** <code>DEPRECATED = 463360435;</code> */
    public static final int DEPRECATED_VALUE = 463360435;

    /** <code>OBSOLETE = 66532761;</code> */
    public static final int OBSOLETE_VALUE = 66532761;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 314733318:
          return ACTIVE;
        case 120962041:
          return DELETED;
        case 463360435:
          return DEPRECATED;
        case 66532761:
          return OBSOLETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.DeprecationStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.DeprecationStatus.State)
  }

  private int bitField0_;
  public static final int DELETED_FIELD_NUMBER = 476721177;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deleted_ = "";

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deleted = 476721177;</code>
   *
   * @return Whether the deleted field is set.
   */
  @java.lang.Override
  public boolean hasDeleted() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deleted = 476721177;</code>
   *
   * @return The deleted.
   */
  @java.lang.Override
  public java.lang.String getDeleted() {
    java.lang.Object ref = deleted_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deleted_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deleted = 476721177;</code>
   *
   * @return The bytes for deleted.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeletedBytes() {
    java.lang.Object ref = deleted_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deleted_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPRECATED_FIELD_NUMBER = 515138995;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deprecated_ = "";

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deprecated = 515138995;</code>
   *
   * @return Whether the deprecated field is set.
   */
  @java.lang.Override
  public boolean hasDeprecated() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deprecated = 515138995;</code>
   *
   * @return The deprecated.
   */
  @java.lang.Override
  public java.lang.String getDeprecated() {
    java.lang.Object ref = deprecated_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deprecated_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string deprecated = 515138995;</code>
   *
   * @return The bytes for deprecated.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeprecatedBytes() {
    java.lang.Object ref = deprecated_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deprecated_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBSOLETE_FIELD_NUMBER = 357647769;

  @SuppressWarnings("serial")
  private volatile java.lang.Object obsolete_ = "";

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string obsolete = 357647769;</code>
   *
   * @return Whether the obsolete field is set.
   */
  @java.lang.Override
  public boolean hasObsolete() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string obsolete = 357647769;</code>
   *
   * @return The obsolete.
   */
  @java.lang.Override
  public java.lang.String getObsolete() {
    java.lang.Object ref = obsolete_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      obsolete_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
   * </pre>
   *
   * <code>optional string obsolete = 357647769;</code>
   *
   * @return The bytes for obsolete.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObsoleteBytes() {
    java.lang.Object ref = obsolete_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      obsolete_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLACEMENT_FIELD_NUMBER = 430919186;

  @SuppressWarnings("serial")
  private volatile java.lang.Object replacement_ = "";

  /**
   *
   *
   * <pre>
   * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
   * </pre>
   *
   * <code>optional string replacement = 430919186;</code>
   *
   * @return Whether the replacement field is set.
   */
  @java.lang.Override
  public boolean hasReplacement() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
   * </pre>
   *
   * <code>optional string replacement = 430919186;</code>
   *
   * @return The replacement.
   */
  @java.lang.Override
  public java.lang.String getReplacement() {
    java.lang.Object ref = replacement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      replacement_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
   * </pre>
   *
   * <code>optional string replacement = 430919186;</code>
   *
   * @return The bytes for replacement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReplacementBytes() {
    java.lang.Object ref = replacement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      replacement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";

  /**
   *
   *
   * <pre>
   * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 357647769, obsolete_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 430919186, replacement_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 476721177, deleted_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 515138995, deprecated_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(357647769, obsolete_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(430919186, replacement_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(476721177, deleted_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(515138995, deprecated_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.DeprecationStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.DeprecationStatus other =
        (com.google.cloud.compute.v1.DeprecationStatus) obj;

    if (hasDeleted() != other.hasDeleted()) return false;
    if (hasDeleted()) {
      if (!getDeleted().equals(other.getDeleted())) return false;
    }
    if (hasDeprecated() != other.hasDeprecated()) return false;
    if (hasDeprecated()) {
      if (!getDeprecated().equals(other.getDeprecated())) return false;
    }
    if (hasObsolete() != other.hasObsolete()) return false;
    if (hasObsolete()) {
      if (!getObsolete().equals(other.getObsolete())) return false;
    }
    if (hasReplacement() != other.hasReplacement()) return false;
    if (hasReplacement()) {
      if (!getReplacement().equals(other.getReplacement())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDeleted()) {
      hash = (37 * hash) + DELETED_FIELD_NUMBER;
      hash = (53 * hash) + getDeleted().hashCode();
    }
    if (hasDeprecated()) {
      hash = (37 * hash) + DEPRECATED_FIELD_NUMBER;
      hash = (53 * hash) + getDeprecated().hashCode();
    }
    if (hasObsolete()) {
      hash = (37 * hash) + OBSOLETE_FIELD_NUMBER;
      hash = (53 * hash) + getObsolete().hashCode();
    }
    if (hasReplacement()) {
      hash = (37 * hash) + REPLACEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getReplacement().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DeprecationStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.DeprecationStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Deprecation status for a public resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.DeprecationStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.DeprecationStatus)
      com.google.cloud.compute.v1.DeprecationStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DeprecationStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DeprecationStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.DeprecationStatus.class,
              com.google.cloud.compute.v1.DeprecationStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.DeprecationStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      deleted_ = "";
      deprecated_ = "";
      obsolete_ = "";
      replacement_ = "";
      state_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DeprecationStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DeprecationStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DeprecationStatus build() {
      com.google.cloud.compute.v1.DeprecationStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DeprecationStatus buildPartial() {
      com.google.cloud.compute.v1.DeprecationStatus result =
          new com.google.cloud.compute.v1.DeprecationStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.DeprecationStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.deleted_ = deleted_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deprecated_ = deprecated_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.obsolete_ = obsolete_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.replacement_ = replacement_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.DeprecationStatus) {
        return mergeFrom((com.google.cloud.compute.v1.DeprecationStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.DeprecationStatus other) {
      if (other == com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()) return this;
      if (other.hasDeleted()) {
        deleted_ = other.deleted_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDeprecated()) {
        deprecated_ = other.deprecated_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasObsolete()) {
        obsolete_ = other.obsolete_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasReplacement()) {
        replacement_ = other.replacement_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 878060682
            case -1433785142:
              {
                obsolete_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1433785142
            case -847613806:
              {
                replacement_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -847613806
            case -481197878:
              {
                deleted_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -481197878
            case -173855334:
              {
                deprecated_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -173855334
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object deleted_ = "";

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @return Whether the deleted field is set.
     */
    public boolean hasDeleted() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @return The deleted.
     */
    public java.lang.String getDeleted() {
      java.lang.Object ref = deleted_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deleted_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @return The bytes for deleted.
     */
    public com.google.protobuf.ByteString getDeletedBytes() {
      java.lang.Object ref = deleted_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deleted_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @param value The deleted to set.
     * @return This builder for chaining.
     */
    public Builder setDeleted(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deleted_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleted() {
      deleted_ = getDefaultInstance().getDeleted();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deleted = 476721177;</code>
     *
     * @param value The bytes for deleted to set.
     * @return This builder for chaining.
     */
    public Builder setDeletedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deleted_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deprecated_ = "";

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @return Whether the deprecated field is set.
     */
    public boolean hasDeprecated() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @return The deprecated.
     */
    public java.lang.String getDeprecated() {
      java.lang.Object ref = deprecated_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deprecated_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @return The bytes for deprecated.
     */
    public com.google.protobuf.ByteString getDeprecatedBytes() {
      java.lang.Object ref = deprecated_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deprecated_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @param value The deprecated to set.
     * @return This builder for chaining.
     */
    public Builder setDeprecated(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deprecated_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeprecated() {
      deprecated_ = getDefaultInstance().getDeprecated();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string deprecated = 515138995;</code>
     *
     * @param value The bytes for deprecated to set.
     * @return This builder for chaining.
     */
    public Builder setDeprecatedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deprecated_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object obsolete_ = "";

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @return Whether the obsolete field is set.
     */
    public boolean hasObsolete() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @return The obsolete.
     */
    public java.lang.String getObsolete() {
      java.lang.Object ref = obsolete_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        obsolete_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @return The bytes for obsolete.
     */
    public com.google.protobuf.ByteString getObsoleteBytes() {
      java.lang.Object ref = obsolete_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        obsolete_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @param value The obsolete to set.
     * @return This builder for chaining.
     */
    public Builder setObsolete(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      obsolete_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObsolete() {
      obsolete_ = getDefaultInstance().getObsolete();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
     * </pre>
     *
     * <code>optional string obsolete = 357647769;</code>
     *
     * @param value The bytes for obsolete to set.
     * @return This builder for chaining.
     */
    public Builder setObsoleteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      obsolete_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object replacement_ = "";

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @return Whether the replacement field is set.
     */
    public boolean hasReplacement() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @return The replacement.
     */
    public java.lang.String getReplacement() {
      java.lang.Object ref = replacement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        replacement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @return The bytes for replacement.
     */
    public com.google.protobuf.ByteString getReplacementBytes() {
      java.lang.Object ref = replacement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        replacement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @param value The replacement to set.
     * @return This builder for chaining.
     */
    public Builder setReplacement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      replacement_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplacement() {
      replacement_ = getDefaultInstance().getReplacement();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
     * </pre>
     *
     * <code>optional string replacement = 430919186;</code>
     *
     * @param value The bytes for replacement to set.
     * @return This builder for chaining.
     */
    public Builder setReplacementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      replacement_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.DeprecationStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.DeprecationStatus)
  private static final com.google.cloud.compute.v1.DeprecationStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.DeprecationStatus();
  }

  public static com.google.cloud.compute.v1.DeprecationStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeprecationStatus> PARSER =
      new com.google.protobuf.AbstractParser<DeprecationStatus>() {
        @java.lang.Override
        public DeprecationStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeprecationStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeprecationStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.DeprecationStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
