/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.CorsPolicy}
 */
public final class CorsPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.CorsPolicy)
    CorsPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CorsPolicy.newBuilder() to construct.
  private CorsPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CorsPolicy() {
    allowHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    allowMethods_ = com.google.protobuf.LazyStringArrayList.emptyList();
    allowOriginRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    allowOrigins_ = com.google.protobuf.LazyStringArrayList.emptyList();
    exposeHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CorsPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CorsPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CorsPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.CorsPolicy.class,
            com.google.cloud.compute.v1.CorsPolicy.Builder.class);
  }

  private int bitField0_;
  public static final int ALLOW_CREDENTIALS_FIELD_NUMBER = 481263366;
  private boolean allowCredentials_ = false;

  /**
   *
   *
   * <pre>
   * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
   * </pre>
   *
   * <code>optional bool allow_credentials = 481263366;</code>
   *
   * @return Whether the allowCredentials field is set.
   */
  @java.lang.Override
  public boolean hasAllowCredentials() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
   * </pre>
   *
   * <code>optional bool allow_credentials = 481263366;</code>
   *
   * @return The allowCredentials.
   */
  @java.lang.Override
  public boolean getAllowCredentials() {
    return allowCredentials_;
  }

  public static final int ALLOW_HEADERS_FIELD_NUMBER = 45179024;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Headers header.
   * </pre>
   *
   * <code>repeated string allow_headers = 45179024;</code>
   *
   * @return A list containing the allowHeaders.
   */
  public com.google.protobuf.ProtocolStringList getAllowHeadersList() {
    return allowHeaders_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Headers header.
   * </pre>
   *
   * <code>repeated string allow_headers = 45179024;</code>
   *
   * @return The count of allowHeaders.
   */
  public int getAllowHeadersCount() {
    return allowHeaders_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Headers header.
   * </pre>
   *
   * <code>repeated string allow_headers = 45179024;</code>
   *
   * @param index The index of the element to return.
   * @return The allowHeaders at the given index.
   */
  public java.lang.String getAllowHeaders(int index) {
    return allowHeaders_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Headers header.
   * </pre>
   *
   * <code>repeated string allow_headers = 45179024;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowHeaders at the given index.
   */
  public com.google.protobuf.ByteString getAllowHeadersBytes(int index) {
    return allowHeaders_.getByteString(index);
  }

  public static final int ALLOW_METHODS_FIELD_NUMBER = 205405372;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowMethods_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Methods header.
   * </pre>
   *
   * <code>repeated string allow_methods = 205405372;</code>
   *
   * @return A list containing the allowMethods.
   */
  public com.google.protobuf.ProtocolStringList getAllowMethodsList() {
    return allowMethods_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Methods header.
   * </pre>
   *
   * <code>repeated string allow_methods = 205405372;</code>
   *
   * @return The count of allowMethods.
   */
  public int getAllowMethodsCount() {
    return allowMethods_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Methods header.
   * </pre>
   *
   * <code>repeated string allow_methods = 205405372;</code>
   *
   * @param index The index of the element to return.
   * @return The allowMethods at the given index.
   */
  public java.lang.String getAllowMethods(int index) {
    return allowMethods_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Allow-Methods header.
   * </pre>
   *
   * <code>repeated string allow_methods = 205405372;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowMethods at the given index.
   */
  public com.google.protobuf.ByteString getAllowMethodsBytes(int index) {
    return allowMethods_.getByteString(index);
  }

  public static final int ALLOW_ORIGIN_REGEXES_FIELD_NUMBER = 215385810;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowOriginRegexes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated string allow_origin_regexes = 215385810;</code>
   *
   * @return A list containing the allowOriginRegexes.
   */
  public com.google.protobuf.ProtocolStringList getAllowOriginRegexesList() {
    return allowOriginRegexes_;
  }

  /**
   *
   *
   * <pre>
   * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated string allow_origin_regexes = 215385810;</code>
   *
   * @return The count of allowOriginRegexes.
   */
  public int getAllowOriginRegexesCount() {
    return allowOriginRegexes_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated string allow_origin_regexes = 215385810;</code>
   *
   * @param index The index of the element to return.
   * @return The allowOriginRegexes at the given index.
   */
  public java.lang.String getAllowOriginRegexes(int index) {
    return allowOriginRegexes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated string allow_origin_regexes = 215385810;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowOriginRegexes at the given index.
   */
  public com.google.protobuf.ByteString getAllowOriginRegexesBytes(int index) {
    return allowOriginRegexes_.getByteString(index);
  }

  public static final int ALLOW_ORIGINS_FIELD_NUMBER = 194914071;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowOrigins_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
   * </pre>
   *
   * <code>repeated string allow_origins = 194914071;</code>
   *
   * @return A list containing the allowOrigins.
   */
  public com.google.protobuf.ProtocolStringList getAllowOriginsList() {
    return allowOrigins_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
   * </pre>
   *
   * <code>repeated string allow_origins = 194914071;</code>
   *
   * @return The count of allowOrigins.
   */
  public int getAllowOriginsCount() {
    return allowOrigins_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
   * </pre>
   *
   * <code>repeated string allow_origins = 194914071;</code>
   *
   * @param index The index of the element to return.
   * @return The allowOrigins at the given index.
   */
  public java.lang.String getAllowOrigins(int index) {
    return allowOrigins_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
   * </pre>
   *
   * <code>repeated string allow_origins = 194914071;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowOrigins at the given index.
   */
  public com.google.protobuf.ByteString getAllowOriginsBytes(int index) {
    return allowOrigins_.getByteString(index);
  }

  public static final int DISABLED_FIELD_NUMBER = 270940796;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int EXPOSE_HEADERS_FIELD_NUMBER = 247604747;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList exposeHeaders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Expose-Headers header.
   * </pre>
   *
   * <code>repeated string expose_headers = 247604747;</code>
   *
   * @return A list containing the exposeHeaders.
   */
  public com.google.protobuf.ProtocolStringList getExposeHeadersList() {
    return exposeHeaders_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Expose-Headers header.
   * </pre>
   *
   * <code>repeated string expose_headers = 247604747;</code>
   *
   * @return The count of exposeHeaders.
   */
  public int getExposeHeadersCount() {
    return exposeHeaders_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Expose-Headers header.
   * </pre>
   *
   * <code>repeated string expose_headers = 247604747;</code>
   *
   * @param index The index of the element to return.
   * @return The exposeHeaders at the given index.
   */
  public java.lang.String getExposeHeaders(int index) {
    return exposeHeaders_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the content for the Access-Control-Expose-Headers header.
   * </pre>
   *
   * <code>repeated string expose_headers = 247604747;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the exposeHeaders at the given index.
   */
  public com.google.protobuf.ByteString getExposeHeadersBytes(int index) {
    return exposeHeaders_.getByteString(index);
  }

  public static final int MAX_AGE_FIELD_NUMBER = 307559332;
  private int maxAge_ = 0;

  /**
   *
   *
   * <pre>
   * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
   * </pre>
   *
   * <code>optional int32 max_age = 307559332;</code>
   *
   * @return Whether the maxAge field is set.
   */
  @java.lang.Override
  public boolean hasMaxAge() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
   * </pre>
   *
   * <code>optional int32 max_age = 307559332;</code>
   *
   * @return The maxAge.
   */
  @java.lang.Override
  public int getMaxAge() {
    return maxAge_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < allowHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 45179024, allowHeaders_.getRaw(i));
    }
    for (int i = 0; i < allowOrigins_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 194914071, allowOrigins_.getRaw(i));
    }
    for (int i = 0; i < allowMethods_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 205405372, allowMethods_.getRaw(i));
    }
    for (int i = 0; i < allowOriginRegexes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 215385810, allowOriginRegexes_.getRaw(i));
    }
    for (int i = 0; i < exposeHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 247604747, exposeHeaders_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(307559332, maxAge_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(481263366, allowCredentials_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAllowHeadersList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowOrigins_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowOrigins_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAllowOriginsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowMethods_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowMethods_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAllowMethodsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowOriginRegexes_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowOriginRegexes_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAllowOriginRegexesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < exposeHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(exposeHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getExposeHeadersList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(307559332, maxAge_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(481263366, allowCredentials_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.CorsPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.CorsPolicy other = (com.google.cloud.compute.v1.CorsPolicy) obj;

    if (hasAllowCredentials() != other.hasAllowCredentials()) return false;
    if (hasAllowCredentials()) {
      if (getAllowCredentials() != other.getAllowCredentials()) return false;
    }
    if (!getAllowHeadersList().equals(other.getAllowHeadersList())) return false;
    if (!getAllowMethodsList().equals(other.getAllowMethodsList())) return false;
    if (!getAllowOriginRegexesList().equals(other.getAllowOriginRegexesList())) return false;
    if (!getAllowOriginsList().equals(other.getAllowOriginsList())) return false;
    if (hasDisabled() != other.hasDisabled()) return false;
    if (hasDisabled()) {
      if (getDisabled() != other.getDisabled()) return false;
    }
    if (!getExposeHeadersList().equals(other.getExposeHeadersList())) return false;
    if (hasMaxAge() != other.hasMaxAge()) return false;
    if (hasMaxAge()) {
      if (getMaxAge() != other.getMaxAge()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAllowCredentials()) {
      hash = (37 * hash) + ALLOW_CREDENTIALS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCredentials());
    }
    if (getAllowHeadersCount() > 0) {
      hash = (37 * hash) + ALLOW_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowHeadersList().hashCode();
    }
    if (getAllowMethodsCount() > 0) {
      hash = (37 * hash) + ALLOW_METHODS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowMethodsList().hashCode();
    }
    if (getAllowOriginRegexesCount() > 0) {
      hash = (37 * hash) + ALLOW_ORIGIN_REGEXES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowOriginRegexesList().hashCode();
    }
    if (getAllowOriginsCount() > 0) {
      hash = (37 * hash) + ALLOW_ORIGINS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowOriginsList().hashCode();
    }
    if (hasDisabled()) {
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    }
    if (getExposeHeadersCount() > 0) {
      hash = (37 * hash) + EXPOSE_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getExposeHeadersList().hashCode();
    }
    if (hasMaxAge()) {
      hash = (37 * hash) + MAX_AGE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAge();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CorsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.CorsPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The specification for allowing client-side cross-origin requests. For more information about the W3C recommendation for cross-origin resource sharing (CORS), see Fetch API Living Standard.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.CorsPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.CorsPolicy)
      com.google.cloud.compute.v1.CorsPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CorsPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CorsPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.CorsPolicy.class,
              com.google.cloud.compute.v1.CorsPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.CorsPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowCredentials_ = false;
      allowHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      allowMethods_ = com.google.protobuf.LazyStringArrayList.emptyList();
      allowOriginRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      allowOrigins_ = com.google.protobuf.LazyStringArrayList.emptyList();
      disabled_ = false;
      exposeHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      maxAge_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CorsPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CorsPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CorsPolicy build() {
      com.google.cloud.compute.v1.CorsPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CorsPolicy buildPartial() {
      com.google.cloud.compute.v1.CorsPolicy result =
          new com.google.cloud.compute.v1.CorsPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.CorsPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allowCredentials_ = allowCredentials_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        allowHeaders_.makeImmutable();
        result.allowHeaders_ = allowHeaders_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        allowMethods_.makeImmutable();
        result.allowMethods_ = allowMethods_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        allowOriginRegexes_.makeImmutable();
        result.allowOriginRegexes_ = allowOriginRegexes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        allowOrigins_.makeImmutable();
        result.allowOrigins_ = allowOrigins_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.disabled_ = disabled_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        exposeHeaders_.makeImmutable();
        result.exposeHeaders_ = exposeHeaders_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxAge_ = maxAge_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.CorsPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.CorsPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.CorsPolicy other) {
      if (other == com.google.cloud.compute.v1.CorsPolicy.getDefaultInstance()) return this;
      if (other.hasAllowCredentials()) {
        setAllowCredentials(other.getAllowCredentials());
      }
      if (!other.allowHeaders_.isEmpty()) {
        if (allowHeaders_.isEmpty()) {
          allowHeaders_ = other.allowHeaders_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAllowHeadersIsMutable();
          allowHeaders_.addAll(other.allowHeaders_);
        }
        onChanged();
      }
      if (!other.allowMethods_.isEmpty()) {
        if (allowMethods_.isEmpty()) {
          allowMethods_ = other.allowMethods_;
          bitField0_ |= 0x00000004;
        } else {
          ensureAllowMethodsIsMutable();
          allowMethods_.addAll(other.allowMethods_);
        }
        onChanged();
      }
      if (!other.allowOriginRegexes_.isEmpty()) {
        if (allowOriginRegexes_.isEmpty()) {
          allowOriginRegexes_ = other.allowOriginRegexes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureAllowOriginRegexesIsMutable();
          allowOriginRegexes_.addAll(other.allowOriginRegexes_);
        }
        onChanged();
      }
      if (!other.allowOrigins_.isEmpty()) {
        if (allowOrigins_.isEmpty()) {
          allowOrigins_ = other.allowOrigins_;
          bitField0_ |= 0x00000010;
        } else {
          ensureAllowOriginsIsMutable();
          allowOrigins_.addAll(other.allowOrigins_);
        }
        onChanged();
      }
      if (other.hasDisabled()) {
        setDisabled(other.getDisabled());
      }
      if (!other.exposeHeaders_.isEmpty()) {
        if (exposeHeaders_.isEmpty()) {
          exposeHeaders_ = other.exposeHeaders_;
          bitField0_ |= 0x00000040;
        } else {
          ensureExposeHeadersIsMutable();
          exposeHeaders_.addAll(other.exposeHeaders_);
        }
        onChanged();
      }
      if (other.hasMaxAge()) {
        setMaxAge(other.getMaxAge());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 361432194:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowHeadersIsMutable();
                allowHeaders_.add(s);
                break;
              } // case 361432194
            case 1559312570:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowOriginsIsMutable();
                allowOrigins_.add(s);
                break;
              } // case 1559312570
            case 1643242978:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowMethodsIsMutable();
                allowMethods_.add(s);
                break;
              } // case 1643242978
            case 1723086482:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowOriginRegexesIsMutable();
                allowOriginRegexes_.add(s);
                break;
              } // case 1723086482
            case 1980837978:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExposeHeadersIsMutable();
                exposeHeaders_.add(s);
                break;
              } // case 1980837978
            case -2127440928:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case -2127440928
            case -1834492640:
              {
                maxAge_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case -1834492640
            case -444860368:
              {
                allowCredentials_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -444860368
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean allowCredentials_;

    /**
     *
     *
     * <pre>
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
     * </pre>
     *
     * <code>optional bool allow_credentials = 481263366;</code>
     *
     * @return Whether the allowCredentials field is set.
     */
    @java.lang.Override
    public boolean hasAllowCredentials() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
     * </pre>
     *
     * <code>optional bool allow_credentials = 481263366;</code>
     *
     * @return The allowCredentials.
     */
    @java.lang.Override
    public boolean getAllowCredentials() {
      return allowCredentials_;
    }

    /**
     *
     *
     * <pre>
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
     * </pre>
     *
     * <code>optional bool allow_credentials = 481263366;</code>
     *
     * @param value The allowCredentials to set.
     * @return This builder for chaining.
     */
    public Builder setAllowCredentials(boolean value) {

      allowCredentials_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header. Default is false.
     * </pre>
     *
     * <code>optional bool allow_credentials = 481263366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowCredentials() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allowCredentials_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowHeadersIsMutable() {
      if (!allowHeaders_.isModifiable()) {
        allowHeaders_ = new com.google.protobuf.LazyStringArrayList(allowHeaders_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @return A list containing the allowHeaders.
     */
    public com.google.protobuf.ProtocolStringList getAllowHeadersList() {
      allowHeaders_.makeImmutable();
      return allowHeaders_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @return The count of allowHeaders.
     */
    public int getAllowHeadersCount() {
      return allowHeaders_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param index The index of the element to return.
     * @return The allowHeaders at the given index.
     */
    public java.lang.String getAllowHeaders(int index) {
      return allowHeaders_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowHeaders at the given index.
     */
    public com.google.protobuf.ByteString getAllowHeadersBytes(int index) {
      return allowHeaders_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setAllowHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowHeadersIsMutable();
      allowHeaders_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param value The allowHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllowHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowHeadersIsMutable();
      allowHeaders_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param values The allowHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureAllowHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowHeaders_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowHeaders() {
      allowHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Headers header.
     * </pre>
     *
     * <code>repeated string allow_headers = 45179024;</code>
     *
     * @param value The bytes of the allowHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllowHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowHeadersIsMutable();
      allowHeaders_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowMethods_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowMethodsIsMutable() {
      if (!allowMethods_.isModifiable()) {
        allowMethods_ = new com.google.protobuf.LazyStringArrayList(allowMethods_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @return A list containing the allowMethods.
     */
    public com.google.protobuf.ProtocolStringList getAllowMethodsList() {
      allowMethods_.makeImmutable();
      return allowMethods_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @return The count of allowMethods.
     */
    public int getAllowMethodsCount() {
      return allowMethods_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param index The index of the element to return.
     * @return The allowMethods at the given index.
     */
    public java.lang.String getAllowMethods(int index) {
      return allowMethods_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowMethods at the given index.
     */
    public com.google.protobuf.ByteString getAllowMethodsBytes(int index) {
      return allowMethods_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowMethods to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMethods(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowMethodsIsMutable();
      allowMethods_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param value The allowMethods to add.
     * @return This builder for chaining.
     */
    public Builder addAllowMethods(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowMethodsIsMutable();
      allowMethods_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param values The allowMethods to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowMethods(java.lang.Iterable<java.lang.String> values) {
      ensureAllowMethodsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowMethods_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMethods() {
      allowMethods_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Allow-Methods header.
     * </pre>
     *
     * <code>repeated string allow_methods = 205405372;</code>
     *
     * @param value The bytes of the allowMethods to add.
     * @return This builder for chaining.
     */
    public Builder addAllowMethodsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowMethodsIsMutable();
      allowMethods_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowOriginRegexes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowOriginRegexesIsMutable() {
      if (!allowOriginRegexes_.isModifiable()) {
        allowOriginRegexes_ = new com.google.protobuf.LazyStringArrayList(allowOriginRegexes_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @return A list containing the allowOriginRegexes.
     */
    public com.google.protobuf.ProtocolStringList getAllowOriginRegexesList() {
      allowOriginRegexes_.makeImmutable();
      return allowOriginRegexes_;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @return The count of allowOriginRegexes.
     */
    public int getAllowOriginRegexesCount() {
      return allowOriginRegexes_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param index The index of the element to return.
     * @return The allowOriginRegexes at the given index.
     */
    public java.lang.String getAllowOriginRegexes(int index) {
      return allowOriginRegexes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowOriginRegexes at the given index.
     */
    public com.google.protobuf.ByteString getAllowOriginRegexesBytes(int index) {
      return allowOriginRegexes_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowOriginRegexes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowOriginRegexes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowOriginRegexesIsMutable();
      allowOriginRegexes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param value The allowOriginRegexes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowOriginRegexes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowOriginRegexesIsMutable();
      allowOriginRegexes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param values The allowOriginRegexes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowOriginRegexes(java.lang.Iterable<java.lang.String> values) {
      ensureAllowOriginRegexesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowOriginRegexes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowOriginRegexes() {
      allowOriginRegexes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a regular expression that matches allowed origins. For more information, see regular expression syntax . An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes. Regular expressions can only be used when the loadBalancingScheme is set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated string allow_origin_regexes = 215385810;</code>
     *
     * @param value The bytes of the allowOriginRegexes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowOriginRegexesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowOriginRegexesIsMutable();
      allowOriginRegexes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowOrigins_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowOriginsIsMutable() {
      if (!allowOrigins_.isModifiable()) {
        allowOrigins_ = new com.google.protobuf.LazyStringArrayList(allowOrigins_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @return A list containing the allowOrigins.
     */
    public com.google.protobuf.ProtocolStringList getAllowOriginsList() {
      allowOrigins_.makeImmutable();
      return allowOrigins_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @return The count of allowOrigins.
     */
    public int getAllowOriginsCount() {
      return allowOrigins_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param index The index of the element to return.
     * @return The allowOrigins at the given index.
     */
    public java.lang.String getAllowOrigins(int index) {
      return allowOrigins_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowOrigins at the given index.
     */
    public com.google.protobuf.ByteString getAllowOriginsBytes(int index) {
      return allowOrigins_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowOrigins to set.
     * @return This builder for chaining.
     */
    public Builder setAllowOrigins(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowOriginsIsMutable();
      allowOrigins_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param value The allowOrigins to add.
     * @return This builder for chaining.
     */
    public Builder addAllowOrigins(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowOriginsIsMutable();
      allowOrigins_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param values The allowOrigins to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowOrigins(java.lang.Iterable<java.lang.String> values) {
      ensureAllowOriginsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowOrigins_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowOrigins() {
      allowOrigins_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the list of origins that is allowed to do CORS requests. An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     * </pre>
     *
     * <code>repeated string allow_origins = 194914071;</code>
     *
     * @param value The bytes of the allowOrigins to add.
     * @return This builder for chaining.
     */
    public Builder addAllowOriginsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowOriginsIsMutable();
      allowOrigins_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, disables the CORS policy. The default value is false, which indicates that the CORS policy is in effect.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000020);
      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList exposeHeaders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExposeHeadersIsMutable() {
      if (!exposeHeaders_.isModifiable()) {
        exposeHeaders_ = new com.google.protobuf.LazyStringArrayList(exposeHeaders_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @return A list containing the exposeHeaders.
     */
    public com.google.protobuf.ProtocolStringList getExposeHeadersList() {
      exposeHeaders_.makeImmutable();
      return exposeHeaders_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @return The count of exposeHeaders.
     */
    public int getExposeHeadersCount() {
      return exposeHeaders_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param index The index of the element to return.
     * @return The exposeHeaders at the given index.
     */
    public java.lang.String getExposeHeaders(int index) {
      return exposeHeaders_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exposeHeaders at the given index.
     */
    public com.google.protobuf.ByteString getExposeHeadersBytes(int index) {
      return exposeHeaders_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param index The index to set the value at.
     * @param value The exposeHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setExposeHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExposeHeadersIsMutable();
      exposeHeaders_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param value The exposeHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addExposeHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExposeHeadersIsMutable();
      exposeHeaders_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param values The exposeHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllExposeHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureExposeHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exposeHeaders_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExposeHeaders() {
      exposeHeaders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the content for the Access-Control-Expose-Headers header.
     * </pre>
     *
     * <code>repeated string expose_headers = 247604747;</code>
     *
     * @param value The bytes of the exposeHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addExposeHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExposeHeadersIsMutable();
      exposeHeaders_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int maxAge_;

    /**
     *
     *
     * <pre>
     * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
     * </pre>
     *
     * <code>optional int32 max_age = 307559332;</code>
     *
     * @return Whether the maxAge field is set.
     */
    @java.lang.Override
    public boolean hasMaxAge() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
     * </pre>
     *
     * <code>optional int32 max_age = 307559332;</code>
     *
     * @return The maxAge.
     */
    @java.lang.Override
    public int getMaxAge() {
      return maxAge_;
    }

    /**
     *
     *
     * <pre>
     * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
     * </pre>
     *
     * <code>optional int32 max_age = 307559332;</code>
     *
     * @param value The maxAge to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAge(int value) {

      maxAge_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies how long results of a preflight request can be cached in seconds. This field translates to the Access-Control-Max-Age header.
     * </pre>
     *
     * <code>optional int32 max_age = 307559332;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxAge() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxAge_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.CorsPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.CorsPolicy)
  private static final com.google.cloud.compute.v1.CorsPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.CorsPolicy();
  }

  public static com.google.cloud.compute.v1.CorsPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CorsPolicy> PARSER =
      new com.google.protobuf.AbstractParser<CorsPolicy>() {
        @java.lang.Override
        public CorsPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CorsPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CorsPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.CorsPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
