/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BackendServiceTlsSettings}
 */
public final class BackendServiceTlsSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BackendServiceTlsSettings)
    BackendServiceTlsSettingsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BackendServiceTlsSettings.newBuilder() to construct.
  private BackendServiceTlsSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendServiceTlsSettings() {
    authenticationConfig_ = "";
    sni_ = "";
    subjectAltNames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendServiceTlsSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendServiceTlsSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendServiceTlsSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BackendServiceTlsSettings.class,
            com.google.cloud.compute.v1.BackendServiceTlsSettings.Builder.class);
  }

  private int bitField0_;
  public static final int AUTHENTICATION_CONFIG_FIELD_NUMBER = 408053481;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authenticationConfig_ = "";

  /**
   *
   *
   * <pre>
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * </pre>
   *
   * <code>optional string authentication_config = 408053481;</code>
   *
   * @return Whether the authenticationConfig field is set.
   */
  @java.lang.Override
  public boolean hasAuthenticationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * </pre>
   *
   * <code>optional string authentication_config = 408053481;</code>
   *
   * @return The authenticationConfig.
   */
  @java.lang.Override
  public java.lang.String getAuthenticationConfig() {
    java.lang.Object ref = authenticationConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authenticationConfig_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
   * </pre>
   *
   * <code>optional string authentication_config = 408053481;</code>
   *
   * @return The bytes for authenticationConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthenticationConfigBytes() {
    java.lang.Object ref = authenticationConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authenticationConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNI_FIELD_NUMBER = 114030;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sni_ = "";

  /**
   *
   *
   * <pre>
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>optional string sni = 114030;</code>
   *
   * @return Whether the sni field is set.
   */
  @java.lang.Override
  public boolean hasSni() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>optional string sni = 114030;</code>
   *
   * @return The sni.
   */
  @java.lang.Override
  public java.lang.String getSni() {
    java.lang.Object ref = sni_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sni_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>optional string sni = 114030;</code>
   *
   * @return The bytes for sni.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSniBytes() {
    java.lang.Object ref = sni_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sni_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBJECT_ALT_NAMES_FIELD_NUMBER = 330029535;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>
      subjectAltNames_;

  /**
   *
   *
   * <pre>
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>
      getSubjectAltNamesList() {
    return subjectAltNames_;
  }

  /**
   *
   *
   * <pre>
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder>
      getSubjectAltNamesOrBuilderList() {
    return subjectAltNames_;
  }

  /**
   *
   *
   * <pre>
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
   * </code>
   */
  @java.lang.Override
  public int getSubjectAltNamesCount() {
    return subjectAltNames_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName getSubjectAltNames(
      int index) {
    return subjectAltNames_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder
      getSubjectAltNamesOrBuilder(int index) {
    return subjectAltNames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 114030, sni_);
    }
    for (int i = 0; i < subjectAltNames_.size(); i++) {
      output.writeMessage(330029535, subjectAltNames_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 408053481, authenticationConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(114030, sni_);
    }
    for (int i = 0; i < subjectAltNames_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              330029535, subjectAltNames_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              408053481, authenticationConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BackendServiceTlsSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BackendServiceTlsSettings other =
        (com.google.cloud.compute.v1.BackendServiceTlsSettings) obj;

    if (hasAuthenticationConfig() != other.hasAuthenticationConfig()) return false;
    if (hasAuthenticationConfig()) {
      if (!getAuthenticationConfig().equals(other.getAuthenticationConfig())) return false;
    }
    if (hasSni() != other.hasSni()) return false;
    if (hasSni()) {
      if (!getSni().equals(other.getSni())) return false;
    }
    if (!getSubjectAltNamesList().equals(other.getSubjectAltNamesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAuthenticationConfig()) {
      hash = (37 * hash) + AUTHENTICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAuthenticationConfig().hashCode();
    }
    if (hasSni()) {
      hash = (37 * hash) + SNI_FIELD_NUMBER;
      hash = (53 * hash) + getSni().hashCode();
    }
    if (getSubjectAltNamesCount() > 0) {
      hash = (37 * hash) + SUBJECT_ALT_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectAltNamesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.BackendServiceTlsSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BackendServiceTlsSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BackendServiceTlsSettings)
      com.google.cloud.compute.v1.BackendServiceTlsSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceTlsSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceTlsSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BackendServiceTlsSettings.class,
              com.google.cloud.compute.v1.BackendServiceTlsSettings.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BackendServiceTlsSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      authenticationConfig_ = "";
      sni_ = "";
      if (subjectAltNamesBuilder_ == null) {
        subjectAltNames_ = java.util.Collections.emptyList();
      } else {
        subjectAltNames_ = null;
        subjectAltNamesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceTlsSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceTlsSettings getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BackendServiceTlsSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceTlsSettings build() {
      com.google.cloud.compute.v1.BackendServiceTlsSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceTlsSettings buildPartial() {
      com.google.cloud.compute.v1.BackendServiceTlsSettings result =
          new com.google.cloud.compute.v1.BackendServiceTlsSettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.BackendServiceTlsSettings result) {
      if (subjectAltNamesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          subjectAltNames_ = java.util.Collections.unmodifiableList(subjectAltNames_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.subjectAltNames_ = subjectAltNames_;
      } else {
        result.subjectAltNames_ = subjectAltNamesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.BackendServiceTlsSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.authenticationConfig_ = authenticationConfig_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sni_ = sni_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BackendServiceTlsSettings) {
        return mergeFrom((com.google.cloud.compute.v1.BackendServiceTlsSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BackendServiceTlsSettings other) {
      if (other == com.google.cloud.compute.v1.BackendServiceTlsSettings.getDefaultInstance())
        return this;
      if (other.hasAuthenticationConfig()) {
        authenticationConfig_ = other.authenticationConfig_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSni()) {
        sni_ = other.sni_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (subjectAltNamesBuilder_ == null) {
        if (!other.subjectAltNames_.isEmpty()) {
          if (subjectAltNames_.isEmpty()) {
            subjectAltNames_ = other.subjectAltNames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSubjectAltNamesIsMutable();
            subjectAltNames_.addAll(other.subjectAltNames_);
          }
          onChanged();
        }
      } else {
        if (!other.subjectAltNames_.isEmpty()) {
          if (subjectAltNamesBuilder_.isEmpty()) {
            subjectAltNamesBuilder_.dispose();
            subjectAltNamesBuilder_ = null;
            subjectAltNames_ = other.subjectAltNames_;
            bitField0_ = (bitField0_ & ~0x00000004);
            subjectAltNamesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSubjectAltNamesFieldBuilder()
                    : null;
          } else {
            subjectAltNamesBuilder_.addAllMessages(other.subjectAltNames_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 912242:
              {
                sni_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 912242
            case -1654731014:
              {
                com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName m =
                    input.readMessage(
                        com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName
                            .parser(),
                        extensionRegistry);
                if (subjectAltNamesBuilder_ == null) {
                  ensureSubjectAltNamesIsMutable();
                  subjectAltNames_.add(m);
                } else {
                  subjectAltNamesBuilder_.addMessage(m);
                }
                break;
              } // case -1654731014
            case -1030539446:
              {
                authenticationConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1030539446
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object authenticationConfig_ = "";

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @return Whether the authenticationConfig field is set.
     */
    public boolean hasAuthenticationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @return The authenticationConfig.
     */
    public java.lang.String getAuthenticationConfig() {
      java.lang.Object ref = authenticationConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authenticationConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @return The bytes for authenticationConfig.
     */
    public com.google.protobuf.ByteString getAuthenticationConfigBytes() {
      java.lang.Object ref = authenticationConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authenticationConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @param value The authenticationConfig to set.
     * @return This builder for chaining.
     */
    public Builder setAuthenticationConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authenticationConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthenticationConfig() {
      authenticationConfig_ = getDefaultInstance().getAuthenticationConfig();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reference to the BackendAuthenticationConfig resource from the networksecurity.googleapis.com namespace. Can be used in authenticating TLS connections to the backend, as specified by the authenticationMode field. Can only be specified if authenticationMode is not NONE.
     * </pre>
     *
     * <code>optional string authentication_config = 408053481;</code>
     *
     * @param value The bytes for authenticationConfig to set.
     * @return This builder for chaining.
     */
    public Builder setAuthenticationConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authenticationConfig_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sni_ = "";

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @return Whether the sni field is set.
     */
    public boolean hasSni() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @return The sni.
     */
    public java.lang.String getSni() {
      java.lang.Object ref = sni_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sni_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @return The bytes for sni.
     */
    public com.google.protobuf.ByteString getSniBytes() {
      java.lang.Object ref = sni_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sni_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @param value The sni to set.
     * @return This builder for chaining.
     */
    public Builder setSni(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sni_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSni() {
      sni_ = getDefaultInstance().getSni();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Server Name Indication - see RFC3546 section 3.1. If set, the load balancer sends this string as the SNI hostname in the TLS connection to the backend, and requires that this string match a Subject Alternative Name (SAN) in the backend's server certificate. With a Regional Internet NEG backend, if the SNI is specified here, the load balancer uses it regardless of whether the Regional Internet NEG is specified with FQDN or IP address and port. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>optional string sni = 114030;</code>
     *
     * @param value The bytes for sni to set.
     * @return This builder for chaining.
     */
    public Builder setSniBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sni_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>
        subjectAltNames_ = java.util.Collections.emptyList();

    private void ensureSubjectAltNamesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        subjectAltNames_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>(
                subjectAltNames_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName,
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder,
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder>
        subjectAltNamesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>
        getSubjectAltNamesList() {
      if (subjectAltNamesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(subjectAltNames_);
      } else {
        return subjectAltNamesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public int getSubjectAltNamesCount() {
      if (subjectAltNamesBuilder_ == null) {
        return subjectAltNames_.size();
      } else {
        return subjectAltNamesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName getSubjectAltNames(
        int index) {
      if (subjectAltNamesBuilder_ == null) {
        return subjectAltNames_.get(index);
      } else {
        return subjectAltNamesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder setSubjectAltNames(
        int index, com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName value) {
      if (subjectAltNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.set(index, value);
        onChanged();
      } else {
        subjectAltNamesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder setSubjectAltNames(
        int index,
        com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
            builderForValue) {
      if (subjectAltNamesBuilder_ == null) {
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.set(index, builderForValue.build());
        onChanged();
      } else {
        subjectAltNamesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder addSubjectAltNames(
        com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName value) {
      if (subjectAltNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(value);
        onChanged();
      } else {
        subjectAltNamesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder addSubjectAltNames(
        int index, com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName value) {
      if (subjectAltNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(index, value);
        onChanged();
      } else {
        subjectAltNamesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder addSubjectAltNames(
        com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
            builderForValue) {
      if (subjectAltNamesBuilder_ == null) {
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(builderForValue.build());
        onChanged();
      } else {
        subjectAltNamesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder addSubjectAltNames(
        int index,
        com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
            builderForValue) {
      if (subjectAltNamesBuilder_ == null) {
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.add(index, builderForValue.build());
        onChanged();
      } else {
        subjectAltNamesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder addAllSubjectAltNames(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName>
            values) {
      if (subjectAltNamesBuilder_ == null) {
        ensureSubjectAltNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjectAltNames_);
        onChanged();
      } else {
        subjectAltNamesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder clearSubjectAltNames() {
      if (subjectAltNamesBuilder_ == null) {
        subjectAltNames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        subjectAltNamesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public Builder removeSubjectAltNames(int index) {
      if (subjectAltNamesBuilder_ == null) {
        ensureSubjectAltNamesIsMutable();
        subjectAltNames_.remove(index);
        onChanged();
      } else {
        subjectAltNamesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
        getSubjectAltNamesBuilder(int index) {
      return getSubjectAltNamesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder
        getSubjectAltNamesOrBuilder(int index) {
      if (subjectAltNamesBuilder_ == null) {
        return subjectAltNames_.get(index);
      } else {
        return subjectAltNamesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder>
        getSubjectAltNamesOrBuilderList() {
      if (subjectAltNamesBuilder_ != null) {
        return subjectAltNamesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(subjectAltNames_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
        addSubjectAltNamesBuilder() {
      return getSubjectAltNamesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder
        addSubjectAltNamesBuilder(int index) {
      return getSubjectAltNamesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of Subject Alternative Names (SANs) that the Load Balancer verifies during a TLS handshake with the backend. When the server presents its X.509 certificate to the Load Balancer, the Load Balancer inspects the certificate's SAN field, and requires that at least one SAN match one of the subjectAltNames in the list. This field is limited to 5 entries. When both sni and subjectAltNames[] are specified, the load balancer matches the backend certificate's SAN only to subjectAltNames[].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName subject_alt_names = 330029535;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder>
        getSubjectAltNamesBuilderList() {
      return getSubjectAltNamesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName,
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder,
            com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder>
        getSubjectAltNamesFieldBuilder() {
      if (subjectAltNamesBuilder_ == null) {
        subjectAltNamesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName,
                com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltName.Builder,
                com.google.cloud.compute.v1.BackendServiceTlsSettingsSubjectAltNameOrBuilder>(
                subjectAltNames_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        subjectAltNames_ = null;
      }
      return subjectAltNamesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BackendServiceTlsSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BackendServiceTlsSettings)
  private static final com.google.cloud.compute.v1.BackendServiceTlsSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BackendServiceTlsSettings();
  }

  public static com.google.cloud.compute.v1.BackendServiceTlsSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackendServiceTlsSettings> PARSER =
      new com.google.protobuf.AbstractParser<BackendServiceTlsSettings>() {
        @java.lang.Override
        public BackendServiceTlsSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackendServiceTlsSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackendServiceTlsSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceTlsSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
