/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Connection Tracking configuration for this BackendService.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy}
 */
public final class BackendServiceConnectionTrackingPolicy
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy)
    BackendServiceConnectionTrackingPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BackendServiceConnectionTrackingPolicy.newBuilder() to construct.
  private BackendServiceConnectionTrackingPolicy(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendServiceConnectionTrackingPolicy() {
    connectionPersistenceOnUnhealthyBackends_ = "";
    trackingMode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendServiceConnectionTrackingPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendServiceConnectionTrackingPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendServiceConnectionTrackingPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.class,
            com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.ConnectionPersistenceOnUnhealthyBackends}
   */
  public enum ConnectionPersistenceOnUnhealthyBackends
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS = 0;</code>
     */
    UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS(0),
    /** <code>ALWAYS_PERSIST = 38400900;</code> */
    ALWAYS_PERSIST(38400900),
    /** <code>DEFAULT_FOR_PROTOCOL = 145265356;</code> */
    DEFAULT_FOR_PROTOCOL(145265356),
    /** <code>NEVER_PERSIST = 138646241;</code> */
    NEVER_PERSIST(138646241),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS = 0;</code>
     */
    public static final int UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS_VALUE = 0;

    /** <code>ALWAYS_PERSIST = 38400900;</code> */
    public static final int ALWAYS_PERSIST_VALUE = 38400900;

    /** <code>DEFAULT_FOR_PROTOCOL = 145265356;</code> */
    public static final int DEFAULT_FOR_PROTOCOL_VALUE = 145265356;

    /** <code>NEVER_PERSIST = 138646241;</code> */
    public static final int NEVER_PERSIST_VALUE = 138646241;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionPersistenceOnUnhealthyBackends valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectionPersistenceOnUnhealthyBackends forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS;
        case 38400900:
          return ALWAYS_PERSIST;
        case 145265356:
          return DEFAULT_FOR_PROTOCOL;
        case 138646241:
          return NEVER_PERSIST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectionPersistenceOnUnhealthyBackends>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<
            ConnectionPersistenceOnUnhealthyBackends>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<
                ConnectionPersistenceOnUnhealthyBackends>() {
              public ConnectionPersistenceOnUnhealthyBackends findValueByNumber(int number) {
                return ConnectionPersistenceOnUnhealthyBackends.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConnectionPersistenceOnUnhealthyBackends[] VALUES = values();

    public static ConnectionPersistenceOnUnhealthyBackends valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectionPersistenceOnUnhealthyBackends(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.ConnectionPersistenceOnUnhealthyBackends)
  }

  /**
   *
   *
   * <pre>
   * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.TrackingMode}
   */
  public enum TrackingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TRACKING_MODE = 0;</code>
     */
    UNDEFINED_TRACKING_MODE(0),
    /** <code>INVALID_TRACKING_MODE = 49234371;</code> */
    INVALID_TRACKING_MODE(49234371),
    /** <code>PER_CONNECTION = 85162848;</code> */
    PER_CONNECTION(85162848),
    /** <code>PER_SESSION = 182099252;</code> */
    PER_SESSION(182099252),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TRACKING_MODE = 0;</code>
     */
    public static final int UNDEFINED_TRACKING_MODE_VALUE = 0;

    /** <code>INVALID_TRACKING_MODE = 49234371;</code> */
    public static final int INVALID_TRACKING_MODE_VALUE = 49234371;

    /** <code>PER_CONNECTION = 85162848;</code> */
    public static final int PER_CONNECTION_VALUE = 85162848;

    /** <code>PER_SESSION = 182099252;</code> */
    public static final int PER_SESSION_VALUE = 182099252;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrackingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrackingMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TRACKING_MODE;
        case 49234371:
          return INVALID_TRACKING_MODE;
        case 85162848:
          return PER_CONNECTION;
        case 182099252:
          return PER_SESSION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrackingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrackingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrackingMode>() {
          public TrackingMode findValueByNumber(int number) {
            return TrackingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final TrackingMode[] VALUES = values();

    public static TrackingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrackingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.TrackingMode)
  }

  private int bitField0_;
  public static final int CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS_FIELD_NUMBER = 152439033;

  @SuppressWarnings("serial")
  private volatile java.lang.Object connectionPersistenceOnUnhealthyBackends_ = "";

  /**
   *
   *
   * <pre>
   * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
   * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
   *
   * @return Whether the connectionPersistenceOnUnhealthyBackends field is set.
   */
  @java.lang.Override
  public boolean hasConnectionPersistenceOnUnhealthyBackends() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
   * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
   *
   * @return The connectionPersistenceOnUnhealthyBackends.
   */
  @java.lang.Override
  public java.lang.String getConnectionPersistenceOnUnhealthyBackends() {
    java.lang.Object ref = connectionPersistenceOnUnhealthyBackends_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connectionPersistenceOnUnhealthyBackends_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
   * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
   * </pre>
   *
   * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
   *
   * @return The bytes for connectionPersistenceOnUnhealthyBackends.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectionPersistenceOnUnhealthyBackendsBytes() {
    java.lang.Object ref = connectionPersistenceOnUnhealthyBackends_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connectionPersistenceOnUnhealthyBackends_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_STRONG_AFFINITY_FIELD_NUMBER = 24539924;
  private boolean enableStrongAffinity_ = false;

  /**
   *
   *
   * <pre>
   * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
   * </pre>
   *
   * <code>optional bool enable_strong_affinity = 24539924;</code>
   *
   * @return Whether the enableStrongAffinity field is set.
   */
  @java.lang.Override
  public boolean hasEnableStrongAffinity() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
   * </pre>
   *
   * <code>optional bool enable_strong_affinity = 24539924;</code>
   *
   * @return The enableStrongAffinity.
   */
  @java.lang.Override
  public boolean getEnableStrongAffinity() {
    return enableStrongAffinity_;
  }

  public static final int IDLE_TIMEOUT_SEC_FIELD_NUMBER = 24977544;
  private int idleTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
   * </pre>
   *
   * <code>optional int32 idle_timeout_sec = 24977544;</code>
   *
   * @return Whether the idleTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasIdleTimeoutSec() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
   * </pre>
   *
   * <code>optional int32 idle_timeout_sec = 24977544;</code>
   *
   * @return The idleTimeoutSec.
   */
  @java.lang.Override
  public int getIdleTimeoutSec() {
    return idleTimeoutSec_;
  }

  public static final int TRACKING_MODE_FIELD_NUMBER = 127757867;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trackingMode_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
   * Check the TrackingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string tracking_mode = 127757867;</code>
   *
   * @return Whether the trackingMode field is set.
   */
  @java.lang.Override
  public boolean hasTrackingMode() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
   * Check the TrackingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string tracking_mode = 127757867;</code>
   *
   * @return The trackingMode.
   */
  @java.lang.Override
  public java.lang.String getTrackingMode() {
    java.lang.Object ref = trackingMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trackingMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
   * Check the TrackingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string tracking_mode = 127757867;</code>
   *
   * @return The bytes for trackingMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrackingModeBytes() {
    java.lang.Object ref = trackingMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trackingMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(24539924, enableStrongAffinity_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(24977544, idleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 127757867, trackingMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 152439033, connectionPersistenceOnUnhealthyBackends_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(24539924, enableStrongAffinity_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(24977544, idleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(127757867, trackingMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              152439033, connectionPersistenceOnUnhealthyBackends_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy other =
        (com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy) obj;

    if (hasConnectionPersistenceOnUnhealthyBackends()
        != other.hasConnectionPersistenceOnUnhealthyBackends()) return false;
    if (hasConnectionPersistenceOnUnhealthyBackends()) {
      if (!getConnectionPersistenceOnUnhealthyBackends()
          .equals(other.getConnectionPersistenceOnUnhealthyBackends())) return false;
    }
    if (hasEnableStrongAffinity() != other.hasEnableStrongAffinity()) return false;
    if (hasEnableStrongAffinity()) {
      if (getEnableStrongAffinity() != other.getEnableStrongAffinity()) return false;
    }
    if (hasIdleTimeoutSec() != other.hasIdleTimeoutSec()) return false;
    if (hasIdleTimeoutSec()) {
      if (getIdleTimeoutSec() != other.getIdleTimeoutSec()) return false;
    }
    if (hasTrackingMode() != other.hasTrackingMode()) return false;
    if (hasTrackingMode()) {
      if (!getTrackingMode().equals(other.getTrackingMode())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConnectionPersistenceOnUnhealthyBackends()) {
      hash = (37 * hash) + CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionPersistenceOnUnhealthyBackends().hashCode();
    }
    if (hasEnableStrongAffinity()) {
      hash = (37 * hash) + ENABLE_STRONG_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStrongAffinity());
    }
    if (hasIdleTimeoutSec()) {
      hash = (37 * hash) + IDLE_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getIdleTimeoutSec();
    }
    if (hasTrackingMode()) {
      hash = (37 * hash) + TRACKING_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getTrackingMode().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy)
      com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceConnectionTrackingPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceConnectionTrackingPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.class,
              com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      connectionPersistenceOnUnhealthyBackends_ = "";
      enableStrongAffinity_ = false;
      idleTimeoutSec_ = 0;
      trackingMode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendServiceConnectionTrackingPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy build() {
      com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy buildPartial() {
      com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy result =
          new com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.connectionPersistenceOnUnhealthyBackends_ =
            connectionPersistenceOnUnhealthyBackends_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableStrongAffinity_ = enableStrongAffinity_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.idleTimeoutSec_ = idleTimeoutSec_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.trackingMode_ = trackingMode_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy) {
        return mergeFrom(
            (com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy other) {
      if (other
          == com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
              .getDefaultInstance()) return this;
      if (other.hasConnectionPersistenceOnUnhealthyBackends()) {
        connectionPersistenceOnUnhealthyBackends_ = other.connectionPersistenceOnUnhealthyBackends_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEnableStrongAffinity()) {
        setEnableStrongAffinity(other.getEnableStrongAffinity());
      }
      if (other.hasIdleTimeoutSec()) {
        setIdleTimeoutSec(other.getIdleTimeoutSec());
      }
      if (other.hasTrackingMode()) {
        trackingMode_ = other.trackingMode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 196319392:
              {
                enableStrongAffinity_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 196319392
            case 199820352:
              {
                idleTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 199820352
            case 1022062938:
              {
                trackingMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1022062938
            case 1219512266:
              {
                connectionPersistenceOnUnhealthyBackends_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1219512266
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object connectionPersistenceOnUnhealthyBackends_ = "";

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @return Whether the connectionPersistenceOnUnhealthyBackends field is set.
     */
    public boolean hasConnectionPersistenceOnUnhealthyBackends() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @return The connectionPersistenceOnUnhealthyBackends.
     */
    public java.lang.String getConnectionPersistenceOnUnhealthyBackends() {
      java.lang.Object ref = connectionPersistenceOnUnhealthyBackends_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionPersistenceOnUnhealthyBackends_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @return The bytes for connectionPersistenceOnUnhealthyBackends.
     */
    public com.google.protobuf.ByteString getConnectionPersistenceOnUnhealthyBackendsBytes() {
      java.lang.Object ref = connectionPersistenceOnUnhealthyBackends_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionPersistenceOnUnhealthyBackends_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @param value The connectionPersistenceOnUnhealthyBackends to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionPersistenceOnUnhealthyBackends(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      connectionPersistenceOnUnhealthyBackends_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionPersistenceOnUnhealthyBackends() {
      connectionPersistenceOnUnhealthyBackends_ =
          getDefaultInstance().getConnectionPersistenceOnUnhealthyBackends();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
     * Check the ConnectionPersistenceOnUnhealthyBackends enum for the list of possible values.
     * </pre>
     *
     * <code>optional string connection_persistence_on_unhealthy_backends = 152439033;</code>
     *
     * @param value The bytes for connectionPersistenceOnUnhealthyBackends to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionPersistenceOnUnhealthyBackendsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      connectionPersistenceOnUnhealthyBackends_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean enableStrongAffinity_;

    /**
     *
     *
     * <pre>
     * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
     * </pre>
     *
     * <code>optional bool enable_strong_affinity = 24539924;</code>
     *
     * @return Whether the enableStrongAffinity field is set.
     */
    @java.lang.Override
    public boolean hasEnableStrongAffinity() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
     * </pre>
     *
     * <code>optional bool enable_strong_affinity = 24539924;</code>
     *
     * @return The enableStrongAffinity.
     */
    @java.lang.Override
    public boolean getEnableStrongAffinity() {
      return enableStrongAffinity_;
    }

    /**
     *
     *
     * <pre>
     * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
     * </pre>
     *
     * <code>optional bool enable_strong_affinity = 24539924;</code>
     *
     * @param value The enableStrongAffinity to set.
     * @return This builder for chaining.
     */
    public Builder setEnableStrongAffinity(boolean value) {

      enableStrongAffinity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable Strong Session Affinity for external passthrough Network Load Balancers. This option is not available publicly.
     * </pre>
     *
     * <code>optional bool enable_strong_affinity = 24539924;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableStrongAffinity() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableStrongAffinity_ = false;
      onChanged();
      return this;
    }

    private int idleTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
     * </pre>
     *
     * <code>optional int32 idle_timeout_sec = 24977544;</code>
     *
     * @return Whether the idleTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasIdleTimeoutSec() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
     * </pre>
     *
     * <code>optional int32 idle_timeout_sec = 24977544;</code>
     *
     * @return The idleTimeoutSec.
     */
    @java.lang.Override
    public int getIdleTimeoutSec() {
      return idleTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
     * </pre>
     *
     * <code>optional int32 idle_timeout_sec = 24977544;</code>
     *
     * @param value The idleTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setIdleTimeoutSec(int value) {

      idleTimeoutSec_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies how long to keep a Connection Tracking entry while there is no matching traffic (in seconds). For internal passthrough Network Load Balancers: - The minimum (default) is 10 minutes and the maximum is 16 hours. - It can be set only if Connection Tracking is less than 5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For external passthrough Network Load Balancers the default is 60 seconds. This option is not available publicly.
     * </pre>
     *
     * <code>optional int32 idle_timeout_sec = 24977544;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdleTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      idleTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object trackingMode_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @return Whether the trackingMode field is set.
     */
    public boolean hasTrackingMode() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @return The trackingMode.
     */
    public java.lang.String getTrackingMode() {
      java.lang.Object ref = trackingMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trackingMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @return The bytes for trackingMode.
     */
    public com.google.protobuf.ByteString getTrackingModeBytes() {
      java.lang.Object ref = trackingMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trackingMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @param value The trackingMode to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trackingMode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrackingMode() {
      trackingMode_ = getDefaultInstance().getTrackingMode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
     * Check the TrackingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string tracking_mode = 127757867;</code>
     *
     * @param value The bytes for trackingMode to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trackingMode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy)
  private static final com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy();
  }

  public static com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackendServiceConnectionTrackingPolicy> PARSER =
      new com.google.protobuf.AbstractParser<BackendServiceConnectionTrackingPolicy>() {
        @java.lang.Override
        public BackendServiceConnectionTrackingPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackendServiceConnectionTrackingPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackendServiceConnectionTrackingPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
