/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameworkAuditName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FRAMEWORK_AUDIT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/frameworkAudits/{framework_audit}");
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK_AUDIT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworkAudits/{framework_audit}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String frameworkAudit;
    private final String organization;

    @Deprecated
    protected FrameworkAuditName() {
        this.project = null;
        this.location = null;
        this.frameworkAudit = null;
        this.organization = null;
    }

    private FrameworkAuditName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkAudit = (String)Preconditions.checkNotNull((Object)builder.getFrameworkAudit());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FRAMEWORK_AUDIT;
    }

    private FrameworkAuditName(OrganizationLocationFrameworkAuditBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkAudit = (String)Preconditions.checkNotNull((Object)builder.getFrameworkAudit());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FRAMEWORK_AUDIT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameworkAudit() {
        return this.frameworkAudit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationFrameworkAuditBuilder() {
        return new Builder();
    }

    public static OrganizationLocationFrameworkAuditBuilder newOrganizationLocationFrameworkAuditBuilder() {
        return new OrganizationLocationFrameworkAuditBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FrameworkAuditName of(String project, String location, String frameworkAudit) {
        return FrameworkAuditName.newBuilder().setProject(project).setLocation(location).setFrameworkAudit(frameworkAudit).build();
    }

    public static FrameworkAuditName ofProjectLocationFrameworkAuditName(String project, String location, String frameworkAudit) {
        return FrameworkAuditName.newBuilder().setProject(project).setLocation(location).setFrameworkAudit(frameworkAudit).build();
    }

    public static FrameworkAuditName ofOrganizationLocationFrameworkAuditName(String organization, String location, String frameworkAudit) {
        return FrameworkAuditName.newOrganizationLocationFrameworkAuditBuilder().setOrganization(organization).setLocation(location).setFrameworkAudit(frameworkAudit).build();
    }

    public static String format(String project, String location, String frameworkAudit) {
        return FrameworkAuditName.newBuilder().setProject(project).setLocation(location).setFrameworkAudit(frameworkAudit).build().toString();
    }

    public static String formatProjectLocationFrameworkAuditName(String project, String location, String frameworkAudit) {
        return FrameworkAuditName.newBuilder().setProject(project).setLocation(location).setFrameworkAudit(frameworkAudit).build().toString();
    }

    public static String formatOrganizationLocationFrameworkAuditName(String organization, String location, String frameworkAudit) {
        return FrameworkAuditName.newOrganizationLocationFrameworkAuditBuilder().setOrganization(organization).setLocation(location).setFrameworkAudit(frameworkAudit).build().toString();
    }

    public static FrameworkAuditName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_FRAMEWORK_AUDIT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FRAMEWORK_AUDIT.match(formattedString);
            return FrameworkAuditName.ofProjectLocationFrameworkAuditName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("framework_audit"));
        }
        if (ORGANIZATION_LOCATION_FRAMEWORK_AUDIT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK_AUDIT.match(formattedString);
            return FrameworkAuditName.ofOrganizationLocationFrameworkAuditName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework_audit"));
        }
        throw new ValidationException("FrameworkAuditName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FrameworkAuditName> parseList(List<String> formattedStrings) {
        ArrayList<FrameworkAuditName> list = new ArrayList<FrameworkAuditName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FrameworkAuditName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FrameworkAuditName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FrameworkAuditName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FRAMEWORK_AUDIT.matches(formattedString) || ORGANIZATION_LOCATION_FRAMEWORK_AUDIT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FrameworkAuditName frameworkAuditName = this;
            synchronized (frameworkAuditName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.frameworkAudit != null) {
                        fieldMapBuilder.put((Object)"framework_audit", (Object)this.frameworkAudit);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FrameworkAuditName that = (FrameworkAuditName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.frameworkAudit, that.frameworkAudit) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.frameworkAudit);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationFrameworkAuditBuilder {
        private String organization;
        private String location;
        private String frameworkAudit;

        protected OrganizationLocationFrameworkAuditBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkAudit() {
            return this.frameworkAudit;
        }

        public OrganizationLocationFrameworkAuditBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationFrameworkAuditBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationFrameworkAuditBuilder setFrameworkAudit(String frameworkAudit) {
            this.frameworkAudit = frameworkAudit;
            return this;
        }

        public FrameworkAuditName build() {
            return new FrameworkAuditName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String frameworkAudit;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkAudit() {
            return this.frameworkAudit;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFrameworkAudit(String frameworkAudit) {
            this.frameworkAudit = frameworkAudit;
            return this;
        }

        private Builder(FrameworkAuditName frameworkAuditName) {
            Preconditions.checkArgument((boolean)Objects.equals(frameworkAuditName.pathTemplate, PROJECT_LOCATION_FRAMEWORK_AUDIT), (Object)"toBuilder is only supported when FrameworkAuditName has the pattern of projects/{project}/locations/{location}/frameworkAudits/{framework_audit}");
            this.project = frameworkAuditName.project;
            this.location = frameworkAuditName.location;
            this.frameworkAudit = frameworkAuditName.frameworkAudit;
        }

        public FrameworkAuditName build() {
            return new FrameworkAuditName(this);
        }
    }
}

