/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FindingSummaryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FINDING_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/findingSummaries/{finding_summary}");
    private static final PathTemplate FOLDER_LOCATION_FINDING_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/findingSummaries/{finding_summary}");
    private static final PathTemplate ORGANIZATION_LOCATION_FINDING_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/findingSummaries/{finding_summary}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String findingSummary;
    private final String folder;
    private final String organization;

    @Deprecated
    protected FindingSummaryName() {
        this.project = null;
        this.location = null;
        this.findingSummary = null;
        this.folder = null;
        this.organization = null;
    }

    private FindingSummaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.findingSummary = (String)Preconditions.checkNotNull((Object)builder.getFindingSummary());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FINDING_SUMMARY;
    }

    private FindingSummaryName(FolderLocationFindingSummaryBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.findingSummary = (String)Preconditions.checkNotNull((Object)builder.getFindingSummary());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_FINDING_SUMMARY;
    }

    private FindingSummaryName(OrganizationLocationFindingSummaryBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.findingSummary = (String)Preconditions.checkNotNull((Object)builder.getFindingSummary());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FINDING_SUMMARY;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFindingSummary() {
        return this.findingSummary;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationFindingSummaryBuilder() {
        return new Builder();
    }

    public static FolderLocationFindingSummaryBuilder newFolderLocationFindingSummaryBuilder() {
        return new FolderLocationFindingSummaryBuilder();
    }

    public static OrganizationLocationFindingSummaryBuilder newOrganizationLocationFindingSummaryBuilder() {
        return new OrganizationLocationFindingSummaryBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FindingSummaryName of(String project, String location, String findingSummary) {
        return FindingSummaryName.newBuilder().setProject(project).setLocation(location).setFindingSummary(findingSummary).build();
    }

    public static FindingSummaryName ofProjectLocationFindingSummaryName(String project, String location, String findingSummary) {
        return FindingSummaryName.newBuilder().setProject(project).setLocation(location).setFindingSummary(findingSummary).build();
    }

    public static FindingSummaryName ofFolderLocationFindingSummaryName(String folder, String location, String findingSummary) {
        return FindingSummaryName.newFolderLocationFindingSummaryBuilder().setFolder(folder).setLocation(location).setFindingSummary(findingSummary).build();
    }

    public static FindingSummaryName ofOrganizationLocationFindingSummaryName(String organization, String location, String findingSummary) {
        return FindingSummaryName.newOrganizationLocationFindingSummaryBuilder().setOrganization(organization).setLocation(location).setFindingSummary(findingSummary).build();
    }

    public static String format(String project, String location, String findingSummary) {
        return FindingSummaryName.newBuilder().setProject(project).setLocation(location).setFindingSummary(findingSummary).build().toString();
    }

    public static String formatProjectLocationFindingSummaryName(String project, String location, String findingSummary) {
        return FindingSummaryName.newBuilder().setProject(project).setLocation(location).setFindingSummary(findingSummary).build().toString();
    }

    public static String formatFolderLocationFindingSummaryName(String folder, String location, String findingSummary) {
        return FindingSummaryName.newFolderLocationFindingSummaryBuilder().setFolder(folder).setLocation(location).setFindingSummary(findingSummary).build().toString();
    }

    public static String formatOrganizationLocationFindingSummaryName(String organization, String location, String findingSummary) {
        return FindingSummaryName.newOrganizationLocationFindingSummaryBuilder().setOrganization(organization).setLocation(location).setFindingSummary(findingSummary).build().toString();
    }

    public static FindingSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_FINDING_SUMMARY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FINDING_SUMMARY.match(formattedString);
            return FindingSummaryName.ofProjectLocationFindingSummaryName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("finding_summary"));
        }
        if (FOLDER_LOCATION_FINDING_SUMMARY.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_FINDING_SUMMARY.match(formattedString);
            return FindingSummaryName.ofFolderLocationFindingSummaryName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("finding_summary"));
        }
        if (ORGANIZATION_LOCATION_FINDING_SUMMARY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FINDING_SUMMARY.match(formattedString);
            return FindingSummaryName.ofOrganizationLocationFindingSummaryName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("finding_summary"));
        }
        throw new ValidationException("FindingSummaryName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FindingSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<FindingSummaryName> list = new ArrayList<FindingSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FindingSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FindingSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FindingSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FINDING_SUMMARY.matches(formattedString) || FOLDER_LOCATION_FINDING_SUMMARY.matches(formattedString) || ORGANIZATION_LOCATION_FINDING_SUMMARY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FindingSummaryName findingSummaryName = this;
            synchronized (findingSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.findingSummary != null) {
                        fieldMapBuilder.put((Object)"finding_summary", (Object)this.findingSummary);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FindingSummaryName that = (FindingSummaryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.findingSummary, that.findingSummary) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.findingSummary);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationFindingSummaryBuilder {
        private String organization;
        private String location;
        private String findingSummary;

        protected OrganizationLocationFindingSummaryBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFindingSummary() {
            return this.findingSummary;
        }

        public OrganizationLocationFindingSummaryBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationFindingSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationFindingSummaryBuilder setFindingSummary(String findingSummary) {
            this.findingSummary = findingSummary;
            return this;
        }

        public FindingSummaryName build() {
            return new FindingSummaryName(this);
        }
    }

    public static class FolderLocationFindingSummaryBuilder {
        private String folder;
        private String location;
        private String findingSummary;

        protected FolderLocationFindingSummaryBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFindingSummary() {
            return this.findingSummary;
        }

        public FolderLocationFindingSummaryBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationFindingSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationFindingSummaryBuilder setFindingSummary(String findingSummary) {
            this.findingSummary = findingSummary;
            return this;
        }

        public FindingSummaryName build() {
            return new FindingSummaryName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String findingSummary;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFindingSummary() {
            return this.findingSummary;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFindingSummary(String findingSummary) {
            this.findingSummary = findingSummary;
            return this;
        }

        private Builder(FindingSummaryName findingSummaryName) {
            Preconditions.checkArgument((boolean)Objects.equals(findingSummaryName.pathTemplate, PROJECT_LOCATION_FINDING_SUMMARY), (Object)"toBuilder is only supported when FindingSummaryName has the pattern of projects/{project}/locations/{location}/findingSummaries/{finding_summary}");
            this.project = findingSummaryName.project;
            this.location = findingSummaryName.location;
            this.findingSummary = findingSummaryName.findingSummary;
        }

        public FindingSummaryName build() {
            return new FindingSummaryName(this);
        }
    }
}

