/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/services/{service}");
    private static final PathTemplate FOLDER_LOCATION_SERVICE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/services/{service}");
    private static final PathTemplate ORGANIZATION_LOCATION_SERVICE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/services/{service}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String service;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ServiceName() {
        this.project = null;
        this.location = null;
        this.service = null;
        this.folder = null;
        this.organization = null;
    }

    private ServiceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_SERVICE;
    }

    private ServiceName(FolderLocationServiceBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_SERVICE;
    }

    private ServiceName(OrganizationLocationServiceBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_SERVICE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getService() {
        return this.service;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationServiceBuilder() {
        return new Builder();
    }

    public static FolderLocationServiceBuilder newFolderLocationServiceBuilder() {
        return new FolderLocationServiceBuilder();
    }

    public static OrganizationLocationServiceBuilder newOrganizationLocationServiceBuilder() {
        return new OrganizationLocationServiceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceName of(String project, String location, String service) {
        return ServiceName.newBuilder().setProject(project).setLocation(location).setService(service).build();
    }

    public static ServiceName ofProjectLocationServiceName(String project, String location, String service) {
        return ServiceName.newBuilder().setProject(project).setLocation(location).setService(service).build();
    }

    public static ServiceName ofFolderLocationServiceName(String folder, String location, String service) {
        return ServiceName.newFolderLocationServiceBuilder().setFolder(folder).setLocation(location).setService(service).build();
    }

    public static ServiceName ofOrganizationLocationServiceName(String organization, String location, String service) {
        return ServiceName.newOrganizationLocationServiceBuilder().setOrganization(organization).setLocation(location).setService(service).build();
    }

    public static String format(String project, String location, String service) {
        return ServiceName.newBuilder().setProject(project).setLocation(location).setService(service).build().toString();
    }

    public static String formatProjectLocationServiceName(String project, String location, String service) {
        return ServiceName.newBuilder().setProject(project).setLocation(location).setService(service).build().toString();
    }

    public static String formatFolderLocationServiceName(String folder, String location, String service) {
        return ServiceName.newFolderLocationServiceBuilder().setFolder(folder).setLocation(location).setService(service).build().toString();
    }

    public static String formatOrganizationLocationServiceName(String organization, String location, String service) {
        return ServiceName.newOrganizationLocationServiceBuilder().setOrganization(organization).setLocation(location).setService(service).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_SERVICE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SERVICE.match(formattedString);
            return ServiceName.ofProjectLocationServiceName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service"));
        }
        if (FOLDER_LOCATION_SERVICE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_SERVICE.match(formattedString);
            return ServiceName.ofFolderLocationServiceName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("service"));
        }
        if (ORGANIZATION_LOCATION_SERVICE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_SERVICE.match(formattedString);
            return ServiceName.ofOrganizationLocationServiceName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("service"));
        }
        throw new ValidationException("ServiceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE.matches(formattedString) || FOLDER_LOCATION_SERVICE.matches(formattedString) || ORGANIZATION_LOCATION_SERVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceName that = (ServiceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.service, that.service) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationServiceBuilder {
        private String organization;
        private String location;
        private String service;

        protected OrganizationLocationServiceBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public OrganizationLocationServiceBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationServiceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    public static class FolderLocationServiceBuilder {
        private String folder;
        private String location;
        private String service;

        protected FolderLocationServiceBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public FolderLocationServiceBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationServiceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String service;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        private Builder(ServiceName serviceName) {
            Preconditions.checkArgument((boolean)Objects.equals(serviceName.pathTemplate, PROJECT_LOCATION_SERVICE), (Object)"toBuilder is only supported when ServiceName has the pattern of projects/{project}/locations/{location}/services/{service}");
            this.project = serviceName.project;
            this.location = serviceName.location;
            this.service = serviceName.service;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

