/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QuotaInfoName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_QUOTA_INFO = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/services/{service}/quotaInfos/{quota_info}");
    private static final PathTemplate FOLDER_LOCATION_SERVICE_QUOTA_INFO = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/services/{service}/quotaInfos/{quota_info}");
    private static final PathTemplate ORGANIZATION_LOCATION_SERVICE_QUOTA_INFO = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/services/{service}/quotaInfos/{quota_info}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String service;
    private final String quotaInfo;
    private final String folder;
    private final String organization;

    @Deprecated
    protected QuotaInfoName() {
        this.project = null;
        this.location = null;
        this.service = null;
        this.quotaInfo = null;
        this.folder = null;
        this.organization = null;
    }

    private QuotaInfoName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.quotaInfo = (String)Preconditions.checkNotNull((Object)builder.getQuotaInfo());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_SERVICE_QUOTA_INFO;
    }

    private QuotaInfoName(FolderLocationServiceQuotaInfoBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.quotaInfo = (String)Preconditions.checkNotNull((Object)builder.getQuotaInfo());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_SERVICE_QUOTA_INFO;
    }

    private QuotaInfoName(OrganizationLocationServiceQuotaInfoBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.quotaInfo = (String)Preconditions.checkNotNull((Object)builder.getQuotaInfo());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_SERVICE_QUOTA_INFO;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getService() {
        return this.service;
    }

    public String getQuotaInfo() {
        return this.quotaInfo;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationServiceQuotaInfoBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderLocationServiceQuotaInfoBuilder newFolderLocationServiceQuotaInfoBuilder() {
        return new FolderLocationServiceQuotaInfoBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLocationServiceQuotaInfoBuilder newOrganizationLocationServiceQuotaInfoBuilder() {
        return new OrganizationLocationServiceQuotaInfoBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QuotaInfoName of(String project, String location, String service, String quotaInfo) {
        return QuotaInfoName.newBuilder().setProject(project).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static QuotaInfoName ofProjectLocationServiceQuotaInfoName(String project, String location, String service, String quotaInfo) {
        return QuotaInfoName.newBuilder().setProject(project).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static QuotaInfoName ofFolderLocationServiceQuotaInfoName(String folder, String location, String service, String quotaInfo) {
        return QuotaInfoName.newFolderLocationServiceQuotaInfoBuilder().setFolder(folder).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static QuotaInfoName ofOrganizationLocationServiceQuotaInfoName(String organization, String location, String service, String quotaInfo) {
        return QuotaInfoName.newOrganizationLocationServiceQuotaInfoBuilder().setOrganization(organization).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build();
    }

    public static String format(String project, String location, String service, String quotaInfo) {
        return QuotaInfoName.newBuilder().setProject(project).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationServiceQuotaInfoName(String project, String location, String service, String quotaInfo) {
        return QuotaInfoName.newBuilder().setProject(project).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderLocationServiceQuotaInfoName(String folder, String location, String service, String quotaInfo) {
        return QuotaInfoName.newFolderLocationServiceQuotaInfoBuilder().setFolder(folder).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationServiceQuotaInfoName(String organization, String location, String service, String quotaInfo) {
        return QuotaInfoName.newOrganizationLocationServiceQuotaInfoBuilder().setOrganization(organization).setLocation(location).setService(service).setQuotaInfo(quotaInfo).build().toString();
    }

    public static QuotaInfoName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SERVICE_QUOTA_INFO.match(formattedString);
            return QuotaInfoName.ofProjectLocationServiceQuotaInfoName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service"), (String)matchMap.get("quota_info"));
        }
        if (FOLDER_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_SERVICE_QUOTA_INFO.match(formattedString);
            return QuotaInfoName.ofFolderLocationServiceQuotaInfoName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("service"), (String)matchMap.get("quota_info"));
        }
        if (ORGANIZATION_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_SERVICE_QUOTA_INFO.match(formattedString);
            return QuotaInfoName.ofOrganizationLocationServiceQuotaInfoName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("service"), (String)matchMap.get("quota_info"));
        }
        throw new ValidationException("QuotaInfoName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<QuotaInfoName> parseList(List<String> formattedStrings) {
        ArrayList<QuotaInfoName> list = new ArrayList<QuotaInfoName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QuotaInfoName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QuotaInfoName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QuotaInfoName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString) || FOLDER_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString) || ORGANIZATION_LOCATION_SERVICE_QUOTA_INFO.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QuotaInfoName quotaInfoName = this;
            synchronized (quotaInfoName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.quotaInfo != null) {
                        fieldMapBuilder.put((Object)"quota_info", (Object)this.quotaInfo);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QuotaInfoName that = (QuotaInfoName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.service, that.service) && Objects.equals(this.quotaInfo, that.quotaInfo) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        h ^= Objects.hashCode(this.quotaInfo);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLocationServiceQuotaInfoBuilder {
        private String organization;
        private String location;
        private String service;
        private String quotaInfo;

        protected OrganizationLocationServiceQuotaInfoBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public String getQuotaInfo() {
            return this.quotaInfo;
        }

        public OrganizationLocationServiceQuotaInfoBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationServiceQuotaInfoBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationServiceQuotaInfoBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public OrganizationLocationServiceQuotaInfoBuilder setQuotaInfo(String quotaInfo) {
            this.quotaInfo = quotaInfo;
            return this;
        }

        public QuotaInfoName build() {
            return new QuotaInfoName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderLocationServiceQuotaInfoBuilder {
        private String folder;
        private String location;
        private String service;
        private String quotaInfo;

        protected FolderLocationServiceQuotaInfoBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public String getQuotaInfo() {
            return this.quotaInfo;
        }

        public FolderLocationServiceQuotaInfoBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationServiceQuotaInfoBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationServiceQuotaInfoBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public FolderLocationServiceQuotaInfoBuilder setQuotaInfo(String quotaInfo) {
            this.quotaInfo = quotaInfo;
            return this;
        }

        public QuotaInfoName build() {
            return new QuotaInfoName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String service;
        private String quotaInfo;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public String getQuotaInfo() {
            return this.quotaInfo;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setQuotaInfo(String quotaInfo) {
            this.quotaInfo = quotaInfo;
            return this;
        }

        private Builder(QuotaInfoName quotaInfoName) {
            Preconditions.checkArgument((boolean)Objects.equals(quotaInfoName.pathTemplate, PROJECT_LOCATION_SERVICE_QUOTA_INFO), (Object)"toBuilder is only supported when QuotaInfoName has the pattern of projects/{project}/locations/{location}/services/{service}/quotaInfos/{quota_info}");
            this.project = quotaInfoName.project;
            this.location = quotaInfoName.location;
            this.service = quotaInfoName.service;
            this.quotaInfo = quotaInfoName.quotaInfo;
        }

        public QuotaInfoName build() {
            return new QuotaInfoName(this);
        }
    }
}

