/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate FOLDER_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}");
    private static final PathTemplate ORGANIZATION_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String folder;
    private final String organization;

    @Deprecated
    protected LocationName() {
        this.project = null;
        this.location = null;
        this.folder = null;
        this.organization = null;
    }

    private LocationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION;
    }

    private LocationName(FolderLocationBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION;
    }

    private LocationName(OrganizationLocationBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationBuilder() {
        return new Builder();
    }

    public static FolderLocationBuilder newFolderLocationBuilder() {
        return new FolderLocationBuilder();
    }

    public static OrganizationLocationBuilder newOrganizationLocationBuilder() {
        return new OrganizationLocationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocationName of(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static LocationName ofProjectLocationName(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static LocationName ofFolderLocationName(String folder, String location) {
        return LocationName.newFolderLocationBuilder().setFolder(folder).setLocation(location).build();
    }

    public static LocationName ofOrganizationLocationName(String organization, String location) {
        return LocationName.newOrganizationLocationBuilder().setOrganization(organization).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static String formatProjectLocationName(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static String formatFolderLocationName(String folder, String location) {
        return LocationName.newFolderLocationBuilder().setFolder(folder).setLocation(location).build().toString();
    }

    public static String formatOrganizationLocationName(String organization, String location) {
        return LocationName.newOrganizationLocationBuilder().setOrganization(organization).setLocation(location).build().toString();
    }

    public static LocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return LocationName.ofProjectLocationName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        if (FOLDER_LOCATION.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION.match(formattedString);
            return LocationName.ofFolderLocationName((String)matchMap.get("folder"), (String)matchMap.get("location"));
        }
        if (ORGANIZATION_LOCATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION.match(formattedString);
            return LocationName.ofOrganizationLocationName((String)matchMap.get("organization"), (String)matchMap.get("location"));
        }
        throw new ValidationException("LocationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LocationName> parseList(List<String> formattedStrings) {
        ArrayList<LocationName> list = new ArrayList<LocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString) || FOLDER_LOCATION.matches(formattedString) || ORGANIZATION_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationName locationName = this;
            synchronized (locationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocationName that = (LocationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationBuilder {
        private String organization;
        private String location;

        protected OrganizationLocationBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public OrganizationLocationBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }

    public static class FolderLocationBuilder {
        private String folder;
        private String location;

        protected FolderLocationBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public FolderLocationBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(LocationName locationName) {
            Preconditions.checkArgument((boolean)Objects.equals(locationName.pathTemplate, PROJECT_LOCATION), (Object)"toBuilder is only supported when LocationName has the pattern of projects/{project}/locations/{location}");
            this.project = locationName.project;
            this.location = locationName.location;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }
}

