/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EkmConnectionsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/ekmConnections");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String customer;
    private final String workload;

    @Deprecated
    protected EkmConnectionsName() {
        this.organization = null;
        this.location = null;
        this.customer = null;
        this.workload = null;
    }

    private EkmConnectionsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getWorkload() {
        return this.workload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EkmConnectionsName of(String organization, String location, String customer, String workload) {
        return EkmConnectionsName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).setWorkload(workload).build();
    }

    public static String format(String organization, String location, String customer, String workload) {
        return EkmConnectionsName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).setWorkload(workload).build().toString();
    }

    public static EkmConnectionsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD.validatedMatch(formattedString, "EkmConnectionsName.parse: formattedString not in valid format");
        return EkmConnectionsName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("customer"), (String)matchMap.get("workload"));
    }

    public static List<EkmConnectionsName> parseList(List<String> formattedStrings) {
        ArrayList<EkmConnectionsName> list = new ArrayList<EkmConnectionsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EkmConnectionsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EkmConnectionsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EkmConnectionsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EkmConnectionsName ekmConnectionsName = this;
            synchronized (ekmConnectionsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    if (this.workload != null) {
                        fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD.instantiate(new String[]{"organization", this.organization, "location", this.location, "customer", this.customer, "workload", this.workload});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EkmConnectionsName that = (EkmConnectionsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.customer, that.customer) && Objects.equals(this.workload, that.workload);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.customer);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workload);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String customer;
        private String workload;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomer() {
            return this.customer;
        }

        public String getWorkload() {
            return this.workload;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        private Builder(EkmConnectionsName ekmConnectionsName) {
            this.organization = ekmConnectionsName.organization;
            this.location = ekmConnectionsName.location;
            this.customer = ekmConnectionsName.customer;
            this.workload = ekmConnectionsName.workload;
        }

        public EkmConnectionsName build() {
            return new EkmConnectionsName(this);
        }
    }
}

