/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessApprovalRequestName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD_ACCESS_APPROVAL_REQUEST = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/accessApprovalRequests/{access_approval_request}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String customer;
    private final String workload;
    private final String accessApprovalRequest;

    @Deprecated
    protected AccessApprovalRequestName() {
        this.organization = null;
        this.location = null;
        this.customer = null;
        this.workload = null;
        this.accessApprovalRequest = null;
    }

    private AccessApprovalRequestName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
        this.accessApprovalRequest = (String)Preconditions.checkNotNull((Object)builder.getAccessApprovalRequest());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getAccessApprovalRequest() {
        return this.accessApprovalRequest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccessApprovalRequestName of(String organization, String location, String customer, String workload, String accessApprovalRequest) {
        return AccessApprovalRequestName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).setWorkload(workload).setAccessApprovalRequest(accessApprovalRequest).build();
    }

    public static String format(String organization, String location, String customer, String workload, String accessApprovalRequest) {
        return AccessApprovalRequestName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).setWorkload(workload).setAccessApprovalRequest(accessApprovalRequest).build().toString();
    }

    public static AccessApprovalRequestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD_ACCESS_APPROVAL_REQUEST.validatedMatch(formattedString, "AccessApprovalRequestName.parse: formattedString not in valid format");
        return AccessApprovalRequestName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("customer"), (String)matchMap.get("workload"), (String)matchMap.get("access_approval_request"));
    }

    public static List<AccessApprovalRequestName> parseList(List<String> formattedStrings) {
        ArrayList<AccessApprovalRequestName> list = new ArrayList<AccessApprovalRequestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccessApprovalRequestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccessApprovalRequestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccessApprovalRequestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD_ACCESS_APPROVAL_REQUEST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccessApprovalRequestName accessApprovalRequestName = this;
            synchronized (accessApprovalRequestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    if (this.workload != null) {
                        fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    }
                    if (this.accessApprovalRequest != null) {
                        fieldMapBuilder.put((Object)"access_approval_request", (Object)this.accessApprovalRequest);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_CUSTOMER_WORKLOAD_ACCESS_APPROVAL_REQUEST.instantiate(new String[]{"organization", this.organization, "location", this.location, "customer", this.customer, "workload", this.workload, "access_approval_request", this.accessApprovalRequest});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccessApprovalRequestName that = (AccessApprovalRequestName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.customer, that.customer) && Objects.equals(this.workload, that.workload) && Objects.equals(this.accessApprovalRequest, that.accessApprovalRequest);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.customer);
        h *= 1000003;
        h ^= Objects.hashCode(this.workload);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accessApprovalRequest);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String customer;
        private String workload;
        private String accessApprovalRequest;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomer() {
            return this.customer;
        }

        public String getWorkload() {
            return this.workload;
        }

        public String getAccessApprovalRequest() {
            return this.accessApprovalRequest;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        public Builder setAccessApprovalRequest(String accessApprovalRequest) {
            this.accessApprovalRequest = accessApprovalRequest;
            return this;
        }

        private Builder(AccessApprovalRequestName accessApprovalRequestName) {
            this.organization = accessApprovalRequestName.organization;
            this.location = accessApprovalRequestName.location;
            this.customer = accessApprovalRequestName.customer;
            this.workload = accessApprovalRequestName.workload;
            this.accessApprovalRequest = accessApprovalRequestName.accessApprovalRequest;
        }

        public AccessApprovalRequestName build() {
            return new AccessApprovalRequestName(this);
        }
    }
}

