/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.cloud.chronicle.v1.CompilationDiagnostic;
import com.google.cloud.chronicle.v1.CompilationDiagnosticOrBuilder;
import com.google.cloud.chronicle.v1.InputsUsed;
import com.google.cloud.chronicle.v1.InputsUsedOrBuilder;
import com.google.cloud.chronicle.v1.RuleOrBuilder;
import com.google.cloud.chronicle.v1.RuleProto;
import com.google.cloud.chronicle.v1.RuleType;
import com.google.cloud.chronicle.v1.RunFrequency;
import com.google.cloud.chronicle.v1.Severity;
import com.google.cloud.chronicle.v1.SeverityOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Rule
extends GeneratedMessageV3
implements RuleOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int REVISION_ID_FIELD_NUMBER = 2;
    private volatile Object revisionId_ = "";
    public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
    private volatile Object displayName_ = "";
    public static final int TEXT_FIELD_NUMBER = 4;
    private volatile Object text_ = "";
    public static final int AUTHOR_FIELD_NUMBER = 5;
    private volatile Object author_ = "";
    public static final int SEVERITY_FIELD_NUMBER = 6;
    private Severity severity_;
    public static final int METADATA_FIELD_NUMBER = 7;
    private MapField<String, String> metadata_;
    public static final int CREATE_TIME_FIELD_NUMBER = 8;
    private Timestamp createTime_;
    public static final int REVISION_CREATE_TIME_FIELD_NUMBER = 9;
    private Timestamp revisionCreateTime_;
    public static final int COMPILATION_STATE_FIELD_NUMBER = 10;
    private int compilationState_ = 0;
    public static final int TYPE_FIELD_NUMBER = 12;
    private int type_ = 0;
    public static final int REFERENCE_LISTS_FIELD_NUMBER = 13;
    private LazyStringArrayList referenceLists_ = LazyStringArrayList.emptyList();
    public static final int ALLOWED_RUN_FREQUENCIES_FIELD_NUMBER = 14;
    private List<Integer> allowedRunFrequencies_;
    private static final Internal.ListAdapter.Converter<Integer, RunFrequency> allowedRunFrequencies_converter_ = new Internal.ListAdapter.Converter<Integer, RunFrequency>(){

        public RunFrequency convert(Integer from) {
            RunFrequency result = RunFrequency.forNumber(from);
            return result == null ? RunFrequency.UNRECOGNIZED : result;
        }
    };
    private int allowedRunFrequenciesMemoizedSerializedSize;
    public static final int ETAG_FIELD_NUMBER = 15;
    private volatile Object etag_ = "";
    public static final int SCOPE_FIELD_NUMBER = 16;
    private volatile Object scope_ = "";
    public static final int COMPILATION_DIAGNOSTICS_FIELD_NUMBER = 17;
    private List<CompilationDiagnostic> compilationDiagnostics_;
    public static final int NEAR_REAL_TIME_LIVE_RULE_ELIGIBLE_FIELD_NUMBER = 18;
    private boolean nearRealTimeLiveRuleEligible_ = false;
    public static final int INPUTS_USED_FIELD_NUMBER = 20;
    private InputsUsed inputsUsed_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Rule DEFAULT_INSTANCE = new Rule();
    private static final Parser<Rule> PARSER = new AbstractParser<Rule>(){

        public Rule parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Rule.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Rule(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Rule() {
        this.name_ = "";
        this.revisionId_ = "";
        this.displayName_ = "";
        this.text_ = "";
        this.author_ = "";
        this.compilationState_ = 0;
        this.type_ = 0;
        this.referenceLists_ = LazyStringArrayList.emptyList();
        this.allowedRunFrequencies_ = Collections.emptyList();
        this.etag_ = "";
        this.scope_ = "";
        this.compilationDiagnostics_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Rule();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RuleProto.internal_static_google_cloud_chronicle_v1_Rule_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 7: {
                return this.internalGetMetadata();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RuleProto.internal_static_google_cloud_chronicle_v1_Rule_fieldAccessorTable.ensureFieldAccessorsInitialized(Rule.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRevisionId() {
        Object ref = this.revisionId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.revisionId_ = s;
        return s;
    }

    @Override
    public ByteString getRevisionIdBytes() {
        Object ref = this.revisionId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.revisionId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getText() {
        Object ref = this.text_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.text_ = s;
        return s;
    }

    @Override
    public ByteString getTextBytes() {
        Object ref = this.text_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.text_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAuthor() {
        Object ref = this.author_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.author_ = s;
        return s;
    }

    @Override
    public ByteString getAuthorBytes() {
        Object ref = this.author_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.author_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasSeverity() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Severity getSeverity() {
        return this.severity_ == null ? Severity.getDefaultInstance() : this.severity_;
    }

    @Override
    public SeverityOrBuilder getSeverityOrBuilder() {
        return this.severity_ == null ? Severity.getDefaultInstance() : this.severity_;
    }

    private MapField<String, String> internalGetMetadata() {
        if (this.metadata_ == null) {
            return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
        }
        return this.metadata_;
    }

    @Override
    public int getMetadataCount() {
        return this.internalGetMetadata().getMap().size();
    }

    @Override
    public boolean containsMetadata(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetMetadata().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getMetadata() {
        return this.getMetadataMap();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        return this.internalGetMetadata().getMap();
    }

    @Override
    public String getMetadataOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetMetadata().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getMetadataOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetMetadata().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasRevisionCreateTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getRevisionCreateTime() {
        return this.revisionCreateTime_ == null ? Timestamp.getDefaultInstance() : this.revisionCreateTime_;
    }

    @Override
    public TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
        return this.revisionCreateTime_ == null ? Timestamp.getDefaultInstance() : this.revisionCreateTime_;
    }

    @Override
    public int getCompilationStateValue() {
        return this.compilationState_;
    }

    @Override
    public CompilationState getCompilationState() {
        CompilationState result = CompilationState.forNumber(this.compilationState_);
        return result == null ? CompilationState.UNRECOGNIZED : result;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public RuleType getType() {
        RuleType result = RuleType.forNumber(this.type_);
        return result == null ? RuleType.UNRECOGNIZED : result;
    }

    public ProtocolStringList getReferenceListsList() {
        return this.referenceLists_;
    }

    @Override
    public int getReferenceListsCount() {
        return this.referenceLists_.size();
    }

    @Override
    public String getReferenceLists(int index) {
        return this.referenceLists_.get(index);
    }

    @Override
    public ByteString getReferenceListsBytes(int index) {
        return this.referenceLists_.getByteString(index);
    }

    @Override
    public List<RunFrequency> getAllowedRunFrequenciesList() {
        return new Internal.ListAdapter(this.allowedRunFrequencies_, allowedRunFrequencies_converter_);
    }

    @Override
    public int getAllowedRunFrequenciesCount() {
        return this.allowedRunFrequencies_.size();
    }

    @Override
    public RunFrequency getAllowedRunFrequencies(int index) {
        return (RunFrequency)((Object)allowedRunFrequencies_converter_.convert((Object)this.allowedRunFrequencies_.get(index)));
    }

    @Override
    public List<Integer> getAllowedRunFrequenciesValueList() {
        return this.allowedRunFrequencies_;
    }

    @Override
    public int getAllowedRunFrequenciesValue(int index) {
        return this.allowedRunFrequencies_.get(index);
    }

    @Override
    public String getEtag() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.etag_ = s;
        return s;
    }

    @Override
    public ByteString getEtagBytes() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.etag_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getScope() {
        Object ref = this.scope_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.scope_ = s;
        return s;
    }

    @Override
    public ByteString getScopeBytes() {
        Object ref = this.scope_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.scope_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<CompilationDiagnostic> getCompilationDiagnosticsList() {
        return this.compilationDiagnostics_;
    }

    @Override
    public List<? extends CompilationDiagnosticOrBuilder> getCompilationDiagnosticsOrBuilderList() {
        return this.compilationDiagnostics_;
    }

    @Override
    public int getCompilationDiagnosticsCount() {
        return this.compilationDiagnostics_.size();
    }

    @Override
    public CompilationDiagnostic getCompilationDiagnostics(int index) {
        return this.compilationDiagnostics_.get(index);
    }

    @Override
    public CompilationDiagnosticOrBuilder getCompilationDiagnosticsOrBuilder(int index) {
        return this.compilationDiagnostics_.get(index);
    }

    @Override
    public boolean getNearRealTimeLiveRuleEligible() {
        return this.nearRealTimeLiveRuleEligible_;
    }

    @Override
    public boolean hasInputsUsed() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public InputsUsed getInputsUsed() {
        return this.inputsUsed_ == null ? InputsUsed.getDefaultInstance() : this.inputsUsed_;
    }

    @Override
    public InputsUsedOrBuilder getInputsUsedOrBuilder() {
        return this.inputsUsed_ == null ? InputsUsed.getDefaultInstance() : this.inputsUsed_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.revisionId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.revisionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.displayName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.text_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.text_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.author_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.author_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(6, (MessageLite)this.getSeverity());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, (int)7);
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(9, (MessageLite)this.getRevisionCreateTime());
        }
        if (this.compilationState_ != CompilationState.COMPILATION_STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.compilationState_);
        }
        if (this.type_ != RuleType.RULE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.type_);
        }
        for (i = 0; i < this.referenceLists_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.referenceLists_.getRaw(i));
        }
        if (this.getAllowedRunFrequenciesList().size() > 0) {
            output.writeUInt32NoTag(114);
            output.writeUInt32NoTag(this.allowedRunFrequenciesMemoizedSerializedSize);
        }
        for (i = 0; i < this.allowedRunFrequencies_.size(); ++i) {
            output.writeEnumNoTag(this.allowedRunFrequencies_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)15, (Object)this.etag_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.scope_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.scope_);
        }
        for (i = 0; i < this.compilationDiagnostics_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.compilationDiagnostics_.get(i));
        }
        if (this.nearRealTimeLiveRuleEligible_) {
            output.writeBool(18, this.nearRealTimeLiveRuleEligible_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(20, (MessageLite)this.getInputsUsed());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.revisionId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.revisionId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.displayName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.text_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.text_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.author_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.author_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getSeverity());
        }
        for (Map.Entry entry : this.internalGetMetadata().getMap().entrySet()) {
            MapEntry metadata__ = MetadataDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)metadata__);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getRevisionCreateTime());
        }
        if (this.compilationState_ != CompilationState.COMPILATION_STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.compilationState_);
        }
        if (this.type_ != RuleType.RULE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.type_);
        }
        int dataSize = 0;
        for (i = 0; i < this.referenceLists_.size(); ++i) {
            dataSize += Rule.computeStringSizeNoTag((Object)this.referenceLists_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getReferenceListsList().size();
        dataSize = 0;
        for (i = 0; i < this.allowedRunFrequencies_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.allowedRunFrequencies_.get(i));
        }
        size += dataSize;
        if (!this.getAllowedRunFrequenciesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.allowedRunFrequenciesMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            size += GeneratedMessageV3.computeStringSize((int)15, (Object)this.etag_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.scope_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.scope_);
        }
        for (int i2 = 0; i2 < this.compilationDiagnostics_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.compilationDiagnostics_.get(i2)));
        }
        if (this.nearRealTimeLiveRuleEligible_) {
            size += CodedOutputStream.computeBoolSize((int)18, (boolean)this.nearRealTimeLiveRuleEligible_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)this.getInputsUsed());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Rule)) {
            return super.equals(obj);
        }
        Rule other = (Rule)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getRevisionId().equals(other.getRevisionId())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (!this.getText().equals(other.getText())) {
            return false;
        }
        if (!this.getAuthor().equals(other.getAuthor())) {
            return false;
        }
        if (this.hasSeverity() != other.hasSeverity()) {
            return false;
        }
        if (this.hasSeverity() && !this.getSeverity().equals(other.getSeverity())) {
            return false;
        }
        if (!this.internalGetMetadata().equals(other.internalGetMetadata())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasRevisionCreateTime() != other.hasRevisionCreateTime()) {
            return false;
        }
        if (this.hasRevisionCreateTime() && !this.getRevisionCreateTime().equals((Object)other.getRevisionCreateTime())) {
            return false;
        }
        if (this.compilationState_ != other.compilationState_) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (!this.getReferenceListsList().equals(other.getReferenceListsList())) {
            return false;
        }
        if (!this.allowedRunFrequencies_.equals(other.allowedRunFrequencies_)) {
            return false;
        }
        if (!this.getEtag().equals(other.getEtag())) {
            return false;
        }
        if (!this.getScope().equals(other.getScope())) {
            return false;
        }
        if (!this.getCompilationDiagnosticsList().equals(other.getCompilationDiagnosticsList())) {
            return false;
        }
        if (this.getNearRealTimeLiveRuleEligible() != other.getNearRealTimeLiveRuleEligible()) {
            return false;
        }
        if (this.hasInputsUsed() != other.hasInputsUsed()) {
            return false;
        }
        if (this.hasInputsUsed() && !this.getInputsUsed().equals(other.getInputsUsed())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Rule.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getRevisionId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getText().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getAuthor().hashCode();
        if (this.hasSeverity()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getSeverity().hashCode();
        }
        if (!this.internalGetMetadata().getMap().isEmpty()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.internalGetMetadata().hashCode();
        }
        if (this.hasCreateTime()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasRevisionCreateTime()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getRevisionCreateTime().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.compilationState_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.type_;
        if (this.getReferenceListsCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getReferenceListsList().hashCode();
        }
        if (this.getAllowedRunFrequenciesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.allowedRunFrequencies_.hashCode();
        }
        hash = 37 * hash + 15;
        hash = 53 * hash + this.getEtag().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getScope().hashCode();
        if (this.getCompilationDiagnosticsCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getCompilationDiagnosticsList().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getNearRealTimeLiveRuleEligible());
        if (this.hasInputsUsed()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getInputsUsed().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Rule parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data);
    }

    public static Rule parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Rule parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data);
    }

    public static Rule parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Rule parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data);
    }

    public static Rule parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Rule)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Rule parseFrom(InputStream input) throws IOException {
        return (Rule)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Rule parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Rule)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Rule parseDelimitedFrom(InputStream input) throws IOException {
        return (Rule)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Rule parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Rule)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Rule parseFrom(CodedInputStream input) throws IOException {
        return (Rule)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Rule parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Rule)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Rule.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Rule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Rule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Rule> parser() {
        return PARSER;
    }

    public Parser<Rule> getParserForType() {
        return PARSER;
    }

    public Rule getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements RuleOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object revisionId_ = "";
        private Object displayName_ = "";
        private Object text_ = "";
        private Object author_ = "";
        private Severity severity_;
        private SingleFieldBuilderV3<Severity, Severity.Builder, SeverityOrBuilder> severityBuilder_;
        private MapField<String, String> metadata_;
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp revisionCreateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> revisionCreateTimeBuilder_;
        private int compilationState_ = 0;
        private int type_ = 0;
        private LazyStringArrayList referenceLists_ = LazyStringArrayList.emptyList();
        private List<Integer> allowedRunFrequencies_ = Collections.emptyList();
        private Object etag_ = "";
        private Object scope_ = "";
        private List<CompilationDiagnostic> compilationDiagnostics_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CompilationDiagnostic, CompilationDiagnostic.Builder, CompilationDiagnosticOrBuilder> compilationDiagnosticsBuilder_;
        private boolean nearRealTimeLiveRuleEligible_;
        private InputsUsed inputsUsed_;
        private SingleFieldBuilderV3<InputsUsed, InputsUsed.Builder, InputsUsedOrBuilder> inputsUsedBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RuleProto.internal_static_google_cloud_chronicle_v1_Rule_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMutableMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RuleProto.internal_static_google_cloud_chronicle_v1_Rule_fieldAccessorTable.ensureFieldAccessorsInitialized(Rule.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getSeverityFieldBuilder();
                this.getCreateTimeFieldBuilder();
                this.getRevisionCreateTimeFieldBuilder();
                this.getCompilationDiagnosticsFieldBuilder();
                this.getInputsUsedFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.revisionId_ = "";
            this.displayName_ = "";
            this.text_ = "";
            this.author_ = "";
            this.severity_ = null;
            if (this.severityBuilder_ != null) {
                this.severityBuilder_.dispose();
                this.severityBuilder_ = null;
            }
            this.internalGetMutableMetadata().clear();
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.revisionCreateTime_ = null;
            if (this.revisionCreateTimeBuilder_ != null) {
                this.revisionCreateTimeBuilder_.dispose();
                this.revisionCreateTimeBuilder_ = null;
            }
            this.compilationState_ = 0;
            this.type_ = 0;
            this.referenceLists_ = LazyStringArrayList.emptyList();
            this.allowedRunFrequencies_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFEFFF;
            this.etag_ = "";
            this.scope_ = "";
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.compilationDiagnostics_ = Collections.emptyList();
            } else {
                this.compilationDiagnostics_ = null;
                this.compilationDiagnosticsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFF7FFF;
            this.nearRealTimeLiveRuleEligible_ = false;
            this.inputsUsed_ = null;
            if (this.inputsUsedBuilder_ != null) {
                this.inputsUsedBuilder_.dispose();
                this.inputsUsedBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RuleProto.internal_static_google_cloud_chronicle_v1_Rule_descriptor;
        }

        public Rule getDefaultInstanceForType() {
            return Rule.getDefaultInstance();
        }

        public Rule build() {
            Rule result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Rule buildPartial() {
            Rule result = new Rule(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Rule result) {
            if ((this.bitField0_ & 0x1000) != 0) {
                this.allowedRunFrequencies_ = Collections.unmodifiableList(this.allowedRunFrequencies_);
                this.bitField0_ &= 0xFFFFEFFF;
            }
            result.allowedRunFrequencies_ = this.allowedRunFrequencies_;
            if (this.compilationDiagnosticsBuilder_ == null) {
                if ((this.bitField0_ & 0x8000) != 0) {
                    this.compilationDiagnostics_ = Collections.unmodifiableList(this.compilationDiagnostics_);
                    this.bitField0_ &= 0xFFFF7FFF;
                }
                result.compilationDiagnostics_ = this.compilationDiagnostics_;
            } else {
                result.compilationDiagnostics_ = this.compilationDiagnosticsBuilder_.build();
            }
        }

        private void buildPartial0(Rule result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.revisionId_ = this.revisionId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.text_ = this.text_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.author_ = this.author_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x20) != 0) {
                result.severity_ = this.severityBuilder_ == null ? this.severity_ : (Severity)this.severityBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.metadata_ = this.internalGetMetadata();
                result.metadata_.makeImmutable();
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.revisionCreateTime_ = this.revisionCreateTimeBuilder_ == null ? this.revisionCreateTime_ : (Timestamp)this.revisionCreateTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.compilationState_ = this.compilationState_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                this.referenceLists_.makeImmutable();
                result.referenceLists_ = this.referenceLists_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.etag_ = this.etag_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.scope_ = this.scope_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.nearRealTimeLiveRuleEligible_ = this.nearRealTimeLiveRuleEligible_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.inputsUsed_ = this.inputsUsedBuilder_ == null ? this.inputsUsed_ : (InputsUsed)this.inputsUsedBuilder_.build();
                to_bitField0_ |= 8;
            }
            Rule rule = result;
            rule.bitField0_ = rule.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Rule) {
                return this.mergeFrom((Rule)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Rule other) {
            if (other == Rule.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getRevisionId().isEmpty()) {
                this.revisionId_ = other.revisionId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getText().isEmpty()) {
                this.text_ = other.text_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getAuthor().isEmpty()) {
                this.author_ = other.author_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasSeverity()) {
                this.mergeSeverity(other.getSeverity());
            }
            this.internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
            this.bitField0_ |= 0x40;
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasRevisionCreateTime()) {
                this.mergeRevisionCreateTime(other.getRevisionCreateTime());
            }
            if (other.compilationState_ != 0) {
                this.setCompilationStateValue(other.getCompilationStateValue());
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (!other.referenceLists_.isEmpty()) {
                if (this.referenceLists_.isEmpty()) {
                    this.referenceLists_ = other.referenceLists_;
                    this.bitField0_ |= 0x800;
                } else {
                    this.ensureReferenceListsIsMutable();
                    this.referenceLists_.addAll((Collection)other.referenceLists_);
                }
                this.onChanged();
            }
            if (!other.allowedRunFrequencies_.isEmpty()) {
                if (this.allowedRunFrequencies_.isEmpty()) {
                    this.allowedRunFrequencies_ = other.allowedRunFrequencies_;
                    this.bitField0_ &= 0xFFFFEFFF;
                } else {
                    this.ensureAllowedRunFrequenciesIsMutable();
                    this.allowedRunFrequencies_.addAll(other.allowedRunFrequencies_);
                }
                this.onChanged();
            }
            if (!other.getEtag().isEmpty()) {
                this.etag_ = other.etag_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (!other.getScope().isEmpty()) {
                this.scope_ = other.scope_;
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            if (this.compilationDiagnosticsBuilder_ == null) {
                if (!other.compilationDiagnostics_.isEmpty()) {
                    if (this.compilationDiagnostics_.isEmpty()) {
                        this.compilationDiagnostics_ = other.compilationDiagnostics_;
                        this.bitField0_ &= 0xFFFF7FFF;
                    } else {
                        this.ensureCompilationDiagnosticsIsMutable();
                        this.compilationDiagnostics_.addAll(other.compilationDiagnostics_);
                    }
                    this.onChanged();
                }
            } else if (!other.compilationDiagnostics_.isEmpty()) {
                if (this.compilationDiagnosticsBuilder_.isEmpty()) {
                    this.compilationDiagnosticsBuilder_.dispose();
                    this.compilationDiagnosticsBuilder_ = null;
                    this.compilationDiagnostics_ = other.compilationDiagnostics_;
                    this.bitField0_ &= 0xFFFF7FFF;
                    this.compilationDiagnosticsBuilder_ = alwaysUseFieldBuilders ? this.getCompilationDiagnosticsFieldBuilder() : null;
                } else {
                    this.compilationDiagnosticsBuilder_.addAllMessages((Iterable)other.compilationDiagnostics_);
                }
            }
            if (other.getNearRealTimeLiveRuleEligible()) {
                this.setNearRealTimeLiveRuleEligible(other.getNearRealTimeLiveRuleEligible());
            }
            if (other.hasInputsUsed()) {
                this.mergeInputsUsed(other.getInputsUsed());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 18: {
                            this.revisionId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 26: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block27;
                        }
                        case 34: {
                            this.text_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 42: {
                            this.author_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getSeverityFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 58: {
                            MapEntry metadata__ = (MapEntry)input.readMessage(MetadataDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableMetadata().getMutableMap().put(metadata__.getKey(), metadata__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block27;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getRevisionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 80: {
                            this.compilationState_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block27;
                        }
                        case 96: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block27;
                        }
                        case 106: {
                            String s = input.readStringRequireUtf8();
                            this.ensureReferenceListsIsMutable();
                            this.referenceLists_.add((Object)s);
                            continue block27;
                        }
                        case 112: {
                            int tmpRaw = input.readEnum();
                            this.ensureAllowedRunFrequenciesIsMutable();
                            this.allowedRunFrequencies_.add(tmpRaw);
                            continue block27;
                        }
                        case 114: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureAllowedRunFrequenciesIsMutable();
                                this.allowedRunFrequencies_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block27;
                        }
                        case 122: {
                            this.etag_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 130: {
                            this.scope_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 138: {
                            CompilationDiagnostic m = (CompilationDiagnostic)input.readMessage(CompilationDiagnostic.parser(), extensionRegistry);
                            if (this.compilationDiagnosticsBuilder_ == null) {
                                this.ensureCompilationDiagnosticsIsMutable();
                                this.compilationDiagnostics_.add(m);
                                continue block27;
                            }
                            this.compilationDiagnosticsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 144: {
                            this.nearRealTimeLiveRuleEligible_ = input.readBool();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 162: {
                            input.readMessage((MessageLite.Builder)this.getInputsUsedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Rule.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getRevisionId() {
            Object ref = this.revisionId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.revisionId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRevisionIdBytes() {
            Object ref = this.revisionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.revisionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRevisionId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.revisionId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearRevisionId() {
            this.revisionId_ = Rule.getDefaultInstance().getRevisionId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setRevisionIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.revisionId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = Rule.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getText() {
            Object ref = this.text_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.text_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTextBytes() {
            Object ref = this.text_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.text_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setText(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.text_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearText() {
            this.text_ = Rule.getDefaultInstance().getText();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setTextBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.text_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getAuthor() {
            Object ref = this.author_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.author_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAuthorBytes() {
            Object ref = this.author_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.author_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAuthor(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.author_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearAuthor() {
            this.author_ = Rule.getDefaultInstance().getAuthor();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setAuthorBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.author_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSeverity() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Severity getSeverity() {
            if (this.severityBuilder_ == null) {
                return this.severity_ == null ? Severity.getDefaultInstance() : this.severity_;
            }
            return (Severity)this.severityBuilder_.getMessage();
        }

        public Builder setSeverity(Severity value) {
            if (this.severityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.severity_ = value;
            } else {
                this.severityBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setSeverity(Severity.Builder builderForValue) {
            if (this.severityBuilder_ == null) {
                this.severity_ = builderForValue.build();
            } else {
                this.severityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeSeverity(Severity value) {
            if (this.severityBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.severity_ != null && this.severity_ != Severity.getDefaultInstance()) {
                    this.getSeverityBuilder().mergeFrom(value);
                } else {
                    this.severity_ = value;
                }
            } else {
                this.severityBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.severity_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSeverity() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.severity_ = null;
            if (this.severityBuilder_ != null) {
                this.severityBuilder_.dispose();
                this.severityBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Severity.Builder getSeverityBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Severity.Builder)this.getSeverityFieldBuilder().getBuilder();
        }

        @Override
        public SeverityOrBuilder getSeverityOrBuilder() {
            if (this.severityBuilder_ != null) {
                return (SeverityOrBuilder)this.severityBuilder_.getMessageOrBuilder();
            }
            return this.severity_ == null ? Severity.getDefaultInstance() : this.severity_;
        }

        private SingleFieldBuilderV3<Severity, Severity.Builder, SeverityOrBuilder> getSeverityFieldBuilder() {
            if (this.severityBuilder_ == null) {
                this.severityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSeverity(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.severity_ = null;
            }
            return this.severityBuilder_;
        }

        private MapField<String, String> internalGetMetadata() {
            if (this.metadata_ == null) {
                return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            return this.metadata_;
        }

        private MapField<String, String> internalGetMutableMetadata() {
            if (this.metadata_ == null) {
                this.metadata_ = MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            if (!this.metadata_.isMutable()) {
                this.metadata_ = this.metadata_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.metadata_;
        }

        @Override
        public int getMetadataCount() {
            return this.internalGetMetadata().getMap().size();
        }

        @Override
        public boolean containsMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetMetadata().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getMetadata() {
            return this.getMetadataMap();
        }

        @Override
        public Map<String, String> getMetadataMap() {
            return this.internalGetMetadata().getMap();
        }

        @Override
        public String getMetadataOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMetadata().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getMetadataOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMetadata().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearMetadata() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableMetadata().getMutableMap().clear();
            return this;
        }

        public Builder removeMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableMetadata().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableMetadata() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableMetadata().getMutableMap();
        }

        public Builder putMetadata(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableMetadata().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllMetadata(Map<String, String> values) {
            this.internalGetMutableMetadata().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasRevisionCreateTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getRevisionCreateTime() {
            if (this.revisionCreateTimeBuilder_ == null) {
                return this.revisionCreateTime_ == null ? Timestamp.getDefaultInstance() : this.revisionCreateTime_;
            }
            return (Timestamp)this.revisionCreateTimeBuilder_.getMessage();
        }

        public Builder setRevisionCreateTime(Timestamp value) {
            if (this.revisionCreateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.revisionCreateTime_ = value;
            } else {
                this.revisionCreateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setRevisionCreateTime(Timestamp.Builder builderForValue) {
            if (this.revisionCreateTimeBuilder_ == null) {
                this.revisionCreateTime_ = builderForValue.build();
            } else {
                this.revisionCreateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeRevisionCreateTime(Timestamp value) {
            if (this.revisionCreateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.revisionCreateTime_ != null && this.revisionCreateTime_ != Timestamp.getDefaultInstance()) {
                    this.getRevisionCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.revisionCreateTime_ = value;
                }
            } else {
                this.revisionCreateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.revisionCreateTime_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRevisionCreateTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.revisionCreateTime_ = null;
            if (this.revisionCreateTimeBuilder_ != null) {
                this.revisionCreateTimeBuilder_.dispose();
                this.revisionCreateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getRevisionCreateTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getRevisionCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
            if (this.revisionCreateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.revisionCreateTimeBuilder_.getMessageOrBuilder();
            }
            return this.revisionCreateTime_ == null ? Timestamp.getDefaultInstance() : this.revisionCreateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getRevisionCreateTimeFieldBuilder() {
            if (this.revisionCreateTimeBuilder_ == null) {
                this.revisionCreateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRevisionCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.revisionCreateTime_ = null;
            }
            return this.revisionCreateTimeBuilder_;
        }

        @Override
        public int getCompilationStateValue() {
            return this.compilationState_;
        }

        public Builder setCompilationStateValue(int value) {
            this.compilationState_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public CompilationState getCompilationState() {
            CompilationState result = CompilationState.forNumber(this.compilationState_);
            return result == null ? CompilationState.UNRECOGNIZED : result;
        }

        public Builder setCompilationState(CompilationState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.compilationState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCompilationState() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.compilationState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public RuleType getType() {
            RuleType result = RuleType.forNumber(this.type_);
            return result == null ? RuleType.UNRECOGNIZED : result;
        }

        public Builder setType(RuleType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureReferenceListsIsMutable() {
            if (!this.referenceLists_.isModifiable()) {
                this.referenceLists_ = new LazyStringArrayList((LazyStringList)this.referenceLists_);
            }
            this.bitField0_ |= 0x800;
        }

        public ProtocolStringList getReferenceListsList() {
            this.referenceLists_.makeImmutable();
            return this.referenceLists_;
        }

        @Override
        public int getReferenceListsCount() {
            return this.referenceLists_.size();
        }

        @Override
        public String getReferenceLists(int index) {
            return this.referenceLists_.get(index);
        }

        @Override
        public ByteString getReferenceListsBytes(int index) {
            return this.referenceLists_.getByteString(index);
        }

        public Builder setReferenceLists(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReferenceListsIsMutable();
            this.referenceLists_.set(index, value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder addReferenceLists(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReferenceListsIsMutable();
            this.referenceLists_.add((Object)value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder addAllReferenceLists(Iterable<String> values) {
            this.ensureReferenceListsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.referenceLists_);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearReferenceLists() {
            this.referenceLists_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder addReferenceListsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.ensureReferenceListsIsMutable();
            this.referenceLists_.add(value);
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        private void ensureAllowedRunFrequenciesIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.allowedRunFrequencies_ = new ArrayList<Integer>(this.allowedRunFrequencies_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<RunFrequency> getAllowedRunFrequenciesList() {
            return new Internal.ListAdapter(this.allowedRunFrequencies_, allowedRunFrequencies_converter_);
        }

        @Override
        public int getAllowedRunFrequenciesCount() {
            return this.allowedRunFrequencies_.size();
        }

        @Override
        public RunFrequency getAllowedRunFrequencies(int index) {
            return (RunFrequency)((Object)allowedRunFrequencies_converter_.convert((Object)this.allowedRunFrequencies_.get(index)));
        }

        public Builder setAllowedRunFrequencies(int index, RunFrequency value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedRunFrequenciesIsMutable();
            this.allowedRunFrequencies_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllowedRunFrequencies(RunFrequency value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAllowedRunFrequenciesIsMutable();
            this.allowedRunFrequencies_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedRunFrequencies(Iterable<? extends RunFrequency> values) {
            this.ensureAllowedRunFrequenciesIsMutable();
            for (RunFrequency runFrequency : values) {
                this.allowedRunFrequencies_.add(runFrequency.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAllowedRunFrequencies() {
            this.allowedRunFrequencies_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAllowedRunFrequenciesValueList() {
            return Collections.unmodifiableList(this.allowedRunFrequencies_);
        }

        @Override
        public int getAllowedRunFrequenciesValue(int index) {
            return this.allowedRunFrequencies_.get(index);
        }

        public Builder setAllowedRunFrequenciesValue(int index, int value) {
            this.ensureAllowedRunFrequenciesIsMutable();
            this.allowedRunFrequencies_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAllowedRunFrequenciesValue(int value) {
            this.ensureAllowedRunFrequenciesIsMutable();
            this.allowedRunFrequencies_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAllowedRunFrequenciesValue(Iterable<Integer> values) {
            this.ensureAllowedRunFrequenciesIsMutable();
            for (int value : values) {
                this.allowedRunFrequencies_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getEtag() {
            Object ref = this.etag_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.etag_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEtagBytes() {
            Object ref = this.etag_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.etag_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEtag(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.etag_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearEtag() {
            this.etag_ = Rule.getDefaultInstance().getEtag();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setEtagBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.etag_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public String getScope() {
            Object ref = this.scope_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.scope_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getScopeBytes() {
            Object ref = this.scope_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.scope_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setScope(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.scope_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearScope() {
            this.scope_ = Rule.getDefaultInstance().getScope();
            this.bitField0_ &= 0xFFFFBFFF;
            this.onChanged();
            return this;
        }

        public Builder setScopeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Rule.checkByteStringIsUtf8((ByteString)value);
            this.scope_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        private void ensureCompilationDiagnosticsIsMutable() {
            if ((this.bitField0_ & 0x8000) == 0) {
                this.compilationDiagnostics_ = new ArrayList<CompilationDiagnostic>(this.compilationDiagnostics_);
                this.bitField0_ |= 0x8000;
            }
        }

        @Override
        public List<CompilationDiagnostic> getCompilationDiagnosticsList() {
            if (this.compilationDiagnosticsBuilder_ == null) {
                return Collections.unmodifiableList(this.compilationDiagnostics_);
            }
            return this.compilationDiagnosticsBuilder_.getMessageList();
        }

        @Override
        public int getCompilationDiagnosticsCount() {
            if (this.compilationDiagnosticsBuilder_ == null) {
                return this.compilationDiagnostics_.size();
            }
            return this.compilationDiagnosticsBuilder_.getCount();
        }

        @Override
        public CompilationDiagnostic getCompilationDiagnostics(int index) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                return this.compilationDiagnostics_.get(index);
            }
            return (CompilationDiagnostic)this.compilationDiagnosticsBuilder_.getMessage(index);
        }

        public Builder setCompilationDiagnostics(int index, CompilationDiagnostic value) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.set(index, value);
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCompilationDiagnostics(int index, CompilationDiagnostic.Builder builderForValue) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCompilationDiagnostics(CompilationDiagnostic value) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.add(value);
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCompilationDiagnostics(int index, CompilationDiagnostic value) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.add(index, value);
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCompilationDiagnostics(CompilationDiagnostic.Builder builderForValue) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCompilationDiagnostics(int index, CompilationDiagnostic.Builder builderForValue) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCompilationDiagnostics(Iterable<? extends CompilationDiagnostic> values) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.ensureCompilationDiagnosticsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.compilationDiagnostics_);
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCompilationDiagnostics() {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.compilationDiagnostics_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFF7FFF;
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.clear();
            }
            return this;
        }

        public Builder removeCompilationDiagnostics(int index) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.ensureCompilationDiagnosticsIsMutable();
                this.compilationDiagnostics_.remove(index);
                this.onChanged();
            } else {
                this.compilationDiagnosticsBuilder_.remove(index);
            }
            return this;
        }

        public CompilationDiagnostic.Builder getCompilationDiagnosticsBuilder(int index) {
            return (CompilationDiagnostic.Builder)this.getCompilationDiagnosticsFieldBuilder().getBuilder(index);
        }

        @Override
        public CompilationDiagnosticOrBuilder getCompilationDiagnosticsOrBuilder(int index) {
            if (this.compilationDiagnosticsBuilder_ == null) {
                return this.compilationDiagnostics_.get(index);
            }
            return (CompilationDiagnosticOrBuilder)this.compilationDiagnosticsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends CompilationDiagnosticOrBuilder> getCompilationDiagnosticsOrBuilderList() {
            if (this.compilationDiagnosticsBuilder_ != null) {
                return this.compilationDiagnosticsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.compilationDiagnostics_);
        }

        public CompilationDiagnostic.Builder addCompilationDiagnosticsBuilder() {
            return (CompilationDiagnostic.Builder)this.getCompilationDiagnosticsFieldBuilder().addBuilder((AbstractMessage)CompilationDiagnostic.getDefaultInstance());
        }

        public CompilationDiagnostic.Builder addCompilationDiagnosticsBuilder(int index) {
            return (CompilationDiagnostic.Builder)this.getCompilationDiagnosticsFieldBuilder().addBuilder(index, (AbstractMessage)CompilationDiagnostic.getDefaultInstance());
        }

        public List<CompilationDiagnostic.Builder> getCompilationDiagnosticsBuilderList() {
            return this.getCompilationDiagnosticsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CompilationDiagnostic, CompilationDiagnostic.Builder, CompilationDiagnosticOrBuilder> getCompilationDiagnosticsFieldBuilder() {
            if (this.compilationDiagnosticsBuilder_ == null) {
                this.compilationDiagnosticsBuilder_ = new RepeatedFieldBuilderV3(this.compilationDiagnostics_, (this.bitField0_ & 0x8000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.compilationDiagnostics_ = null;
            }
            return this.compilationDiagnosticsBuilder_;
        }

        @Override
        public boolean getNearRealTimeLiveRuleEligible() {
            return this.nearRealTimeLiveRuleEligible_;
        }

        public Builder setNearRealTimeLiveRuleEligible(boolean value) {
            this.nearRealTimeLiveRuleEligible_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearNearRealTimeLiveRuleEligible() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.nearRealTimeLiveRuleEligible_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasInputsUsed() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public InputsUsed getInputsUsed() {
            if (this.inputsUsedBuilder_ == null) {
                return this.inputsUsed_ == null ? InputsUsed.getDefaultInstance() : this.inputsUsed_;
            }
            return (InputsUsed)this.inputsUsedBuilder_.getMessage();
        }

        public Builder setInputsUsed(InputsUsed value) {
            if (this.inputsUsedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.inputsUsed_ = value;
            } else {
                this.inputsUsedBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setInputsUsed(InputsUsed.Builder builderForValue) {
            if (this.inputsUsedBuilder_ == null) {
                this.inputsUsed_ = builderForValue.build();
            } else {
                this.inputsUsedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeInputsUsed(InputsUsed value) {
            if (this.inputsUsedBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.inputsUsed_ != null && this.inputsUsed_ != InputsUsed.getDefaultInstance()) {
                    this.getInputsUsedBuilder().mergeFrom(value);
                } else {
                    this.inputsUsed_ = value;
                }
            } else {
                this.inputsUsedBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.inputsUsed_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInputsUsed() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.inputsUsed_ = null;
            if (this.inputsUsedBuilder_ != null) {
                this.inputsUsedBuilder_.dispose();
                this.inputsUsedBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public InputsUsed.Builder getInputsUsedBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (InputsUsed.Builder)this.getInputsUsedFieldBuilder().getBuilder();
        }

        @Override
        public InputsUsedOrBuilder getInputsUsedOrBuilder() {
            if (this.inputsUsedBuilder_ != null) {
                return (InputsUsedOrBuilder)this.inputsUsedBuilder_.getMessageOrBuilder();
            }
            return this.inputsUsed_ == null ? InputsUsed.getDefaultInstance() : this.inputsUsed_;
        }

        private SingleFieldBuilderV3<InputsUsed, InputsUsed.Builder, InputsUsedOrBuilder> getInputsUsedFieldBuilder() {
            if (this.inputsUsedBuilder_ == null) {
                this.inputsUsedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInputsUsed(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.inputsUsed_ = null;
            }
            return this.inputsUsedBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class MetadataDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)RuleProto.internal_static_google_cloud_chronicle_v1_Rule_MetadataEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private MetadataDefaultEntryHolder() {
        }
    }

    public static enum CompilationState implements ProtocolMessageEnum
    {
        COMPILATION_STATE_UNSPECIFIED(0),
        SUCCEEDED(1),
        FAILED(2),
        UNRECOGNIZED(-1);

        public static final int COMPILATION_STATE_UNSPECIFIED_VALUE = 0;
        public static final int SUCCEEDED_VALUE = 1;
        public static final int FAILED_VALUE = 2;
        private static final Internal.EnumLiteMap<CompilationState> internalValueMap;
        private static final CompilationState[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static CompilationState valueOf(int value) {
            return CompilationState.forNumber(value);
        }

        public static CompilationState forNumber(int value) {
            switch (value) {
                case 0: {
                    return COMPILATION_STATE_UNSPECIFIED;
                }
                case 1: {
                    return SUCCEEDED;
                }
                case 2: {
                    return FAILED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<CompilationState> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)CompilationState.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return CompilationState.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Rule.getDescriptor().getEnumTypes().get(0);
        }

        public static CompilationState valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != CompilationState.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private CompilationState(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<CompilationState>(){

                public CompilationState findValueByNumber(int number) {
                    return CompilationState.forNumber(number);
                }
            };
            VALUES = CompilationState.values();
        }
    }
}

